#include "cDeck.h"

//Helper functions
double max(double a, double b){if (a > b) return a; else return b;};
double max(double a, double b, double c) {return max(max(a, b), c);};
bool IsDouble(cDecision dec){return (dec == DOUBLE || dec == DOUBLEORHIT || dec == DOUBLEORSTAND);};

cDeck::cDeck(int deck, bool ten)
{
	bTen = ten;
	nDeck = deck;
	Reset();
}

void cDeck::Reset()
{
	HighLowIndex = 0;
	Card.erase(Card.begin(), Card.end());
	Deck.erase(Deck.begin(), Deck.end());

	Total = 52 * nDeck;

	Card.resize(13);

	for(int i=0; i<13; i++)
	{
		Card[i] = 4 * nDeck;
	}

	for(int j=0; j<13; j++)
	{
		for(int k=0; k<4*nDeck; k++)
		{
			Deck.push_back(j);
		}
	}

	random_shuffle(Deck.begin(), Deck.end());
}

int cDeck::NumLeft(int n)
{
	if (!bTen)
	{
		return Card[n-1];
	}
	else
	{
		if (n >= 1 && n <= 9)
		{
			return Card[n-1];
		}
		else if (n == 11)
		{
			return NumLeft(1);
		}
		else if (n == 12 || n == 13)
		{
			return 0;
		}
		else if (n == 10)
		{
			return	Card[10-1] +
					Card[11-1] +
					Card[12-1] +
					Card[13-1];
		}
		else
		{
			return 0;
		}
	}
}

int cDeck::Deal()
{
	if (Total == 0)
	{
		
		cout << "No more card, shuffle then deal" << endl;
		Reset();
		return Deal();
	}

	int Top = Deck.back();
	Deck.pop_back();

	Card[Top]--;
	Total--;

	int card = Top + 1;
	
	if (card >= 10 && card <= 13 || card == 1) HighLowIndex--;
	else if (card >= 2 && card <= 6) HighLowIndex++;

	if (bTen)
	{
		if (card == 11 || card == 12 || card == 13) return 10;
	}
	
	return card;
}

int cDeck::ForceDeal(cCard card)
{
	if (NumLeft() == 0)
	{
		cerr << "No more card!!" << endl;
		Reset();
		return ForceDeal(card);
	}

	if (NumLeft(card) == 0 && !bTen) //remove this check when bTen is activiated
	{
		cerr << "The card to be forced does not exist, another card is dealt" << endl;
		return Deal();
	}

	if (bTen == true && card == 11) card = 1;

	int Index = card - 1;
	
	for(int d=0; d<Deck.size(); d++)
	{
		if (Deck[d] == Index)
		{
			swap(Deck[d], Deck[Deck.size()-1]);
			return Deal();
		}
	}

	//I should have return a card already
	assert(false);
	return -1;
}

void cDeck::Output()
{
	cout << "Number of Card: " << NumLeft() << endl;
	
	int Max;
	
	if (bTen) Max = 10;
	else Max = 13;

	for(int i=0; i<Max; i++)
	{
		cout << "\t" << "Num of " << i+1 << " is " << NumLeft(i+1) << endl;
	}

	cout << endl;
}

double cDeck::HighLowCount(void)
{
	assert(-HighLowIndex ==	Card[1] + Card[2] + Card[3] + Card[4] + Card[5] -
							Card[0] - Card[9] - Card[10]- Card[11]- Card[12]);

	if (NumLeft() == 0) return 0.0;
	return double(HighLowIndex)  / (double(NumLeft()) / 52.0);
}

double cDeck::MyCount(void)
{
	if (NumLeft() == 0) return 0.0;
	else
	{
		int high = Card[0];
		for(int h=8; h<=12; h++) high += Card[h];

		int low = 0;
		for(int l=1; l<=6; l++) low += Card[l];

		return double(high - low) / (double(NumLeft()) / 52.0);
	}

}

vector<cExp> cDeck::Exp(const int upcard, const cStrat s)
{
	assert(NumLeft() != 0);

	//figure out if dealer has ace or not
	bool bSoft;
	if (upcard == 11) bSoft = true;
	else bSoft = false;
	
	//figure out the probility for each result
	vector<double> dealer = Prob(upcard, bSoft, s);

	//renormalize dealer's probability, taken blackjack out of the account
	double pBJ = 0;
	if (upcard == 10) pBJ = NumLeft(11)/double(NumLeft());
	else if (upcard == 11) pBJ = NumLeft(10)/double(NumLeft());

	if (pBJ != 0)
	{
		dealer[21] -= pBJ;
		double mult = 1.0 / (1.0 - pBJ);

		for(int ca = 0; ca<dealer.size(); ca++)
		{
			dealer[ca] *= mult;
		}
	}

	//set up some constants
	const int MAX = MAXTOTAL;
	const double BET = 1;

	vector<cExp> exp(MAX+11+1);

	//for everything above 21, it's an automatic lose
	for(int e=22; e<exp.size(); e++)
	{
		exp[e].exp = -BET;
		exp[e].dec = STAND;
		exp[e].expdouble = -BET * 2.0;
		exp[e].expstand = -BET;

		//TODO: double check this part later to see if the below choice is right
		exp[e].expsoft = -BET;
		exp[e].decsoft = STAND;
		exp[e].expdoublesoft = -BET * 2.0;
		exp[e].expstandsoft = -BET;

		exp[e].split = false;
	}

	int p;

	//figure out the expectation for stay 
	for(p=21; p>=0; p--)
	{
		double pLose = 0;
		double pWin = 0;
		double pTie = 0;

		for(int d=0; d<dealer.size(); d++)
		{
			//if the probility is 0, don't bother waste time on this one
			if (dealer[d] == 0) continue;

			//if dealer bust, player wins
			if (d > MAX)
			{
				pWin += dealer[d];
				continue;
			}

			if (d < p) pWin += dealer[d];
			else if (d == p) pTie += dealer[d];
			else if (d > p) pLose += dealer[d];
		}

		assert(fabs(pLose + pWin + pTie - 1) < TOLERANCE);

		//figure out the expectation
		exp[p].exp = BET * pWin - BET * pLose;
		exp[p].dec = STAND;
		exp[p].expstand = exp[p].exp;

		//also the exp for soft
		exp[p].expsoft = exp[p].exp;
		exp[p].decsoft = exp[p].dec;
		exp[p].expstandsoft = exp[p].expstand;

	}

	//figure out the expectation for double
	for(p=21; p>=0; p--)
	{
		double newexp = 0;
		double newexpsoft = 0;

		for(int i=1; i<=10; i++)
		{
			//figure out how likely is it for the player to get a card with value i
			double prob = double(NumLeft(i)) / double(NumLeft());

			//since this is double and only 1 more card is drawn, below is actually ACCURATE
			if (i == 1)
			{
				int n1 = p+i;
				int n11 = p+i+10;

				newexp += prob * max(exp[n1].exp, exp[n11].exp);
			}
			else
			{
				newexp += prob * exp[p+i].exp;
			}

			//figure out the part for soft, in here, additional ace always treated as 1
			int s1 = p+i;
			int s2 = p+i-10;

			if (s2 < 0)
			{
				newexpsoft += prob * exp[s1].expsoft;
			}
			else
			{
				newexpsoft += prob * max(exp[s1].expsoft, exp[s2].expsoft);
			}
		}

		//make sure expectation is smaller than the bet
		assert(fabs(newexp) <= BET + 0.001);
		assert(fabs(newexpsoft) <= BET + 0.001);

		//compute the exp for double
		exp[p].expdouble = 2.0 * newexp;
		if (exp[p].expdouble > exp[p].exp)
		{
			assert(exp[p].dec == STAND);
			exp[p].dec = DOUBLEORSTAND;
		}

		exp[p].expdoublesoft = 2.0 * newexpsoft;
		if (exp[p].expdoublesoft > exp[p].expsoft)
		{
			assert(exp[p].decsoft == STAND);
			exp[p].decsoft = DOUBLEORSTAND;
		}
	}

	//Loop 2 times, assume a hand can be counted as soft total at most twices
	//	in this case it's true
	for(int t=0; t<2; t++)
	{
		//figure out the expectation for hit on hard total
		//note that reversing the order, i.e. from 21 to 0 is crucial here for dynamic programming to work
		for(p=21; p>=0; p--)
		{
			double newexp = 0;

			for(int i=1; i<=10; i++)
			{
				//figure out how likely is it for the player to get a card with value i
				double prob = double(NumLeft(i)) / double(NumLeft());

				//for ease of estimation, ace counts as 1 or 11, depending on the HARD TOTAL result.
				if (i == 1)
				{
					int n1 = p+i;
					int n11 = p+i+10;

					newexp += prob * max(exp[n1].exp, exp[n11].expsoft);
				}
				else
				{
					newexp += prob * exp[p+i].exp;
				}
			}

			exp[p].exphit = newexp;

			double eStand = exp[p].expstand;
			double eHit = exp[p].exphit;
			double eDouble = exp[p].expdouble;

			//note: max does not include double
			double eMax = max(eStand, eHit);
			exp[p].exp = eMax;
			

			/*
			if (newexp > exp[p].expstand &&
				newexp < exp[p].expdouble)
			{
				exp[p].exp = newexp;
				if (IsDouble(exp[p].dec)) exp[p].dec = DOUBLEORHIT;
				else exp[p].dec = HIT;
			}

			if (newexp > exp[p].expdouble &&
				newexp > exp[p].expstand)
			{
				exp[p].exp = newexp;
				exp[p].dec = HIT;
			}
			*/
		}

		for(p=21; p>=0; p--)
		{
			double newexpsoft = 0;

			for(int i=1; i<=10; i++)
			{
				//figure out how likely is it for the player to get a card with value i
				double prob = double(NumLeft(i)) / double(NumLeft());

				int s1 = p+i;
				int s2 = p+i-10;

				if (s2 > 0)	newexpsoft += prob * max(exp[s1].expsoft, exp[s2].exp);
				else		newexpsoft += prob * exp[s1].expsoft;
			}

			exp[p].exphitsoft = newexpsoft;

			double eStand = exp[p].expstandsoft;
			double eHit = exp[p].exphitsoft;
			double eDouble = exp[p].expdoublesoft;
			
			double eMax = max(eStand, eHit);
			exp[p].expsoft = eMax;

			/*
			if (newexpsoft > exp[p].expstandsoft)
			{
				exp[p].expsoft = newexpsoft;

				if (IsDouble(exp[p].decsoft)) exp[p].decsoft = DOUBLEORHIT;
				else exp[p].decsoft = HIT;
			}

			if (newexpsoft > exp[p].expdouble &&
				newexpsoft > exp[p].expstand)
			{
				exp[p].expsoft = newexpsoft;
				exp[p].decsoft = HIT;
			}
			*/
		}
	}

	//figure out the decision
	for(e=0; e<exp.size(); e++)
	{
		double eStand = exp[e].expstand;
		double eHit = exp[e].exphit;
		double eDouble = exp[e].expdouble;

		double eMax = max(eStand, eHit, eDouble);

		cDecision dec;
		
		if (eMax == eStand)	dec = STAND;
		if (eMax == eHit)	dec = HIT;
		if (eMax == eDouble)	dec = DOUBLE;

		if (dec == DOUBLE)
		{
			if (eStand > eHit)	dec = DOUBLEORSTAND;
			else				dec = DOUBLEORHIT;
		}

		exp[e].dec = dec;

		//do the same thing for soft total
		eStand = exp[e].expstandsoft;
		eHit = exp[e].exphitsoft;
		eDouble = exp[e].expdoublesoft;

		eMax = max(eStand, eHit, eDouble);

		if (eMax == eStand)	dec = STAND;
		if (eMax == eHit)	dec = HIT;
		if (eMax == eDouble)dec = DOUBLE;

		if (dec == DOUBLE)
		{
			if (eStand > eHit)	dec = DOUBLEORSTAND;
			else				dec = DOUBLEORHIT;
		}

		exp[e].decsoft = dec;
	}

	//figure out if split should be done
	//note: here is NO double after split, and split only once
	for(e=0; e<exp.size(); e++)
	{
		if (e % 2 != 0 && e == 0)
		{
			exp[e].split = false;
		}
		else
		{
			double eSplit = 0.0;
			
			bool bSplit = false;
			
			//handle two aces differently
			if (e == 2 || e == 22)
			{
				eSplit = exp[11].expsoft * 2.0;
				if (eSplit > max(exp[12].expsoft, exp[e].expdoublesoft)) bSplit = true;
			}
			else
			{
				eSplit = exp[e/2].exp * 2.0;
				if (eSplit > max(exp[e].exp, exp[e].expdouble)) bSplit = true;
			}

			exp[e].split = bSplit;
			exp[e].expsplit = eSplit;
		}
	}
	
	return exp;
}

double cDeck::OverallExp(cStrat strat)
{
	//get the decision on all situation
	vector<vector<cExp> > allexp(12);
	for(int a=2; a<=11; a++)
	{
		allexp[a] = Exp(a, strat);
	}

	//figure out the overall expectation
	double exp = 0;
	const double BET = 1.0;

	for(int d=2; d<=11; d++)
	{
		//probability that dealer gets blackjack
		double pBJ = 0;
		if (d == 10) pBJ = NumLeft(11)/double(NumLeft());
		else if (d == 11) pBJ = NumLeft(10)/double(NumLeft());

		for(int p1=2; p1<=11; p1++)
		{
			for(int p2=2; p2<=11; p2++)
			{
				double prob =
						double(NumLeft(d))/double(NumLeft()) *
						double(NumLeft(p1))/double(NumLeft()) *
						double(NumLeft(p2))/double(NumLeft());

				//if it is not a blackjack
				if (p1 + p2 != 21)
				{
					exp += -BET * pBJ * prob;

					//if it's hard total
					if (p1 != 11 && p2 != 11)
					{
						if (p1 == p2)
						{
							if (allexp[d][p1+p2].split == true)
							{
								exp += allexp[d][p1+p2].expsplit * (1.0 - pBJ) * prob;
							}
							else //don't split
							{
								exp += max(allexp[d][p1+p2].exp, allexp[d][p1+p2].expdouble) * (1.0 - pBJ) * prob;
							}
						}
						else //no choice of split
						{
							exp += max(allexp[d][p1+p2].exp, allexp[d][p1+p2].expdouble) * (1.0 - pBJ) * prob;
						}
					}
					else //it's soft total
					{
						if (p1 == p2)
						{
							if (allexp[d][p1+p2].split == true)
							{
								exp += allexp[d][p1+p2].expsplit * (1.0 - pBJ) * prob;
							}
							else //don't split
							{
								exp += max(allexp[d][p1+p2].expsoft, allexp[d][p1+p2].expdoublesoft) * (1.0 - pBJ) * prob;
							}
						}
						else //no choice of split
						{
							exp += max(allexp[d][p1+p2].expsoft, allexp[d][p1+p2].expdoublesoft) * (1.0 - pBJ) * prob;
						}
					}
				}
				else //player blackjack
				{
					//tie when both side blackjack
					exp += 0.0 * pBJ * prob;

					//otherwise win
					exp += 1.5 * BET * (1.0 - pBJ) * prob;
				}

				//the expectation can not be much bigger than the bet
				assert(fabs(exp) < 100 * BET);
			}
		}
	}

	return exp;

}

//Return a vector of 1 to MAXTOTAL+11, containing the probability for dealer to get get that total
vector<double> cDeck::Prob(const int nTotal, bool bSoft, cStrat s)
{
	int STANDAT; //when should comp stop at hard total, not sure what happen if this is set below 11
	int SOFTSTANDAT;	//when should comp stop at soft total
	int MAX;		//maximun number of points, not sure what happen if this is greater than 22, (two ace might be problematic)
	bool ACEIS11;	//should ACE always be counted as 11
	bool FIRSTACEIS11; //should first ace be counted as 11, the rest are 1
	
	//Set up the parameter depending on dealer's strategy
	if (s == sHITSOFT17)
	{
		STANDAT = 17;
		SOFTSTANDAT = 18;
		MAX = MAXTOTAL;
		ACEIS11 = false;
		FIRSTACEIS11 = false;
	}
	else if (s == sHIT16)
	{
		STANDAT = 17;
		SOFTSTANDAT = 17;
		MAX = MAXTOTAL;
		ACEIS11 = false;
		FIRSTACEIS11 = false;
	}
	else assert(false);
	
	if (ACEIS11 && FIRSTACEIS11)
	{
		cerr << "Only one of the above can be true" << endl;
		ACEIS11 = false;
	}

	//when first ace is 11, soft total is those with one ace
	vector<double> ThisSoft(MAX + 11, 0);
	vector<double> ThisHard(MAX + 11, 0);

	//when ace counts as 11, there is no soft total
	if (ACEIS11) bSoft = false;
	
	if (bSoft)
	{
		ThisSoft[nTotal] = 1.0;
		assert(nTotal >= 11);
	}
	else
	{
		ThisHard[nTotal] = 1.0;
	}

	for(;;)
	{
		//break when no probability for everything below STANDAT
		bool end = true;
		for(int s=0; s<STANDAT; s++)
		{
			if (ThisHard[s] != 0)
			{
				end = false;
				break;
			}
		}

		for(s=0; s<SOFTSTANDAT; s++)
		{
			if (ThisSoft[s] != 0)
			{
				end = false;
				break;
			}
		}

		if (end) break;

		//figure out the result of next round
		// i.e. deal another card or stand
		vector<double> NextHard(MAX + 11, 0);
		vector<double> NextSoft(MAX + 11, 0);
		
		//for the case of hit for hard total
		for(int current = 0; current < STANDAT; current++)
		{
			if (ThisHard[current] == 0) continue;

			for(int nextcard = 1; nextcard <= 10; nextcard++)
			{
				double prob = ThisHard[current] * (double(NumLeft(nextcard)) / double(NumLeft()));
				if (nextcard == 1)
				{
					if (ACEIS11)
					{
						NextHard[current + 11] += prob;
					}
					else if (FIRSTACEIS11)
					{
						NextSoft[current + 11] += prob;
					}
					else
					{
						if (current <= 10)
						{
							NextSoft[current + 11] += prob;
						}
						else
						{
							NextHard[current + 1] += prob;
						}
					}
				}
				else
				{
					NextHard[current + nextcard] += prob;
				}
			}
		}

		//for soft total
		for(current = 0; current < SOFTSTANDAT; current++)
		{
			if (ThisSoft[current] == 0) continue;
			for(int nextcard = 1; nextcard <= 10; nextcard++)
			{
				double prob = ThisSoft[current] * (double(NumLeft(nextcard)) / double(NumLeft()));
				
				//if blow up, then it's no longer soft total
				if (!FIRSTACEIS11 && current + nextcard > MAX)
				{
					NextHard[current + nextcard - 10] += prob;
				}
				else
				{	//no need to handle ace differently, because it will be counted 1
					NextSoft[current + nextcard] += prob;
				}
			}
		}

		//for the case of stand
		for(current = STANDAT; current < ThisHard.size(); current++)
		{
			NextHard[current] += ThisHard[current];
		}

		for(current = SOFTSTANDAT; current < ThisSoft.size(); current++)
		{
			NextSoft[current] += ThisSoft[current];
		}

		ThisSoft = NextSoft;
		ThisHard = NextHard;

		//error check
		assert(ThisSoft.size() == ThisHard.size());
		double totalp = 0;
		for(int i=0 ;i<ThisSoft.size(); i++)
		{
			totalp += ThisSoft[i] + ThisHard[i];
		}
		assert(fabs(totalp - 1.0) <= 0.01);
	}

	vector<double> Res(ThisHard.size());

	for(int i=0; i<ThisHard.size(); i++)
	{
		Res[i] = ThisHard[i] + ThisSoft[i];
	}

	return Res;
}

int cHand::GetTotal(bool& soft)
{
	//Count the total
	int nAce = 0;
	int nRest = 0;

	for(int h = 0; h < cards.size(); h++)
	{
		int nThis = cards[h];

		if (nThis == 1)
		{
			nAce++;
		}
		else if (nThis >= 10 && nThis <= 13)
		{
			nRest += 10;
		}
		else
		{
			nRest += nThis;
		}
	}

	if (nAce > 0)
	{
		// if the total is greater than 12, all Ace has to be counted 1
		if (nRest + nAce >= 12)
		{
			nRest += nAce;
			nAce = 0;
		}

		// if there are more than 1 ace, only 1 ace can be counted as 11
		if (nAce >= 2)
		{
			nRest += nAce - 1;
			nAce = 1;
		}
	}

	soft = (nAce == 1);
	nRest += nAce * 11;

	return nRest;
}

bool cHand::IsBlackjack()
{
	if (cards.size() != 2) return false;
	return (GetTotal() == 21);
}

void cHand::Add(cCard card)
{
	switch (card)
	{
	case 1:
	case 11:	cards.push_back(1); break;
	case 2:
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
	case 9:
	case 10:	cards.push_back(card); break;
	default:	assert(false);
	}

}

void cHand::Output(void)
{
	cout << GetTotal() << " -";
	for(int d=0; d<cards.size(); d++)
	{
		cCard card = cards[d];
		if (card == 1)	cout << ' ' << 'A';
		else			cout << ' ' << card;
	}
	cout << endl;
}

cDecision HitSoft17(cDeck& deck, cHand dealer, cHand player)
{
	bool bSoft;
	int n = player.GetTotal(bSoft);

	if (bSoft && n<=17) return HIT;
	else if (!bSoft && n<=16) return HIT;
	else return STAND;
}

cDecision Hit16(cDeck& deck, cHand dealer, cHand player)
{
	int n = player.GetTotal();
	if (n <= 16) return HIT;
	else return STAND;
}

/*
250000 / 250000
Money: -1564.000000
500000 / 500000
Money: -1986.000000
1000000 / 100000000
Money: -5153.000000
*/

/* extra
1250000 / 100000000
Money: -6717.000000
1562500 / 100000000
Money: -8313.000000
2000000 / 100000000
Money: -11208.000000
2500000 / 100000000
Money: -13194.500000
*/

cDecision Optimal(cDeck& deck, cHand dealer, cHand player)
{
	//get dealer's up card
	int up = dealer.cards[0];

	//figure out the player's total
	bool bSoft;
	int total = player.GetTotal(bSoft);
	
	if (total > MAXTOTAL) return STAND;

	//compute the best decision
	vector<cExp> exp = deck.Exp(up);

	//extract the needed info
	cDecision res;
	
	if (bSoft)	res = exp[total].decsoft;
	else		res = exp[total].dec;

	if (IsDouble(res))
	{
		//if player has only two cards and player can double
		if (player.cards.size() == 2 && player.bDouble) res = DOUBLE;
		else
		{
			if (res == DOUBLEORHIT) res = HIT;
			else if (res == DOUBLEORSTAND) res = STAND;
		}
	}

	//check for split
	if(player.cards.size() == 2 && player.bSplit)
	{
		//if both of the player's card is the same
		if (player.cards[0] == player.cards[1])
		{
			//can not use total, but need to use below because of Ace
			int index = player.cards[0] * 2.0;

			if (exp[index].split == true) res = SPLIT;
		}
	}

	return res;
}

/* result for basic
250000 / 250000
Money: -1680.000000
500000 / 500000
Money: -3843.000000
1000000 / 100000000
Money: -5880.000000
*/

/* extra
1250000 / 100000000
Money: -7590.500000
1562500 / 100000000
Money: -9582.000000
2000000 / 100000000
Money: -11598.500000
2500000 / 100000000
Money: -15441.500000
3125000 / 100000000
Money: -19063.000000
4000000 / 100000000
Money: -23583.500000
5000000 / 100000000
Money: -30341.000000
6250000 / 100000000
Money: -38187.000000
10000000 / 100000000
Money: -59574.500000
*/
//basic strategy indepedent of the current deck
cDecision Basic(cDeck& deck, cHand dealer, cHand player)
{
	cDeck complete(1, true);
	return Optimal(complete, dealer, player);
}

double AlwaysOne(cDeck& deck)
{
	return 1;
}

double TwoBet(cDeck& deck)
{
	if (deck.OverallExp() > 0)	return 2;
	else						return 1;
}

double MultiBet(cDeck& deck)
{
	double exp = deck.OverallExp();
	if (exp <= 0) return 1;
	else return int(exp / 0.005) + 2;
}

double CountBet(cDeck& deck)
{
	double count = deck.HighLowCount();

	if (count <= 1) return 1;
	else
	{
		return static_cast<int>(count);
	}
}

void cGame::Play(long nGame, bool bDetail)
{
	for(long g=1; g<=nGame; g++)
	{
		if (nGame % g == 0)
		{
			cout << g << " / " << nGame << " simulated." << endl;
			//cout << "Money: " << GetMoney() << endl;
		}

		//create a new round
		NewRound();

		//make bet
		double bet = fMakeBet(deck);
		player[0].bet = bet;
		assert(bet > 0);

		//remember the count
		double count = deck.MyCount();

		//Deal the cards
		player[0].Add(Deal());
		dealer.Add(Deal());

		player[0].Add(Deal());
		dealer.Add(Deal()); //(Maybe I should deal dealer's card later...)

		//Output the cards for both dealer and player
		if (bDetail)
		{
			cout << endl << "***NEW ROUND*** #" << g << endl;
			cout << "Dealer: ";
			dealer.Output();
			
			cout << "Player: ";
			player[0].Output();

			cout << endl;
		}


		//Indicator to decide if this round ends
		bool bEnd = false;

		if (dealer.IsBlackjack()) bEnd = true;

		//the player plays;
		if(!bEnd)
		{
			//Player makes decision for each hand.
			//  Note: player.size() > 1 only when split occurs
			for(int p=0; p<player.size(); p++)
			{
				//Player makes decision until he stands or bust
				for(int t=0;;t++)
				{
					//A player can never have 21 cards in his hand
					if (t > MAXTOTAL)
					{
						cerr << "WARNING: too many cards in a hand ";
						player[p].Output();
						break;
					}

					//busted!
					if (player[p].GetTotal() > MAXTOTAL) break;

					cDecision dec = fPlayer(deck, dealer, player[p]);

					if (dec == STAND) break;
					
					if (dec == DOUBLE)
					{
						player[p].Add(Deal());
						player[p].Double();
						break;
					}
					
					if (dec == HIT)
					{
						//Player should not hit if he already exceeds the 21 limit
						assert(player[p].GetTotal < MAXTOTAL);
						player[p].Add(Deal());

						continue;
					}

					if (dec == SPLIT)
					{
						//You can only split for both of your card are the same
						assert(player[p].cards.size() == 2);
						assert(player[p].cards[0] == player[p].cards[1]);

						cCard thecard = player[p].cards[0];

						//Deal another card for the current hand
						player[p].cards.erase(player[p].cards.begin());
						player[p].Add(Deal());

						//Create a new hand
						cHand newhand(thecard);
						newhand.bDouble = bDAS;
						newhand.bSplit = bSAS;
						newhand.Add(Deal());
						newhand.bet = player[p].bet;
						player.push_back(newhand);

						continue;
					}

					//A decision should have been made already
					assert(false);

				}
			}
		}

		//Dealer's turn to play
		for(;;)
		{
			//Wahoo!  Dealer busted!
			if (dealer.GetTotal() > MAXTOTAL) break;

			cDecision dec = fDealer(deck, dealer, dealer);

			if (dec == STAND) break;
			if (dec == HIT)
			{
				dealer.Add(Deal());
				continue;
			}

			assert(false);
		}

		//Time to decide the payout!

		double diff = 0;

		int nDealer = dealer.GetTotal();

		if (bDetail)
		{
			cout << "Dealer: ";
			dealer.Output();
		}

		//For each of the player's hand
		for(int e=0; e<player.size(); e++)
		{
			int nPlayer = player[e].GetTotal();

			//Display player's hand if detail
			if (bDetail)
			{
				cout << "Player: ";
				player[e].Output();
			}
			
			int bet = player[e].bet;

			//Dealer got blackjack? Hope not...
			if (dealer.IsBlackjack())
			{
				//If dealer blackjack, there should be no chance for the player to split/
				assert(player.size() == 1);

				if (player[e].IsBlackjack())
				{
					//Tie if both get blackjack
					continue;
				}
				else
				{
					diff -= bet;
					continue;
				}
			}

			//Blackjack! Sweet =)
			if (player[e].IsBlackjack())
			{
				diff += bet * (1.0 + BLACKJACKBONUS);
				continue;
			}

			//Player lose when busted
			if (nPlayer > 21)
			{
				diff -= bet;
				continue;
			}

			//Dealer busted!
			if (nDealer > 21 && nPlayer <= 21)
			{
				diff += bet;
				continue;
			}

			//Who is higher?
			if (nDealer > nPlayer)
			{
				diff -= bet;
				continue;
			}

			if (nDealer < nPlayer)
			{
				diff += bet;
				continue;
			}

			if (nDealer == nPlayer)
			{
				continue;
			}

			//I should have covered all the cases
			assert(false);
		}

		//Time to update my payoff
		UpdateMoney(int(count), diff);
	}

	cout << endl;
}


void cGame::NewRound()
{
	//if there are less than half of the card, shuffle
	if (deck.NumLeft() <= deck.NumDeck() * 52 - NUMCARDUSE) deck.Reset();

	//reset dealer's hand
	dealer.Reset();
	
	//reset player's hands (a player could have multiple hand due to splits)
	player.erase(player.begin(), player.end());
	player.push_back(cHand());
}

void cGame::UpdateMoney(int count, double diff)
{
	money[count+MAXCOUNT]+=diff;
	times[count+MAXCOUNT]+= 1;
};

double cGame::GetMoney(int count)
{
	return money[count+MAXCOUNT];
};

double cGame::GetTimes(int count)
{
	return times[count+MAXCOUNT];
}

void cGame::OutStat(void)
{
	double avg = 0;
	double weight = 0;

	for(int c=-MAXCOUNT; c<=MAXCOUNT; c++)
	{
		if (GetMoney(c) == 0) continue;
		else
		{

			double money = GetMoney(c);
			double times = GetTimes(c);
			double thisavg = money / times;

			cout<< c << ' '
				<< setiosflags(ios::showpos) << setprecision(1) << GetMoney(c) << " / " 
				<< resetiosflags(ios::showpos) << setprecision(0) << GetTimes(c) << " = " 
				<< setiosflags(ios::showpos) << setprecision(5) << double(GetMoney(c)) / double(GetTimes(c)) << endl;

			avg += money;
			if (c <= 0) weight += money;
			else		weight += money * c;
		}
	}

	assert(fabs(GetMoney() - avg) < TOLERANCE);

	cout << "Average: " << avg << endl;
	cout << "Weight: " << weight << endl;

}