//Simulate blackjack and show it's possible to WIN!  =)

#include <vector>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <ctime>
#include "cDeck.h"
#include "Output.h"
#include "test.h"

using namespace std;

int main(void)
{
	//Show decision and probability table for debugging
	//ShowTable();
	if (TestAll() == false)
		cerr << "FAIL ONE OR MORE TESTS!" << endl;

	srand(unsigned int(time(NULL)));
	//srand(1);

	//Play the game
	cout << "Start to simulate " << NUMGAME << " games." << endl;
	cout << "  Number of decks: " << NUMDECK << endl;
    cout << "  Shuffle after " << NUMCARDUSE << " cards" << endl;

	//The parameters to games are...
	//  game(Dealer's strategy, player's strategy, player's betting strategy, double after split?, split more than once?)
	//  Strategy can be &Hit16, &HitSoft17, &Basic, &Optimal, or implement your own!
	//  Bet can be &AlwaysOne, &TwoBet, &MutliBet, &CountBet, or create your own!
	cGame game(&HitSoft17, &Optimal, &AlwaysOne, false, false);
	game.Play(NUMGAME, false);

	//Display the result: Figure out the pay off for each count
	const double COUNTMULT = 2.0; //Bet two dollars for each additional count
	cout << "Showing payoff table for each count..." << endl << endl;
	cout << "Count Payoff/Frequency Expected_Payoff Weighted_Payoff" << endl;

	double weight = 0; //weighted average (because bet changes due to count)
	double total = 0;
	for(int c=-MAXCOUNT; c<=MAXCOUNT; c++)
	{
		if (game.GetMoney(c) == 0) continue;
		else
		{

			double money = game.GetMoney(c);
			double times = game.GetTimes(c);
			double thisavg = money / times;

			double thisweight;
			if (c <= 0) thisweight = money;
			else		thisweight = money * COUNTMULT * c;

			total += money;
			weight += thisweight;

			cout.setf(ios_base::fixed);
			cout<< setw(4) << c << ' '
				<< setw(6) << setiosflags(ios::showpos) << setprecision(1) << game.GetMoney(c) << " / " 
				<< setw(8) << resetiosflags(ios::showpos) << setprecision(0) << game.GetTimes(c) << " = " 
				<< setw(11) << setiosflags(ios::showpos) << setprecision(6) << thisavg << ' '
				<< setw(11) << setiosflags(ios::showpos) << setprecision(6) << thisweight << endl;

		}
	}

	//The result for the statistics should match with the actual result
	assert(fabs(game.GetMoney() - total) < TOLERANCE);
	cout << endl;

	cout << "Payoff: " << total << " (If you always bet 1 dollars.)" <<  endl;
	cout << "Average: " << total / static_cast<double>(NUMGAME) << endl;
	cout << "Weighted payoff: " << weight << " (If you bet " << COUNTMULT << " for each additional count.)" << endl;
	cout << "Weighted average: " << weight / static_cast<double>(NUMGAME) << endl;

	return 1;
}
