#include "test.h"
#include "output.h"


void ShowTable(void)
{
	//Table is almost identical to the result on the internet =)
	for(int s=0; s<1; s++)
	{
		//Decide on the strategy
		cStrat strat;
		if (s == 1) strat = sHIT16;
		else if (s == 0) strat = sHITSOFT17;
		else assert(false);

		//Output the probability for dealer's ending total
		OutProb(strat);

		//Output the decision table assuming complete decks
		//Default Rule
		//  No Double after split
		//  Split at most once
		//  No surrender
		//  No insurance
		//  Double any two cards
		//  6 deck, shuffle after 3 decks
		//  Dealer checks for blackjack for both 10 and Ace
		//  Blackjack pays 3 to 2
		OutDecision(strat, true);
	}
}

bool TestAll(void)
{
	bool ret = true;

	bool result;
	cout << "Testing Deck...";
	result = TestDeck();
	ret = (result && ret);
	if (result) cout << "Passed" << endl;
	else cerr << "FAILED!!" << endl;

	cout << "Testing Count...";
	result = TestCount();
	ret = (result && ret);
	if (result) cout << "Passed" << endl;
	else cerr << "FAILED!!" << endl;

	cout << "Testing Hand...";
	result = TestHand();
	ret = (result && ret);
	if (result) cout << "Passed" << endl;
	else cerr << "FAILED!!" << endl;

	cout << endl;

	return ret;
}

bool TestDeck(void)
{
	cDeck deck(1);

	assert(deck.NumLeft() == 52);
	assert(deck.NumLeft(10) == 16);
	for(int i=2; i<=9; i++)
		assert(deck.NumLeft(1) == 4);

	cCard card = deck.ForceDeal(1); //deal an Ace
	assert(card == 1);

	assert(deck.NumLeft() == 51);
	assert(deck.NumLeft(1) == 3);

	for(int j=1; j<10; j++)
	{
		assert(deck.NumLeft() == 52 - j);
		deck.Deal();
	}

	deck.Reset();
	assert(deck.NumLeft() == 52);
	
	return true;
}

bool TestCount(void)
{
	cDeck deck(2);
	assert(deck.HighLowCount() == 0);

	deck.ForceDeal(10);
	deck.ForceDeal(11);
	assert(fabs(deck.HighLowCount() - (-2.0 * (52.0) / (52.0*2-2))) < TOLERANCE );
	
	deck.ForceDeal(2);
	deck.ForceDeal(3);
	assert(fabs(deck.HighLowCount()) < TOLERANCE);

	return true;
}

bool TestHand(void)
{
	cHand hand;
	hand.Add(10);
	assert(hand.GetTotal() == 10);

	hand.Add(10);
	assert(hand.GetTotal() == 20);

	hand.Reset();
	assert(hand.GetTotal() == 0);

	hand.Add(1);
	bool bSoft = true;
	assert(hand.GetTotal(bSoft) == 11);
	assert(bSoft);

	hand.Add(5);
	assert(hand.GetTotal(bSoft) == 16);
	assert(bSoft);

	hand.Add(2);
	assert(hand.GetTotal(bSoft) == 18);
	assert(bSoft);

	hand.Add(2);
	assert(hand.GetTotal(bSoft) == 20);
	assert(bSoft);

	hand.Add(1);
	assert(hand.GetTotal(bSoft) == 21);
	assert(bSoft);
	assert(hand.IsBlackjack() == false);

	hand.Add(1);
	assert(hand.GetTotal(bSoft) == 12);
	assert(!bSoft);

	hand.Add(1);
	assert(hand.GetTotal(bSoft) == 13);
	assert(!bSoft);

	hand.Add(9);
	assert(hand.GetTotal(bSoft) == 22);
	assert(!bSoft);

	hand.Reset();
	hand.Add(10);
	hand.Add(1);
	assert(hand.IsBlackjack());

	return true;
}