#include "Output.h"


ostream& operator<<(ostream& out, const cDecision dec)
{
	switch (dec)
	{
	case UNDEF:			out << "BAD"; break;
	case STAND:			out << "sta"; break;
	case HIT:			out << "hit"; break;
	case DOUBLE:		out << "2x!"; break;
	case DOUBLEORHIT:	out << "2/h"; break;
	case DOUBLEORSTAND:	out << "2/s"; break;
	case SPLIT:			out << "spl"; break;
	case NOTSPLIT:		out << "not"; break;
	default: assert(false);
	}

	return out;
}

void OutProb(cStrat strat)
{
	//Output heading
	cout << "Dealer's-up-card";
	for(int m=MINDEALERTOTAL; m<=MAXTOTAL; m++) cout << " " << m;
	cout << " Bust" << endl;

	//Store the probability for each total (+2 space to store the probability of bust)
	vector<double> overall(MAXTOTAL+2, 0);

	//Create a deck and use its function to extract the probabilities
	cDeck deck(1, true);

	//For each possible card the dealer shows (2 to Ace)
	for(int i=2; i<=11; i++)
	{
		vector<double> prob;

		//Figure out the probability for dealer to obtain a total of 17, 18 ... 21 and bust given the card dealer shows
		if (i == 11)
		{
			prob = deck.Prob(i, true, strat);
		}
		else
		{
			prob = deck.Prob(i, false, strat);
		}

		//Output dealer's up card
		cout.width(2);
		if (i < 11) cout << i << ' ';
		else if (i == 11) cout << "A ";
		else assert(false);

		double totalp = 0.0;
		cout.precision(OUTPROBPRECISION);
		cout.setf(ios::fixed);
		//Output the probability for those below 21
		for(int r=MINDEALERTOTAL; r<=MAXTOTAL; r++)
		{
			cout << prob[r] << ' ';
			totalp += prob[r];
		}

		//Dealer can never end with 16 or less
		for(int p=0; p<MINDEALERTOTAL; p++)
			assert(prob[p] == 0);

		//Accumulate all the probability of exceeding MAXTOTAL to MAXTOTAL+1
		double sum = prob[MAXTOTAL+1];
		totalp+= prob[MAXTOTAL+1];
		for(int b=MAXTOTAL+2; b<prob.size(); b++)
		{
			sum += prob[b];
			totalp += prob[b];
			prob[MAXTOTAL+1] += prob[b];
		}

		//Total probability of all dealer's possible total should add up to 1
		assert(fabs(totalp - 1.0) < TOLERANCE);

		//Output probability of bust
		assert(sum == prob[MAXTOTAL+1]);
		cout << sum << endl;

		//Add the probability to overall
		for(int o=MINDEALERTOTAL; o<=MAXTOTAL+1; o++)
		{
			//Weighted the probability of dealer's up card based on the number of such card in the deck.
			overall[o] += prob[o] * static_cast<double>(deck.NumLeft(i))/static_cast<double>(deck.NumLeft());
		}

	}

	//For checking total probability add up to 1
	double allp = 0;

	//Output overall results
	cout << "Overall ";
	for(int out=MINDEALERTOTAL; out<=MAXTOTAL+1; out++)
	{
		allp += overall[out];
		cout << overall[out] << ' ';
	}
	cout << endl;

	assert(fabs(allp - 1) < TOLERANCE);

}

void OutDecision(cStrat strat, bool bDetail)
{
	ofstream out(DECISIONFILENAME);

	//Create the deck
	cDeck deck(NUMDECK, true);

	vector<vector<cExp> > allexp(12);
	for(int a=2; a<=11; a++)
	{
		//Compute the expectation for player for each decision, (a = player's current total)
		allexp[a] = deck.Exp(a, strat);
	}

	int d;
	//Output decision table for "Hard Total"
	//  when d = 1, output headings
	for(d=1; d<=11; d++)
	{
		//Output the dealer's upcard
		if (d == 1) cout << endl << "HARD";
		else		cout << setw(2) << d << "  ";

		//Output to file
		if (d == 1) out << endl << "HARD ";
		else		out << d << ' ';

		for(int e=11; e<MAXTOTAL; e++)
		{
			if (d == 1) cout << setw(2) << e << "  ";
			else		cout << allexp[d][e].dec << ' ';

			if (d == 1) out << e << " ";
			else		out << allexp[d][e].dec << ' ';
		}
		cout << endl;
		out << endl;
	}

	//Output decision table for "Soft Total"
	for(d=1; d<=11; d++)
	{
		//Output the dealer's upcard
		cout.unsetf(ios::showpos);
		if (d == 1) cout << endl << "SOFT";
		else		cout << setw(2) << d << "  ";

		out.unsetf(ios::showpos);
		if (d == 1) out << endl << "SOFT ";
		else		out << d << " ";

		for(int e=13; e<MAXTOTAL; e++)
		{
			if (d == 1) cout << " A" << e-11 << ' ';
			else		cout << allexp[d][e].decsoft << ' ';

			if (d == 1) out << "A" << e-11 << ' ';
			else		out << allexp[d][e].decsoft << ' ';
		}	
		cout << endl;
		out << endl;
	}

	//Output decision table for Split
	for(d=1; d<=11; d++)
	{
		//Output the dealer's upcard
		cout.unsetf(ios::showpos);
		if (d == 1) cout << endl << "SPLT";
		else		cout << setw(2) << d << "  ";

		out.unsetf(ios::showpos);
		if (d == 1) out << endl << "SPLT ";
		else		out << d << " ";

		for(int e=4; e<=22; e+=2)
		{
			if (d == 1)
			{
				if (e/2 != 11) cout << setw(2) << e/2 << ' ';
				else			cout << " A ";

				if (e/2 != 11)	out << e/2 << ' ';
				else			out << "A ";
			}
			else
			{
				cout << ' ' << (allexp[d][e].split ? 'Y' : 'N') << ' ';
				out << (allexp[d][e].split ? 'Y' : 'N') << ' ';
			}
		}
		cout << endl;
		out << endl;
	}

	//figure out the overall odd
	double exp = deck.OverallExp();

	cout << endl << "Overall Exp:" << setprecision(OUTPROBPRECISION) << setw(OUTPROBPRECISION+2) << exp << endl;
	out << endl << "Overall Exp:" << setprecision(OUTPROBPRECISION) << setw(OUTPROBPRECISION+2) << exp << endl;

	//Output expectation tables
	if (bDetail)
	{
		cout << "More info in " << string(DECISIONFILENAME) << endl;

		//for hard total
		for(d=1; d<=11; d++)
		{
			//output the dealer's upcard
			out.unsetf(ios::showpos);
			if (d == 1) out << endl << "HARD ";
			else		out << d << ' ';

			for(int e=4; e<=21; e++)
			{
				if (d == 1)
				{
					out << e << ' ';
				}
				else
				{
					out.width(4);
					out.precision(2);
					out.setf(ios::fixed | ios::dec | ios::showpoint | ios::showpos);
					out  << allexp[d][e].expstand << ';'
						 << allexp[d][e].exphit << ';'
						 << allexp[d][e].expdouble;

					if (e != 21) out << ' ';
				}
			}
			out << endl;
		}

		//for soft total
		for(d=1; d<=11; d++)
		{
			//output the dealer's upcard
			out.unsetf(ios::showpos);
			if (d == 1) out << endl << "SOFT ";
			else		out << d << ' ';

			for(int e=12; e<=21; e++)
			{
				if (d == 1)
				{
					if (e == 12) out << "AA ";
					else out << "A" << e-11 << ' ';
				}
				else
				{
					out.width(4);
					out.precision(2);
					out.setf(ios::fixed | ios::dec | ios::showpoint | ios::showpos);
					out  << allexp[d][e].expstandsoft << ';'
						 << allexp[d][e].exphitsoft << ';'
						 << allexp[d][e].expdoublesoft;

					if (e != 21)
					{
						if (allexp[d][e].expsoft > 0) out << "*";
						
						out << ' ';
					}
				}
			}
			out << endl;
		}

		//for split
		for(d=1; d<=11; d++)
		{
			//output the dealer's upcard
			out.unsetf(ios::showpos);
			if (d == 1) out << endl << "SPLT "; //Always split Ace
			else		out << d << " ";

			for(int e=4; e<=22; e+=2)
			{
				if (d == 1)
				{
					if (e/2 != 11)	out << e/2 << ',' << e/2 << ' ';
					else			out << "A,A ";
				}
				else
				{
					out.setf(ios::showpos);
					double eNotSplit = max(allexp[d][e].exp, allexp[d][e].expdouble);
					//Handle two Aces seperately
					if (e == 22) eNotSplit = max(allexp[d][12].expsoft, allexp[d][12].expdoublesoft);

					out << eNotSplit << ';'
						<< allexp[d][e].expsplit << ' ';
				}
			}
			out << endl;
		}
	}
}

