#ifndef CONSTANTHEADER
#define CONSTANTHEADER

const long NUMGAME = 50000; //number of games to simulate
const int MAXTOTAL = 21; //the maximum total without bust
const int NUMDECK = 2; //the of decks to use
const int NUMCARDUSE = 60; //number of cards to use before reshuffle (Note: only check for reshuffle between rounds)
const double BLACKJACKBONUS = 0.5; //blackjack pays 2 to 3

const int MINDEALERTOTAL = 17; //Minimum amount for dealer -- useful for error checking

//Two possible strategies for the dealer
//  sHITSOFT17 = dealer hits soft 17 or hard 16
//  sHIT16 = dealer hits if the total is 16 or less
enum cStrat {sHITSOFT17, sHIT16};

enum cDecision {UNDEF = -1, STAND = 0, HIT, DOUBLE, DOUBLEORHIT, DOUBLEORSTAND, SPLIT, NOTSPLIT};

const int OUTPROBPRECISION = 7; //Number of decimal points to output in the probability table
const double TOLERANCE = 0.0001; //The tolerance when comparing two doubles.

const char DECISIONFILENAME[] = "out.txt";
const int MAXCOUNT = NUMDECK*30;  //An upper bound on the count

#endif