!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! File:  ctusrModule.f90
! Type definition for ctProb structure.
!
! 09 Feb 2010: Current version.
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

module ctUsrModule
  use precision,    only : ip, rp
  implicit none

  private
  public  :: ctProb

  ! Control problem data
  type ctProb

     ! General problem data:
     character(8) :: probName

     integer(ip) :: nY,   &  ! number of states
                    nU,   &  ! number of controls
                    nP,   &  ! number of parameters
                    nC,   &  ! number of additional constraints
                    nPhs     ! number of phases

     integer(ip), pointer :: objL(:),    &  ! location of objective
                             ytype(:,:), &  ! nonlinear/linear state eqns
                             ctype(:,:), &  ! nonlinear/linear algebraic constraints
                             npInt(:)       ! number of intervals in each phase

     real(rp),    pointer :: phsPt(:) ! start/end points for each phase


     ! For SPARSE structures:
     ! ( must be specified if using the sparse version )
     integer(ip), pointer :: neJ(:), &  ! number of Jacobian elements for odecon
                             neG(:)     ! number of Jacobian elements for algcon



     ! Options:
     integer(ip) :: iIntf, &
                    iDisc, &
                    iRefn, &
                    iCPrt, &
                    iRefL

     real(rp)    :: refTol

  end type ctProb

end module ctUsrModule

