*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  saduserfg.f
*
*     sdfnfg   s2fnfg   inisad
*
*     Written by Mike Gertz - 07-Mar-2000
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

       subroutine sdfnfg
     &   ( Status, nv, v,
     &     needF, lenF, F,
     &     needG, neG,  G,
     &     iwork, rwork,
     &     g_userf,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw,
     &     ia, lenia, ra, lenra )

      implicit
     &      none
      integer
     &     Status, nv, needF, lenF, needG, neG, lencu, lencw,
     &     leniu, leniw, lenia, lenru, lenrw, lenra,
     &     iu(leniu), iw(leniw), ia(lenia), iwork(nv)
      double precision
     &     F(lenF), v(nv), g(neG), ru(lenru), rw(lenrw), ra(lenra),
     &     rwork(nv)
      external
     &     g_userf
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     sdfnfg is an intermediate stage in calling an Adifor-generated
*     function, specialized to calling functions that define NLPs and
*     which were generated by sparse Adifor.
*
*     The process of calling an Adifor generated function is as follows,
*
*     userfg - has the interface needed by snopt. Decides whether to use
*     sparse or dense Adifor and passes on to the next layer.
*
*     sdfnfg - A gathers the data structures needed by Adifor out of
*     system memory (the cw, iw, rw arrays). Passes the data down to the
*     next layer.
*
*     spfnfg - A generic routine for calling a function generated by
*     sparse Adifor. Does some bookkeeping, and passes on to the next
*     layer.
*
*     s2fnfg - This routine provides a generic interface to a sparse
*     Adifor-generated function. Subroutine d2fnfg calls the code that
*     adifor generated from the users problem-definition function. The
*     generated code will have an interface specific to an NLP.
*     adfnfg
*
*     07 Mar 2000: First version of sdfnfg.
*     05 Jul 2000: Current version.
*     ==================================================================
      integer
     &     iirowC, neC, ijcolC, iC, iirowG, neGg, ijcolG, m, iitcon,
     &     mncon, ijtvar, nnvar, ijv, ij_cf, isizes(1)
      external
     &     s2fnfg
*     ------------------------------------------------------------------
*     isizes is not needed in this context.

      isizes(1)    = 0

      call getmtx
     &   ( iirowC, neC, ijcolC, iC,
     &     iirowG, neGg, ijcolG, m, ia, lenia )
      call gtadmx
     &   ( iitcon, mncon, ijtvar, nnvar,
     &     ijv, ij_cf, ia, lenia )
      call spfnfg
     &   ( Status,
     &     v, ia(ijv), nv, isizes,
     &     needF, lenF, F, ia(ij_cf),
     &     needG, ia(iirowG), neG, ia(ijcolG), G,
     &     ia(iitcon), mncon, ia(ijtvar), nnvar,
     &     iwork, rwork,
     &     g_userf, s2fnfg,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! subroutine sdfnfg

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2fnfg
     &   ( Status,
     &     v, j_v, nv, isizes,
     &     needF, lenF, F, j_cf,
     &     g_userf,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Status, nv, isizes(*), needF, lenF, lencu, lencw,
     &     leniu, leniw, lenru, lenrw, iu(leniu), iw(leniw),
     &     j_v(nv), j_cf(lenF)
      double precision
     &     v(nv), F(lenF), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)
      external
     &     g_userf

*     ==================================================================
*     s2fnfg calls the Adifor-generated routine that computes the
*     function and gradient.
*
*     The final layer in the process of calling an Adifor-generated
*     function, see sdfnfg for a description of the process.
*
*     07 Mar 2000: First version of s2fnfg.
*     05 Jul 2000: Current version.
*     ==================================================================
      integer
     &     mode
*     ------------------------------------------------------------------

      mode = 0

      call g_userf
     &   ( Status, mode, lenF,
     &     nv, v, j_v,
     &     F, j_cf,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! subroutine s2fnfg

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine inisad
     &   ( v0, nv, blv, buv,
     &     bl, lenF, bu,
     &     g_userf, adtlc, ladtlc,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw,
     &     ia, lenia, ra, lenra,
     &     lusdi, lusdr, morei, morer )

      implicit
     &     none
      integer
     &     nv, lenF, ladtlc, lencu, lencw, leniu, leniw, lenia,
     &     lenru, lenrw, lenra, lusdi, lusdr, morei, morer,
     &     iu(leniu), iw(leniw), ia(lenia)
      double precision
     &     v0(nv), blv(nv), buv(nv), bl(lenF), bu(lenF),
     &     ru(lenru), rw(lenrw), ra(lenra)
      character*8
     &     cu(lencu), cw(lencw)
      external
     &     g_userf, adtlc, ladtlc

*     ==================================================================
*     inisad
*
*     07 Mar 2000: First version of inisad.
*     30 Jun 2000: Current version.
*     ==================================================================
      integer
     &     isizes(1)
      external
     &     s2fnfg
*     ------------------------------------------------------------------
*     isizes is not used in this context

      isizes(1)  = 0

      call insdgn
     &   ( v0, nv, isizes, blv, buv,
     &     lenF, bl, bu,
     &     s2fnfg, g_userf, adtlc, ladtlc,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw,
     &     ia, lenia, ra, lenra,
     &     lusdi, lusdr, morei, morer )

      end ! subroutine inisad


