*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  daduserfg.f
*
*     ddfnfg   d2fnfg   inidad
*
*     Written by Mike Gertz - 07-Mar-2000
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

       subroutine ddfnfg
     &   ( Status, nv, v,
     &     needF, lenF, F,
     &     needG, neG,  G,
     &     g_userf,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw,
     &     ia, lenia, ra, lenra )

      implicit
     &      none
      integer
     &     Status, nv, needF, lenF, needG, neG, lencu, lencw,
     &     leniu, leniw, lenia, lenru, lenrw, lenra,
     &     iu(leniu), iw(leniw), ia(lenia)
      double precision
     &     F(lenF), v(nv), g(neG), ru(lenru), rw(lenrw), ra(lenra)
      external
     &     g_userf
      character
     &     cu(lencu)*8, cw(lencw)*8

*     ==================================================================
*     ddfnfg is an intermediate stage in calling an Adifor-generated
*     function, specialized to calling functions that define NLPs and
*     which were generated by dense Adifor.
*
*     The process of calling an Adifor generated function is as follows,
*
*     userfg - has the interface needed by snopt. Decides whether to use
*     sparse or dense Adifor and passes on to the next layer.
*
*     ddfnfg - gathers the data structures needed by Adifor out of
*     system memory (the cw, iw, rw arrays). Passes the data down to the
*     next layer.
*
*     defnfg - A generic routine for calling a function generated by
*     dense Adifor. Does some bookkeeping, and passes on to the next
*     layer.
*
*     d2fnfg - This routine provides a generic interface to a dense
*     Adifor-generated function.  Subroutine d2fnfg calls the code that
*     adifor generated from the users problem-definition function. The
*     generated code will have an interface specific to an NLP.
*
*     07 Mar 2000: First version of ddfnfg.
*     05 Jul 2000: Current version.
*     ==================================================================
      integer
     &     iirowc, neC, ijcolC, iC, iirowG, neGg, ijcolG, m, iitcon,
     &     mncon, ijtvar, nnvar, igv, ig_cf, isizes(1)
      external
     &     d2fnfg
*     ------------------------------------------------------------------
*     isizes is not needed in this context.

      isizes(1)    = 0

      call getmtx
     &   ( iirowc, neC, ijcolC, iC,
     &     iirowG, neGg, ijcolG, m, ia, lenia )
      call gtadmx
     &   ( iitcon, mncon, ijtvar, nnvar,
     &     igv, ig_cf, ia, lenia )
      call defnfg
     &   ( Status,
     &     v, ra(igv), nnvar, nv, isizes,
     &     needF, lenF, F, ra(ig_cf),
     &     needG, ia(iirowG), neG, ia(ijcolG), G,
     &     ia(iitcon), mncon, ia(ijtvar),
     &     d2fnfg, g_userf,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! subroutine ddfnfg

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine d2fnfg
     &   ( Status,
     &     v, g_v, nnvar, nv, isizes,
     &     needF, lenF, F, g_cf,
     &     g_userf,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Status, nnvar, nv, isizes(*), needF, lenF, lencu, lencw,
     &     leniu, leniw, lenru, lenrw, iu(leniu), iw(leniw)
      double precision
     &     v(nv), g_v(nnvar, nv), F(lenF), g_cf(nnvar,lenF),
     &     ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)
      external
     &     g_userf

*     ==================================================================
*     d2fnfg calls the Adifor-generated routine that computes the
*     function and gradient.
*
*     07 Mar 2000: First version of d2fnfg.
*     05 Jul 2000: Current version.
*
*     The final layer in the process of calling an Adifor-generated
*     function, see ddfnfg for a description of the process.
*     ==================================================================
      integer
     &     mode
*     ------------------------------------------------------------------

      mode = 0

      call g_userf
     &   ( nnvar, Status, mode, lenF,
     &     nv, v, g_v, nnvar,
     &     F, g_cf, nnvar,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! subroutine d2fnfg

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine inidad
     &   ( v0, nv, blv, buv,
     &     bl, lenF, bu,
     &     g_userf, adtlc, ladtlc,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw,
     &     ia, lenia, ra, lenra,
     &     lusdi, lusdr, morei, morer )

      implicit
     &     none
      integer
     &     nv, lenF, ladtlc, lencu, lencw, leniu, leniw, lenia,
     &     lenru, lenrw, lenra, lusdi, lusdr, morei, morer,
     &     iu(leniu), iw(leniw), ia(lenia)
      double precision
     &     v0(nv), blv(nv), buv(nv), bl(lenF), bu(lenF),
     &     ru(lenru), rw(lenrw), ra(lenra)
      character*8
     &     cu(lencu), cw(lencw)
      external
     &     g_userf, adtlc, ladtlc

*     ==================================================================
*     inidad
*
*     07 Mar 2000: First version of inidad.
*     30 Jun 2000: Current version.
*     ==================================================================
      integer
     &     NEGG, isizes(1)
      external
     &     d2fnfg
*     ------------------------------------------------------------------
*     isizes is not used in this context

      isizes(1)  = 0

      call inddgn
     &   ( v0, nv, isizes, blv, buv,
     &     bl, lenF, bu,
     &     d2fnfg, g_userf, adtlc, ladtlc,
     &     cu, lencu, iu, leniu, ru, lenru,
     &     cw, lencw, iw, leniw, rw, lenrw,
     &     ia, lenia, ra, lenra,
     &     lusdi, lusdr, morei, morer )

      end ! subroutine inidad


