 function [F,G] = snsolveuserfun(x)
%function [F,G] = snsolveuserfun(x)
% Defines the nonlinear part of the function and derivatives
% for the problem Hexagon.

F   = [  x(2)*x(6) - x(1)*x(7) + x(3)*x(7) + x(5)*x(8) - x(4)*x(9) - x(3)*x(8);
         x(1)^2          +  x(6)^2;
        (x(2) - x(1))^2  +  (x(7) - x(6))^2;
        (x(3) - x(1))^2  +  x(6)^2;
        (x(1) - x(4))^2  +  (x(6) - x(8))^2;
        (x(1) - x(5))^2  +  (x(6) - x(9))^2;
         x(2)^2          +  x(7)^2;
        (x(3) - x(2))^2  +  x(7)^2;;
        (x(4) - x(2))^2  +  (x(8) - x(7))^2;
        (x(2) - x(5))^2  +  (x(7) - x(9))^2;
        (x(4) - x(3))^2  +  x(8)^2;
        (x(5) - x(3))^2  +  x(9)^2;
         x(4)^2          +  x(8)^2;
        (x(4) - x(5))^2  +  (x(9) - x(8))^2;
         x(5)^2          +  x(9)^2;
         0;
         0;
         0;
         0 ];

% Define the derivatives.
% The coordinates aren't needed but we include them as a safety check.

G = [  1,   1,      -x(7);
       1,   2,       x(6);
       1,   3,       x(7)  - x(8);
       1,   4,      -x(9);
       1,   5,       x(8);
       1,   6,       x(2);
       1,   7,       x(3)  - x(1);
       1,   8,       x(5)  - x(3);
       1,   9,     - x(4);
       2,   1,     2*x(1);
       2,   6,     2*x(6);
       3,   1,    -2*(x(2) - x(1));
       3,   2,     2*(x(2) - x(1));
       3,   6,    -2*(x(7) - x(6));
       3,   7,     2*(x(7) - x(6));
       4,   1,    -2*(x(3) - x(1));
       4,   3,     2*(x(3) - x(1));
       4,   6,     2*x(6);
       5,   1,     2*(x(1) - x(4));
       5,   4,    -2*(x(1) - x(4));
       5,   6,     2*(x(6) - x(8));
       5,   8,    -2*(x(6) - x(8));
       6,   1,     2*(x(1) - x(5));
       6,   5,    -2*(x(1) - x(5));
       6,   6,     2*(x(6) - x(9));
       6,   9,    -2*(x(6) - x(9));
       7,   2,     2*x(2);
       7,   7,     2*x(7);
       8,   2,    -2*(x(3) - x(2));
       8,   3,     2*(x(3) - x(2));
       8,   7,     2*x(7);
       9,   2,    -2*(x(4) - x(2));
       9,   4,     2*(x(4) - x(2));
       9,   7,    -2*(x(8) - x(7));
       9,   8,     2*(x(8) - x(7));
      10,   2,     2*(x(2) - x(5));
      10,   5,    -2*(x(2) - x(5));
      10,   7,     2*(x(7) - x(9));
      10,   9,    -2*(x(7) - x(9));
      11,   3,    -2*(x(4) - x(3));
      11,   4,     2*(x(4) - x(3));
      11,   8,     2*x(8);
      12,   3,    -2*(x(5) - x(3));
      12,   5,     2*(x(5) - x(3));
      12,   9,     2*x(9);
      13,   4,     2*x(4);
      13,   8,     2*x(8);
      14,   4,     2*(x(4) - x(5));
      14,   5,    -2*(x(4) - x(5));
      14,   8,    -2*(x(9) - x(8));
      14,   9,     2*(x(9) - x(8));
      15,   5,     2*x(5);
      15,   9,     2*x(9) ];

G = G(:,3);
