
This is README.AMPL.                   Philip E. Gill, May 26, 2007.


 Purpose
 =======

 This README is  intended for those who wish to use  snopt as a solver
with the AMPL modeling language.  AMPL is a comprehensive and powerful
algebraic  modeling  language for  linear  and nonlinear  optimization
problems, in  discrete or continuous  variables (see the  AMPL website
http://www.ampl.com).  The symbol $SNOPT refers to the location of the
SNOPT installation.


 Overview
 ========

 There are two ways to call SNOPT from AMPL.

 (1) (Recommended)  Compile   the  AMPL  interface   provided  in  the
     directory $SNOPT/ampl/solvers/snopt.

 (2) Use the  SNOPT C++  interface to AMPL  provided in  the directory
     $SNOPT/snopt-ampl.

 Method (1) fully exploits the  problem structure provided by the AMPL
language.  Method (2)  makes it easier to get  started for Linux, Unix
and OSX users.

  For more information on using  Method (2), the reader is referred to
the readme  file in the directory $SNOPT/snopt-ampl.   For Method (1),
precompiled  SNOPT  AMPL executables  are  provided  in the  directory
$SNOPT/snopt-ampl/solvers/snopt.  The files are:

 +----------------------------------------------+
 | File Name      |  System       | Called as:  |
 |----------------+---------------+-------------|
 | snopt.exe_i686 | Windows       | snopt.exe   |
 | snopt_i686     | 32bit Linux   | snopt       |
 | snopt_x86_64   | 64bit Linux   | snopt       |
 | snopt_mac      | OSX ppc       | snopt       |
 | snopt_maci     | OSX intel     | snopt       |
 +----------------------------------------------+

 The appropriate  file must  be an executable  file renamed as  in the
"called as" column and placed  on the AMPL path.  If these precompiled
executables  work correctly  on  your system,  the  remainder of  this
README may be skipped.


 Constructing an SNOPT AMPL Interface
 ====================================

 Here we describe  how to create the SNOPT  AMPL executables for using
Method (1).

 AMPL uses the SNOPT  libraries libsnopt.a, libsnprint.a and libblas.a
for  Linux/Unix/OSX  systems and  snopt.lib  for  Windows.  The  files
needed to generate these libraries are provided in $SNOPT/ampl/solvers
and   its  subdirectories.    These  files   form  the   AMPL  Solvers
distribution,  which also may  be downloaded  from the  AMPL web-site:
http://www.netlib.org/ampl/.   Follow  the  links to  "solvers".   The
subdirectories of $SNOPT/solvers are:

  solvers  (AMPL files used to generate AMPL libraries  amplsolver.a
    |       for Linux/Unix/OSX or amplsolv.lib for Windows)
    |
  snopt    (contains the  SNOPT-AMPL  interface and makefiles needed
    |       to generate the AMPL-SNOPT executable 'snopt' for
    |       Linux/Unix/OSX or snopt.exe for Windows)
    |
   src     (contains makefiles for generating the snopt libraries
            needed to generate the AMPL/SNOPT executable 'snopt')


 First, you will need to generate the archived library amplsolver.a in
the ampl/solvers/ directory.  You will  not be able to create the AMPL
version of SNOPT without this  library.  The relevent README files are
provided by the AMPL team to help you do this.

 The  SNOPT  executable is  generated  using  one  of two  alternative
makefiles: makefile.u for  Linux/Unix/OSX systems, and makefile.vc for
the Microsoft  Visual Studio  C++ compiler.  We  suggest you  copy the
relevant  variant to "makefile",  then make  any necessary  changes to
"makefile".   The makefiles  in $SNOPT/ampl/solvers/snopt  assume that
the  snopt  libraries  (libsnopt.a,  libsnprint.a  and  libblas.a  for
Linux/Unix/OSX),  or  snopt.lib  (for  Windows)  are  present  in  the
directory  $SNOPT/ampl/solvers/snopt/src.    (Edit  the  makefiles  to
adjust "M =  src" appropriately if you put  the SNOPT source directory
elsewhere.)  The makefiles and  source assume f2c calling conventions;
see  $SNOPT/ampl/solvers/README.f77 for  information on  using Fortran
compilers that do not follow these conventions.

 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 |   PLEASE NOTE: the makefiles downloadable from the AMPL website   |
 |   are MACHINE DEPENDENT.  It is impossible to provide makefiles   |
 |   that will work for every compiler on every machine.  Please     |
 |   consult your LOCAL SYSTEM ADMINISTRATOR if you have trouble.    |
 |   If your  local system administrator is unable to help,          |
 |   contact the AMPL team at dmg@ampl.com (David M. Gay).           |
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


Specific instructions follow.


FOR LINUX/UNIX/OSX USERS:
=========================

Step 1:
-------

 Create  the AMPL  library $SNOPT/ampl/solvers/amplsolver.a  using the
command "make -f makefile.u" in $SNOPT/ampl/solvers.


Step 2:
-------

 Create the SNOPT libraries.  You have three ways to do this.

 Option 1. (Recommended.)   Use  the existing SNOPT  object libraries:
           $SNOPT/lib/libsnopt.a,     $SNOPT/lib/libsnprint.a,     and
           $SNOPT/lib/libblas.a  that are  generated during  the SNOPT
           installation.   Either   copy  these  libraries   into  the
           directory $SNOPT/ampl/solvers/snopt/src  or create symbolic
           links:
           ln -s  $SNOPT/lib/libsnopt.a   $SNOPT/ampl/solvers/snopt/src/
           ln -s  $SNOPT/lib/libsnprint.a $SNOPT/ampl/solvers/snopt/src/
           ln -s  $SNOPT/lib/libblas.a    $SNOPT/ampl/solvers/snopt/src/

 Option 2.  Create new archive libraries  libsnopt.a, libsnprint.a and
           libblas.a  using  Fortran source  code  and  the AMPL  Unix
           makefile   $SNOPT/ampl/solvers/snopt/src/makefile.fu.    In
           this case,  copy the Fortran  files *.f from  the directory
           $SNOPT/src/       into       the       AMPL       directory
           $SNOPT/ampl/solvers/snopt/src.  In this same directory, use
           makefile.fu to generate libsnopt.a and libblas.a.

 Option  3.  Generate  new  libraries libsnopt.a,  libsnprint.a  and
           libblas.a using C source  code and the AMPL unix makefile
           $SNOPT/ampl/solvers/snopt/src/makefile.u.   In this case,
           copy the C files *.c from the directory $SNOPT/csrc/ into
           the  AMPL  directory  $SNOPT/ampl/solvers/snopt/src.   In
           this   same  directory,   use   makefile.u  to   generate
           libsnopt.a, libsnprint.a and libblas.a.

           Make sure that you have  a copy of f2c.h in the directory
           $SNOPT/ampl/solvers.

Step 3:
-------

 Create the SNOPT executable.

In  the  directory  $SNOPT/ampl/solvers/snopt,  generate  the  snopt
executable using the provided makefile: makefile.u.

Step 4:
-------
 Place the executable 'snopt' on your path.


-----------------------------------------------------------------------------

FOR MSDOS/WINDOWS USERS:
========================

Step 1:
-------

 Create the AMPL library $SNOPT/ampl/solvers/amplsolver.lib  using the
command "nmake -f makefile.vc" in  $SNOPT/ampl/solvers.


Step 2:
-------

 Create the library snopt.lib.

 Option 1.  If  you  have MicroSoft Visual  Studio 2005, then  you may
            generate  the  library  snopt.lib  using the  Project  and
            Solution  files in $SNOPT/win32/snopt_csrc.   This library
            must   be  copied   to   $SNOPT/solvers/snopt/src.   After
            starting Visual Studio, open  a command prompt window from
            the "  Visual Studio tools"  menu.  This window  will have
            the correct PATH for the VC commands "nmake" and "cl".  In
            the  directory  $SNOPT/solvers/snopt,  invoke the  command
            "nmake  -f  makefile.vc".  This  will  generate the  SNOPT
            library snopt.lib.

 Option 2.  The  library snopt.lib can be generated  using the AMPL vc
            makefile $SNOPT/solvers/snopt/src/makefile.vc.

            Step (a) Define  the  correct  PATH  for  the VC  commands
                     "nmake" and "cl".

            Step (b) Copy the SNOPT  C source files from the directory
                     $SNOPT/csrc to $SNOPT/ampl/solvers/snopt/src.

            Step (b) Type the command  "nmake -f makefile.vc"  in the
                     directory $SNOPT/ampl/solvers/snopt/src

Step 3:
-------

 Create the SNOPT-AMPL executable snopt.exe.

 In  the  directory   $SNOPT/ampl/solvers/snopt,  generate  the  snopt
executable snopt.exe.

            type "nmake -f makefile.vc" in  $SNOPT/ampl/solvers/src

Step 4:
-------

Place the executable "snopt.exe" on your path.


-----------------------------------------------------------------------------
