/*
Generated 24-Jun-2008 21:10:06 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041


ROADMAP (srss.sd)

Bodies        Inb
No  Name      body Joint type  Coords q
--- --------- ---- ----------- ----------------
 -1 $ground                                    
  0 l.calf     -1  Pin           0             
  1 l.thigh     0  Sliding       1             
  2 torso       1  Pin           2             
  3 r.thigh     2  Pin           3             
  4 r.calf      3  Sliding       4             

*/
#include <math.h>
#include <stdio.h>

typedef struct {
    int ground_,nbod_,ndof_,ncons_,nloop_,nldof_,nloopc_,nball_,nlball_,npres_,
      nuser_;
    int jtype_[5],inb_[5],outb_[5],njntdof_[5],njntc_[5],njntp_[5],firstq_[5],
      ballq_[5],firstm_[5],firstp_[5];
    int trans_[5];
} srssgtopo_t;
#define ground (srssgtopo.ground_)
#define nbod (srssgtopo.nbod_)
#define ndof (srssgtopo.ndof_)
#define ncons (srssgtopo.ncons_)
#define nloop (srssgtopo.nloop_)
#define nldof (srssgtopo.nldof_)
#define nloopc (srssgtopo.nloopc_)
#define nball (srssgtopo.nball_)
#define nlball (srssgtopo.nlball_)
#define npres (srssgtopo.npres_)
#define nuser (srssgtopo.nuser_)
#define jtype (srssgtopo.jtype_)
#define inb (srssgtopo.inb_)
#define outb (srssgtopo.outb_)
#define njntdof (srssgtopo.njntdof_)
#define njntc (srssgtopo.njntc_)
#define njntp (srssgtopo.njntp_)
#define firstq (srssgtopo.firstq_)
#define ballq (srssgtopo.ballq_)
#define firstm (srssgtopo.firstm_)
#define firstp (srssgtopo.firstp_)
#define trans (srssgtopo.trans_)

typedef struct {
    double grav_[3],mk_[5],ik_[5][3][3],pin_[5][3];
    double rk_[5][3],ri_[5][3],pres_[5],stabvel_,stabpos_;
    int mfrcflg_,roustate_,vpkflg_,inerflg_,mmflg_,mmlduflg_,wwflg_,ltauflg_,
      fs0flg_,ii_,mmap_[5];
    int gravq_[3],mkq_[5],ikq_[5][3][3],pinq_[5][3],rkq_[5][3],riq_[5][3],presq_
      [5],stabvelq_,stabposq_;
    double mtot_,psmkg_,rhead_[5][3],rcom_[5][3],mkrcomt_[5][3][3],psikg_[3][3],
      psrcomg_[3],psrkg_[3],psrig_[3],psmk_[5],psik_[5][3][3],psrcom_[5][3],
      psrk_[5][3],psri_[5][3];
} srssginput_t;
#define grav (srssginput.grav_)
#define mk (srssginput.mk_)
#define ik (srssginput.ik_)
#define pin (srssginput.pin_)
#define rk (srssginput.rk_)
#define ri (srssginput.ri_)
#define pres (srssginput.pres_)
#define stabvel (srssginput.stabvel_)
#define stabpos (srssginput.stabpos_)
#define rhead (srssginput.rhead_)
#define rcom (srssginput.rcom_)
#define psrcomg (srssginput.psrcomg_)
#define psrcom (srssginput.psrcom_)
#define mkrcomt (srssginput.mkrcomt_)
#define psmk (srssginput.psmk_)
#define psik (srssginput.psik_)
#define psrk (srssginput.psrk_)
#define psri (srssginput.psri_)
#define psmkg (srssginput.psmkg_)
#define psikg (srssginput.psikg_)
#define psrkg (srssginput.psrkg_)
#define psrig (srssginput.psrig_)
#define mtot (srssginput.mtot_)
#define mfrcflg (srssginput.mfrcflg_)
#define roustate (srssginput.roustate_)
#define vpkflg (srssginput.vpkflg_)
#define inerflg (srssginput.inerflg_)
#define mmflg (srssginput.mmflg_)
#define mmlduflg (srssginput.mmlduflg_)
#define wwflg (srssginput.wwflg_)
#define ltauflg (srssginput.ltauflg_)
#define fs0flg (srssginput.fs0flg_)
#define ii (srssginput.ii_)
#define mmap (srssginput.mmap_)
#define gravq (srssginput.gravq_)
#define mkq (srssginput.mkq_)
#define ikq (srssginput.ikq_)
#define pinq (srssginput.pinq_)
#define rkq (srssginput.rkq_)
#define riq (srssginput.riq_)
#define presq (srssginput.presq_)
#define stabvelq (srssginput.stabvelq_)
#define stabposq (srssginput.stabposq_)

typedef struct {
    double curtim_,q_[5],qn_[5],u_[5],cnk_[5][3][3],cnb_[5][3][3];
    double rnk_[5][3],vnk_[5][3],wk_[5][3],rnb_[5][3],vnb_[5][3],wb_[5][3],
      wbrcom_[5][3],com_[3],rnkg_[3];
    double Cik_[5][3][3],rikt_[5][3][3],Iko_[5][3][3],mkrk_[5][3][3],Cib_[5][3][
      3];
    double Wkk_[5][3],Vkk_[5][3],dik_[5][3],rpp_[5][3],rpk_[5][3],rik_[5][3],
      rik2_[5][3];
    double rpri_[5][3],Wik_[5][3],Vik_[5][3],Wirk_[5][3],rkWkk_[5][3],Wkrpk_[5][
      3],VikWkr_[5][3];
    double perr_[1],verr_[1],aerr_[1],mult_[1],ufk_[5][3],utk_[5][3],mfk_[5][3],
      mtk_[5][3];
    double utau_[5],mtau_[5],uacc_[5],uvel_[5],upos_[5];
    double s0_,c0_,s2_,c2_,s3_,c3_;
} srssgstate_t;
#define curtim (srssgstate.curtim_)
#define q (srssgstate.q_)
#define qn (srssgstate.qn_)
#define u (srssgstate.u_)
#define cnk (srssgstate.cnk_)
#define cnb (srssgstate.cnb_)
#define rnkg (srssgstate.rnkg_)
#define rnk (srssgstate.rnk_)
#define rnb (srssgstate.rnb_)
#define vnk (srssgstate.vnk_)
#define vnb (srssgstate.vnb_)
#define wk (srssgstate.wk_)
#define wb (srssgstate.wb_)
#define com (srssgstate.com_)
#define Cik (srssgstate.Cik_)
#define Cib (srssgstate.Cib_)
#define rikt (srssgstate.rikt_)
#define Iko (srssgstate.Iko_)
#define mkrk (srssgstate.mkrk_)
#define Wkk (srssgstate.Wkk_)
#define Vkk (srssgstate.Vkk_)
#define dik (srssgstate.dik_)
#define rpp (srssgstate.rpp_)
#define rpk (srssgstate.rpk_)
#define rik (srssgstate.rik_)
#define rik2 (srssgstate.rik2_)
#define rpri (srssgstate.rpri_)
#define Wik (srssgstate.Wik_)
#define Vik (srssgstate.Vik_)
#define Wirk (srssgstate.Wirk_)
#define rkWkk (srssgstate.rkWkk_)
#define Wkrpk (srssgstate.Wkrpk_)
#define VikWkr (srssgstate.VikWkr_)
#define wbrcom (srssgstate.wbrcom_)
#define perr (srssgstate.perr_)
#define verr (srssgstate.verr_)
#define aerr (srssgstate.aerr_)
#define mult (srssgstate.mult_)
#define ufk (srssgstate.ufk_)
#define utk (srssgstate.utk_)
#define utau (srssgstate.utau_)
#define mfk (srssgstate.mfk_)
#define mtk (srssgstate.mtk_)
#define mtau (srssgstate.mtau_)
#define uacc (srssgstate.uacc_)
#define uvel (srssgstate.uvel_)
#define upos (srssgstate.upos_)
#define s0 (srssgstate.s0_)
#define c0 (srssgstate.c0_)
#define s2 (srssgstate.s2_)
#define c2 (srssgstate.c2_)
#define s3 (srssgstate.s3_)
#define c3 (srssgstate.c3_)

typedef struct {
    double fs0_[5],qdot_[5],Otk_[5][3],Atk_[5][3],AiOiWi_[5][3],Fstar_[5][3];
    double Tstar_[5][3],Fstark_[5][3],Tstark_[5][3],IkWk_[5][3],WkIkWk_[5][3],
      gk_[5][3],IkbWk_[5][3],WkIkbWk_[5][3];
    double w0w0_[5],w1w1_[5],w2w2_[5],w0w1_[5],w0w2_[5],w1w2_[5];
    double w00w11_[5],w00w22_[5],w11w22_[5],ww_[1][1],qraux_[1];
    double mm_[5][5],mlo_[5][5],mdi_[5],IkWpk_[5][5][3],works_[5],workss_[5][5];
    double Wpk_[5][5][3],Vpk_[5][5][3],VWri_[5][5][3];
    int wmap_[1],multmap_[1],jpvt_[1],wsiz_,wrank_;
} srssglhs_t;
#define qdot (srssglhs.qdot_)
#define Otk (srssglhs.Otk_)
#define Atk (srssglhs.Atk_)
#define AiOiWi (srssglhs.AiOiWi_)
#define Fstar (srssglhs.Fstar_)
#define Tstar (srssglhs.Tstar_)
#define fs0 (srssglhs.fs0_)
#define Fstark (srssglhs.Fstark_)
#define Tstark (srssglhs.Tstark_)
#define IkWk (srssglhs.IkWk_)
#define IkbWk (srssglhs.IkbWk_)
#define WkIkWk (srssglhs.WkIkWk_)
#define WkIkbWk (srssglhs.WkIkbWk_)
#define gk (srssglhs.gk_)
#define w0w0 (srssglhs.w0w0_)
#define w1w1 (srssglhs.w1w1_)
#define w2w2 (srssglhs.w2w2_)
#define w0w1 (srssglhs.w0w1_)
#define w0w2 (srssglhs.w0w2_)
#define w1w2 (srssglhs.w1w2_)
#define w00w11 (srssglhs.w00w11_)
#define w00w22 (srssglhs.w00w22_)
#define w11w22 (srssglhs.w11w22_)
#define ww (srssglhs.ww_)
#define qraux (srssglhs.qraux_)
#define mm (srssglhs.mm_)
#define mlo (srssglhs.mlo_)
#define mdi (srssglhs.mdi_)
#define IkWpk (srssglhs.IkWpk_)
#define works (srssglhs.works_)
#define workss (srssglhs.workss_)
#define Wpk (srssglhs.Wpk_)
#define Vpk (srssglhs.Vpk_)
#define VWri (srssglhs.VWri_)
#define wmap (srssglhs.wmap_)
#define multmap (srssglhs.multmap_)
#define jpvt (srssglhs.jpvt_)
#define wsiz (srssglhs.wsiz_)
#define wrank (srssglhs.wrank_)

typedef struct {
    double fs_[5],udot_[5],tauc_[5],dyad_[5][3][3],fc_[5][3],tc_[5][3];
    double ank_[5][3],onk_[5][3],Onkb_[5][3],AOnkri_[5][3],Ankb_[5][3],AnkAtk_[5
      ][3],anb_[5][3],onb_[5][3],dyrcom_[5][3];
    double ffk_[5][3],ttk_[5][3],fccikt_[5][3],ffkb_[5][3],ttkb_[5][3];
} srssgrhs_t;
#define fs (srssgrhs.fs_)
#define udot (srssgrhs.udot_)
#define ank (srssgrhs.ank_)
#define anb (srssgrhs.anb_)
#define onk (srssgrhs.onk_)
#define onb (srssgrhs.onb_)
#define Onkb (srssgrhs.Onkb_)
#define AOnkri (srssgrhs.AOnkri_)
#define Ankb (srssgrhs.Ankb_)
#define AnkAtk (srssgrhs.AnkAtk_)
#define dyrcom (srssgrhs.dyrcom_)
#define ffk (srssgrhs.ffk_)
#define ttk (srssgrhs.ttk_)
#define fccikt (srssgrhs.fccikt_)
#define ffkb (srssgrhs.ffkb_)
#define ttkb (srssgrhs.ttkb_)
#define dyad (srssgrhs.dyad_)
#define fc (srssgrhs.fc_)
#define tc (srssgrhs.tc_)
#define tauc (srssgrhs.tauc_)

typedef struct {
    double temp_[3000],tmat1_[3][3],tmat2_[3][3],tvec1_[3],tvec2_[3],tvec3_[3],
      tvec4_[3],tvec5_[3];
    double tsc1_,tsc2_,tsc3_;
} srssgtemp_t;
#define temp (srssgtemp.temp_)
#define tmat1 (srssgtemp.tmat1_)
#define tmat2 (srssgtemp.tmat2_)
#define tvec1 (srssgtemp.tvec1_)
#define tvec2 (srssgtemp.tvec2_)
#define tvec3 (srssgtemp.tvec3_)
#define tvec4 (srssgtemp.tvec4_)
#define tvec5 (srssgtemp.tvec5_)
#define tsc1 (srssgtemp.tsc1_)
#define tsc2 (srssgtemp.tsc2_)
#define tsc3 (srssgtemp.tsc3_)

srssgtopo_t srssgtopo = {
/*  Topological information
*/
    /* ground */ 1,
    /* nbod */ 5,
    /* ndof */ 5,
    /* ncons */ 0,
    /* nloop */ 0,
    /* nldof */ 0,
    /* nloopc */ 0,
    /* nball */ 0,
    /* nlball */ 0,
    /* npres */ 0,
    /* nuser */ 0,
    /* jtype[0] */ 1,
    /* jtype[1] */ 5,
    /* jtype[2] */ 1,
    /* jtype[3] */ 1,
    /* jtype[4] */ 5,
    /* inb[0] */ -1,
    /* inb[1] */ 0,
    /* inb[2] */ 1,
    /* inb[3] */ 2,
    /* inb[4] */ 3,
    /* outb[0] */ 0,
    /* outb[1] */ 1,
    /* outb[2] */ 2,
    /* outb[3] */ 3,
    /* outb[4] */ 4,
    /* njntdof[0] */ 1,
    /* njntdof[1] */ 1,
    /* njntdof[2] */ 1,
    /* njntdof[3] */ 1,
    /* njntdof[4] */ 1,
    /* njntc[0] */ 0,
    /* njntc[1] */ 0,
    /* njntc[2] */ 0,
    /* njntc[3] */ 0,
    /* njntc[4] */ 0,
    /* njntp[0] */ 0,
    /* njntp[1] */ 0,
    /* njntp[2] */ 0,
    /* njntp[3] */ 0,
    /* njntp[4] */ 0,
    /* firstq[0] */ 0,
    /* firstq[1] */ 1,
    /* firstq[2] */ 2,
    /* firstq[3] */ 3,
    /* firstq[4] */ 4,
    /* ballq[0] */ -104,
    /* ballq[1] */ -104,
    /* ballq[2] */ -104,
    /* ballq[3] */ -104,
    /* ballq[4] */ -104,
    /* firstm[0] */ -1,
    /* firstm[1] */ -1,
    /* firstm[2] */ -1,
    /* firstm[3] */ -1,
    /* firstm[4] */ -1,
    /* firstp[0] */ -1,
    /* firstp[1] */ -1,
    /* firstp[2] */ -1,
    /* firstp[3] */ -1,
    /* firstp[4] */ -1,
    /* trans[0] */ 0,
    /* trans[1] */ 1,
    /* trans[2] */ 0,
    /* trans[3] */ 0,
    /* trans[4] */ 1,
};
srssginput_t srssginput = {
/* Model parameters from the input file */

/* gravity */
    /* grav[0] */ 0.,
    /* grav[1] */ 0.,
    /* grav[2] */ -9.81,

/* mass */
    /* mk[0] */ 6.8952,
    /* mk[1] */ 5.676,
    /* mk[2] */ 50.,
    /* mk[3] */ 5.676,
    /* mk[4] */ 6.8952,

/* inertia */
    /* ik[0][0][0] */ 1.,
    /* ik[0][0][1] */ 0.,
    /* ik[0][0][2] */ 0.,
    /* ik[0][1][0] */ 0.,
    /* ik[0][1][1] */ .1535,
    /* ik[0][1][2] */ 0.,
    /* ik[0][2][0] */ 0.,
    /* ik[0][2][1] */ 0.,
    /* ik[0][2][2] */ 1.,
    /* ik[1][0][0] */ 1.,
    /* ik[1][0][1] */ 0.,
    /* ik[1][0][2] */ 0.,
    /* ik[1][1][0] */ 0.,
    /* ik[1][1][1] */ .09592,
    /* ik[1][1][2] */ 0.,
    /* ik[1][2][0] */ 0.,
    /* ik[1][2][1] */ 0.,
    /* ik[1][2][2] */ 1.,
    /* ik[2][0][0] */ 1.,
    /* ik[2][0][1] */ 0.,
    /* ik[2][0][2] */ 0.,
    /* ik[2][1][0] */ 0.,
    /* ik[2][1][1] */ 1.5,
    /* ik[2][1][2] */ 0.,
    /* ik[2][2][0] */ 0.,
    /* ik[2][2][1] */ 0.,
    /* ik[2][2][2] */ 1.,
    /* ik[3][0][0] */ 1.,
    /* ik[3][0][1] */ 0.,
    /* ik[3][0][2] */ 0.,
    /* ik[3][1][0] */ 0.,
    /* ik[3][1][1] */ .09592,
    /* ik[3][1][2] */ 0.,
    /* ik[3][2][0] */ 0.,
    /* ik[3][2][1] */ 0.,
    /* ik[3][2][2] */ 1.,
    /* ik[4][0][0] */ 1.,
    /* ik[4][0][1] */ 0.,
    /* ik[4][0][2] */ 0.,
    /* ik[4][1][0] */ 0.,
    /* ik[4][1][1] */ .1535,
    /* ik[4][1][2] */ 0.,
    /* ik[4][2][0] */ 0.,
    /* ik[4][2][1] */ 0.,
    /* ik[4][2][2] */ 1.,

/* tree hinge axis vectors */
    /* pin[0][0] */ 0.,
    /* pin[0][1] */ -1.,
    /* pin[0][2] */ 0.,
    /* pin[1][0] */ 0.,
    /* pin[1][1] */ 0.,
    /* pin[1][2] */ 1.,
    /* pin[2][0] */ 0.,
    /* pin[2][1] */ -1.,
    /* pin[2][2] */ 0.,
    /* pin[3][0] */ 0.,
    /* pin[3][1] */ -1.,
    /* pin[3][2] */ 0.,
    /* pin[4][0] */ 0.,
    /* pin[4][1] */ 0.,
    /* pin[4][2] */ -1.,

/* tree bodytojoint vectors */
    /* rk[0][0] */ 0.,
    /* rk[0][1] */ 0.,
    /* rk[0][2] */ -.1426,
    /* rk[1][0] */ 0.,
    /* rk[1][1] */ 0.,
    /* rk[1][2] */ -.202,
    /* rk[2][0] */ -.0889,
    /* rk[2][1] */ 0.,
    /* rk[2][2] */ -.2868,
    /* rk[3][0] */ 0.,
    /* rk[3][1] */ 0.,
    /* rk[3][2] */ .1898,
    /* rk[4][0] */ 0.,
    /* rk[4][1] */ 0.,
    /* rk[4][2] */ .2384,

/* tree inbtojoint vectors */
    /* ri[0][0] */ 0.,
    /* ri[0][1] */ 0.,
    /* ri[0][2] */ 0.,
    /* ri[1][0] */ 0.,
    /* ri[1][1] */ 0.,
    /* ri[1][2] */ .2384,
    /* ri[2][0] */ 0.,
    /* ri[2][1] */ 0.,
    /* ri[2][2] */ .1898,
    /* ri[3][0] */ .0889,
    /* ri[3][1] */ 0.,
    /* ri[3][2] */ -.2868,
    /* ri[4][0] */ 0.,
    /* ri[4][1] */ 0.,
    /* ri[4][2] */ -.202,

/* tree prescribed motion */
    /* pres[0] */ 0.,
    /* pres[1] */ 0.,
    /* pres[2] */ 0.,
    /* pres[3] */ 0.,
    /* pres[4] */ 0.,

/* stabilization parameters */
    /* stabvel */ 0.,
    /* stabpos */ 0.,

/* miscellaneous */
    /* mfrcflg */ 0,
    /* roustate */ 0,
    /* vpkflg */ 0,
    /* inerflg */ 0,
    /* mmflg */ 0,
    /* mmlduflg */ 0,
    /* wwflg */ 0,
    /* ltauflg */ 0,
    /* fs0flg */ 0,
    /* ii */ 0,
    /* mmap[0] */ 0,
    /* mmap[1] */ 1,
    /* mmap[2] */ 2,
    /* mmap[3] */ 3,
    /* mmap[4] */ 4,

/* Which parameters were "?" (1) or "<nominal>?" (3) */
    /* gravq[0] */ 0,
    /* gravq[1] */ 0,
    /* gravq[2] */ 0,
    /* mkq[0] */ 3,
    /* mkq[1] */ 3,
    /* mkq[2] */ 3,
    /* mkq[3] */ 3,
    /* mkq[4] */ 3,
    /* ikq[0][0][0] */ 0,
    /* ikq[0][0][1] */ 0,
    /* ikq[0][0][2] */ 0,
    /* ikq[0][1][0] */ 0,
    /* ikq[0][1][1] */ 3,
    /* ikq[0][1][2] */ 0,
    /* ikq[0][2][0] */ 0,
    /* ikq[0][2][1] */ 0,
    /* ikq[0][2][2] */ 0,
    /* ikq[1][0][0] */ 0,
    /* ikq[1][0][1] */ 0,
    /* ikq[1][0][2] */ 0,
    /* ikq[1][1][0] */ 0,
    /* ikq[1][1][1] */ 3,
    /* ikq[1][1][2] */ 0,
    /* ikq[1][2][0] */ 0,
    /* ikq[1][2][1] */ 0,
    /* ikq[1][2][2] */ 0,
    /* ikq[2][0][0] */ 0,
    /* ikq[2][0][1] */ 0,
    /* ikq[2][0][2] */ 0,
    /* ikq[2][1][0] */ 0,
    /* ikq[2][1][1] */ 3,
    /* ikq[2][1][2] */ 0,
    /* ikq[2][2][0] */ 0,
    /* ikq[2][2][1] */ 0,
    /* ikq[2][2][2] */ 0,
    /* ikq[3][0][0] */ 0,
    /* ikq[3][0][1] */ 0,
    /* ikq[3][0][2] */ 0,
    /* ikq[3][1][0] */ 0,
    /* ikq[3][1][1] */ 3,
    /* ikq[3][1][2] */ 0,
    /* ikq[3][2][0] */ 0,
    /* ikq[3][2][1] */ 0,
    /* ikq[3][2][2] */ 0,
    /* ikq[4][0][0] */ 0,
    /* ikq[4][0][1] */ 0,
    /* ikq[4][0][2] */ 0,
    /* ikq[4][1][0] */ 0,
    /* ikq[4][1][1] */ 3,
    /* ikq[4][1][2] */ 0,
    /* ikq[4][2][0] */ 0,
    /* ikq[4][2][1] */ 0,
    /* ikq[4][2][2] */ 0,
    /* pinq[0][0] */ 0,
    /* pinq[0][1] */ 0,
    /* pinq[0][2] */ 0,
    /* pinq[1][0] */ 0,
    /* pinq[1][1] */ 0,
    /* pinq[1][2] */ 0,
    /* pinq[2][0] */ 0,
    /* pinq[2][1] */ 0,
    /* pinq[2][2] */ 0,
    /* pinq[3][0] */ 0,
    /* pinq[3][1] */ 0,
    /* pinq[3][2] */ 0,
    /* pinq[4][0] */ 0,
    /* pinq[4][1] */ 0,
    /* pinq[4][2] */ 0,
    /* rkq[0][0] */ 3,
    /* rkq[0][1] */ 0,
    /* rkq[0][2] */ 3,
    /* rkq[1][0] */ 3,
    /* rkq[1][1] */ 0,
    /* rkq[1][2] */ 3,
    /* rkq[2][0] */ 3,
    /* rkq[2][1] */ 0,
    /* rkq[2][2] */ 3,
    /* rkq[3][0] */ 3,
    /* rkq[3][1] */ 0,
    /* rkq[3][2] */ 3,
    /* rkq[4][0] */ 3,
    /* rkq[4][1] */ 0,
    /* rkq[4][2] */ 3,
    /* riq[0][0] */ 0,
    /* riq[0][1] */ 0,
    /* riq[0][2] */ 0,
    /* riq[1][0] */ 3,
    /* riq[1][1] */ 0,
    /* riq[1][2] */ 3,
    /* riq[2][0] */ 3,
    /* riq[2][1] */ 0,
    /* riq[2][2] */ 3,
    /* riq[3][0] */ 3,
    /* riq[3][1] */ 0,
    /* riq[3][2] */ 3,
    /* riq[4][0] */ 3,
    /* riq[4][1] */ 0,
    /* riq[4][2] */ 3,
    /* presq[0] */ 0,
    /* presq[1] */ 0,
    /* presq[2] */ 0,
    /* presq[3] */ 0,
    /* presq[4] */ 0,
    /* stabvelq */ 3,
    /* stabposq */ 3,

/* End of values from input file */

};
srssgstate_t srssgstate;
srssglhs_t srssglhs;
srssgrhs_t srssgrhs;
srssgtemp_t srssgtemp;


void srssinit(void)
{
/*
Initialization routine


 This routine must be called before the first call to sdstate(), after
 supplying values for any `?' parameters in the input.
*/
    double sumsq,norminv;
    int i,j,k;


/* Check that all `?' parameters have been assigned values */

    for (k = 0; k < 3; k++) {
        if (gravq[k] == 1) {
            srssseterr(7,25);
        }
    }
    for (k = 0; k < 5; k++) {
        if (mkq[k] == 1) {
            srssseterr(7,26);
        }
        for (i = 0; i < 3; i++) {
            if (rkq[k][i] == 1) {
                srssseterr(7,29);
            }
            if (riq[k][i] == 1) {
                srssseterr(7,30);
            }
            for (j = 0; j < 3; j++) {
                if (ikq[k][i][j] == 1) {
                    srssseterr(7,27);
                }
            }
        }
    }
    for (k = 0; k < 5; k++) {
        for (i = 0; i < 3; i++) {
            if (pinq[k][i] == 1) {
                srssseterr(7,28);
            }
        }
    }

/* Normalize pin vectors if necessary */


/* Zero out Vpk and Wpk */

    for (i = 0; i < 5; i++) {
        for (j = i; j <= 4; j++) {
            for (k = 0; k < 3; k++) {
                Vpk[i][j][k] = 0.;
                Wpk[i][j][k] = 0.;
            }
        }
    }

/* Compute pseudobody-related constants */

    rcom[0][0] = 0.;
    rcom[0][1] = 0.;
    rcom[0][2] = 0.;
    rcom[1][0] = 0.;
    rcom[1][1] = 0.;
    rcom[1][2] = 0.;
    rcom[2][0] = 0.;
    rcom[2][1] = 0.;
    rcom[2][2] = 0.;
    rcom[3][0] = 0.;
    rcom[3][1] = 0.;
    rcom[3][2] = 0.;
    rcom[4][0] = 0.;
    rcom[4][1] = 0.;
    rcom[4][2] = 0.;
    dik[1][0] = (ri[1][0]-rk[0][0]);
    dik[1][2] = (ri[1][2]-rk[0][2]);
    dik[2][0] = (ri[2][0]-rk[1][0]);
    dik[2][2] = (ri[2][2]-rk[1][2]);
    dik[3][0] = (ri[3][0]-rk[2][0]);
    dik[3][2] = (ri[3][2]-rk[2][2]);
    dik[4][0] = (ri[4][0]-rk[3][0]);
    dik[4][2] = (ri[4][2]-rk[3][2]);

/* Compute mass properties-related constants */

    mtot = (mk[4]+(mk[3]+(mk[2]+(mk[0]+mk[1]))));
    mkrk[0][0][1] = -(mk[0]*rk[0][2]);
    mkrk[0][1][0] = (mk[0]*rk[0][2]);
    mkrk[0][1][2] = -(mk[0]*rk[0][0]);
    mkrk[0][2][1] = (mk[0]*rk[0][0]);
    mkrk[1][0][1] = -(mk[1]*rk[1][2]);
    mkrk[1][1][0] = (mk[1]*rk[1][2]);
    mkrk[1][1][2] = -(mk[1]*rk[1][0]);
    mkrk[1][2][1] = (mk[1]*rk[1][0]);
    mkrk[2][0][1] = -(mk[2]*rk[2][2]);
    mkrk[2][1][0] = (mk[2]*rk[2][2]);
    mkrk[2][1][2] = -(mk[2]*rk[2][0]);
    mkrk[2][2][1] = (mk[2]*rk[2][0]);
    mkrk[3][0][1] = -(mk[3]*rk[3][2]);
    mkrk[3][1][0] = (mk[3]*rk[3][2]);
    mkrk[3][1][2] = -(mk[3]*rk[3][0]);
    mkrk[3][2][1] = (mk[3]*rk[3][0]);
    mkrk[4][0][1] = -(mk[4]*rk[4][2]);
    mkrk[4][1][0] = (mk[4]*rk[4][2]);
    mkrk[4][1][2] = -(mk[4]*rk[4][0]);
    mkrk[4][2][1] = (mk[4]*rk[4][0]);
    Iko[0][0][0] = (1.-(mkrk[0][0][1]*rk[0][2]));
    Iko[0][0][2] = (mkrk[0][0][1]*rk[0][0]);
    Iko[0][1][1] = (ik[0][1][1]-((mkrk[0][1][2]*rk[0][0])-(mkrk[0][1][0]*
      rk[0][2])));
    Iko[0][2][0] = -(mkrk[0][2][1]*rk[0][2]);
    Iko[0][2][2] = (1.+(mkrk[0][2][1]*rk[0][0]));
    Iko[1][0][0] = (1.-(mkrk[1][0][1]*rk[1][2]));
    Iko[1][0][2] = (mkrk[1][0][1]*rk[1][0]);
    Iko[1][1][1] = (ik[1][1][1]-((mkrk[1][1][2]*rk[1][0])-(mkrk[1][1][0]*
      rk[1][2])));
    Iko[1][2][0] = -(mkrk[1][2][1]*rk[1][2]);
    Iko[1][2][2] = (1.+(mkrk[1][2][1]*rk[1][0]));
    Iko[2][0][0] = (1.-(mkrk[2][0][1]*rk[2][2]));
    Iko[2][0][2] = (mkrk[2][0][1]*rk[2][0]);
    Iko[2][1][1] = (ik[2][1][1]-((mkrk[2][1][2]*rk[2][0])-(mkrk[2][1][0]*
      rk[2][2])));
    Iko[2][2][0] = -(mkrk[2][2][1]*rk[2][2]);
    Iko[2][2][2] = (1.+(mkrk[2][2][1]*rk[2][0]));
    Iko[3][0][0] = (1.-(mkrk[3][0][1]*rk[3][2]));
    Iko[3][0][2] = (mkrk[3][0][1]*rk[3][0]);
    Iko[3][1][1] = (ik[3][1][1]-((mkrk[3][1][2]*rk[3][0])-(mkrk[3][1][0]*
      rk[3][2])));
    Iko[3][2][0] = -(mkrk[3][2][1]*rk[3][2]);
    Iko[3][2][2] = (1.+(mkrk[3][2][1]*rk[3][0]));
    Iko[4][0][0] = (1.-(mkrk[4][0][1]*rk[4][2]));
    Iko[4][0][2] = (mkrk[4][0][1]*rk[4][0]);
    Iko[4][1][1] = (ik[4][1][1]-((mkrk[4][1][2]*rk[4][0])-(mkrk[4][1][0]*
      rk[4][2])));
    Iko[4][2][0] = -(mkrk[4][2][1]*rk[4][2]);
    Iko[4][2][2] = (1.+(mkrk[4][2][1]*rk[4][0]));
    srssserialno(&i);
    if (i != 30123) {
        srssseterr(7,41);
    }
    roustate = 1;
}

/* Convert state to form using 1-2-3 Euler angles for ball joints. */

void srssst2ang(double st[5],
    double stang[5])
{
    int i;

    for (i = 0; i < 5; i++) {
        stang[i] = st[i];
    }
}

/* Convert 1-2-3 form of state back to Euler parameters for ball joints. */

void srssang2st(double stang[5],
    double st[5])
{
    int i;

    for (i = 0; i < 5; i++) {
        st[i] = stang[i];
    }
}

/* Normalize Euler parameters in state. */

void srssnrmsterr(double st[5],
    double normst[5],
    int routine)
{
    int i;

    for (i = 0; i < 5; i++) {
        normst[i] = st[i];
    }
}

void srssnormst(double st[5],
    double normst[5])
{

    srssnrmsterr(st,normst,0);
}

void srssstate(double timein,
    double qin[5],
    double uin[5])
{
/*
Compute kinematic information and store it in sdgstate.

Generated 24-Jun-2008 21:10:06 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    int i,j,qchg,uchg;

  /*
    printf( "srssstate: uin: %g %g %g %g %g\n",
	    uin[0], uin[1], uin[2], uin[3], uin[4], uin[5] );
  */

    if ((roustate != 1) && (roustate != 2) && (roustate != 3)) {
        srssseterr(8,22);
        return;
    }
    if (roustate == 1) {
        for (i = 0; i < 5; i++) {
            if (presq[i] == 1) {
                srssseterr(8,31);
            }
        }
    }
/*
See if time or any qs have changed since last call
*/
    if ((roustate != 1) && (timein == curtim)) {
        qchg = 0;
        for (i = 0; i < 5; i++) {
            if (qin[i] != q[i]) {
                qchg = 1;
                break;
            }
        }
    } else {
        qchg = 1;
    }
/*
If time and qs are unchanged, check us
*/
    if (qchg == 0) {
        uchg = 0;
        for (i = 0; i < 5; i++) {
            if (uin[i] != u[i]) {
                uchg = 1;
                break;
            }
        }
    } else {
        uchg = 1;
    }
    curtim = timein;
    roustate = 2;
    if (qchg == 0) {
        goto skipqs;
    }
/*
Position-related variables need to be computed
*/
    vpkflg = 0;
    mmflg = 0;
    mmlduflg = 0;
    wwflg = 0;
    for (i = 0; i < 5; i++) {
        q[i] = qin[i];
    }
/*
Compute sines and cosines of q
*/
    s0 = sin(q[0]);
    c0 = cos(q[0]);
    s2 = sin(q[2]);
    c2 = cos(q[2]);
    s3 = sin(q[3]);
    c3 = cos(q[3]);
/*
Compute across-axis direction cosines Cik
*/
/*
Compute across-joint direction cosines Cib
*/
/*
Compute gravity
*/
    gk[2][0] = -(9.81*((s0*c2)+(s2*c0)));
    gk[2][2] = (9.81*((s0*s2)-(c0*c2)));
    gk[3][0] = ((gk[2][0]*c3)+(gk[2][2]*s3));
    gk[3][2] = ((gk[2][2]*c3)-(gk[2][0]*s3));
/*
Compute cnk & cnb (direction cosines in N)
*/
    cnk[2][0][0] = ((c0*c2)-(s0*s2));
    cnk[2][0][2] = -((s0*c2)+(s2*c0));
    cnk[2][2][0] = ((s0*c2)+(s2*c0));
    cnk[2][2][2] = ((c0*c2)-(s0*s2));
    cnk[3][0][0] = ((cnk[2][0][0]*c3)+(cnk[2][0][2]*s3));
    cnk[3][0][2] = ((cnk[2][0][2]*c3)-(cnk[2][0][0]*s3));
    cnk[3][2][0] = ((cnk[2][2][0]*c3)+(cnk[2][2][2]*s3));
    cnk[3][2][2] = ((cnk[2][2][2]*c3)-(cnk[2][2][0]*s3));
    cnb[0][0][0] = c0;
    cnb[0][0][1] = 0.;
    cnb[0][0][2] = -s0;
    cnb[0][1][0] = 0.;
    cnb[0][1][1] = 1.;
    cnb[0][1][2] = 0.;
    cnb[0][2][0] = s0;
    cnb[0][2][1] = 0.;
    cnb[0][2][2] = c0;
    cnb[1][0][0] = c0;
    cnb[1][0][1] = 0.;
    cnb[1][0][2] = -s0;
    cnb[1][1][0] = 0.;
    cnb[1][1][1] = 1.;
    cnb[1][1][2] = 0.;
    cnb[1][2][0] = s0;
    cnb[1][2][1] = 0.;
    cnb[1][2][2] = c0;
    cnb[2][0][0] = cnk[2][0][0];
    cnb[2][0][1] = 0.;
    cnb[2][0][2] = cnk[2][0][2];
    cnb[2][1][0] = 0.;
    cnb[2][1][1] = 1.;
    cnb[2][1][2] = 0.;
    cnb[2][2][0] = cnk[2][2][0];
    cnb[2][2][1] = 0.;
    cnb[2][2][2] = cnk[2][2][2];
    cnb[3][0][0] = cnk[3][0][0];
    cnb[3][0][1] = 0.;
    cnb[3][0][2] = cnk[3][0][2];
    cnb[3][1][0] = 0.;
    cnb[3][1][1] = 1.;
    cnb[3][1][2] = 0.;
    cnb[3][2][0] = cnk[3][2][0];
    cnb[3][2][1] = 0.;
    cnb[3][2][2] = cnk[3][2][2];
    cnb[4][0][0] = cnk[3][0][0];
    cnb[4][0][1] = 0.;
    cnb[4][0][2] = cnk[3][0][2];
    cnb[4][1][0] = 0.;
    cnb[4][1][1] = 1.;
    cnb[4][1][2] = 0.;
    cnb[4][2][0] = cnk[3][2][0];
    cnb[4][2][1] = 0.;
    cnb[4][2][2] = cnk[3][2][2];
/*
Compute q-related auxiliary variables
*/
    rpri[1][2] = (q[1]+ri[1][2]);
    rpri[4][2] = (ri[4][2]-q[4]);
    rpk[1][2] = (q[1]-rk[1][2]);
    rpk[4][2] = -(q[4]+rk[4][2]);
    rik[1][0] = (ri[1][0]-rk[1][0]);
    rik[1][2] = (ri[1][2]+rpk[1][2]);
    rik[2][0] = (((ri[2][0]*c2)+(ri[2][2]*s2))-rk[2][0]);
    rik[2][2] = (((ri[2][2]*c2)-(ri[2][0]*s2))-rk[2][2]);
    rik[3][0] = (((ri[3][0]*c3)+(ri[3][2]*s3))-rk[3][0]);
    rik[3][2] = (((ri[3][2]*c3)-(ri[3][0]*s3))-rk[3][2]);
    rik[4][0] = (ri[4][0]-rk[4][0]);
    rik[4][2] = (ri[4][2]+rpk[4][2]);
/*
Compute rnk & rnb (mass center locations in N)
*/
    rnk[0][0] = ((rk[0][2]*s0)-(rk[0][0]*c0));
    rnk[0][2] = -((rk[0][0]*s0)+(rk[0][2]*c0));
    rnk[1][0] = ((rnk[0][0]+((ri[1][0]*c0)-(ri[1][2]*s0)))-((rk[1][0]*c0)+(
      rpk[1][2]*s0)));
    rnk[1][2] = ((rnk[0][2]+((ri[1][0]*s0)+(ri[1][2]*c0)))+((rpk[1][2]*c0)-(
      rk[1][0]*s0)));
    rnk[2][0] = ((rnk[1][0]+((ri[2][0]*c0)-(ri[2][2]*s0)))-((cnk[2][0][0]*
      rk[2][0])+(cnk[2][0][2]*rk[2][2])));
    rnk[2][2] = ((rnk[1][2]+((ri[2][0]*s0)+(ri[2][2]*c0)))-((cnk[2][2][0]*
      rk[2][0])+(cnk[2][2][2]*rk[2][2])));
    rnk[3][0] = ((rnk[2][0]+((cnk[2][0][0]*ri[3][0])+(cnk[2][0][2]*ri[3][2])))-(
      (cnk[3][0][0]*rk[3][0])+(cnk[3][0][2]*rk[3][2])));
    rnk[3][2] = ((rnk[2][2]+((cnk[2][2][0]*ri[3][0])+(cnk[2][2][2]*ri[3][2])))-(
      (cnk[3][2][0]*rk[3][0])+(cnk[3][2][2]*rk[3][2])));
    rnk[4][0] = ((rnk[3][0]+((cnk[3][0][0]*ri[4][0])+(cnk[3][0][2]*ri[4][2])))+(
      (cnk[3][0][2]*rpk[4][2])-(cnk[3][0][0]*rk[4][0])));
    rnk[4][2] = ((rnk[3][2]+((cnk[3][2][0]*ri[4][0])+(cnk[3][2][2]*ri[4][2])))+(
      (cnk[3][2][2]*rpk[4][2])-(cnk[3][2][0]*rk[4][0])));
    rnb[0][0] = rnk[0][0];
    rnb[0][1] = 0.;
    rnb[0][2] = rnk[0][2];
    rnb[1][0] = rnk[1][0];
    rnb[1][1] = 0.;
    rnb[1][2] = rnk[1][2];
    rnb[2][0] = rnk[2][0];
    rnb[2][1] = 0.;
    rnb[2][2] = rnk[2][2];
    rnb[3][0] = rnk[3][0];
    rnb[3][1] = 0.;
    rnb[3][2] = rnk[3][2];
    rnb[4][0] = rnk[4][0];
    rnb[4][1] = 0.;
    rnb[4][2] = rnk[4][2];
/*
Compute com (system mass center location in N)
*/
    com[0] = ((1./mtot)*((mk[4]*rnk[4][0])+((mk[3]*rnk[3][0])+((mk[2]*rnk[2][0])
      +((mk[0]*rnk[0][0])+(mk[1]*rnk[1][0]))))));
    com[1] = 0.;
    com[2] = ((1./mtot)*((mk[4]*rnk[4][2])+((mk[3]*rnk[3][2])+((mk[2]*rnk[2][2])
      +((mk[0]*rnk[0][2])+(mk[1]*rnk[1][2]))))));
    skipqs: ;
    if (uchg == 0) {
        goto skipus;
    }
/*
Velocity-related variables need to be computed
*/
    inerflg = 0;
    for (i = 0; i < 5; i++) {
        u[i] = uin[i];
    }
    /*
    printf( "srssstate: computing v: %g %g %g %g %g\n",
	    u[0], u[1], u[2], u[3], u[4], u[5] );
    */
/*
Compute u-related auxiliary variables
*/
/*
Compute wk & wb (angular velocities)
*/
    wk[2][1] = -(u[0]+u[2]);
    wk[3][1] = (wk[2][1]-u[3]);
    wb[0][0] = 0.;
    wb[0][1] = -u[0];
    wb[0][2] = 0.;
    wb[1][0] = 0.;
    wb[1][1] = -u[0];
    wb[1][2] = 0.;
    wb[2][0] = 0.;
    wb[2][1] = wk[2][1];
    wb[2][2] = 0.;
    wb[3][0] = 0.;
    wb[3][1] = wk[3][1];
    wb[3][2] = 0.;
    wb[4][0] = 0.;
    wb[4][1] = wk[3][1];
    wb[4][2] = 0.;
/*
Compute auxiliary variables involving wk
*/
    Wirk[1][0] = -(ri[1][2]*u[0]);
    Wirk[1][2] = (ri[1][0]*u[0]);
    Wirk[2][0] = -(ri[2][2]*u[0]);
    Wirk[2][2] = (ri[2][0]*u[0]);
    Wirk[3][0] = (ri[3][2]*wk[2][1]);
    Wirk[3][2] = -(ri[3][0]*wk[2][1]);
    Wirk[4][0] = (ri[4][2]*wk[3][1]);
    Wirk[4][2] = -(ri[4][0]*wk[3][1]);
    Wkrpk[0][0] = (rk[0][2]*u[0]);
    Wkrpk[0][2] = -(rk[0][0]*u[0]);
    Wkrpk[1][0] = -(rpk[1][2]*u[0]);
    Wkrpk[1][2] = -(rk[1][0]*u[0]);
    Wkrpk[2][0] = -(rk[2][2]*wk[2][1]);
    Wkrpk[2][2] = (rk[2][0]*wk[2][1]);
    Wkrpk[3][0] = -(rk[3][2]*wk[3][1]);
    Wkrpk[3][2] = (rk[3][0]*wk[3][1]);
    Wkrpk[4][0] = (rpk[4][2]*wk[3][1]);
    Wkrpk[4][2] = (rk[4][0]*wk[3][1]);
    VikWkr[1][2] = (u[1]+Wkrpk[1][2]);
    VikWkr[4][2] = (Wkrpk[4][2]-u[4]);
    IkWk[0][1] = -(ik[0][1][1]*u[0]);
    IkWk[1][1] = -(ik[1][1][1]*u[0]);
    IkWk[2][1] = (ik[2][1][1]*wk[2][1]);
    IkWk[3][1] = (ik[3][1][1]*wk[3][1]);
    IkWk[4][1] = (ik[4][1][1]*wk[3][1]);
/*
Compute temporaries for use in SDRHS
*/
    w1w1[0] = (u[0]*u[0]);
    w1w1[1] = (u[0]*u[0]);
    w1w1[2] = (wk[2][1]*wk[2][1]);
    w1w1[3] = (wk[3][1]*wk[3][1]);
    w1w1[4] = (wk[3][1]*wk[3][1]);
/*
Compute vnk & vnb (mass center linear velocities in N)
*/
    vnk[0][0] = ((Wkrpk[0][0]*c0)-(Wkrpk[0][2]*s0));
    vnk[0][2] = ((Wkrpk[0][0]*s0)+(Wkrpk[0][2]*c0));
    vnk[1][0] = ((vnk[0][0]+((Wirk[1][0]*c0)-(Wirk[1][2]*s0)))+((Wkrpk[1][0]*c0)
      -(VikWkr[1][2]*s0)));
    vnk[1][2] = ((vnk[0][2]+((Wirk[1][0]*s0)+(Wirk[1][2]*c0)))+((VikWkr[1][2]*c0
      )+(Wkrpk[1][0]*s0)));
    vnk[2][0] = ((vnk[1][0]+((Wirk[2][0]*c0)-(Wirk[2][2]*s0)))+((cnk[2][0][0]*
      Wkrpk[2][0])+(cnk[2][0][2]*Wkrpk[2][2])));
    vnk[2][2] = ((vnk[1][2]+((Wirk[2][0]*s0)+(Wirk[2][2]*c0)))+((cnk[2][2][0]*
      Wkrpk[2][0])+(cnk[2][2][2]*Wkrpk[2][2])));
    vnk[3][0] = ((vnk[2][0]+((cnk[2][0][0]*Wirk[3][0])+(cnk[2][0][2]*Wirk[3][2])
      ))+((cnk[3][0][0]*Wkrpk[3][0])+(cnk[3][0][2]*Wkrpk[3][2])));
    vnk[3][2] = ((vnk[2][2]+((cnk[2][2][0]*Wirk[3][0])+(cnk[2][2][2]*Wirk[3][2])
      ))+((cnk[3][2][0]*Wkrpk[3][0])+(cnk[3][2][2]*Wkrpk[3][2])));
    vnk[4][0] = ((vnk[3][0]+((cnk[3][0][0]*Wirk[4][0])+(cnk[3][0][2]*Wirk[4][2])
      ))+((cnk[3][0][0]*Wkrpk[4][0])+(cnk[3][0][2]*VikWkr[4][2])));
    vnk[4][2] = ((vnk[3][2]+((cnk[3][2][0]*Wirk[4][0])+(cnk[3][2][2]*Wirk[4][2])
      ))+((cnk[3][2][0]*Wkrpk[4][0])+(cnk[3][2][2]*VikWkr[4][2])));
    vnb[0][0] = vnk[0][0];
    vnb[0][1] = 0.;
    vnb[0][2] = vnk[0][2];
    vnb[1][0] = vnk[1][0];
    vnb[1][1] = 0.;
    vnb[1][2] = vnk[1][2];
    vnb[2][0] = vnk[2][0];
    vnb[2][1] = 0.;
    vnb[2][2] = vnk[2][2];
    vnb[3][0] = vnk[3][0];
    vnb[3][1] = 0.;
    vnb[3][2] = vnk[3][2];
    vnb[4][0] = vnk[4][0];
    vnb[4][1] = 0.;
    vnb[4][2] = vnk[4][2];
/*
Compute qdot (kinematical equations)
*/
    qdot[0] = u[0];
    qdot[1] = u[1];
    qdot[2] = u[2];
    qdot[3] = u[3];
    qdot[4] = u[4];
    skipus: ;
/*
Initialize applied forces and torques to zero
*/
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 3; j++) {
            ufk[i][j] = 0.;
            utk[i][j] = 0.;
        }
    }
    for (i = 0; i < 5; i++) {
        utau[i] = 0.;
    }
    ltauflg = 0;
    fs0flg = 0;
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  128 adds/subtracts/negates
                    146 multiplies
                      2 divides
                    219 assignments
*/
}

void srssqdot(double oqdot[5])
{
/*
Return position coordinate derivatives for tree joints.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(63,23);
        return;
    }
    for (i = 0; i <= 4; i++) {
        oqdot[i] = qdot[i];
    }
}

void srssu2qdot(double uin[5],
    double oqdot[5])
{
/*
Convert velocities to qdots.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(64,23);
        return;
    }
    for (i = 0; i <= 4; i++) {
        oqdot[i] = uin[i];
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srsspsstate(double lqin[1])
{

    if (roustate != 2) {
        srssseterr(9,23);
        return;
    }
}

void srssdovpk(void)
{

    if (vpkflg == 0) {
/*
Compute Wpk (partial angular velocities)
*/
        Wpk[0][0][1] = -1.;
        Wpk[0][1][1] = -1.;
        Wpk[0][2][1] = -1.;
        Wpk[0][3][1] = -1.;
        Wpk[0][4][1] = -1.;
        Wpk[2][2][1] = -1.;
        Wpk[2][3][1] = -1.;
        Wpk[2][4][1] = -1.;
        Wpk[3][3][1] = -1.;
        Wpk[3][4][1] = -1.;
/*
Compute Vpk (partial velocities)
*/
        Vpk[0][0][0] = rk[0][2];
        Vpk[0][0][2] = -rk[0][0];
        VWri[0][1][0] = (rk[0][2]-ri[1][2]);
        VWri[0][1][2] = (ri[1][0]-rk[0][0]);
        Vpk[0][1][0] = (VWri[0][1][0]-rpk[1][2]);
        Vpk[0][1][2] = (VWri[0][1][2]-rk[1][0]);
        VWri[0][2][0] = (Vpk[0][1][0]-ri[2][2]);
        VWri[0][2][2] = (ri[2][0]+Vpk[0][1][2]);
        Vpk[0][2][0] = (rk[2][2]+((VWri[0][2][0]*c2)+(VWri[0][2][2]*s2)));
        Vpk[0][2][2] = (((VWri[0][2][2]*c2)-(VWri[0][2][0]*s2))-rk[2][0]);
        VWri[0][3][0] = (Vpk[0][2][0]-ri[3][2]);
        VWri[0][3][2] = (ri[3][0]+Vpk[0][2][2]);
        Vpk[0][3][0] = (rk[3][2]+((VWri[0][3][0]*c3)+(VWri[0][3][2]*s3)));
        Vpk[0][3][2] = (((VWri[0][3][2]*c3)-(VWri[0][3][0]*s3))-rk[3][0]);
        VWri[0][4][0] = (Vpk[0][3][0]-ri[4][2]);
        VWri[0][4][2] = (ri[4][0]+Vpk[0][3][2]);
        Vpk[0][4][0] = (VWri[0][4][0]-rpk[4][2]);
        Vpk[0][4][2] = (VWri[0][4][2]-rk[4][0]);
        Vpk[1][1][2] = 1.;
        Vpk[1][2][0] = s2;
        Vpk[1][2][2] = c2;
        Vpk[1][3][0] = ((s2*c3)+(s3*c2));
        Vpk[1][3][2] = ((c2*c3)-(s2*s3));
        Vpk[1][4][0] = Vpk[1][3][0];
        Vpk[1][4][2] = Vpk[1][3][2];
        Vpk[2][2][0] = rk[2][2];
        Vpk[2][2][2] = -rk[2][0];
        VWri[2][3][0] = (rk[2][2]-ri[3][2]);
        VWri[2][3][2] = (ri[3][0]-rk[2][0]);
        Vpk[2][3][0] = (rk[3][2]+((VWri[2][3][0]*c3)+(VWri[2][3][2]*s3)));
        Vpk[2][3][2] = (((VWri[2][3][2]*c3)-(VWri[2][3][0]*s3))-rk[3][0]);
        VWri[2][4][0] = (Vpk[2][3][0]-ri[4][2]);
        VWri[2][4][2] = (ri[4][0]+Vpk[2][3][2]);
        Vpk[2][4][0] = (VWri[2][4][0]-rpk[4][2]);
        Vpk[2][4][2] = (VWri[2][4][2]-rk[4][0]);
        Vpk[3][3][0] = rk[3][2];
        Vpk[3][3][2] = -rk[3][0];
        VWri[3][4][0] = (rk[3][2]-ri[4][2]);
        VWri[3][4][2] = (ri[4][0]-rk[3][0]);
        Vpk[3][4][0] = (VWri[3][4][0]-rpk[4][2]);
        Vpk[3][4][2] = (VWri[3][4][2]-rk[4][0]);
        Vpk[4][4][2] = -1.;
        vpkflg = 1;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   39 adds/subtracts/negates
                     16 multiplies
                      0 divides
                     52 assignments
*/
}

void srssdoltau(void)
{

/*
Compute effect of loop hinge torques
*/
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      0 assignments
*/
}

void srssdoiner(void)
{

/*
Compute inertial accelerations and related temps
*/
    if (inerflg == 0) {
/*
Compute Otk (inertial angular acceleration)
*/
/*
Compute Atk (inertial linear acceleration)
*/
        Atk[0][0] = -(u[0]*Wkrpk[0][2]);
        Atk[0][2] = (u[0]*Wkrpk[0][0]);
        AiOiWi[1][0] = (Atk[0][0]-(u[0]*Wirk[1][2]));
        AiOiWi[1][2] = (Atk[0][2]+(u[0]*Wirk[1][0]));
        Atk[1][0] = (AiOiWi[1][0]-((2.*(u[0]*u[1]))+(u[0]*Wkrpk[1][2])));
        Atk[1][2] = (AiOiWi[1][2]+(u[0]*Wkrpk[1][0]));
        AiOiWi[2][0] = (Atk[1][0]-(u[0]*Wirk[2][2]));
        AiOiWi[2][2] = (Atk[1][2]+(u[0]*Wirk[2][0]));
        Atk[2][0] = ((wk[2][1]*Wkrpk[2][2])+((AiOiWi[2][0]*c2)+(AiOiWi[2][2]*s2)
          ));
        Atk[2][2] = (((AiOiWi[2][2]*c2)-(AiOiWi[2][0]*s2))-(wk[2][1]*Wkrpk[2][0]
          ));
        AiOiWi[3][0] = (Atk[2][0]+(Wirk[3][2]*wk[2][1]));
        AiOiWi[3][2] = (Atk[2][2]-(Wirk[3][0]*wk[2][1]));
        Atk[3][0] = ((wk[3][1]*Wkrpk[3][2])+((AiOiWi[3][0]*c3)+(AiOiWi[3][2]*s3)
          ));
        Atk[3][2] = (((AiOiWi[3][2]*c3)-(AiOiWi[3][0]*s3))-(wk[3][1]*Wkrpk[3][0]
          ));
        AiOiWi[4][0] = (Atk[3][0]+(Wirk[4][2]*wk[3][1]));
        AiOiWi[4][2] = (Atk[3][2]-(Wirk[4][0]*wk[3][1]));
        Atk[4][0] = (AiOiWi[4][0]+((wk[3][1]*Wkrpk[4][2])-(2.*(u[4]*wk[3][1]))))
          ;
        Atk[4][2] = (AiOiWi[4][2]-(wk[3][1]*Wkrpk[4][0]));
        inerflg = 1;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   23 adds/subtracts/negates
                     30 multiplies
                      0 divides
                     18 assignments
*/
}

void srssdofs0(void)
{

/*
Compute effect of all applied loads
*/
    if (fs0flg == 0) {
        srssdoltau();
        srssdoiner();
/*
Compute Fstar (forces)
*/
        Fstar[0][0] = ((mk[0]*(Atk[0][0]+(9.81*s0)))-ufk[0][0]);
        Fstar[0][2] = ((mk[0]*(Atk[0][2]+(9.81*c0)))-ufk[0][2]);
        Fstar[1][0] = ((mk[1]*(Atk[1][0]+(9.81*s0)))-ufk[1][0]);
        Fstar[1][2] = ((mk[1]*(Atk[1][2]+(9.81*c0)))-ufk[1][2]);
        Fstar[2][0] = ((mk[2]*(Atk[2][0]-gk[2][0]))-ufk[2][0]);
        Fstar[2][2] = ((mk[2]*(Atk[2][2]-gk[2][2]))-ufk[2][2]);
        Fstar[3][0] = ((mk[3]*(Atk[3][0]-gk[3][0]))-ufk[3][0]);
        Fstar[3][2] = ((mk[3]*(Atk[3][2]-gk[3][2]))-ufk[3][2]);
        Fstar[4][0] = ((mk[4]*(Atk[4][0]-gk[3][0]))-ufk[4][0]);
        Fstar[4][2] = ((mk[4]*(Atk[4][2]-gk[3][2]))-ufk[4][2]);
/*
Compute Tstar (torques)
*/
/*
Compute fs0 (RHS ignoring constraints)
*/
        srssdovpk();
        fs0[0] = (utau[0]-((utk[4][1]+((Fstar[4][0]*Vpk[0][4][0])+(Fstar[4][2]*
          Vpk[0][4][2])))+((utk[3][1]+((Fstar[3][0]*Vpk[0][3][0])+(Fstar[3][2]*
          Vpk[0][3][2])))+((utk[2][1]+((Fstar[2][0]*Vpk[0][2][0])+(Fstar[2][2]*
          Vpk[0][2][2])))+((utk[0][1]+((Fstar[0][0]*rk[0][2])-(Fstar[0][2]*
          rk[0][0])))+(utk[1][1]+((Fstar[1][0]*Vpk[0][1][0])+(Fstar[1][2]*
          Vpk[0][1][2]))))))));
        fs0[1] = (utau[1]-(((Fstar[1][2]+((Fstar[2][0]*s2)+(Fstar[2][2]*c2)))+((
          Fstar[3][0]*Vpk[1][3][0])+(Fstar[3][2]*Vpk[1][3][2])))+((Fstar[4][0]*
          Vpk[1][3][0])+(Fstar[4][2]*Vpk[1][3][2]))));
        fs0[2] = (utau[2]-((utk[4][1]+((Fstar[4][0]*Vpk[2][4][0])+(Fstar[4][2]*
          Vpk[2][4][2])))+((utk[2][1]+((Fstar[2][0]*rk[2][2])-(Fstar[2][2]*
          rk[2][0])))+(utk[3][1]+((Fstar[3][0]*Vpk[2][3][0])+(Fstar[3][2]*
          Vpk[2][3][2]))))));
        fs0[3] = (utau[3]-((utk[3][1]+((Fstar[3][0]*rk[3][2])-(Fstar[3][2]*
          rk[3][0])))+(utk[4][1]+((Fstar[4][0]*Vpk[3][4][0])+(Fstar[4][2]*
          Vpk[3][4][2])))));
        fs0[4] = (Fstar[4][2]+utau[4]);
        fs0flg = 1;
    }
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   58 adds/subtracts/negates
                     40 multiplies
                      0 divides
                     15 assignments
*/
}

void srssdomm(int routine)
{
    int dumroutine,errnum;
    int i;

    if (mmflg == 0) {
/*
Compute mass matrix (MM)
*/
        srssdovpk();
        temp[0] = ((ik[3][1][1]+(mk[3]*((Vpk[0][3][0]*Vpk[0][3][0])+(
          Vpk[0][3][2]*Vpk[0][3][2]))))+((ik[2][1][1]+(mk[2]*((Vpk[0][2][0]*
          Vpk[0][2][0])+(Vpk[0][2][2]*Vpk[0][2][2]))))+((ik[0][1][1]+(mk[0]*((
          rk[0][0]*rk[0][0])+(rk[0][2]*rk[0][2]))))+(ik[1][1][1]+(mk[1]*((
          Vpk[0][1][0]*Vpk[0][1][0])+(Vpk[0][1][2]*Vpk[0][1][2])))))));
        mm[0][0] = ((ik[4][1][1]+(mk[4]*((Vpk[0][4][0]*Vpk[0][4][0])+(
          Vpk[0][4][2]*Vpk[0][4][2]))))+temp[0]);
        mm[0][1] = ((mk[4]*((Vpk[0][4][0]*Vpk[1][3][0])+(Vpk[0][4][2]*
          Vpk[1][3][2])))+((mk[3]*((Vpk[0][3][0]*Vpk[1][3][0])+(Vpk[0][3][2]*
          Vpk[1][3][2])))+((mk[1]*Vpk[0][1][2])+(mk[2]*((Vpk[0][2][0]*s2)+(
          Vpk[0][2][2]*c2))))));
        mm[0][2] = ((ik[4][1][1]+(mk[4]*((Vpk[0][4][0]*Vpk[2][4][0])+(
          Vpk[0][4][2]*Vpk[2][4][2]))))+((ik[2][1][1]+(mk[2]*((rk[2][2]*
          Vpk[0][2][0])-(rk[2][0]*Vpk[0][2][2]))))+(ik[3][1][1]+(mk[3]*((
          Vpk[0][3][0]*Vpk[2][3][0])+(Vpk[0][3][2]*Vpk[2][3][2]))))));
        mm[0][3] = ((ik[3][1][1]+(mk[3]*((rk[3][2]*Vpk[0][3][0])-(rk[3][0]*
          Vpk[0][3][2]))))+(ik[4][1][1]+(mk[4]*((Vpk[0][4][0]*Vpk[3][4][0])+(
          Vpk[0][4][2]*Vpk[3][4][2])))));
        mm[0][4] = -(mk[4]*Vpk[0][4][2]);
        mm[1][1] = ((mk[4]*((Vpk[1][3][0]*Vpk[1][3][0])+(Vpk[1][3][2]*
          Vpk[1][3][2])))+((mk[1]+mk[2])+(mk[3]*((Vpk[1][3][0]*Vpk[1][3][0])+(
          Vpk[1][3][2]*Vpk[1][3][2])))));
        mm[1][2] = ((mk[4]*((Vpk[1][3][0]*Vpk[2][4][0])+(Vpk[1][3][2]*
          Vpk[2][4][2])))+((mk[2]*((rk[2][2]*s2)-(rk[2][0]*c2)))+(mk[3]*((
          Vpk[1][3][0]*Vpk[2][3][0])+(Vpk[1][3][2]*Vpk[2][3][2])))));
        mm[1][3] = ((mk[3]*((rk[3][2]*Vpk[1][3][0])-(rk[3][0]*Vpk[1][3][2])))+(
          mk[4]*((Vpk[1][3][0]*Vpk[3][4][0])+(Vpk[1][3][2]*Vpk[3][4][2]))));
        mm[1][4] = -(mk[4]*Vpk[1][3][2]);
        mm[2][2] = ((ik[4][1][1]+(mk[4]*((Vpk[2][4][0]*Vpk[2][4][0])+(
          Vpk[2][4][2]*Vpk[2][4][2]))))+((ik[2][1][1]+(mk[2]*((rk[2][0]*rk[2][0]
          )+(rk[2][2]*rk[2][2]))))+(ik[3][1][1]+(mk[3]*((Vpk[2][3][0]*
          Vpk[2][3][0])+(Vpk[2][3][2]*Vpk[2][3][2]))))));
        mm[2][3] = ((ik[3][1][1]+(mk[3]*((rk[3][2]*Vpk[2][3][0])-(rk[3][0]*
          Vpk[2][3][2]))))+(ik[4][1][1]+(mk[4]*((Vpk[2][4][0]*Vpk[3][4][0])+(
          Vpk[2][4][2]*Vpk[3][4][2])))));
        mm[2][4] = -(mk[4]*Vpk[2][4][2]);
        mm[3][3] = ((ik[3][1][1]+(mk[3]*((rk[3][0]*rk[3][0])+(rk[3][2]*rk[3][2])
          )))+(ik[4][1][1]+(mk[4]*((Vpk[3][4][0]*Vpk[3][4][0])+(Vpk[3][4][2]*
          Vpk[3][4][2])))));
        mm[3][4] = -(mk[4]*Vpk[3][4][2]);
        mm[4][4] = mk[4];
/*
Check for singular mass matrix
*/
        for (i = 0; i < 5; i++) {
            if (mm[i][i] < 1e-13) {
                srssseterr(routine,47);
            }
        }
        srsserror(&dumroutine,&errnum);
        if (errnum == 0) {
            mmflg = 1;
        }
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   68 adds/subtracts/negates
                     86 multiplies
                      0 divides
                     16 assignments
*/
}

void srssdommldu(int routine)
{
    int i;
    int dumroutine,errnum;

    if (mmlduflg == 0) {
        srssdomm(routine);
/*
Numerically decompose the mass matrix
*/
        srssldudcomp(5,5,mmap,1e-13,workss,works,mm,mlo,mdi);
/*
Check for singular mass matrix
*/
        for (i = 0; i < 5; i++) {
            if (mdi[i] <= 1e-13) {
                srssseterr(routine,47);
            }
        }
        srsserror(&dumroutine,&errnum);
        if (errnum == 0) {
            mmlduflg = 1;
        }
    }
}

void srsslhs(int routine)
{
/* Compute all remaining state- and force-dependent quantities
*/

    roustate = 2;
    srssdommldu(routine);
    srssdofs0();
}

void srssmfrc(double imult[1])
{

}

void srssequivht(double tau[5])
{
/* Compute tree hinge torques to match effect of applied loads
*/
    double fstareq[5][3],tstareq[5][3];

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(56,23);
        return;
    }
/*
Compute fstareq (forces)
*/
    fstareq[0][0] = ((9.81*(mk[0]*s0))-ufk[0][0]);
    fstareq[0][2] = ((9.81*(mk[0]*c0))-ufk[0][2]);
    fstareq[1][0] = ((9.81*(mk[1]*s0))-ufk[1][0]);
    fstareq[1][2] = ((9.81*(mk[1]*c0))-ufk[1][2]);
    fstareq[2][0] = -(ufk[2][0]+(gk[2][0]*mk[2]));
    fstareq[2][2] = -(ufk[2][2]+(gk[2][2]*mk[2]));
    fstareq[3][0] = -(ufk[3][0]+(gk[3][0]*mk[3]));
    fstareq[3][2] = -(ufk[3][2]+(gk[3][2]*mk[3]));
    fstareq[4][0] = -(ufk[4][0]+(gk[3][0]*mk[4]));
    fstareq[4][2] = -(ufk[4][2]+(gk[3][2]*mk[4]));
/*
Compute tstareq (torques)
*/
/*
Compute taus (RHS ignoring constraints and inertial forces)
*/
    srssdovpk();
    tau[0] = (utau[0]-((utk[4][1]+((fstareq[4][0]*Vpk[0][4][0])+(fstareq[4][2]*
      Vpk[0][4][2])))+((utk[3][1]+((fstareq[3][0]*Vpk[0][3][0])+(fstareq[3][2]*
      Vpk[0][3][2])))+((utk[2][1]+((fstareq[2][0]*Vpk[0][2][0])+(fstareq[2][2]*
      Vpk[0][2][2])))+((utk[0][1]+((fstareq[0][0]*rk[0][2])-(fstareq[0][2]*
      rk[0][0])))+(utk[1][1]+((fstareq[1][0]*Vpk[0][1][0])+(fstareq[1][2]*
      Vpk[0][1][2]))))))));
    tau[1] = (utau[1]-(((fstareq[1][2]+((fstareq[2][0]*s2)+(fstareq[2][2]*c2)))+
      ((fstareq[3][0]*Vpk[1][3][0])+(fstareq[3][2]*Vpk[1][3][2])))+((
      fstareq[4][0]*Vpk[1][3][0])+(fstareq[4][2]*Vpk[1][3][2]))));
    tau[2] = (utau[2]-((utk[4][1]+((fstareq[4][0]*Vpk[2][4][0])+(fstareq[4][2]*
      Vpk[2][4][2])))+((utk[2][1]+((fstareq[2][0]*rk[2][2])-(fstareq[2][2]*
      rk[2][0])))+(utk[3][1]+((fstareq[3][0]*Vpk[2][3][0])+(fstareq[3][2]*
      Vpk[2][3][2]))))));
    tau[3] = (utau[3]-((utk[3][1]+((fstareq[3][0]*rk[3][2])-(fstareq[3][2]*
      rk[3][0])))+(utk[4][1]+((fstareq[4][0]*Vpk[3][4][0])+(fstareq[4][2]*
      Vpk[3][4][2])))));
    tau[4] = (fstareq[4][2]+utau[4]);
/*
Op counts below do not include called subroutines
*/
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   54 adds/subtracts/negates
                     40 multiplies
                      0 divides
                     15 assignments
*/
}

void srssfs0(void)
{

/*
Compute Fs (ignoring multiplier forces)
*/
    fs[0] = fs0[0];
    fs[1] = fs0[1];
    fs[2] = fs0[2];
    fs[3] = fs0[3];
    fs[4] = fs0[4];
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srssfsmult(void)
{
    int i;

/*
Compute Fs (multiplier-generated forces only)
*/
    for (i = 0; i < 5; i++) {
        fs[i] = 0.;
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srssfsfull(void)
{

/*
Compute Fs (including all forces)
*/
    srssfsmult();
    fs[0] = (fs[0]+fs0[0]);
    fs[1] = (fs[1]+fs0[1]);
    fs[2] = (fs[2]+fs0[2]);
    fs[3] = (fs[3]+fs0[3]);
    fs[4] = (fs[4]+fs0[4]);
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    5 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srssfsgenmult(void)
{
    int i;

/*
Compute Fs (generic multiplier-generated forces)
*/
    for (i = 0; i < 5; i++) {
        fs[i] = 0.;
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srssfsgenfull(void)
{

/*
Compute Fs (incl generic mult & other forces)
*/
    srssfsgenmult();
    fs[0] = (fs[0]+fs0[0]);
    fs[1] = (fs[1]+fs0[1]);
    fs[2] = (fs[2]+fs0[2]);
    fs[3] = (fs[3]+fs0[3]);
    fs[4] = (fs[4]+fs0[4]);
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    5 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srssfulltrq(double udotin[5],
    double multin[1],
    double trqout[5])
{
/* Compute hinge torques which would produce indicated udots
*/
    double fstarr[5][3],tstarr[5][3],Otkr[5][3],Atir[5][3],Atkr[5][3];

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(61,23);
        return;
    }
/*
Account for inertial accelerations and supplied udots
*/
    Otkr[2][1] = -(udotin[0]+udotin[2]);
    Otkr[3][1] = (Otkr[2][1]-udotin[3]);
    Atkr[0][0] = ((rk[0][2]*udotin[0])-(u[0]*Wkrpk[0][2]));
    Atkr[0][2] = ((u[0]*Wkrpk[0][0])-(rk[0][0]*udotin[0]));
    Atir[1][0] = (Atkr[0][0]-((ri[1][2]*udotin[0])+(u[0]*Wirk[1][2])));
    Atir[1][2] = (Atkr[0][2]+((ri[1][0]*udotin[0])+(u[0]*Wirk[1][0])));
    Atkr[1][0] = (Atir[1][0]-((2.*(u[0]*u[1]))+((rpk[1][2]*udotin[0])+(u[0]*
      Wkrpk[1][2]))));
    Atkr[1][2] = (udotin[1]+(Atir[1][2]+((u[0]*Wkrpk[1][0])-(rk[1][0]*udotin[0])
      )));
    Atir[2][0] = (Atkr[1][0]-((ri[2][2]*udotin[0])+(u[0]*Wirk[2][2])));
    Atir[2][2] = (Atkr[1][2]+((ri[2][0]*udotin[0])+(u[0]*Wirk[2][0])));
    Atkr[2][0] = (((Atir[2][0]*c2)+(Atir[2][2]*s2))+((wk[2][1]*Wkrpk[2][2])-(
      Otkr[2][1]*rk[2][2])));
    Atkr[2][2] = (((Atir[2][2]*c2)-(Atir[2][0]*s2))+((Otkr[2][1]*rk[2][0])-(
      wk[2][1]*Wkrpk[2][0])));
    Atir[3][0] = (Atkr[2][0]+((Otkr[2][1]*ri[3][2])+(Wirk[3][2]*wk[2][1])));
    Atir[3][2] = (Atkr[2][2]-((Otkr[2][1]*ri[3][0])+(Wirk[3][0]*wk[2][1])));
    Atkr[3][0] = (((Atir[3][0]*c3)+(Atir[3][2]*s3))+((wk[3][1]*Wkrpk[3][2])-(
      Otkr[3][1]*rk[3][2])));
    Atkr[3][2] = (((Atir[3][2]*c3)-(Atir[3][0]*s3))+((Otkr[3][1]*rk[3][0])-(
      wk[3][1]*Wkrpk[3][0])));
    Atir[4][0] = (Atkr[3][0]+((Otkr[3][1]*ri[4][2])+(Wirk[4][2]*wk[3][1])));
    Atir[4][2] = (Atkr[3][2]-((Otkr[3][1]*ri[4][0])+(Wirk[4][0]*wk[3][1])));
    Atkr[4][0] = (Atir[4][0]+(((Otkr[3][1]*rpk[4][2])+(wk[3][1]*Wkrpk[4][2]))-(
      2.*(u[4]*wk[3][1]))));
    Atkr[4][2] = ((Atir[4][2]+((Otkr[3][1]*rk[4][0])-(wk[3][1]*Wkrpk[4][0])))-
      udotin[4]);
/*
Accumulate all forces and torques
*/
    fstarr[0][0] = (ufk[0][0]-(mk[0]*(Atkr[0][0]+(9.81*s0))));
    fstarr[0][2] = (ufk[0][2]-(mk[0]*(Atkr[0][2]+(9.81*c0))));
    fstarr[1][0] = (ufk[1][0]-(mk[1]*(Atkr[1][0]+(9.81*s0))));
    fstarr[1][2] = (ufk[1][2]-(mk[1]*(Atkr[1][2]+(9.81*c0))));
    fstarr[2][0] = (ufk[2][0]+(mk[2]*(gk[2][0]-Atkr[2][0])));
    fstarr[2][2] = (ufk[2][2]+(mk[2]*(gk[2][2]-Atkr[2][2])));
    fstarr[3][0] = (ufk[3][0]+(mk[3]*(gk[3][0]-Atkr[3][0])));
    fstarr[3][2] = (ufk[3][2]+(mk[3]*(gk[3][2]-Atkr[3][2])));
    fstarr[4][0] = (ufk[4][0]+(mk[4]*(gk[3][0]-Atkr[4][0])));
    fstarr[4][2] = (ufk[4][2]+(mk[4]*(gk[3][2]-Atkr[4][2])));
    tstarr[0][1] = (utk[0][1]+(ik[0][1][1]*udotin[0]));
    tstarr[1][1] = (utk[1][1]+(ik[1][1][1]*udotin[0]));
    tstarr[2][1] = (utk[2][1]-(ik[2][1][1]*Otkr[2][1]));
    tstarr[3][1] = (utk[3][1]-(ik[3][1][1]*Otkr[3][1]));
    tstarr[4][1] = (utk[4][1]-(ik[4][1][1]*Otkr[3][1]));
/*
Now calculate the torques
*/
    srssdovpk();
    trqout[0] = -(utau[0]+((((fstarr[4][0]*Vpk[0][4][0])+(fstarr[4][2]*
      Vpk[0][4][2]))-tstarr[4][1])+((((fstarr[3][0]*Vpk[0][3][0])+(fstarr[3][2]*
      Vpk[0][3][2]))-tstarr[3][1])+((((fstarr[2][0]*Vpk[0][2][0])+(fstarr[2][2]*
      Vpk[0][2][2]))-tstarr[2][1])+((((fstarr[0][0]*rk[0][2])-(fstarr[0][2]*
      rk[0][0]))-tstarr[0][1])+(((fstarr[1][0]*Vpk[0][1][0])+(fstarr[1][2]*
      Vpk[0][1][2]))-tstarr[1][1]))))));
    trqout[1] = -(utau[1]+(((fstarr[1][2]+((fstarr[2][0]*s2)+(fstarr[2][2]*c2)))
      +((fstarr[3][0]*Vpk[1][3][0])+(fstarr[3][2]*Vpk[1][3][2])))+((fstarr[4][0]
      *Vpk[1][3][0])+(fstarr[4][2]*Vpk[1][3][2]))));
    trqout[2] = -(utau[2]+((((fstarr[4][0]*Vpk[2][4][0])+(fstarr[4][2]*
      Vpk[2][4][2]))-tstarr[4][1])+((((fstarr[2][0]*rk[2][2])-(fstarr[2][2]*
      rk[2][0]))-tstarr[2][1])+(((fstarr[3][0]*Vpk[2][3][0])+(fstarr[3][2]*
      Vpk[2][3][2]))-tstarr[3][1]))));
    trqout[3] = -(utau[3]+((((fstarr[3][0]*rk[3][2])-(fstarr[3][2]*rk[3][0]))-
      tstarr[3][1])+(((fstarr[4][0]*Vpk[3][4][0])+(fstarr[4][2]*Vpk[3][4][2]))-
      tstarr[4][1])));
    trqout[4] = (fstarr[4][2]-utau[4]);
/*
Op counts below do not include called subroutines
*/
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  112 adds/subtracts/negates
                     93 multiplies
                      0 divides
                     40 assignments
*/
}

void srsscomptrq(double udotin[5],
    double trqout[5])
{
/* Compute hinge torques to produce these udots, ignoring constraints
*/
    double multin[1];

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(60,23);
        return;
    }
    srssfulltrq(udotin,multin,trqout);
}

void srssmulttrq(double multin[1],
    double trqout[5])
{
/* Compute hinge trqs which would be produced by these mults.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(65,23);
        return;
    }
    for (i = 0; i < 5; i++) {
        trqout[i] = 0.;
    }
}

void srssrhs(void)
{
/*
Generated 24-Jun-2008 21:10:06 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/

/*
Compute hinge torques for tree hinges
*/
    tauc[0] = utau[0];
    tauc[1] = utau[1];
    tauc[2] = utau[2];
    tauc[3] = utau[3];
    tauc[4] = utau[4];
    srssdoiner();
/*
Compute onk & onb (angular accels in N)
*/
    Onkb[2][1] = -(udot[0]+udot[2]);
    Onkb[3][1] = (Onkb[2][1]-udot[3]);
    onb[0][0] = 0.;
    onb[0][1] = -udot[0];
    onb[0][2] = 0.;
    onb[1][0] = 0.;
    onb[1][1] = -udot[0];
    onb[1][2] = 0.;
    onb[2][0] = 0.;
    onb[2][1] = Onkb[2][1];
    onb[2][2] = 0.;
    onb[3][0] = 0.;
    onb[3][1] = Onkb[3][1];
    onb[3][2] = 0.;
    onb[4][0] = 0.;
    onb[4][1] = Onkb[3][1];
    onb[4][2] = 0.;
/*
Compute acceleration dyadics
*/
    dyad[0][0][0] = -w1w1[0];
    dyad[0][0][1] = 0.;
    dyad[0][0][2] = -udot[0];
    dyad[0][1][0] = 0.;
    dyad[0][1][1] = 0.;
    dyad[0][1][2] = 0.;
    dyad[0][2][0] = udot[0];
    dyad[0][2][1] = 0.;
    dyad[0][2][2] = -w1w1[0];
    dyad[1][0][0] = -w1w1[1];
    dyad[1][0][1] = 0.;
    dyad[1][0][2] = -udot[0];
    dyad[1][1][0] = 0.;
    dyad[1][1][1] = 0.;
    dyad[1][1][2] = 0.;
    dyad[1][2][0] = udot[0];
    dyad[1][2][1] = 0.;
    dyad[1][2][2] = -w1w1[1];
    dyad[2][0][0] = -w1w1[2];
    dyad[2][0][1] = 0.;
    dyad[2][0][2] = Onkb[2][1];
    dyad[2][1][0] = 0.;
    dyad[2][1][1] = 0.;
    dyad[2][1][2] = 0.;
    dyad[2][2][0] = -Onkb[2][1];
    dyad[2][2][1] = 0.;
    dyad[2][2][2] = -w1w1[2];
    dyad[3][0][0] = -w1w1[3];
    dyad[3][0][1] = 0.;
    dyad[3][0][2] = Onkb[3][1];
    dyad[3][1][0] = 0.;
    dyad[3][1][1] = 0.;
    dyad[3][1][2] = 0.;
    dyad[3][2][0] = -Onkb[3][1];
    dyad[3][2][1] = 0.;
    dyad[3][2][2] = -w1w1[3];
    dyad[4][0][0] = -w1w1[4];
    dyad[4][0][1] = 0.;
    dyad[4][0][2] = Onkb[3][1];
    dyad[4][1][0] = 0.;
    dyad[4][1][1] = 0.;
    dyad[4][1][2] = 0.;
    dyad[4][2][0] = -Onkb[3][1];
    dyad[4][2][1] = 0.;
    dyad[4][2][2] = -w1w1[4];
/*
Compute ank & anb (mass center linear accels in N)
*/
    Ankb[0][0] = (rk[0][2]*udot[0]);
    Ankb[0][2] = -(rk[0][0]*udot[0]);
    AOnkri[1][0] = (Ankb[0][0]-(ri[1][2]*udot[0]));
    AOnkri[1][2] = (Ankb[0][2]+(ri[1][0]*udot[0]));
    Ankb[1][0] = (AOnkri[1][0]-(rpk[1][2]*udot[0]));
    Ankb[1][2] = (AOnkri[1][2]+(udot[1]-(rk[1][0]*udot[0])));
    AOnkri[2][0] = (Ankb[1][0]-(ri[2][2]*udot[0]));
    AOnkri[2][2] = (Ankb[1][2]+(ri[2][0]*udot[0]));
    Ankb[2][0] = (((AOnkri[2][0]*c2)+(AOnkri[2][2]*s2))-(Onkb[2][1]*rk[2][2]));
    Ankb[2][2] = ((Onkb[2][1]*rk[2][0])+((AOnkri[2][2]*c2)-(AOnkri[2][0]*s2)));
    AOnkri[3][0] = (Ankb[2][0]+(Onkb[2][1]*ri[3][2]));
    AOnkri[3][2] = (Ankb[2][2]-(Onkb[2][1]*ri[3][0]));
    Ankb[3][0] = (((AOnkri[3][0]*c3)+(AOnkri[3][2]*s3))-(Onkb[3][1]*rk[3][2]));
    Ankb[3][2] = ((Onkb[3][1]*rk[3][0])+((AOnkri[3][2]*c3)-(AOnkri[3][0]*s3)));
    AOnkri[4][0] = (Ankb[3][0]+(Onkb[3][1]*ri[4][2]));
    AOnkri[4][2] = (Ankb[3][2]-(Onkb[3][1]*ri[4][0]));
    Ankb[4][0] = (AOnkri[4][0]+(Onkb[3][1]*rpk[4][2]));
    Ankb[4][2] = (AOnkri[4][2]+((Onkb[3][1]*rk[4][0])-udot[4]));
    AnkAtk[0][0] = (Ankb[0][0]+Atk[0][0]);
    AnkAtk[0][2] = (Ankb[0][2]+Atk[0][2]);
    ank[0][0] = ((AnkAtk[0][0]*c0)-(AnkAtk[0][2]*s0));
    ank[0][2] = ((AnkAtk[0][0]*s0)+(AnkAtk[0][2]*c0));
    AnkAtk[1][0] = (Ankb[1][0]+Atk[1][0]);
    AnkAtk[1][2] = (Ankb[1][2]+Atk[1][2]);
    ank[1][0] = ((AnkAtk[1][0]*c0)-(AnkAtk[1][2]*s0));
    ank[1][2] = ((AnkAtk[1][0]*s0)+(AnkAtk[1][2]*c0));
    AnkAtk[2][0] = (Ankb[2][0]+Atk[2][0]);
    AnkAtk[2][2] = (Ankb[2][2]+Atk[2][2]);
    ank[2][0] = ((AnkAtk[2][0]*cnk[2][0][0])+(AnkAtk[2][2]*cnk[2][0][2]));
    ank[2][2] = ((AnkAtk[2][0]*cnk[2][2][0])+(AnkAtk[2][2]*cnk[2][2][2]));
    AnkAtk[3][0] = (Ankb[3][0]+Atk[3][0]);
    AnkAtk[3][2] = (Ankb[3][2]+Atk[3][2]);
    ank[3][0] = ((AnkAtk[3][0]*cnk[3][0][0])+(AnkAtk[3][2]*cnk[3][0][2]));
    ank[3][2] = ((AnkAtk[3][0]*cnk[3][2][0])+(AnkAtk[3][2]*cnk[3][2][2]));
    AnkAtk[4][0] = (Ankb[4][0]+Atk[4][0]);
    AnkAtk[4][2] = (Ankb[4][2]+Atk[4][2]);
    ank[4][0] = ((AnkAtk[4][0]*cnk[3][0][0])+(AnkAtk[4][2]*cnk[3][0][2]));
    ank[4][2] = ((AnkAtk[4][0]*cnk[3][2][0])+(AnkAtk[4][2]*cnk[3][2][2]));
    anb[0][0] = ank[0][0];
    anb[0][1] = 0.;
    anb[0][2] = ank[0][2];
    anb[1][0] = ank[1][0];
    anb[1][1] = 0.;
    anb[1][2] = ank[1][2];
    anb[2][0] = ank[2][0];
    anb[2][1] = 0.;
    anb[2][2] = ank[2][2];
    anb[3][0] = ank[3][0];
    anb[3][1] = 0.;
    anb[3][2] = ank[3][2];
    anb[4][0] = ank[4][0];
    anb[4][1] = 0.;
    anb[4][2] = ank[4][2];
    roustate = 3;
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   63 adds/subtracts/negates
                     46 multiplies
                      0 divides
                    120 assignments
*/
}

void srssmassmat(double mmat[5][5])
{
/* Return the system mass matrix (LHS)
*/
    int i,j;

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(57,23);
        return;
    }
    srssdomm(57);
    for (i = 0; i < 5; i++) {
        for (j = i; j <= 4; j++) {
            mmat[i][j] = mm[i][j];
            mmat[j][i] = mm[i][j];
        }
    }
}

void srssfrcmat(double fmat[5])
{
/* Return the system force matrix (RHS), excluding constraints
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(58,23);
        return;
    }
    srssdofs0();
    for (i = 0; i < 5; i++) {
        fmat[i] = fs0[i];
    }
}

void srsspseudo(double lqout[1],
    double luout[1])
{
/*
Return pseudo-coordinates for loop joints.

*/
/*
There are no loop joints in this system.

*/
}

void srsspsqdot(double lqdout[1])
{
/*
Return pseudo-coordinate derivatives for loop joints.

*/
/*
There are no loop joints in this system.

*/
}

void srsspsudot(double ludout[1])
{
/*
Return pseudo-coordinate accelerations for loop joints.

*/
/*
There are no loop joints in this system.

*/
}

void srssperr(double errs[1])
{

}

void srssverr(double errs[1])
{

}

void srssaerr(double errs[1])
{

}
int 
srsschkbnum(int routine,
    int bnum)
{

    if ((bnum < -1) || (bnum > 4)) {
        srssseterr(routine,15);
        return 1;
    }
    return 0;
}
int 
srsschkjnum(int routine,
    int jnum)
{

    if ((jnum < 0) || (jnum > 4)) {
        srssseterr(routine,16);
        return 1;
    }
    return 0;
}
int 
srsschkucnum(int routine,
    int ucnum)
{

    if ((ucnum < 0) || (ucnum > -1)) {
        srssseterr(routine,21);
        return 1;
    }
    return 0;
}
int 
srsschkjaxis(int routine,
    int jnum,
    int axnum)
{
    int maxax;

    if (srsschkjnum(routine,jnum) != 0) {
        return 1;
    }
    if ((axnum < 0) || (axnum > 6)) {
        srssseterr(routine,17);
        return 1;
    }
    maxax = njntdof[jnum]-1;
    if ((jtype[jnum] == 4) || (jtype[jnum] == 6) || (jtype[jnum] == 21)) {
        maxax = maxax+1;
    }
    if (axnum > maxax) {
        srssseterr(routine,18);
        return 1;
    }
    return 0;
}
int 
srsschkjpin(int routine,
    int jnum,
    int pinno)
{
    int maxax,pinok;

    if (srsschkjnum(routine,jnum) != 0) {
        return 1;
    }
    if ((pinno < 0) || (pinno > 5)) {
        srssseterr(routine,17);
        return 1;
    }
    if (njntdof[jnum] >= 3) {
        maxax = 2;
    } else {
        maxax = njntdof[jnum]-1;
    }
    if (jtype[jnum] == 4) {
        maxax = -1;
    }
    if (jtype[jnum] == 7) {
        maxax = 0;
    }
    pinok = 0;
    if (pinno <= maxax) {
        pinok = 1;
    }
    if (pinok == 0) {
        srssseterr(routine,18);
        return 1;
    }
    return 0;
}
int 
srssindx(int joint,
    int axis)
{
    int offs,gotit;

    if (srsschkjaxis(36,joint,axis) != 0) {
        return 0;
    }
    gotit = 0;
    if (jtype[joint] == 4) {
        if (axis == 3) {
            offs = ballq[joint];
            gotit = 1;
        }
    } else {
        if ((jtype[joint] == 6) || (jtype[joint] == 21)) {
            if (axis == 6) {
                offs = ballq[joint];
                gotit = 1;
            }
        }
    }
    if (gotit == 0) {
        offs = firstq[joint]+axis;
    }
    return offs;
}

void srsspresacc(int joint,
    int axis,
    double prval)
{

}

void srsspresvel(int joint,
    int axis,
    double prval)
{

}

void srssprespos(int joint,
    int axis,
    double prval)
{

}

void srssgetht(int joint,
    int axis,
    double *torque)
{

    if (srsschkjaxis(30,joint,axis) != 0) {
        return;
    }
    if (roustate != 3) {
        srssseterr(30,24);
        return;
    }
    *torque = tauc[srssindx(joint,axis)];
}

void srsshinget(int joint,
    int axis,
    double torque)
{

    if (srsschkjaxis(10,joint,axis) != 0) {
        return;
    }
    if (roustate != 2) {
        srssseterr(10,23);
        return;
    }
    if (mfrcflg != 0) {
        mtau[srssindx(joint,axis)] = mtau[srssindx(joint,axis)]+torque;
    } else {
        fs0flg = 0;
        utau[srssindx(joint,axis)] = utau[srssindx(joint,axis)]+torque;
    }
}

void srsspointf(int body,
    double point[3],
    double force[3])
{
    double torque[3];

    if (srsschkbnum(11,body) != 0) {
        return;
    }
    if (roustate != 2) {
        srssseterr(11,23);
        return;
    }
    if (body == -1) {
        return;
    }
    torque[0] = point[1]*force[2]-point[2]*force[1];
    torque[1] = point[2]*force[0]-point[0]*force[2];
    torque[2] = point[0]*force[1]-point[1]*force[0];
    if (mfrcflg != 0) {
        mfk[body][0] = mfk[body][0]+force[0];
        mtk[body][0] = mtk[body][0]+torque[0];
        mfk[body][1] = mfk[body][1]+force[1];
        mtk[body][1] = mtk[body][1]+torque[1];
        mfk[body][2] = mfk[body][2]+force[2];
        mtk[body][2] = mtk[body][2]+torque[2];
    } else {
        fs0flg = 0;
        ufk[body][0] = ufk[body][0]+force[0];
        utk[body][0] = utk[body][0]+torque[0];
        ufk[body][1] = ufk[body][1]+force[1];
        utk[body][1] = utk[body][1]+torque[1];
        ufk[body][2] = ufk[body][2]+force[2];
        utk[body][2] = utk[body][2]+torque[2];
    }
}

void srssbodyt(int body,
    double torque[3])
{

    if (srsschkbnum(12,body) != 0) {
        return;
    }
    if (roustate != 2) {
        srssseterr(12,23);
        return;
    }
    if (body == -1) {
        return;
    }
    if (mfrcflg != 0) {
        mtk[body][0] = mtk[body][0]+torque[0];
        mtk[body][1] = mtk[body][1]+torque[1];
        mtk[body][2] = mtk[body][2]+torque[2];
    } else {
        fs0flg = 0;
        utk[body][0] = utk[body][0]+torque[0];
        utk[body][1] = utk[body][1]+torque[1];
        utk[body][2] = utk[body][2]+torque[2];
    }
}

void srssdoww(int routine)
{

    roustate = 2;
    if (wwflg == 0) {
        wwflg = 1;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      0 assignments
*/
}

void srssxudot0(int routine,
    double oudot0[5])
{
/*
Compute unconstrained equations
*/
    int i;

    srsslhs(routine);
/*
Solve equations for udots
*/
    srssfs0();
    srssldubslv(5,5,mmap,works,mlo,mdi,fs,udot);
    for (i = 0; i <= 4; i++) {
        oudot0[i] = udot[i];
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srssudot0(double oudot0[5])
{

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(66,23);
        return;
    }
    srssxudot0(66,oudot0);
}

void srsssetudot(double iudot[5])
{
/*
Assign udots and advance to stage Dynamics Ready
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(68,23);
        return;
    }
    for (i = 0; i <= 4; i++) {
        udot[i] = iudot[i];
    }
    srssrhs();
}

void srssxudotm(int routine,
    double imult[1],
    double oudotm[5])
{
/*
Compute udots due only to multipliers
*/
    int i;

    srsslhs(routine);
    for (i = 0; i <= 4; i++) {
        udot[i] = 0.;
    }
    for (i = 0; i <= 4; i++) {
        oudotm[i] = udot[i];
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                     10 assignments
*/
}

void srssudotm(double imult[1],
    double oudotm[5])
{

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(67,23);
        return;
    }
    srssxudotm(67,imult,oudotm);
}

void srssderiv(double oqdot[5],
    double oudot[5])
{
/*
This is the derivative section for a 5-body ground-based
system with 5 hinge degree(s) of freedom.
*/
    int i;
    double udot0[5],udot1[5];

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(17,23);
        return;
    }
    if (stabvelq == 1) {
        srssseterr(17,32);
    }
    if (stabposq == 1) {
        srssseterr(17,33);
    }
    wsiz = 0;
/*
Compute unconstrained equations
*/
    srssxudot0(17,udot0);
    srssrhs();
    wrank = 0;
    for (i = 0; i <= 4; i++) {
        oqdot[i] = qdot[i];
    }
    for (i = 0; i <= 4; i++) {
        oudot[i] = udot[i];
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                     10 assignments
*/
}
/*
Compute residuals for use with DAE integrator
*/

void srssresid(double eqdot[5],
    double eudot[5],
    double emults[1],
    double resid[10])
{
    int i;
    double uderrs[5];

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(16,23);
        return;
    }
    if (stabposq == 1) {
        srssseterr(16,33);
    }
    srssfulltrq(eudot,emults,uderrs);
    for (i = 0; i < 5; i++) {
        resid[i] = eqdot[i]-qdot[i];
    }
    for (i = 0; i < 5; i++) {
        resid[5+i] = uderrs[i];
    }
    for (i = 0; i < 5; i++) {
        udot[i] = eudot[i];
    }
    srssrhs();
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    5 adds/subtracts/negates
                      0 multiplies
                      0 divides
                     15 assignments
*/
}

void srssmult(double omults[1],
    int *owrank,
    int omultmap[1])
{

    if (roustate != 3) {
        srssseterr(34,24);
        return;
    }
    *owrank = wrank;
}

void srssreac(double force[5][3],
    double torque[5][3])
{
/*
Generated 24-Jun-2008 21:10:06 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/

    if (roustate != 3) {
        srssseterr(31,24);
        return;
    }
/*
Compute reaction forces for non-weld tree joints
*/
    fc[4][0] = ((mk[4]*(AnkAtk[4][0]-gk[3][0]))-ufk[4][0]);
    fc[4][1] = -ufk[4][1];
    fc[4][2] = ((mk[4]*(AnkAtk[4][2]-gk[3][2]))-ufk[4][2]);
    tc[4][0] = -(utk[4][0]-(fc[4][1]*rk[4][2]));
    tc[4][1] = ((ik[4][1][1]*Onkb[3][1])-(utk[4][1]+((fc[4][0]*rk[4][2])-(
      fc[4][2]*rk[4][0]))));
    tc[4][2] = -(utk[4][2]+(fc[4][1]*rk[4][0]));
    fccikt[4][0] = fc[4][0];
    fccikt[4][1] = fc[4][1];
    fccikt[4][2] = fc[4][2];
    ffk[3][0] = (ufk[3][0]-fccikt[4][0]);
    ffk[3][1] = (ufk[3][1]-fccikt[4][1]);
    ffk[3][2] = (ufk[3][2]-fccikt[4][2]);
    ttk[3][0] = (utk[3][0]-(tc[4][0]-(fccikt[4][1]*rpri[4][2])));
    ttk[3][1] = (utk[3][1]-(tc[4][1]+((fccikt[4][0]*rpri[4][2])-(fccikt[4][2]*
      ri[4][0]))));
    ttk[3][2] = (utk[3][2]-(tc[4][2]+(fccikt[4][1]*ri[4][0])));
    fc[3][0] = ((mk[3]*(AnkAtk[3][0]-gk[3][0]))-ffk[3][0]);
    fc[3][1] = -ffk[3][1];
    fc[3][2] = ((mk[3]*(AnkAtk[3][2]-gk[3][2]))-ffk[3][2]);
    tc[3][0] = -(ttk[3][0]-(fc[3][1]*rk[3][2]));
    tc[3][1] = ((ik[3][1][1]*Onkb[3][1])-(ttk[3][1]+((fc[3][0]*rk[3][2])-(
      fc[3][2]*rk[3][0]))));
    tc[3][2] = -(ttk[3][2]+(fc[3][1]*rk[3][0]));
    fccikt[3][0] = ((fc[3][0]*c3)-(fc[3][2]*s3));
    fccikt[3][1] = fc[3][1];
    fccikt[3][2] = ((fc[3][0]*s3)+(fc[3][2]*c3));
    ffk[2][0] = (ufk[2][0]-fccikt[3][0]);
    ffk[2][1] = (ufk[2][1]-fccikt[3][1]);
    ffk[2][2] = (ufk[2][2]-fccikt[3][2]);
    ttk[2][0] = (utk[2][0]-(((tc[3][0]*c3)-(tc[3][2]*s3))-(fccikt[3][1]*ri[3][2]
      )));
    ttk[2][1] = (utk[2][1]-(tc[3][1]+((fccikt[3][0]*ri[3][2])-(fccikt[3][2]*
      ri[3][0]))));
    ttk[2][2] = (utk[2][2]-((fccikt[3][1]*ri[3][0])+((tc[3][0]*s3)+(tc[3][2]*c3)
      )));
    fc[2][0] = ((mk[2]*(AnkAtk[2][0]-gk[2][0]))-ffk[2][0]);
    fc[2][1] = -ffk[2][1];
    fc[2][2] = ((mk[2]*(AnkAtk[2][2]-gk[2][2]))-ffk[2][2]);
    tc[2][0] = -(ttk[2][0]-(fc[2][1]*rk[2][2]));
    tc[2][1] = ((ik[2][1][1]*Onkb[2][1])-(ttk[2][1]+((fc[2][0]*rk[2][2])-(
      fc[2][2]*rk[2][0]))));
    tc[2][2] = -(ttk[2][2]+(fc[2][1]*rk[2][0]));
    fccikt[2][0] = ((fc[2][0]*c2)-(fc[2][2]*s2));
    fccikt[2][1] = fc[2][1];
    fccikt[2][2] = ((fc[2][0]*s2)+(fc[2][2]*c2));
    ffk[1][0] = (ufk[1][0]-fccikt[2][0]);
    ffk[1][1] = (ufk[1][1]-fccikt[2][1]);
    ffk[1][2] = (ufk[1][2]-fccikt[2][2]);
    ttk[1][0] = (utk[1][0]-(((tc[2][0]*c2)-(tc[2][2]*s2))-(fccikt[2][1]*ri[2][2]
      )));
    ttk[1][1] = (utk[1][1]-(tc[2][1]+((fccikt[2][0]*ri[2][2])-(fccikt[2][2]*
      ri[2][0]))));
    ttk[1][2] = (utk[1][2]-((fccikt[2][1]*ri[2][0])+((tc[2][0]*s2)+(tc[2][2]*c2)
      )));
    fc[1][0] = ((mk[1]*(AnkAtk[1][0]+(9.81*s0)))-ffk[1][0]);
    fc[1][1] = -ffk[1][1];
    fc[1][2] = ((mk[1]*(AnkAtk[1][2]+(9.81*c0)))-ffk[1][2]);
    tc[1][0] = -(ttk[1][0]-(fc[1][1]*rk[1][2]));
    tc[1][1] = -((ik[1][1][1]*udot[0])+(ttk[1][1]+((fc[1][0]*rk[1][2])-(fc[1][2]
      *rk[1][0]))));
    tc[1][2] = -(ttk[1][2]+(fc[1][1]*rk[1][0]));
    fccikt[1][0] = fc[1][0];
    fccikt[1][1] = fc[1][1];
    fccikt[1][2] = fc[1][2];
    ffk[0][0] = (ufk[0][0]-fccikt[1][0]);
    ffk[0][1] = (ufk[0][1]-fccikt[1][1]);
    ffk[0][2] = (ufk[0][2]-fccikt[1][2]);
    ttk[0][0] = (utk[0][0]-(tc[1][0]-(fccikt[1][1]*rpri[1][2])));
    ttk[0][1] = (utk[0][1]-(tc[1][1]+((fccikt[1][0]*rpri[1][2])-(fccikt[1][2]*
      ri[1][0]))));
    ttk[0][2] = (utk[0][2]-(tc[1][2]+(fccikt[1][1]*ri[1][0])));
    fc[0][0] = ((mk[0]*(AnkAtk[0][0]+(9.81*s0)))-ffk[0][0]);
    fc[0][1] = -ffk[0][1];
    fc[0][2] = ((mk[0]*(AnkAtk[0][2]+(9.81*c0)))-ffk[0][2]);
    tc[0][0] = -(ttk[0][0]-(fc[0][1]*rk[0][2]));
    tc[0][1] = -((ik[0][1][1]*udot[0])+(ttk[0][1]+((fc[0][0]*rk[0][2])-(fc[0][2]
      *rk[0][0]))));
    tc[0][2] = -(ttk[0][2]+(fc[0][1]*rk[0][0]));
    force[0][0] = fc[0][0];
    torque[0][0] = tc[0][0];
    force[0][1] = fc[0][1];
    torque[0][1] = tc[0][1];
    force[0][2] = fc[0][2];
    torque[0][2] = tc[0][2];
    force[1][0] = fc[1][0];
    torque[1][0] = tc[1][0];
    force[1][1] = fc[1][1];
    torque[1][1] = tc[1][1];
    force[1][2] = fc[1][2];
    torque[1][2] = tc[1][2];
    force[2][0] = fc[2][0];
    torque[2][0] = tc[2][0];
    force[2][1] = fc[2][1];
    torque[2][1] = tc[2][1];
    force[2][2] = fc[2][2];
    torque[2][2] = tc[2][2];
    force[3][0] = fc[3][0];
    torque[3][0] = tc[3][0];
    force[3][1] = fc[3][1];
    torque[3][1] = tc[3][1];
    force[3][2] = fc[3][2];
    torque[3][2] = tc[3][2];
    force[4][0] = fc[4][0];
    torque[4][0] = tc[4][0];
    force[4][1] = fc[4][1];
    torque[4][1] = tc[4][1];
    force[4][2] = fc[4][2];
    torque[4][2] = tc[4][2];
/*
Compute reaction forces for tree weld joints
*/
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  110 adds/subtracts/negates
                     71 multiplies
                      0 divides
                     96 assignments
*/
}

void srssmom(double lm[3],
    double am[3],
    double *ke)
{
/*
Compute system linear and angular momentum, and kinetic energy.

Generated 24-Jun-2008 21:10:06 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    double lk[5][3],hnk[5][3];

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(19,23);
        return;
    }
    lk[0][0] = (mk[0]*vnk[0][0]);
    lk[0][2] = (mk[0]*vnk[0][2]);
    lk[1][0] = (mk[1]*vnk[1][0]);
    lk[1][2] = (mk[1]*vnk[1][2]);
    lk[2][0] = (mk[2]*vnk[2][0]);
    lk[2][2] = (mk[2]*vnk[2][2]);
    lk[3][0] = (mk[3]*vnk[3][0]);
    lk[3][2] = (mk[3]*vnk[3][2]);
    lk[4][0] = (mk[4]*vnk[4][0]);
    lk[4][2] = (mk[4]*vnk[4][2]);
    hnk[0][1] = -(ik[0][1][1]*u[0]);
    hnk[1][1] = -(ik[1][1][1]*u[0]);
    hnk[2][1] = (ik[2][1][1]*wk[2][1]);
    hnk[3][1] = (ik[3][1][1]*wk[3][1]);
    hnk[4][1] = (ik[4][1][1]*wk[3][1]);
    lm[0] = (lk[4][0]+(lk[3][0]+(lk[2][0]+(lk[0][0]+lk[1][0]))));
    lm[1] = 0.;
    lm[2] = (lk[4][2]+(lk[3][2]+(lk[2][2]+(lk[0][2]+lk[1][2]))));
    am[0] = 0.;
    am[1] = (((hnk[4][1]+((lk[4][0]*rnk[4][2])-(lk[4][2]*rnk[4][0])))+((
      hnk[3][1]+((lk[3][0]*rnk[3][2])-(lk[3][2]*rnk[3][0])))+((hnk[2][1]+((
      lk[2][0]*rnk[2][2])-(lk[2][2]*rnk[2][0])))+((hnk[0][1]+((lk[0][0]*
      rnk[0][2])-(lk[0][2]*rnk[0][0])))+(hnk[1][1]+((lk[1][0]*rnk[1][2])-(
      lk[1][2]*rnk[1][0])))))))-((com[2]*lm[0])-(com[0]*lm[2])));
    am[2] = 0.;
    *ke = (.5*(((hnk[4][1]*wk[3][1])+((lk[4][0]*vnk[4][0])+(lk[4][2]*vnk[4][2]))
      )+(((hnk[3][1]*wk[3][1])+((lk[3][0]*vnk[3][0])+(lk[3][2]*vnk[3][2])))+(((
      hnk[2][1]*wk[2][1])+((lk[2][0]*vnk[2][0])+(lk[2][2]*vnk[2][2])))+((((
      lk[0][0]*vnk[0][0])+(lk[0][2]*vnk[0][2]))-(hnk[0][1]*u[0]))+(((lk[1][0]*
      vnk[1][0])+(lk[1][2]*vnk[1][2]))-(hnk[1][1]*u[0])))))));
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   40 adds/subtracts/negates
                     43 multiplies
                      0 divides
                     22 assignments
*/
}

void srsssys(double *mtoto,
    double cm[3],
    double icm[3][3])
{
/*
Compute system total mass, and instantaneous center of mass and
inertia matrix.

Generated 24-Jun-2008 21:10:06 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    double ikcnkt[5][3][3];

    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(20,23);
        return;
    }
    *mtoto = mtot;
    cm[0] = com[0];
    cm[1] = 0.;
    cm[2] = com[2];
    icm[0][0] = (2.+((((mk[4]*(rnk[4][2]*rnk[4][2]))+((cnk[3][0][0]*cnk[3][0][0]
      )+(cnk[3][0][2]*cnk[3][0][2])))+(((mk[3]*(rnk[3][2]*rnk[3][2]))+((
      cnk[3][0][0]*cnk[3][0][0])+(cnk[3][0][2]*cnk[3][0][2])))+(((mk[0]*(
      rnk[0][2]*rnk[0][2]))+(mk[1]*(rnk[1][2]*rnk[1][2])))+((mk[2]*(rnk[2][2]*
      rnk[2][2]))+((cnk[2][0][0]*cnk[2][0][0])+(cnk[2][0][2]*cnk[2][0][2]))))))-
      (mtot*(com[2]*com[2]))));
    icm[0][1] = 0.;
    icm[0][2] = ((mtot*(com[0]*com[2]))+((((cnk[3][0][0]*cnk[3][2][0])+(
      cnk[3][0][2]*cnk[3][2][2]))-(mk[4]*(rnk[4][0]*rnk[4][2])))+((((
      cnk[3][0][0]*cnk[3][2][0])+(cnk[3][0][2]*cnk[3][2][2]))-(mk[3]*(rnk[3][0]*
      rnk[3][2])))+((((cnk[2][0][0]*cnk[2][2][0])+(cnk[2][0][2]*cnk[2][2][2]))-(
      mk[2]*(rnk[2][0]*rnk[2][2])))-((mk[0]*(rnk[0][0]*rnk[0][2]))+(mk[1]*(
      rnk[1][0]*rnk[1][2])))))));
    icm[1][0] = icm[0][1];
    icm[1][1] = (((ik[4][1][1]+(mk[4]*((rnk[4][0]*rnk[4][0])+(rnk[4][2]*
      rnk[4][2]))))+((ik[3][1][1]+(mk[3]*((rnk[3][0]*rnk[3][0])+(rnk[3][2]*
      rnk[3][2]))))+((ik[2][1][1]+(mk[2]*((rnk[2][0]*rnk[2][0])+(rnk[2][2]*
      rnk[2][2]))))+((ik[0][1][1]+(mk[0]*((rnk[0][0]*rnk[0][0])+(rnk[0][2]*
      rnk[0][2]))))+(ik[1][1][1]+(mk[1]*((rnk[1][0]*rnk[1][0])+(rnk[1][2]*
      rnk[1][2]))))))))-(mtot*((com[0]*com[0])+(com[2]*com[2]))));
    icm[1][2] = 0.;
    icm[2][0] = icm[0][2];
    icm[2][1] = icm[1][2];
    icm[2][2] = (2.+((((mk[4]*(rnk[4][0]*rnk[4][0]))+((cnk[3][2][0]*cnk[3][2][0]
      )+(cnk[3][2][2]*cnk[3][2][2])))+(((mk[3]*(rnk[3][0]*rnk[3][0]))+((
      cnk[3][2][0]*cnk[3][2][0])+(cnk[3][2][2]*cnk[3][2][2])))+(((mk[0]*(
      rnk[0][0]*rnk[0][0]))+(mk[1]*(rnk[1][0]*rnk[1][0])))+((mk[2]*(rnk[2][0]*
      rnk[2][0]))+((cnk[2][2][0]*cnk[2][2][0])+(cnk[2][2][2]*cnk[2][2][2]))))))-
      (mtot*(com[0]*com[0]))));
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   51 adds/subtracts/negates
                     72 multiplies
                      0 divides
                     13 assignments
*/
}

void srsspos(int body,
    double pt[3],
    double loc[3])
{
/*
Return inertial frame location of a point on a body.

*/
    double pv[3];

    if (srsschkbnum(21,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(21,23);
        return;
    }
    if (body  ==  -1) {
        loc[0] = pt[0];
        loc[1] = pt[1];
        loc[2] = pt[2];
    } else {
        pv[0] = rnb[body][0]+pt[0]*cnb[body][0][0]+pt[1]*cnb[body][0][1]+pt[2]*
          cnb[body][0][2];
        pv[1] = rnb[body][1]+pt[0]*cnb[body][1][0]+pt[1]*cnb[body][1][1]+pt[2]*
          cnb[body][1][2];
        pv[2] = rnb[body][2]+pt[0]*cnb[body][2][0]+pt[1]*cnb[body][2][1]+pt[2]*
          cnb[body][2][2];
        loc[0] = pv[0];
        loc[1] = pv[1];
        loc[2] = pv[2];
    }
}

void srssvel(int body,
    double pt[3],
    double velo[3])
{
/*
Return inertial frame velocity of a point on a body.

*/
    double pv[3];

    if (srsschkbnum(22,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(22,23);
        return;
    }
    if (body  ==  -1) {
        velo[0] = 0.;
        velo[1] = 0.;
        velo[2] = 0.;
    } else {
        pv[0] = wb[body][1]*pt[2]-wb[body][2]*pt[1];
        pv[1] = wb[body][2]*pt[0]-wb[body][0]*pt[2];
        pv[2] = wb[body][0]*pt[1]-wb[body][1]*pt[0];
        velo[0] = vnb[body][0]+pv[0]*cnb[body][0][0]+pv[1]*cnb[body][0][1]+pv[2]
          *cnb[body][0][2];
        velo[1] = vnb[body][1]+pv[0]*cnb[body][1][0]+pv[1]*cnb[body][1][1]+pv[2]
          *cnb[body][1][2];
        velo[2] = vnb[body][2]+pv[0]*cnb[body][2][0]+pv[1]*cnb[body][2][1]+pv[2]
          *cnb[body][2][2];
    }
}

void srssorient(int body,
    double dircos[3][3])
{
/*
Return orientation of body w.r.t. ground frame.

*/

    if (srsschkbnum(23,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(23,23);
        return;
    }
    if (body == -1) {
        dircos[0][0] = 1.;
        dircos[0][1] = 0.;
        dircos[0][2] = 0.;
        dircos[1][0] = 0.;
        dircos[1][1] = 1.;
        dircos[1][2] = 0.;
        dircos[2][0] = 0.;
        dircos[2][1] = 0.;
        dircos[2][2] = 1.;
    } else {
        dircos[0][0] = cnb[body][0][0];
        dircos[0][1] = cnb[body][0][1];
        dircos[0][2] = cnb[body][0][2];
        dircos[1][0] = cnb[body][1][0];
        dircos[1][1] = cnb[body][1][1];
        dircos[1][2] = cnb[body][1][2];
        dircos[2][0] = cnb[body][2][0];
        dircos[2][1] = cnb[body][2][1];
        dircos[2][2] = cnb[body][2][2];
    }
}

void srssangvel(int body,
    double avel[3])
{
/*
Return angular velocity of the body.

*/

    if (srsschkbnum(24,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(24,23);
        return;
    }
    if (body == -1) {
        avel[0] = 0.;
        avel[1] = 0.;
        avel[2] = 0.;
    } else {
        avel[0] = wb[body][0];
        avel[1] = wb[body][1];
        avel[2] = wb[body][2];
    }
}

void srsstrans(int frbod,
    double ivec[3],
    int tobod,
    double ovec[3])
{
/*
Transform ivec from frbod frame to tobod frame.

*/
    double pv[3];

    if (srsschkbnum(25,frbod) != 0) {
        return;
    }
    if (srsschkbnum(25,tobod) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(25,23);
        return;
    }
    if (frbod == tobod) {
        srssvcopy(ivec,ovec);
        return;
    }
    if (frbod == -1) {
        srssvcopy(ivec,pv);
        ovec[0] = pv[0]*cnb[tobod][0][0]+pv[1]*cnb[tobod][1][0]+pv[2]*cnb[tobod
          ][2][0];
        ovec[1] = pv[0]*cnb[tobod][0][1]+pv[1]*cnb[tobod][1][1]+pv[2]*cnb[tobod
          ][2][1];
        ovec[2] = pv[0]*cnb[tobod][0][2]+pv[1]*cnb[tobod][1][2]+pv[2]*cnb[tobod
          ][2][2];
        return;
    }
    if (tobod == -1) {
        srssvcopy(ivec,pv);
        ovec[0] = pv[0]*cnb[frbod][0][0]+pv[1]*cnb[frbod][0][1]+pv[2]*cnb[frbod
          ][0][2];
        ovec[1] = pv[0]*cnb[frbod][1][0]+pv[1]*cnb[frbod][1][1]+pv[2]*cnb[frbod
          ][1][2];
        ovec[2] = pv[0]*cnb[frbod][2][0]+pv[1]*cnb[frbod][2][1]+pv[2]*cnb[frbod
          ][2][2];
        return;
    }
    pv[0] = ivec[0]*cnb[frbod][0][0]+ivec[1]*cnb[frbod][0][1]+ivec[2]*cnb[frbod
      ][0][2];
    pv[1] = ivec[0]*cnb[frbod][1][0]+ivec[1]*cnb[frbod][1][1]+ivec[2]*cnb[frbod
      ][1][2];
    pv[2] = ivec[0]*cnb[frbod][2][0]+ivec[1]*cnb[frbod][2][1]+ivec[2]*cnb[frbod
      ][2][2];
    ovec[0] = pv[0]*cnb[tobod][0][0]+pv[1]*cnb[tobod][1][0]+pv[2]*cnb[tobod][2][
      0];
    ovec[1] = pv[0]*cnb[tobod][0][1]+pv[1]*cnb[tobod][1][1]+pv[2]*cnb[tobod][2][
      1];
    ovec[2] = pv[0]*cnb[tobod][0][2]+pv[1]*cnb[tobod][1][2]+pv[2]*cnb[tobod][2][
      2];
}

void srssrel2cart(int coord,
    int body,
    double point[3],
    double linchg[3],
    double rotchg[3])
{
/* Return derivative of pt loc and body orient w.r.t. hinge rate
*/
    int x,i,gnd;
    double lin[3],pv[3];

    if ((coord < 0) || (coord > 4)) {
        srssseterr(59,45);
        return;
    }
    if (srsschkbnum(59,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srssseterr(59,23);
        return;
    }
    gnd = -1;
    if (body == gnd) {
        x = -1;
    } else {
        x = firstq[body]+njntdof[body]-1;
    }
    if (x < coord) {
        srssvset(0.,0.,0.,linchg);
        srssvset(0.,0.,0.,rotchg);
        return;
    }
    srssdovpk();
    for (i = 0; i < 3; i++) {
        rotchg[i] = Wpk[coord][x][i];
        lin[i] = Vpk[coord][x][i];
    }
    if (body == gnd) {
        srssvcopy(point,pv);
    } else {
        pv[0] = rcom[body][0]+point[0];
        pv[1] = rcom[body][1]+point[1];
        pv[2] = rcom[body][2]+point[2];
    }
    srssvcross(rotchg,pv,linchg);
    srssvadd(linchg,lin,linchg);
}

void srssacc(int body,
    double pt[3],
    double accel[3])
{
/*
Return linear acceleration a point of the specified body.

*/
    double pv[3];

    if (srsschkbnum(32,body) != 0) {
        return;
    }
    if (roustate != 3) {
        srssseterr(32,24);
        return;
    }
    if (body  ==  -1) {
        accel[0] = 0.;
        accel[1] = 0.;
        accel[2] = 0.;
    } else {
        pv[0] = pt[0]*dyad[body][0][0]+pt[1]*dyad[body][0][1]+pt[2]*dyad[body][0
          ][2];
        pv[1] = pt[0]*dyad[body][1][0]+pt[1]*dyad[body][1][1]+pt[2]*dyad[body][1
          ][2];
        pv[2] = pt[0]*dyad[body][2][0]+pt[1]*dyad[body][2][1]+pt[2]*dyad[body][2
          ][2];
        accel[0] = anb[body][0]+pv[0]*cnb[body][0][0]+pv[1]*cnb[body][0][1]+pv[2
          ]*cnb[body][0][2];
        accel[1] = anb[body][1]+pv[0]*cnb[body][1][0]+pv[1]*cnb[body][1][1]+pv[2
          ]*cnb[body][1][2];
        accel[2] = anb[body][2]+pv[0]*cnb[body][2][0]+pv[1]*cnb[body][2][1]+pv[2
          ]*cnb[body][2][2];
    }
}

void srssangacc(int body,
    double aacc[3])
{
/*
Return angular acceleration of the body.

*/

    if (srsschkbnum(33,body) != 0) {
        return;
    }
    if (roustate != 3) {
        srssseterr(33,24);
        return;
    }
    if (body == -1) {
        aacc[0] = 0.;
        aacc[1] = 0.;
        aacc[2] = 0.;
    } else {
        aacc[0] = onb[body][0];
        aacc[1] = onb[body][1];
        aacc[2] = onb[body][2];
    }
}

void srssgrav(double gravin[3])
{

    srssseterr(1,19);
    roustate = 0;
}

void srssmass(int body,
    double massin)
{

    if (srsschkbnum(2,body) != 0) {
        return;
    }
    if (body == -1) {
        srssseterr(2,15);
        return;
    }
    if (mkq[body] != 0) {
        mk[body] = massin;
        mkq[body] = 3;
    } else {
        srssseterr(2,19);
    }
    roustate = 0;
}

void srssiner(int body,
    double inerin[3][3])
{
    int anyques;

    if (srsschkbnum(3,body) != 0) {
        return;
    }
    if (body == -1) {
        srssseterr(3,15);
        return;
    }
    anyques = 0;
    if (ikq[body][0][0]  !=  0) {
        ik[body][0][0] = inerin[0][0];
        ikq[body][0][0] = 3;
        anyques = 1;
    }
    if (ikq[body][0][1]  !=  0) {
        ik[body][0][1] = inerin[0][1];
        ikq[body][0][1] = 3;
        ik[body][1][0] = inerin[0][1];
        ikq[body][1][0] = 3;
        anyques = 1;
    }
    if (ikq[body][0][2]  !=  0) {
        ik[body][0][2] = inerin[0][2];
        ikq[body][0][2] = 3;
        ik[body][2][0] = inerin[0][2];
        ikq[body][2][0] = 3;
        anyques = 1;
    }
    if (ikq[body][1][1]  !=  0) {
        ik[body][1][1] = inerin[1][1];
        ikq[body][1][1] = 3;
        anyques = 1;
    }
    if (ikq[body][1][2]  !=  0) {
        ik[body][1][2] = inerin[1][2];
        ikq[body][1][2] = 3;
        ik[body][2][1] = inerin[1][2];
        ikq[body][2][1] = 3;
        anyques = 1;
    }
    if (ikq[body][2][2]  !=  0) {
        ik[body][2][2] = inerin[2][2];
        ikq[body][2][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        srssseterr(3,19);
    }
    roustate = 0;
}

void srssbtj(int joint,
    double btjin[3])
{
    int anyques;

    if (srsschkjnum(4,joint) != 0) {
        return;
    }
    anyques = 0;
    if (rkq[joint][0]  !=  0) {
        rk[joint][0] = btjin[0];
        rkq[joint][0] = 3;
        anyques = 1;
    }
    if (rkq[joint][1]  !=  0) {
        rk[joint][1] = btjin[1];
        rkq[joint][1] = 3;
        anyques = 1;
    }
    if (rkq[joint][2]  !=  0) {
        rk[joint][2] = btjin[2];
        rkq[joint][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        srssseterr(4,19);
    }
    roustate = 0;
}

void srssitj(int joint,
    double itjin[3])
{
    int anyques;

    if (srsschkjnum(5,joint) != 0) {
        return;
    }
    anyques = 0;
    if (riq[joint][0]  !=  0) {
        ri[joint][0] = itjin[0];
        riq[joint][0] = 3;
        anyques = 1;
    }
    if (riq[joint][1]  !=  0) {
        ri[joint][1] = itjin[1];
        riq[joint][1] = 3;
        anyques = 1;
    }
    if (riq[joint][2]  !=  0) {
        ri[joint][2] = itjin[2];
        riq[joint][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        srssseterr(5,19);
    }
    roustate = 0;
}

void srsspin(int joint,
    int pinno,
    double pinin[3])
{
    int anyques,offs;

    if (srsschkjpin(6,joint,pinno) != 0) {
        return;
    }
    anyques = 0;
    offs = firstq[joint]+pinno;
    if (jtype[joint] == 21) {
        offs = offs+3;
    }
    if (jtype[joint] == 11) {
        offs = offs+1;
    }
    if (pinq[offs][0]  !=  0) {
        pin[offs][0] = pinin[0];
        pinq[offs][0] = 3;
        anyques = 1;
    }
    if (pinq[offs][1]  !=  0) {
        pin[offs][1] = pinin[1];
        pinq[offs][1] = 3;
        anyques = 1;
    }
    if (pinq[offs][2]  !=  0) {
        pin[offs][2] = pinin[2];
        pinq[offs][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        srssseterr(6,19);
    }
    roustate = 0;
}

void srsspres(int joint,
    int axis,
    int presin)
{
    int anyques;

    if (srsschkjaxis(37,joint,axis) != 0) {
        return;
    }
    if ((presin != 0) && (presin != 1)) {
        srssseterr(37,20);
    }
    anyques = 0;
    if (presq[srssindx(joint,axis)]  !=  0) {
        if (presin  !=  0) {
            pres[srssindx(joint,axis)] = 1.;
        } else {
            pres[srssindx(joint,axis)] = 0.;
        }
        presq[srssindx(joint,axis)] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        srssseterr(37,19);
    }
    wwflg = 0;
}

void srssconschg(void)
{

    wwflg = 0;
}

void srssstab(double velin,
    double posin)
{

    stabvel = velin;
    stabvelq = 3;
    stabpos = posin;
    stabposq = 3;
}

void srssgetgrav(double gravout[3])
{

    gravout[0] = grav[0];
    gravout[1] = grav[1];
    gravout[2] = grav[2];
}

void srssgetmass(int body,
    double *massout)
{

    if (srsschkbnum(40,body) != 0) {
        return;
    }
    if (body == -1) {
        srssseterr(40,15);
        return;
    }
    *massout = mk[body];
}

void srssgetiner(int body,
    double inerout[3][3])
{

    if (srsschkbnum(41,body) != 0) {
        return;
    }
    if (body == -1) {
        srssseterr(41,15);
        return;
    }
    inerout[0][0] = ik[body][0][0];
    inerout[0][1] = ik[body][0][1];
    inerout[0][2] = ik[body][0][2];
    inerout[1][0] = ik[body][1][0];
    inerout[1][1] = ik[body][1][1];
    inerout[1][2] = ik[body][1][2];
    inerout[2][0] = ik[body][2][0];
    inerout[2][1] = ik[body][2][1];
    inerout[2][2] = ik[body][2][2];
}

void srssgetbtj(int joint,
    double btjout[3])
{

    if (srsschkjnum(42,joint) != 0) {
        return;
    }
    btjout[0] = rk[joint][0];
    btjout[1] = rk[joint][1];
    btjout[2] = rk[joint][2];
}

void srssgetitj(int joint,
    double itjout[3])
{

    if (srsschkjnum(43,joint) != 0) {
        return;
    }
    itjout[0] = ri[joint][0];
    itjout[1] = ri[joint][1];
    itjout[2] = ri[joint][2];
}

void srssgetpin(int joint,
    int pinno,
    double pinout[3])
{
    int offs;

    if (srsschkjpin(44,joint,pinno) != 0) {
        return;
    }
    offs = firstq[joint]+pinno;
    if (jtype[joint] == 21) {
        offs = offs+3;
    }
    if (jtype[joint] == 11) {
        offs = offs+1;
    }
    pinout[0] = pin[offs][0];
    pinout[1] = pin[offs][1];
    pinout[2] = pin[offs][2];
}

void srssgetpres(int joint,
    int axis,
    int *presout)
{

    if (srsschkjaxis(45,joint,axis) != 0) {
        return;
    }
    if (pres[srssindx(joint,axis)]  !=  0.) {
        *presout = 1;
    } else {
        *presout = 0;
    }
}

void srssgetstab(double *velout,
    double *posout)
{

    *velout = stabvel;
    *posout = stabpos;
}

void srssinfo(int info[50])
{

    info[0] = ground;
    info[1] = nbod;
    info[2] = ndof;
    info[3] = ncons;
    info[4] = nloop;
    info[5] = nldof;
    info[6] = nloopc;
    info[7] = nball;
    info[8] = nlball;
    info[9] = npres;
    info[10] = nuser;
    info[11] = 0;
/* info entries from 12-49 are reserved */
}

void srssjnt(int joint,
    int info[50],
    int tran[6])
{
    int i,offs;

    if (srsschkjnum(48,joint) != 0) {
        return;
    }
    info[0] = jtype[joint];
    info[1] = 0;
    offs = 0;
    info[2] = inb[joint];
    info[3] = outb[joint];
    info[4] = njntdof[joint];
    info[5] = njntc[joint];
    info[6] = njntp[joint];
    info[7] = firstq[joint];
    info[8] = ballq[joint];
    info[9] = firstm[joint];
    info[10] = firstp[joint];
/* info entries from 11-49 are reserved */

    for (i = 0; i <= 5; i++) {
        if (i  <  njntdof[joint]) {
            tran[i] = trans[offs+firstq[joint]+i];
        } else {
            tran[i] = -1;
        }
    }
}

void srsscons(int consno,
    int info[50])
{

    if (srsschkucnum(49,consno) != 0) {
        return;
    }
/* There are no user constraints in this problem. */
}

void srssgentime(int *gentm)
{

    *gentm = 211006;
}
/*
Done. CPU seconds used: 0.12  Memory used: 1687552 bytes.
Equation complexity:
  sdstate:   128 adds   146 multiplies     2 divides   219 assignments
  sdderiv:   296 adds   278 multiplies     5 divides   399 assignments
  sdresid:   219 adds   155 multiplies     0 divides   227 assignments
  sdreac:    110 adds    71 multiplies     0 divides    96 assignments
  sdmom:      40 adds    43 multiplies     0 divides    22 assignments
  sdsys:      51 adds    72 multiplies     0 divides    13 assignments
*/
