/*
Generated 24-Jun-2008 21:10:41 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041


ROADMAP (srds.sd)

Bodies        Inb
No  Name      body Joint type  Coords q         Multipliers
--- --------- ---- ----------- ---------------- -----------------------
 -1 $ground                                    |
  0 l.calf     -1  Pin           0             |
  1 l.thigh     0  Sliding       1             |
  2 torso       1  Pin           2             |
  3 r.thigh     2  Pin           3             |
  4 r.calf      3  Sliding       4             |

Loop Joints                    Pseudo Coords lq

  5 r.calf     -1  Pin           0             |  0   1   2   3   4 

*/
#include <math.h>
#include <stdio.h>

typedef struct {
    int ground_,nbod_,ndof_,ncons_,nloop_,nldof_,nloopc_,nball_,nlball_,npres_,
      nuser_;
    int jtype_[6],inb_[6],outb_[6],njntdof_[6],njntc_[6],njntp_[6],firstq_[6],
      ballq_[6],firstm_[6],firstp_[6];
    int trans_[6];
} srdsgtopo_t;
#define ground (srdsgtopo.ground_)
#define nbod (srdsgtopo.nbod_)
#define ndof (srdsgtopo.ndof_)
#define ncons (srdsgtopo.ncons_)
#define nloop (srdsgtopo.nloop_)
#define nldof (srdsgtopo.nldof_)
#define nloopc (srdsgtopo.nloopc_)
#define nball (srdsgtopo.nball_)
#define nlball (srdsgtopo.nlball_)
#define npres (srdsgtopo.npres_)
#define nuser (srdsgtopo.nuser_)
#define jtype (srdsgtopo.jtype_)
#define inb (srdsgtopo.inb_)
#define outb (srdsgtopo.outb_)
#define njntdof (srdsgtopo.njntdof_)
#define njntc (srdsgtopo.njntc_)
#define njntp (srdsgtopo.njntp_)
#define firstq (srdsgtopo.firstq_)
#define ballq (srdsgtopo.ballq_)
#define firstm (srdsgtopo.firstm_)
#define firstp (srdsgtopo.firstp_)
#define trans (srdsgtopo.trans_)

typedef struct {
    double grav_[3],mk_[5],ik_[5][3][3],pin_[5][3];
    double rk_[5][3],ri_[5][3],pres_[5],stabvel_,stabpos_;
    double inbpin1_[1][3],inbpin2_[1][3],inbpin3_[1][3],inbref_[1][3];
    double bodypin_[1][3],bodyref_[1][3],lbtj_[1][3],litj_[1][3],lpres_[1];
    int mfrcflg_,roustate_,vpkflg_,inerflg_,mmflg_,mmlduflg_,wwflg_,ltauflg_,
      fs0flg_,ii_,mmap_[5];
    int gravq_[3],mkq_[5],ikq_[5][3][3],pinq_[5][3],rkq_[5][3],riq_[5][3],presq_
      [5],stabvelq_,stabposq_;
    int inbpin1q_[1][3],inbpin2q_[1][3],inbpin3q_[1][3],inbrefq_[1][3],bodypinq_
      [1][3],bodyrefq_[1][3],lbtjq_[1][3],litjq_[1][3],lpresq_[1];
    double mtot_,psmkg_,rhead_[5][3],rcom_[5][3],mkrcomt_[5][3][3],psikg_[3][3],
      psrcomg_[3],psrkg_[3],psrig_[3],psmk_[5],psik_[5][3][3],psrcom_[5][3],
      psrk_[5][3],psri_[5][3];
    double ipin_[1][3],ipin2_[1][3],iref_[1][3],iperp_[1][3],opin_[1][3],oref_[1
      ][3],operp_[1][3],ghand_[1];
} srdsginput_t;
#define grav (srdsginput.grav_)
#define mk (srdsginput.mk_)
#define ik (srdsginput.ik_)
#define pin (srdsginput.pin_)
#define rk (srdsginput.rk_)
#define ri (srdsginput.ri_)
#define pres (srdsginput.pres_)
#define stabvel (srdsginput.stabvel_)
#define stabpos (srdsginput.stabpos_)
#define rhead (srdsginput.rhead_)
#define rcom (srdsginput.rcom_)
#define psrcomg (srdsginput.psrcomg_)
#define psrcom (srdsginput.psrcom_)
#define mkrcomt (srdsginput.mkrcomt_)
#define psmk (srdsginput.psmk_)
#define psik (srdsginput.psik_)
#define psrk (srdsginput.psrk_)
#define psri (srdsginput.psri_)
#define psmkg (srdsginput.psmkg_)
#define psikg (srdsginput.psikg_)
#define psrkg (srdsginput.psrkg_)
#define psrig (srdsginput.psrig_)
#define mtot (srdsginput.mtot_)
#define inbpin1 (srdsginput.inbpin1_)
#define inbpin2 (srdsginput.inbpin2_)
#define inbpin3 (srdsginput.inbpin3_)
#define inbref (srdsginput.inbref_)
#define bodypin (srdsginput.bodypin_)
#define bodyref (srdsginput.bodyref_)
#define lbtj (srdsginput.lbtj_)
#define litj (srdsginput.litj_)
#define lpres (srdsginput.lpres_)
#define ipin (srdsginput.ipin_)
#define ipin2 (srdsginput.ipin2_)
#define iref (srdsginput.iref_)
#define iperp (srdsginput.iperp_)
#define opin (srdsginput.opin_)
#define oref (srdsginput.oref_)
#define operp (srdsginput.operp_)
#define ghand (srdsginput.ghand_)
#define mfrcflg (srdsginput.mfrcflg_)
#define roustate (srdsginput.roustate_)
#define vpkflg (srdsginput.vpkflg_)
#define inerflg (srdsginput.inerflg_)
#define mmflg (srdsginput.mmflg_)
#define mmlduflg (srdsginput.mmlduflg_)
#define wwflg (srdsginput.wwflg_)
#define ltauflg (srdsginput.ltauflg_)
#define fs0flg (srdsginput.fs0flg_)
#define ii (srdsginput.ii_)
#define mmap (srdsginput.mmap_)
#define gravq (srdsginput.gravq_)
#define mkq (srdsginput.mkq_)
#define ikq (srdsginput.ikq_)
#define pinq (srdsginput.pinq_)
#define rkq (srdsginput.rkq_)
#define riq (srdsginput.riq_)
#define presq (srdsginput.presq_)
#define stabvelq (srdsginput.stabvelq_)
#define stabposq (srdsginput.stabposq_)
#define lbtjq (srdsginput.lbtjq_)
#define litjq (srdsginput.litjq_)
#define lpresq (srdsginput.lpresq_)
#define inbpin1q (srdsginput.inbpin1q_)
#define inbpin2q (srdsginput.inbpin2q_)
#define inbpin3q (srdsginput.inbpin3q_)
#define inbrefq (srdsginput.inbrefq_)
#define bodypinq (srdsginput.bodypinq_)
#define bodyrefq (srdsginput.bodyrefq_)

typedef struct {
    double curtim_,q_[5],qn_[5],u_[5],cnk_[5][3][3],cnb_[5][3][3];
    double rnk_[5][3],vnk_[5][3],wk_[5][3],rnb_[5][3],vnb_[5][3],wb_[5][3],
      wbrcom_[5][3],com_[3],rnkg_[3];
    double Cik_[5][3][3],rikt_[5][3][3],Iko_[5][3][3],mkrk_[5][3][3],Cib_[5][3][
      3];
    double Wkk_[5][3],Vkk_[5][3],dik_[5][3],rpp_[5][3],rpk_[5][3],rik_[5][3],
      rik2_[5][3];
    double rpri_[5][3],Wik_[5][3],Vik_[5][3],Wirk_[5][3],rkWkk_[5][3],Wkrpk_[5][
      3],VikWkr_[5][3];
    double perr_[5],verr_[5],aerr_[5],mult_[5],ufk_[5][3],utk_[5][3],mfk_[5][3],
      mtk_[5][3];
    double utau_[5],mtau_[5],uacc_[5],uvel_[5],upos_[5];
    double Cio_[1][3][3],Cibo_[1][3][3],Cibob_[1][3][3],eul1_[1],eul2_[1],eul3_[
      1],eul4_[1];
    double eul1dot_[1],eul2dot_[1],eul3dot_[1],eul4dot_[1],eul1a_[1],eul2a_[1],
      eul3a_[1];
    double ceul1_[1],ceul2_[1],ceul3_[1],seul1_[1],seul2_[1],seul3_[1],sli1_[1],
      sli2_[1],sli3_[1];
    double sli1v_[1],sli2v_[1],sli3v_[1],sli1a_[1],sli2a_[1],sli3a_[1],ipin2x_[1
      ][3];
    double ltau_[1],mltau_[1],lacc_[1],lvel_[1],lpos_[1],lq_[1];
    double mltaufi_[1][3],mltaufo_[1][3],mltauti_[1][3],mltauto_[1][3],Woio_[1][
      3],Woiob_[1][3],Ooiob_[1][3];
    double vt1_[1][3],vt2_[1][3],vt2a_[1][3],vt3_[1][3],vt4_[1][3],vt5_[1][3],
      vt6_[1][3];
    double vt7_[1][3],vt8_[1][3],vt9_[1][3],vt10_[1][3],vt10a_[1][3],vt10b_[1][3
      ],vt10c_[1][3];
    double vt11_[1][3],vt12_[1][3],vt13_[1][3],vt13a_[1][3],vt14_[1][3],vt15_[1
      ][3];
    double vt16_[1][3],vt17_[1][3],vt18_[1][3],vt19_[1][3],vt20_[1][3],vt21_[1][
      3];
    double vt22_[1][3],vt23_[1][3],vt24_[1][3],vt25_[1][3],vt26_[1][3],vt26a_[1
      ][3],vt27_[1][3];
    double s0_,c0_,s2_,c2_,s3_,c3_;
} srdsgstate_t;
#define curtim (srdsgstate.curtim_)
#define q (srdsgstate.q_)
#define qn (srdsgstate.qn_)
#define u (srdsgstate.u_)
#define cnk (srdsgstate.cnk_)
#define cnb (srdsgstate.cnb_)
#define rnkg (srdsgstate.rnkg_)
#define rnk (srdsgstate.rnk_)
#define rnb (srdsgstate.rnb_)
#define vnk (srdsgstate.vnk_)
#define vnb (srdsgstate.vnb_)
#define wk (srdsgstate.wk_)
#define wb (srdsgstate.wb_)
#define com (srdsgstate.com_)
#define Cik (srdsgstate.Cik_)
#define Cib (srdsgstate.Cib_)
#define rikt (srdsgstate.rikt_)
#define Iko (srdsgstate.Iko_)
#define mkrk (srdsgstate.mkrk_)
#define Wkk (srdsgstate.Wkk_)
#define Vkk (srdsgstate.Vkk_)
#define dik (srdsgstate.dik_)
#define rpp (srdsgstate.rpp_)
#define rpk (srdsgstate.rpk_)
#define rik (srdsgstate.rik_)
#define rik2 (srdsgstate.rik2_)
#define rpri (srdsgstate.rpri_)
#define Wik (srdsgstate.Wik_)
#define Vik (srdsgstate.Vik_)
#define Wirk (srdsgstate.Wirk_)
#define rkWkk (srdsgstate.rkWkk_)
#define Wkrpk (srdsgstate.Wkrpk_)
#define VikWkr (srdsgstate.VikWkr_)
#define wbrcom (srdsgstate.wbrcom_)
#define perr (srdsgstate.perr_)
#define verr (srdsgstate.verr_)
#define aerr (srdsgstate.aerr_)
#define mult (srdsgstate.mult_)
#define ufk (srdsgstate.ufk_)
#define utk (srdsgstate.utk_)
#define utau (srdsgstate.utau_)
#define mfk (srdsgstate.mfk_)
#define mtk (srdsgstate.mtk_)
#define mtau (srdsgstate.mtau_)
#define uacc (srdsgstate.uacc_)
#define uvel (srdsgstate.uvel_)
#define upos (srdsgstate.upos_)
#define Cio (srdsgstate.Cio_)
#define Cibo (srdsgstate.Cibo_)
#define Cibob (srdsgstate.Cibob_)
#define ltau (srdsgstate.ltau_)
#define mltau (srdsgstate.mltau_)
#define lacc (srdsgstate.lacc_)
#define lvel (srdsgstate.lvel_)
#define lpos (srdsgstate.lpos_)
#define lq (srdsgstate.lq_)
#define mltaufi (srdsgstate.mltaufi_)
#define mltaufo (srdsgstate.mltaufo_)
#define mltauti (srdsgstate.mltauti_)
#define mltauto (srdsgstate.mltauto_)
#define Woio (srdsgstate.Woio_)
#define Woiob (srdsgstate.Woiob_)
#define Ooiob (srdsgstate.Ooiob_)
#define eul1 (srdsgstate.eul1_)
#define eul2 (srdsgstate.eul2_)
#define eul3 (srdsgstate.eul3_)
#define eul4 (srdsgstate.eul4_)
#define eul1dot (srdsgstate.eul1dot_)
#define eul2dot (srdsgstate.eul2dot_)
#define eul3dot (srdsgstate.eul3dot_)
#define eul4dot (srdsgstate.eul4dot_)
#define eul1a (srdsgstate.eul1a_)
#define eul2a (srdsgstate.eul2a_)
#define eul3a (srdsgstate.eul3a_)
#define ceul1 (srdsgstate.ceul1_)
#define ceul2 (srdsgstate.ceul2_)
#define ceul3 (srdsgstate.ceul3_)
#define seul1 (srdsgstate.seul1_)
#define seul2 (srdsgstate.seul2_)
#define seul3 (srdsgstate.seul3_)
#define sli1 (srdsgstate.sli1_)
#define sli2 (srdsgstate.sli2_)
#define sli3 (srdsgstate.sli3_)
#define sli1v (srdsgstate.sli1v_)
#define sli2v (srdsgstate.sli2v_)
#define sli3v (srdsgstate.sli3v_)
#define sli1a (srdsgstate.sli1a_)
#define sli2a (srdsgstate.sli2a_)
#define sli3a (srdsgstate.sli3a_)
#define ipin2x (srdsgstate.ipin2x_)
#define vt1 (srdsgstate.vt1_)
#define vt2 (srdsgstate.vt2_)
#define vt2a (srdsgstate.vt2a_)
#define vt3 (srdsgstate.vt3_)
#define vt4 (srdsgstate.vt4_)
#define vt5 (srdsgstate.vt5_)
#define vt6 (srdsgstate.vt6_)
#define vt7 (srdsgstate.vt7_)
#define vt8 (srdsgstate.vt8_)
#define vt9 (srdsgstate.vt9_)
#define vt10 (srdsgstate.vt10_)
#define vt10a (srdsgstate.vt10a_)
#define vt10b (srdsgstate.vt10b_)
#define vt10c (srdsgstate.vt10c_)
#define vt11 (srdsgstate.vt11_)
#define vt12 (srdsgstate.vt12_)
#define vt13 (srdsgstate.vt13_)
#define vt13a (srdsgstate.vt13a_)
#define vt14 (srdsgstate.vt14_)
#define vt15 (srdsgstate.vt15_)
#define vt16 (srdsgstate.vt16_)
#define vt17 (srdsgstate.vt17_)
#define vt18 (srdsgstate.vt18_)
#define vt19 (srdsgstate.vt19_)
#define vt20 (srdsgstate.vt20_)
#define vt21 (srdsgstate.vt21_)
#define vt22 (srdsgstate.vt22_)
#define vt23 (srdsgstate.vt23_)
#define vt24 (srdsgstate.vt24_)
#define vt25 (srdsgstate.vt25_)
#define vt26 (srdsgstate.vt26_)
#define vt26a (srdsgstate.vt26a_)
#define vt27 (srdsgstate.vt27_)
#define s0 (srdsgstate.s0_)
#define c0 (srdsgstate.c0_)
#define s2 (srdsgstate.s2_)
#define c2 (srdsgstate.c2_)
#define s3 (srdsgstate.s3_)
#define c3 (srdsgstate.c3_)

typedef struct {
    double fs0_[5],qdot_[5],Otk_[5][3],Atk_[5][3],AiOiWi_[5][3],Fstar_[5][3];
    double Tstar_[5][3],Fstark_[5][3],Tstark_[5][3],IkWk_[5][3],WkIkWk_[5][3],
      gk_[5][3],IkbWk_[5][3],WkIkbWk_[5][3];
    double w0w0_[5],w1w1_[5],w2w2_[5],w0w1_[5],w0w2_[5],w1w2_[5];
    double w00w11_[5],w00w22_[5],w11w22_[5],ww_[5][5],qraux_[5];
    double mm_[5][5],mlo_[5][5],mdi_[5],IkWpk_[5][5][3],works_[5],workss_[5][5];
    double Wpk_[5][5][3],Vpk_[5][5][3],VWri_[5][5][3];
    double ltaufk_[5][3],ltautk_[5][3],ltauc_[1],ltci_[1][3],ltc_[1][3],lfci_[1
      ][3],lfc_[1][3];
    double Tinb_[1][3],Toutb_[1][3],ltaufi_[1][3],ltaufo_[1][3],ltauti_[1][3],
      ltauto_[1][3];
    int wmap_[5],multmap_[5],jpvt_[5],wsiz_,wrank_;
} srdsglhs_t;
#define qdot (srdsglhs.qdot_)
#define Otk (srdsglhs.Otk_)
#define Atk (srdsglhs.Atk_)
#define AiOiWi (srdsglhs.AiOiWi_)
#define Fstar (srdsglhs.Fstar_)
#define Tstar (srdsglhs.Tstar_)
#define fs0 (srdsglhs.fs0_)
#define Fstark (srdsglhs.Fstark_)
#define Tstark (srdsglhs.Tstark_)
#define IkWk (srdsglhs.IkWk_)
#define IkbWk (srdsglhs.IkbWk_)
#define WkIkWk (srdsglhs.WkIkWk_)
#define WkIkbWk (srdsglhs.WkIkbWk_)
#define gk (srdsglhs.gk_)
#define w0w0 (srdsglhs.w0w0_)
#define w1w1 (srdsglhs.w1w1_)
#define w2w2 (srdsglhs.w2w2_)
#define w0w1 (srdsglhs.w0w1_)
#define w0w2 (srdsglhs.w0w2_)
#define w1w2 (srdsglhs.w1w2_)
#define w00w11 (srdsglhs.w00w11_)
#define w00w22 (srdsglhs.w00w22_)
#define w11w22 (srdsglhs.w11w22_)
#define ww (srdsglhs.ww_)
#define qraux (srdsglhs.qraux_)
#define ltaufk (srdsglhs.ltaufk_)
#define ltautk (srdsglhs.ltautk_)
#define ltci (srdsglhs.ltci_)
#define ltc (srdsglhs.ltc_)
#define lfci (srdsglhs.lfci_)
#define lfc (srdsglhs.lfc_)
#define Tinb (srdsglhs.Tinb_)
#define Toutb (srdsglhs.Toutb_)
#define ltauc (srdsglhs.ltauc_)
#define ltaufi (srdsglhs.ltaufi_)
#define ltaufo (srdsglhs.ltaufo_)
#define ltauti (srdsglhs.ltauti_)
#define ltauto (srdsglhs.ltauto_)
#define mm (srdsglhs.mm_)
#define mlo (srdsglhs.mlo_)
#define mdi (srdsglhs.mdi_)
#define IkWpk (srdsglhs.IkWpk_)
#define works (srdsglhs.works_)
#define workss (srdsglhs.workss_)
#define Wpk (srdsglhs.Wpk_)
#define Vpk (srdsglhs.Vpk_)
#define VWri (srdsglhs.VWri_)
#define wmap (srdsglhs.wmap_)
#define multmap (srdsglhs.multmap_)
#define jpvt (srdsglhs.jpvt_)
#define wsiz (srdsglhs.wsiz_)
#define wrank (srdsglhs.wrank_)

typedef struct {
    double fs_[5],udot_[5],tauc_[5],dyad_[5][3][3],fc_[5][3],tc_[5][3];
    double ank_[5][3],onk_[5][3],Onkb_[5][3],AOnkri_[5][3],Ankb_[5][3],AnkAtk_[5
      ][3],anb_[5][3],onb_[5][3],dyrcom_[5][3];
    double ffk_[5][3],ttk_[5][3],fccikt_[5][3],ffkb_[5][3],ttkb_[5][3];
} srdsgrhs_t;
#define fs (srdsgrhs.fs_)
#define udot (srdsgrhs.udot_)
#define ank (srdsgrhs.ank_)
#define anb (srdsgrhs.anb_)
#define onk (srdsgrhs.onk_)
#define onb (srdsgrhs.onb_)
#define Onkb (srdsgrhs.Onkb_)
#define AOnkri (srdsgrhs.AOnkri_)
#define Ankb (srdsgrhs.Ankb_)
#define AnkAtk (srdsgrhs.AnkAtk_)
#define dyrcom (srdsgrhs.dyrcom_)
#define ffk (srdsgrhs.ffk_)
#define ttk (srdsgrhs.ttk_)
#define fccikt (srdsgrhs.fccikt_)
#define ffkb (srdsgrhs.ffkb_)
#define ttkb (srdsgrhs.ttkb_)
#define dyad (srdsgrhs.dyad_)
#define fc (srdsgrhs.fc_)
#define tc (srdsgrhs.tc_)
#define tauc (srdsgrhs.tauc_)

typedef struct {
    double temp_[3000],tmat1_[3][3],tmat2_[3][3],tvec1_[3],tvec2_[3],tvec3_[3],
      tvec4_[3],tvec5_[3];
    double tsc1_,tsc2_,tsc3_;
} srdsgtemp_t;
#define temp (srdsgtemp.temp_)
#define tmat1 (srdsgtemp.tmat1_)
#define tmat2 (srdsgtemp.tmat2_)
#define tvec1 (srdsgtemp.tvec1_)
#define tvec2 (srdsgtemp.tvec2_)
#define tvec3 (srdsgtemp.tvec3_)
#define tvec4 (srdsgtemp.tvec4_)
#define tvec5 (srdsgtemp.tvec5_)
#define tsc1 (srdsgtemp.tsc1_)
#define tsc2 (srdsgtemp.tsc2_)
#define tsc3 (srdsgtemp.tsc3_)

srdsgtopo_t srdsgtopo = {
/*  Topological information
*/
    /* ground */ 1,
    /* nbod */ 5,
    /* ndof */ 5,
    /* ncons */ 5,
    /* nloop */ 1,
    /* nldof */ 1,
    /* nloopc */ 5,
    /* nball */ 0,
    /* nlball */ 0,
    /* npres */ 0,
    /* nuser */ 0,
    /* jtype[0] */ 1,
    /* jtype[1] */ 5,
    /* jtype[2] */ 1,
    /* jtype[3] */ 1,
    /* jtype[4] */ 5,
    /* jtype[5] */ 1,
    /* inb[0] */ -1,
    /* inb[1] */ 0,
    /* inb[2] */ 1,
    /* inb[3] */ 2,
    /* inb[4] */ 3,
    /* inb[5] */ -1,
    /* outb[0] */ 0,
    /* outb[1] */ 1,
    /* outb[2] */ 2,
    /* outb[3] */ 3,
    /* outb[4] */ 4,
    /* outb[5] */ 4,
    /* njntdof[0] */ 1,
    /* njntdof[1] */ 1,
    /* njntdof[2] */ 1,
    /* njntdof[3] */ 1,
    /* njntdof[4] */ 1,
    /* njntdof[5] */ 1,
    /* njntc[0] */ 0,
    /* njntc[1] */ 0,
    /* njntc[2] */ 0,
    /* njntc[3] */ 0,
    /* njntc[4] */ 0,
    /* njntc[5] */ 5,
    /* njntp[0] */ 0,
    /* njntp[1] */ 0,
    /* njntp[2] */ 0,
    /* njntp[3] */ 0,
    /* njntp[4] */ 0,
    /* njntp[5] */ 0,
    /* firstq[0] */ 0,
    /* firstq[1] */ 1,
    /* firstq[2] */ 2,
    /* firstq[3] */ 3,
    /* firstq[4] */ 4,
    /* firstq[5] */ 0,
    /* ballq[0] */ -104,
    /* ballq[1] */ -104,
    /* ballq[2] */ -104,
    /* ballq[3] */ -104,
    /* ballq[4] */ -104,
    /* ballq[5] */ -104,
    /* firstm[0] */ -1,
    /* firstm[1] */ -1,
    /* firstm[2] */ -1,
    /* firstm[3] */ -1,
    /* firstm[4] */ -1,
    /* firstm[5] */ 0,
    /* firstp[0] */ -1,
    /* firstp[1] */ -1,
    /* firstp[2] */ -1,
    /* firstp[3] */ -1,
    /* firstp[4] */ -1,
    /* firstp[5] */ -1,
    /* trans[0] */ 0,
    /* trans[1] */ 1,
    /* trans[2] */ 0,
    /* trans[3] */ 0,
    /* trans[4] */ 1,
    /* trans[5] */ 0,
};
srdsginput_t srdsginput = {
/* Model parameters from the input file */

/* gravity */
    /* grav[0] */ 0.,
    /* grav[1] */ 0.,
    /* grav[2] */ -9.81,

/* mass */
    /* mk[0] */ 6.8952,
    /* mk[1] */ 5.676,
    /* mk[2] */ 50.,
    /* mk[3] */ 5.676,
    /* mk[4] */ 6.8952,

/* inertia */
    /* ik[0][0][0] */ 1.,
    /* ik[0][0][1] */ 0.,
    /* ik[0][0][2] */ 0.,
    /* ik[0][1][0] */ 0.,
    /* ik[0][1][1] */ .1535,
    /* ik[0][1][2] */ 0.,
    /* ik[0][2][0] */ 0.,
    /* ik[0][2][1] */ 0.,
    /* ik[0][2][2] */ 1.,
    /* ik[1][0][0] */ 1.,
    /* ik[1][0][1] */ 0.,
    /* ik[1][0][2] */ 0.,
    /* ik[1][1][0] */ 0.,
    /* ik[1][1][1] */ .09592,
    /* ik[1][1][2] */ 0.,
    /* ik[1][2][0] */ 0.,
    /* ik[1][2][1] */ 0.,
    /* ik[1][2][2] */ 1.,
    /* ik[2][0][0] */ 1.,
    /* ik[2][0][1] */ 0.,
    /* ik[2][0][2] */ 0.,
    /* ik[2][1][0] */ 0.,
    /* ik[2][1][1] */ 1.5,
    /* ik[2][1][2] */ 0.,
    /* ik[2][2][0] */ 0.,
    /* ik[2][2][1] */ 0.,
    /* ik[2][2][2] */ 1.,
    /* ik[3][0][0] */ 1.,
    /* ik[3][0][1] */ 0.,
    /* ik[3][0][2] */ 0.,
    /* ik[3][1][0] */ 0.,
    /* ik[3][1][1] */ .09592,
    /* ik[3][1][2] */ 0.,
    /* ik[3][2][0] */ 0.,
    /* ik[3][2][1] */ 0.,
    /* ik[3][2][2] */ 1.,
    /* ik[4][0][0] */ 1.,
    /* ik[4][0][1] */ 0.,
    /* ik[4][0][2] */ 0.,
    /* ik[4][1][0] */ 0.,
    /* ik[4][1][1] */ .1535,
    /* ik[4][1][2] */ 0.,
    /* ik[4][2][0] */ 0.,
    /* ik[4][2][1] */ 0.,
    /* ik[4][2][2] */ 1.,

/* tree hinge axis vectors */
    /* pin[0][0] */ 0.,
    /* pin[0][1] */ -1.,
    /* pin[0][2] */ 0.,
    /* pin[1][0] */ 0.,
    /* pin[1][1] */ 0.,
    /* pin[1][2] */ 1.,
    /* pin[2][0] */ 0.,
    /* pin[2][1] */ -1.,
    /* pin[2][2] */ 0.,
    /* pin[3][0] */ 0.,
    /* pin[3][1] */ -1.,
    /* pin[3][2] */ 0.,
    /* pin[4][0] */ 0.,
    /* pin[4][1] */ 0.,
    /* pin[4][2] */ -1.,

/* tree bodytojoint vectors */
    /* rk[0][0] */ 0.,
    /* rk[0][1] */ 0.,
    /* rk[0][2] */ -.1426,
    /* rk[1][0] */ 0.,
    /* rk[1][1] */ 0.,
    /* rk[1][2] */ -.202,
    /* rk[2][0] */ -.0889,
    /* rk[2][1] */ 0.,
    /* rk[2][2] */ -.2868,
    /* rk[3][0] */ 0.,
    /* rk[3][1] */ 0.,
    /* rk[3][2] */ .1898,
    /* rk[4][0] */ 0.,
    /* rk[4][1] */ 0.,
    /* rk[4][2] */ .2384,

/* tree inbtojoint vectors */
    /* ri[0][0] */ 0.,
    /* ri[0][1] */ 0.,
    /* ri[0][2] */ 0.,
    /* ri[1][0] */ 0.,
    /* ri[1][1] */ 0.,
    /* ri[1][2] */ .2384,
    /* ri[2][0] */ 0.,
    /* ri[2][1] */ 0.,
    /* ri[2][2] */ .1898,
    /* ri[3][0] */ .0889,
    /* ri[3][1] */ 0.,
    /* ri[3][2] */ -.2868,
    /* ri[4][0] */ 0.,
    /* ri[4][1] */ 0.,
    /* ri[4][2] */ -.202,

/* tree prescribed motion */
    /* pres[0] */ 0.,
    /* pres[1] */ 0.,
    /* pres[2] */ 0.,
    /* pres[3] */ 0.,
    /* pres[4] */ 0.,

/* stabilization parameters */
    /* stabvel */ 0.,
    /* stabpos */ 0.,

/* loop first inboard pin vectors */
    /* inbpin1[0][0] */ 0.,
    /* inbpin1[0][1] */ -1.,
    /* inbpin1[0][2] */ 0.,

/* loop second inboard pin vectors */
    /* inbpin2[0][0] */ 0.,
    /* inbpin2[0][1] */ 0.,
    /* inbpin2[0][2] */ 0.,

/* loop third inboard pin vectors */
    /* inbpin3[0][0] */ 0.,
    /* inbpin3[0][1] */ 0.,
    /* inbpin3[0][2] */ 0.,

/* loop inboard reference vectors */
    /* inbref[0][0] */ 0.,
    /* inbref[0][1] */ 0.,
    /* inbref[0][2] */ 0.,

/* loop body pin vectors */
    /* bodypin[0][0] */ 0.,
    /* bodypin[0][1] */ 0.,
    /* bodypin[0][2] */ 0.,

/* loop body reference vectors */
    /* bodyref[0][0] */ 0.,
    /* bodyref[0][1] */ 0.,
    /* bodyref[0][2] */ 0.,

/* loop bodytojoint vectors */
    /* lbtj[0][0] */ 0.,
    /* lbtj[0][1] */ 0.,
    /* lbtj[0][2] */ -.1426,

/* loop inbtojoint vectors */
    /* litj[0][0] */ 0.,
    /* litj[0][1] */ 0.,
    /* litj[0][2] */ 0.,

/* loop prescribed motion */
    /* lpres[0] */ 0.,

/* miscellaneous */
    /* mfrcflg */ 0,
    /* roustate */ 0,
    /* vpkflg */ 0,
    /* inerflg */ 0,
    /* mmflg */ 0,
    /* mmlduflg */ 0,
    /* wwflg */ 0,
    /* ltauflg */ 0,
    /* fs0flg */ 0,
    /* ii */ 0,
    /* mmap[0] */ 0,
    /* mmap[1] */ 1,
    /* mmap[2] */ 2,
    /* mmap[3] */ 3,
    /* mmap[4] */ 4,

/* Which parameters were "?" (1) or "<nominal>?" (3) */
    /* gravq[0] */ 0,
    /* gravq[1] */ 0,
    /* gravq[2] */ 0,
    /* mkq[0] */ 3,
    /* mkq[1] */ 3,
    /* mkq[2] */ 3,
    /* mkq[3] */ 3,
    /* mkq[4] */ 3,
    /* ikq[0][0][0] */ 0,
    /* ikq[0][0][1] */ 0,
    /* ikq[0][0][2] */ 0,
    /* ikq[0][1][0] */ 0,
    /* ikq[0][1][1] */ 3,
    /* ikq[0][1][2] */ 0,
    /* ikq[0][2][0] */ 0,
    /* ikq[0][2][1] */ 0,
    /* ikq[0][2][2] */ 0,
    /* ikq[1][0][0] */ 0,
    /* ikq[1][0][1] */ 0,
    /* ikq[1][0][2] */ 0,
    /* ikq[1][1][0] */ 0,
    /* ikq[1][1][1] */ 3,
    /* ikq[1][1][2] */ 0,
    /* ikq[1][2][0] */ 0,
    /* ikq[1][2][1] */ 0,
    /* ikq[1][2][2] */ 0,
    /* ikq[2][0][0] */ 0,
    /* ikq[2][0][1] */ 0,
    /* ikq[2][0][2] */ 0,
    /* ikq[2][1][0] */ 0,
    /* ikq[2][1][1] */ 3,
    /* ikq[2][1][2] */ 0,
    /* ikq[2][2][0] */ 0,
    /* ikq[2][2][1] */ 0,
    /* ikq[2][2][2] */ 0,
    /* ikq[3][0][0] */ 0,
    /* ikq[3][0][1] */ 0,
    /* ikq[3][0][2] */ 0,
    /* ikq[3][1][0] */ 0,
    /* ikq[3][1][1] */ 3,
    /* ikq[3][1][2] */ 0,
    /* ikq[3][2][0] */ 0,
    /* ikq[3][2][1] */ 0,
    /* ikq[3][2][2] */ 0,
    /* ikq[4][0][0] */ 0,
    /* ikq[4][0][1] */ 0,
    /* ikq[4][0][2] */ 0,
    /* ikq[4][1][0] */ 0,
    /* ikq[4][1][1] */ 3,
    /* ikq[4][1][2] */ 0,
    /* ikq[4][2][0] */ 0,
    /* ikq[4][2][1] */ 0,
    /* ikq[4][2][2] */ 0,
    /* pinq[0][0] */ 0,
    /* pinq[0][1] */ 0,
    /* pinq[0][2] */ 0,
    /* pinq[1][0] */ 0,
    /* pinq[1][1] */ 0,
    /* pinq[1][2] */ 0,
    /* pinq[2][0] */ 0,
    /* pinq[2][1] */ 0,
    /* pinq[2][2] */ 0,
    /* pinq[3][0] */ 0,
    /* pinq[3][1] */ 0,
    /* pinq[3][2] */ 0,
    /* pinq[4][0] */ 0,
    /* pinq[4][1] */ 0,
    /* pinq[4][2] */ 0,
    /* rkq[0][0] */ 3,
    /* rkq[0][1] */ 0,
    /* rkq[0][2] */ 3,
    /* rkq[1][0] */ 3,
    /* rkq[1][1] */ 0,
    /* rkq[1][2] */ 3,
    /* rkq[2][0] */ 3,
    /* rkq[2][1] */ 0,
    /* rkq[2][2] */ 3,
    /* rkq[3][0] */ 3,
    /* rkq[3][1] */ 0,
    /* rkq[3][2] */ 3,
    /* rkq[4][0] */ 3,
    /* rkq[4][1] */ 0,
    /* rkq[4][2] */ 3,
    /* riq[0][0] */ 0,
    /* riq[0][1] */ 0,
    /* riq[0][2] */ 0,
    /* riq[1][0] */ 3,
    /* riq[1][1] */ 0,
    /* riq[1][2] */ 3,
    /* riq[2][0] */ 3,
    /* riq[2][1] */ 0,
    /* riq[2][2] */ 3,
    /* riq[3][0] */ 3,
    /* riq[3][1] */ 0,
    /* riq[3][2] */ 3,
    /* riq[4][0] */ 3,
    /* riq[4][1] */ 0,
    /* riq[4][2] */ 3,
    /* presq[0] */ 0,
    /* presq[1] */ 0,
    /* presq[2] */ 0,
    /* presq[3] */ 0,
    /* presq[4] */ 0,
    /* stabvelq */ 3,
    /* stabposq */ 3,
    /* inbpin1q[0][0] */ 0,
    /* inbpin1q[0][1] */ 0,
    /* inbpin1q[0][2] */ 0,
    /* inbpin2q[0][0] */ 0,
    /* inbpin2q[0][1] */ 0,
    /* inbpin2q[0][2] */ 0,
    /* inbpin3q[0][0] */ 0,
    /* inbpin3q[0][1] */ 0,
    /* inbpin3q[0][2] */ 0,
    /* inbrefq[0][0] */ 0,
    /* inbrefq[0][1] */ 0,
    /* inbrefq[0][2] */ 0,
    /* bodypinq[0][0] */ 0,
    /* bodypinq[0][1] */ 0,
    /* bodypinq[0][2] */ 0,
    /* bodyrefq[0][0] */ 0,
    /* bodyrefq[0][1] */ 0,
    /* bodyrefq[0][2] */ 0,
    /* lbtjq[0][0] */ 0,
    /* lbtjq[0][1] */ 0,
    /* lbtjq[0][2] */ 0,
    /* litjq[0][0] */ 1,
    /* litjq[0][1] */ 0,
    /* litjq[0][2] */ 0,
    /* lpresq[0] */ 0,

/* End of values from input file */

};
srdsgstate_t srdsgstate;
srdsglhs_t srdsglhs;
srdsgrhs_t srdsgrhs;
srdsgtemp_t srdsgtemp;


void srdsinit(void)
{
/*
Initialization routine


 This routine must be called before the first call to sdstate(), after
 supplying values for any `?' parameters in the input.
*/
    double sumsq,norminv;
    int i,j,k;


/* Check that all `?' parameters have been assigned values */

    for (k = 0; k < 3; k++) {
        if (gravq[k] == 1) {
            srdsseterr(7,25);
        }
    }
    for (k = 0; k < 5; k++) {
        if (mkq[k] == 1) {
            srdsseterr(7,26);
        }
        for (i = 0; i < 3; i++) {
            if (rkq[k][i] == 1) {
                srdsseterr(7,29);
            }
            if (riq[k][i] == 1) {
                srdsseterr(7,30);
            }
            for (j = 0; j < 3; j++) {
                if (ikq[k][i][j] == 1) {
                    srdsseterr(7,27);
                }
            }
        }
    }
    for (k = 0; k < 5; k++) {
        for (i = 0; i < 3; i++) {
            if (pinq[k][i] == 1) {
                srdsseterr(7,28);
            }
        }
    }
    for (k = 0; k < 1; k++) {
        for (i = 0; i < 3; i++) {
            if (inbpin1q[k][i] == 1) {
                srdsseterr(7,34);
            }
            if (inbpin2q[k][i] == 1) {
                srdsseterr(7,34);
            }
            if (inbpin3q[k][i] == 1) {
                srdsseterr(7,34);
            }
            if (inbrefq[k][i] == 1) {
                srdsseterr(7,35);
            }
            if (bodypinq[k][i] == 1) {
                srdsseterr(7,36);
            }
            if (bodyrefq[k][i] == 1) {
                srdsseterr(7,37);
            }
            if (lbtjq[k][i] == 1) {
                srdsseterr(7,38);
            }
            if (litjq[k][i] == 1) {
                srdsseterr(7,39);
            }
        }
    }

/* Normalize pin vectors if necessary */


/* Zero out Vpk and Wpk */

    for (i = 0; i < 5; i++) {
        for (j = i; j <= 4; j++) {
            for (k = 0; k < 3; k++) {
                Vpk[i][j][k] = 0.;
                Wpk[i][j][k] = 0.;
            }
        }
    }

/* Compute pseudobody-related constants */

    rcom[0][0] = 0.;
    rcom[0][1] = 0.;
    rcom[0][2] = 0.;
    rcom[1][0] = 0.;
    rcom[1][1] = 0.;
    rcom[1][2] = 0.;
    rcom[2][0] = 0.;
    rcom[2][1] = 0.;
    rcom[2][2] = 0.;
    rcom[3][0] = 0.;
    rcom[3][1] = 0.;
    rcom[3][2] = 0.;
    rcom[4][0] = 0.;
    rcom[4][1] = 0.;
    rcom[4][2] = 0.;
    dik[1][0] = (ri[1][0]-rk[0][0]);
    dik[1][2] = (ri[1][2]-rk[0][2]);
    dik[2][0] = (ri[2][0]-rk[1][0]);
    dik[2][2] = (ri[2][2]-rk[1][2]);
    dik[3][0] = (ri[3][0]-rk[2][0]);
    dik[3][2] = (ri[3][2]-rk[2][2]);
    dik[4][0] = (ri[4][0]-rk[3][0]);
    dik[4][2] = (ri[4][2]-rk[3][2]);

/* Compute mass properties-related constants */

    mtot = (mk[4]+(mk[3]+(mk[2]+(mk[0]+mk[1]))));
    mkrk[0][0][1] = -(mk[0]*rk[0][2]);
    mkrk[0][1][0] = (mk[0]*rk[0][2]);
    mkrk[0][1][2] = -(mk[0]*rk[0][0]);
    mkrk[0][2][1] = (mk[0]*rk[0][0]);
    mkrk[1][0][1] = -(mk[1]*rk[1][2]);
    mkrk[1][1][0] = (mk[1]*rk[1][2]);
    mkrk[1][1][2] = -(mk[1]*rk[1][0]);
    mkrk[1][2][1] = (mk[1]*rk[1][0]);
    mkrk[2][0][1] = -(mk[2]*rk[2][2]);
    mkrk[2][1][0] = (mk[2]*rk[2][2]);
    mkrk[2][1][2] = -(mk[2]*rk[2][0]);
    mkrk[2][2][1] = (mk[2]*rk[2][0]);
    mkrk[3][0][1] = -(mk[3]*rk[3][2]);
    mkrk[3][1][0] = (mk[3]*rk[3][2]);
    mkrk[3][1][2] = -(mk[3]*rk[3][0]);
    mkrk[3][2][1] = (mk[3]*rk[3][0]);
    mkrk[4][0][1] = -(mk[4]*rk[4][2]);
    mkrk[4][1][0] = (mk[4]*rk[4][2]);
    mkrk[4][1][2] = -(mk[4]*rk[4][0]);
    mkrk[4][2][1] = (mk[4]*rk[4][0]);
    Iko[0][0][0] = (1.-(mkrk[0][0][1]*rk[0][2]));
    Iko[0][0][2] = (mkrk[0][0][1]*rk[0][0]);
    Iko[0][1][1] = (ik[0][1][1]-((mkrk[0][1][2]*rk[0][0])-(mkrk[0][1][0]*
      rk[0][2])));
    Iko[0][2][0] = -(mkrk[0][2][1]*rk[0][2]);
    Iko[0][2][2] = (1.+(mkrk[0][2][1]*rk[0][0]));
    Iko[1][0][0] = (1.-(mkrk[1][0][1]*rk[1][2]));
    Iko[1][0][2] = (mkrk[1][0][1]*rk[1][0]);
    Iko[1][1][1] = (ik[1][1][1]-((mkrk[1][1][2]*rk[1][0])-(mkrk[1][1][0]*
      rk[1][2])));
    Iko[1][2][0] = -(mkrk[1][2][1]*rk[1][2]);
    Iko[1][2][2] = (1.+(mkrk[1][2][1]*rk[1][0]));
    Iko[2][0][0] = (1.-(mkrk[2][0][1]*rk[2][2]));
    Iko[2][0][2] = (mkrk[2][0][1]*rk[2][0]);
    Iko[2][1][1] = (ik[2][1][1]-((mkrk[2][1][2]*rk[2][0])-(mkrk[2][1][0]*
      rk[2][2])));
    Iko[2][2][0] = -(mkrk[2][2][1]*rk[2][2]);
    Iko[2][2][2] = (1.+(mkrk[2][2][1]*rk[2][0]));
    Iko[3][0][0] = (1.-(mkrk[3][0][1]*rk[3][2]));
    Iko[3][0][2] = (mkrk[3][0][1]*rk[3][0]);
    Iko[3][1][1] = (ik[3][1][1]-((mkrk[3][1][2]*rk[3][0])-(mkrk[3][1][0]*
      rk[3][2])));
    Iko[3][2][0] = -(mkrk[3][2][1]*rk[3][2]);
    Iko[3][2][2] = (1.+(mkrk[3][2][1]*rk[3][0]));
    Iko[4][0][0] = (1.-(mkrk[4][0][1]*rk[4][2]));
    Iko[4][0][2] = (mkrk[4][0][1]*rk[4][0]);
    Iko[4][1][1] = (ik[4][1][1]-((mkrk[4][1][2]*rk[4][0])-(mkrk[4][1][0]*
      rk[4][2])));
    Iko[4][2][0] = -(mkrk[4][2][1]*rk[4][2]);
    Iko[4][2][2] = (1.+(mkrk[4][2][1]*rk[4][0]));
    srdsserialno(&i);
    if (i != 30123) {
        srdsseterr(7,41);
    }
    roustate = 1;
}

/* Convert state to form using 1-2-3 Euler angles for ball joints. */

void srdsst2ang(double st[5],
    double stang[5])
{
    int i;

    for (i = 0; i < 5; i++) {
        stang[i] = st[i];
    }
}

/* Convert 1-2-3 form of state back to Euler parameters for ball joints. */

void srdsang2st(double stang[5],
    double st[5])
{
    int i;

    for (i = 0; i < 5; i++) {
        st[i] = stang[i];
    }
}

/* Normalize Euler parameters in state. */

void srdsnrmsterr(double st[5],
    double normst[5],
    int routine)
{
    int i;

    for (i = 0; i < 5; i++) {
        normst[i] = st[i];
    }
}

void srdsnormst(double st[5],
    double normst[5])
{

    srdsnrmsterr(st,normst,0);
}

void srdsstate(double timein,
    double qin[5],
    double uin[5])
{
/*
Compute kinematic information and store it in sdgstate.

Generated 24-Jun-2008 21:10:41 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    int i,j,qchg,uchg;
    double e1,e2,e3,e4;

    if ((roustate != 1) && (roustate != 2) && (roustate != 3)) {
        srdsseterr(8,22);
        return;
    }
    if (roustate == 1) {
        for (i = 0; i < 5; i++) {
            if (presq[i] == 1) {
                srdsseterr(8,31);
            }
        }
        for (i = 0; i < 1; i++) {
            if (lpresq[i] == 1) {
                srdsseterr(8,40);
            }
        }
    }
/*
See if time or any qs have changed since last call
*/
    if ((roustate != 1) && (timein == curtim)) {
        qchg = 0;
        for (i = 0; i < 5; i++) {
            if (qin[i] != q[i]) {
                qchg = 1;
                break;
            }
        }
    } else {
        qchg = 1;
    }
/*
If time and qs are unchanged, check us
*/
    if (qchg == 0) {
        uchg = 0;
        for (i = 0; i < 5; i++) {
            if (uin[i] != u[i]) {
                uchg = 1;
                break;
            }
        }
    } else {
        uchg = 1;
    }
    curtim = timein;
    roustate = 2;
    if (qchg == 0) {
        goto skipqs;
    }
/*
Position-related variables need to be computed
*/
    vpkflg = 0;
    mmflg = 0;
    mmlduflg = 0;
    wwflg = 0;
    for (i = 0; i < 5; i++) {
        q[i] = qin[i];
    }
/*
Compute sines and cosines of q
*/
    s0 = sin(q[0]);
    c0 = cos(q[0]);
    s2 = sin(q[2]);
    c2 = cos(q[2]);
    s3 = sin(q[3]);
    c3 = cos(q[3]);
/*
Compute across-axis direction cosines Cik
*/
/*
Compute across-joint direction cosines Cib
*/
/*
Compute gravity
*/
    gk[2][0] = -(9.81*((s0*c2)+(s2*c0)));
    gk[2][2] = (9.81*((s0*s2)-(c0*c2)));
    gk[3][0] = ((gk[2][0]*c3)+(gk[2][2]*s3));
    gk[3][2] = ((gk[2][2]*c3)-(gk[2][0]*s3));
/*
Compute cnk & cnb (direction cosines in N)
*/
    cnk[2][0][0] = ((c0*c2)-(s0*s2));
    cnk[2][0][2] = -((s0*c2)+(s2*c0));
    cnk[2][2][0] = ((s0*c2)+(s2*c0));
    cnk[2][2][2] = ((c0*c2)-(s0*s2));
    cnk[3][0][0] = ((cnk[2][0][0]*c3)+(cnk[2][0][2]*s3));
    cnk[3][0][2] = ((cnk[2][0][2]*c3)-(cnk[2][0][0]*s3));
    cnk[3][2][0] = ((cnk[2][2][0]*c3)+(cnk[2][2][2]*s3));
    cnk[3][2][2] = ((cnk[2][2][2]*c3)-(cnk[2][2][0]*s3));
    cnb[0][0][0] = c0;
    cnb[0][0][1] = 0.;
    cnb[0][0][2] = -s0;
    cnb[0][1][0] = 0.;
    cnb[0][1][1] = 1.;
    cnb[0][1][2] = 0.;
    cnb[0][2][0] = s0;
    cnb[0][2][1] = 0.;
    cnb[0][2][2] = c0;
    cnb[1][0][0] = c0;
    cnb[1][0][1] = 0.;
    cnb[1][0][2] = -s0;
    cnb[1][1][0] = 0.;
    cnb[1][1][1] = 1.;
    cnb[1][1][2] = 0.;
    cnb[1][2][0] = s0;
    cnb[1][2][1] = 0.;
    cnb[1][2][2] = c0;
    cnb[2][0][0] = cnk[2][0][0];
    cnb[2][0][1] = 0.;
    cnb[2][0][2] = cnk[2][0][2];
    cnb[2][1][0] = 0.;
    cnb[2][1][1] = 1.;
    cnb[2][1][2] = 0.;
    cnb[2][2][0] = cnk[2][2][0];
    cnb[2][2][1] = 0.;
    cnb[2][2][2] = cnk[2][2][2];
    cnb[3][0][0] = cnk[3][0][0];
    cnb[3][0][1] = 0.;
    cnb[3][0][2] = cnk[3][0][2];
    cnb[3][1][0] = 0.;
    cnb[3][1][1] = 1.;
    cnb[3][1][2] = 0.;
    cnb[3][2][0] = cnk[3][2][0];
    cnb[3][2][1] = 0.;
    cnb[3][2][2] = cnk[3][2][2];
    cnb[4][0][0] = cnk[3][0][0];
    cnb[4][0][1] = 0.;
    cnb[4][0][2] = cnk[3][0][2];
    cnb[4][1][0] = 0.;
    cnb[4][1][1] = 1.;
    cnb[4][1][2] = 0.;
    cnb[4][2][0] = cnk[3][2][0];
    cnb[4][2][1] = 0.;
    cnb[4][2][2] = cnk[3][2][2];
/*
Compute Cio (dircos btw loop jt connected bodies)
*/
/*
Compute q-related auxiliary variables
*/
    rpri[1][2] = (q[1]+ri[1][2]);
    rpri[4][2] = (ri[4][2]-q[4]);
    rpk[1][2] = (q[1]-rk[1][2]);
    rpk[4][2] = -(q[4]+rk[4][2]);
    rik[1][0] = (ri[1][0]-rk[1][0]);
    rik[1][2] = (ri[1][2]+rpk[1][2]);
    rik[2][0] = (((ri[2][0]*c2)+(ri[2][2]*s2))-rk[2][0]);
    rik[2][2] = (((ri[2][2]*c2)-(ri[2][0]*s2))-rk[2][2]);
    rik[3][0] = (((ri[3][0]*c3)+(ri[3][2]*s3))-rk[3][0]);
    rik[3][2] = (((ri[3][2]*c3)-(ri[3][0]*s3))-rk[3][2]);
    rik[4][0] = (ri[4][0]-rk[4][0]);
    rik[4][2] = (ri[4][2]+rpk[4][2]);
/*
Compute rnk & rnb (mass center locations in N)
*/
    rnk[0][0] = ((rk[0][2]*s0)-(rk[0][0]*c0));
    rnk[0][2] = -((rk[0][0]*s0)+(rk[0][2]*c0));
    rnk[1][0] = ((rnk[0][0]+((ri[1][0]*c0)-(ri[1][2]*s0)))-((rk[1][0]*c0)+(
      rpk[1][2]*s0)));
    rnk[1][2] = ((rnk[0][2]+((ri[1][0]*s0)+(ri[1][2]*c0)))+((rpk[1][2]*c0)-(
      rk[1][0]*s0)));
    rnk[2][0] = ((rnk[1][0]+((ri[2][0]*c0)-(ri[2][2]*s0)))-((cnk[2][0][0]*
      rk[2][0])+(cnk[2][0][2]*rk[2][2])));
    rnk[2][2] = ((rnk[1][2]+((ri[2][0]*s0)+(ri[2][2]*c0)))-((cnk[2][2][0]*
      rk[2][0])+(cnk[2][2][2]*rk[2][2])));
    rnk[3][0] = ((rnk[2][0]+((cnk[2][0][0]*ri[3][0])+(cnk[2][0][2]*ri[3][2])))-(
      (cnk[3][0][0]*rk[3][0])+(cnk[3][0][2]*rk[3][2])));
    rnk[3][2] = ((rnk[2][2]+((cnk[2][2][0]*ri[3][0])+(cnk[2][2][2]*ri[3][2])))-(
      (cnk[3][2][0]*rk[3][0])+(cnk[3][2][2]*rk[3][2])));
    rnk[4][0] = ((rnk[3][0]+((cnk[3][0][0]*ri[4][0])+(cnk[3][0][2]*ri[4][2])))+(
      (cnk[3][0][2]*rpk[4][2])-(cnk[3][0][0]*rk[4][0])));
    rnk[4][2] = ((rnk[3][2]+((cnk[3][2][0]*ri[4][0])+(cnk[3][2][2]*ri[4][2])))+(
      (cnk[3][2][2]*rpk[4][2])-(cnk[3][2][0]*rk[4][0])));
    rnb[0][0] = rnk[0][0];
    rnb[0][1] = 0.;
    rnb[0][2] = rnk[0][2];
    rnb[1][0] = rnk[1][0];
    rnb[1][1] = 0.;
    rnb[1][2] = rnk[1][2];
    rnb[2][0] = rnk[2][0];
    rnb[2][1] = 0.;
    rnb[2][2] = rnk[2][2];
    rnb[3][0] = rnk[3][0];
    rnb[3][1] = 0.;
    rnb[3][2] = rnk[3][2];
    rnb[4][0] = rnk[4][0];
    rnb[4][1] = 0.;
    rnb[4][2] = rnk[4][2];
/*
Compute com (system mass center location in N)
*/
    com[0] = ((1./mtot)*((mk[4]*rnk[4][0])+((mk[3]*rnk[3][0])+((mk[2]*rnk[2][0])
      +((mk[0]*rnk[0][0])+(mk[1]*rnk[1][0]))))));
    com[1] = 0.;
    com[2] = ((1./mtot)*((mk[4]*rnk[4][2])+((mk[3]*rnk[3][2])+((mk[2]*rnk[2][2])
      +((mk[0]*rnk[0][2])+(mk[1]*rnk[1][2]))))));
/*
Compute loop joint q-related temps
*/
    vt10c[0][0] = (rnk[4][0]-(.1426*cnk[3][0][2]));
    vt10c[0][2] = (rnk[4][2]-(.1426*cnk[3][2][2]));
    vt11[0][0] = (litj[0][0]-vt10c[0][0]);
/*
Compute dircos inside loop joints
*/
/*
Decompose loop joint dircos into Euler angles or parameters
*/
    e1 = atan2(-cnk[3][0][2],cnk[3][2][2]);
    eul1[0] = e1;
    ceul1[0] = cos(eul1[0]);
    seul1[0] = sin(eul1[0]);
/*
Compute constraint position errors
*/
    skipqs: ;
    if (uchg == 0) {
        goto skipus;
    }
/*
Velocity-related variables need to be computed
*/
    inerflg = 0;
    for (i = 0; i < 5; i++) {
        u[i] = uin[i];
    }
/*
Compute u-related auxiliary variables
*/
/*
Compute wk & wb (angular velocities)
*/
    wk[2][1] = -(u[0]+u[2]);
    wk[3][1] = (wk[2][1]-u[3]);
    wb[0][0] = 0.;
    wb[0][1] = -u[0];
    wb[0][2] = 0.;
    wb[1][0] = 0.;
    wb[1][1] = -u[0];
    wb[1][2] = 0.;
    wb[2][0] = 0.;
    wb[2][1] = wk[2][1];
    wb[2][2] = 0.;
    wb[3][0] = 0.;
    wb[3][1] = wk[3][1];
    wb[3][2] = 0.;
    wb[4][0] = 0.;
    wb[4][1] = wk[3][1];
    wb[4][2] = 0.;
/*
Compute auxiliary variables involving wk
*/
    Wirk[1][0] = -(ri[1][2]*u[0]);
    Wirk[1][2] = (ri[1][0]*u[0]);
    Wirk[2][0] = -(ri[2][2]*u[0]);
    Wirk[2][2] = (ri[2][0]*u[0]);
    Wirk[3][0] = (ri[3][2]*wk[2][1]);
    Wirk[3][2] = -(ri[3][0]*wk[2][1]);
    Wirk[4][0] = (ri[4][2]*wk[3][1]);
    Wirk[4][2] = -(ri[4][0]*wk[3][1]);
    Wkrpk[0][0] = (rk[0][2]*u[0]);
    Wkrpk[0][2] = -(rk[0][0]*u[0]);
    Wkrpk[1][0] = -(rpk[1][2]*u[0]);
    Wkrpk[1][2] = -(rk[1][0]*u[0]);
    Wkrpk[2][0] = -(rk[2][2]*wk[2][1]);
    Wkrpk[2][2] = (rk[2][0]*wk[2][1]);
    Wkrpk[3][0] = -(rk[3][2]*wk[3][1]);
    Wkrpk[3][2] = (rk[3][0]*wk[3][1]);
    Wkrpk[4][0] = (rpk[4][2]*wk[3][1]);
    Wkrpk[4][2] = (rk[4][0]*wk[3][1]);
    VikWkr[1][2] = (u[1]+Wkrpk[1][2]);
    VikWkr[4][2] = (Wkrpk[4][2]-u[4]);
    IkWk[0][1] = -(ik[0][1][1]*u[0]);
    IkWk[1][1] = -(ik[1][1][1]*u[0]);
    IkWk[2][1] = (ik[2][1][1]*wk[2][1]);
    IkWk[3][1] = (ik[3][1][1]*wk[3][1]);
    IkWk[4][1] = (ik[4][1][1]*wk[3][1]);
/*
Compute temporaries for use in SDRHS
*/
    w1w1[0] = (u[0]*u[0]);
    w1w1[1] = (u[0]*u[0]);
    w1w1[2] = (wk[2][1]*wk[2][1]);
    w1w1[3] = (wk[3][1]*wk[3][1]);
    w1w1[4] = (wk[3][1]*wk[3][1]);
/*
Compute vnk & vnb (mass center linear velocities in N)
*/
    vnk[0][0] = ((Wkrpk[0][0]*c0)-(Wkrpk[0][2]*s0));
    vnk[0][2] = ((Wkrpk[0][0]*s0)+(Wkrpk[0][2]*c0));
    vnk[1][0] = ((vnk[0][0]+((Wirk[1][0]*c0)-(Wirk[1][2]*s0)))+((Wkrpk[1][0]*c0)
      -(VikWkr[1][2]*s0)));
    vnk[1][2] = ((vnk[0][2]+((Wirk[1][0]*s0)+(Wirk[1][2]*c0)))+((VikWkr[1][2]*c0
      )+(Wkrpk[1][0]*s0)));
    vnk[2][0] = ((vnk[1][0]+((Wirk[2][0]*c0)-(Wirk[2][2]*s0)))+((cnk[2][0][0]*
      Wkrpk[2][0])+(cnk[2][0][2]*Wkrpk[2][2])));
    vnk[2][2] = ((vnk[1][2]+((Wirk[2][0]*s0)+(Wirk[2][2]*c0)))+((cnk[2][2][0]*
      Wkrpk[2][0])+(cnk[2][2][2]*Wkrpk[2][2])));
    vnk[3][0] = ((vnk[2][0]+((cnk[2][0][0]*Wirk[3][0])+(cnk[2][0][2]*Wirk[3][2])
      ))+((cnk[3][0][0]*Wkrpk[3][0])+(cnk[3][0][2]*Wkrpk[3][2])));
    vnk[3][2] = ((vnk[2][2]+((cnk[2][2][0]*Wirk[3][0])+(cnk[2][2][2]*Wirk[3][2])
      ))+((cnk[3][2][0]*Wkrpk[3][0])+(cnk[3][2][2]*Wkrpk[3][2])));
    vnk[4][0] = ((vnk[3][0]+((cnk[3][0][0]*Wirk[4][0])+(cnk[3][0][2]*Wirk[4][2])
      ))+((cnk[3][0][0]*Wkrpk[4][0])+(cnk[3][0][2]*VikWkr[4][2])));
    vnk[4][2] = ((vnk[3][2]+((cnk[3][2][0]*Wirk[4][0])+(cnk[3][2][2]*Wirk[4][2])
      ))+((cnk[3][2][0]*Wkrpk[4][0])+(cnk[3][2][2]*VikWkr[4][2])));
    vnb[0][0] = vnk[0][0];
    vnb[0][1] = 0.;
    vnb[0][2] = vnk[0][2];
    vnb[1][0] = vnk[1][0];
    vnb[1][1] = 0.;
    vnb[1][2] = vnk[1][2];
    vnb[2][0] = vnk[2][0];
    vnb[2][1] = 0.;
    vnb[2][2] = vnk[2][2];
    vnb[3][0] = vnk[3][0];
    vnb[3][1] = 0.;
    vnb[3][2] = vnk[3][2];
    vnb[4][0] = vnk[4][0];
    vnb[4][1] = 0.;
    vnb[4][2] = vnk[4][2];
/*
Compute loop joint u-related temps
*/
    vt12[0][0] = ((.1426*(cnk[3][0][0]*wk[3][1]))-vnk[4][0]);
    vt12[0][2] = ((.1426*(cnk[3][2][0]*wk[3][1]))-vnk[4][2]);
/*
Compute angvel inside loop joints
*/
/*
Compute derivatives of loop joint pseudo-coordinates
*/
/*
Compute qdot (kinematical equations)
*/
    qdot[0] = u[0];
    qdot[1] = u[1];
    qdot[2] = u[2];
    qdot[3] = u[3];
    qdot[4] = u[4];
/*
Compute constraint velocity errors
*/
    skipus: ;
/*
Initialize applied forces and torques to zero
*/
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 3; j++) {
            ufk[i][j] = 0.;
            utk[i][j] = 0.;
        }
    }
    for (i = 0; i < 5; i++) {
        utau[i] = 0.;
    }
    for (i = 0; i < 1; i++) {
        ltau[i] = 0.;
    }
    ltauflg = 0;
    fs0flg = 0;
/*
Set lqs -- srdspsstate may override some
*/
    lq[0] = eul1[0];
/*
 Used 0.15 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  134 adds/subtracts/negates
                    152 multiplies
                      2 divides
                    230 assignments
*/
}

void srdsqdot(double oqdot[5])
{
/*
Return position coordinate derivatives for tree joints.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(63,23);
        return;
    }
    for (i = 0; i <= 4; i++) {
        oqdot[i] = qdot[i];
    }
}

void srdsu2qdot(double uin[5],
    double oqdot[5])
{
/*
Convert velocities to qdots.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(64,23);
        return;
    }
    for (i = 0; i <= 4; i++) {
        oqdot[i] = uin[i];
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srdspsstate(double lqin[1])
{

    if (roustate != 2) {
        srdsseterr(9,23);
        return;
    }
}

void srdsdovpk(void)
{

    if (vpkflg == 0) {
/*
Compute Wpk (partial angular velocities)
*/
        Wpk[0][0][1] = -1.;
        Wpk[0][1][1] = -1.;
        Wpk[0][2][1] = -1.;
        Wpk[0][3][1] = -1.;
        Wpk[0][4][1] = -1.;
        Wpk[2][2][1] = -1.;
        Wpk[2][3][1] = -1.;
        Wpk[2][4][1] = -1.;
        Wpk[3][3][1] = -1.;
        Wpk[3][4][1] = -1.;
/*
Compute Vpk (partial velocities)
*/
        Vpk[0][0][0] = rk[0][2];
        Vpk[0][0][2] = -rk[0][0];
        VWri[0][1][0] = (rk[0][2]-ri[1][2]);
        VWri[0][1][2] = (ri[1][0]-rk[0][0]);
        Vpk[0][1][0] = (VWri[0][1][0]-rpk[1][2]);
        Vpk[0][1][2] = (VWri[0][1][2]-rk[1][0]);
        VWri[0][2][0] = (Vpk[0][1][0]-ri[2][2]);
        VWri[0][2][2] = (ri[2][0]+Vpk[0][1][2]);
        Vpk[0][2][0] = (rk[2][2]+((VWri[0][2][0]*c2)+(VWri[0][2][2]*s2)));
        Vpk[0][2][2] = (((VWri[0][2][2]*c2)-(VWri[0][2][0]*s2))-rk[2][0]);
        VWri[0][3][0] = (Vpk[0][2][0]-ri[3][2]);
        VWri[0][3][2] = (ri[3][0]+Vpk[0][2][2]);
        Vpk[0][3][0] = (rk[3][2]+((VWri[0][3][0]*c3)+(VWri[0][3][2]*s3)));
        Vpk[0][3][2] = (((VWri[0][3][2]*c3)-(VWri[0][3][0]*s3))-rk[3][0]);
        VWri[0][4][0] = (Vpk[0][3][0]-ri[4][2]);
        VWri[0][4][2] = (ri[4][0]+Vpk[0][3][2]);
        Vpk[0][4][0] = (VWri[0][4][0]-rpk[4][2]);
        Vpk[0][4][2] = (VWri[0][4][2]-rk[4][0]);
        Vpk[1][1][2] = 1.;
        Vpk[1][2][0] = s2;
        Vpk[1][2][2] = c2;
        Vpk[1][3][0] = ((s2*c3)+(s3*c2));
        Vpk[1][3][2] = ((c2*c3)-(s2*s3));
        Vpk[1][4][0] = Vpk[1][3][0];
        Vpk[1][4][2] = Vpk[1][3][2];
        Vpk[2][2][0] = rk[2][2];
        Vpk[2][2][2] = -rk[2][0];
        VWri[2][3][0] = (rk[2][2]-ri[3][2]);
        VWri[2][3][2] = (ri[3][0]-rk[2][0]);
        Vpk[2][3][0] = (rk[3][2]+((VWri[2][3][0]*c3)+(VWri[2][3][2]*s3)));
        Vpk[2][3][2] = (((VWri[2][3][2]*c3)-(VWri[2][3][0]*s3))-rk[3][0]);
        VWri[2][4][0] = (Vpk[2][3][0]-ri[4][2]);
        VWri[2][4][2] = (ri[4][0]+Vpk[2][3][2]);
        Vpk[2][4][0] = (VWri[2][4][0]-rpk[4][2]);
        Vpk[2][4][2] = (VWri[2][4][2]-rk[4][0]);
        Vpk[3][3][0] = rk[3][2];
        Vpk[3][3][2] = -rk[3][0];
        VWri[3][4][0] = (rk[3][2]-ri[4][2]);
        VWri[3][4][2] = (ri[4][0]-rk[3][0]);
        Vpk[3][4][0] = (VWri[3][4][0]-rpk[4][2]);
        Vpk[3][4][2] = (VWri[3][4][2]-rk[4][0]);
        Vpk[4][4][2] = -1.;
        vpkflg = 1;
    }
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   39 adds/subtracts/negates
                     16 multiplies
                      0 divides
                     52 assignments
*/
}

void srdsdoltau(void)
{

/*
Compute effect of loop hinge torques
*/
    if (ltauflg == 0) {
/*
Compute forces due to loop taus
*/
        ltauflg = 1;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      0 assignments
*/
}

void srdsdoiner(void)
{

/*
Compute inertial accelerations and related temps
*/
    if (inerflg == 0) {
/*
Compute Otk (inertial angular acceleration)
*/
/*
Compute Atk (inertial linear acceleration)
*/
        Atk[0][0] = -(u[0]*Wkrpk[0][2]);
        Atk[0][2] = (u[0]*Wkrpk[0][0]);
        AiOiWi[1][0] = (Atk[0][0]-(u[0]*Wirk[1][2]));
        AiOiWi[1][2] = (Atk[0][2]+(u[0]*Wirk[1][0]));
        Atk[1][0] = (AiOiWi[1][0]-((2.*(u[0]*u[1]))+(u[0]*Wkrpk[1][2])));
        Atk[1][2] = (AiOiWi[1][2]+(u[0]*Wkrpk[1][0]));
        AiOiWi[2][0] = (Atk[1][0]-(u[0]*Wirk[2][2]));
        AiOiWi[2][2] = (Atk[1][2]+(u[0]*Wirk[2][0]));
        Atk[2][0] = ((wk[2][1]*Wkrpk[2][2])+((AiOiWi[2][0]*c2)+(AiOiWi[2][2]*s2)
          ));
        Atk[2][2] = (((AiOiWi[2][2]*c2)-(AiOiWi[2][0]*s2))-(wk[2][1]*Wkrpk[2][0]
          ));
        AiOiWi[3][0] = (Atk[2][0]+(Wirk[3][2]*wk[2][1]));
        AiOiWi[3][2] = (Atk[2][2]-(Wirk[3][0]*wk[2][1]));
        Atk[3][0] = ((wk[3][1]*Wkrpk[3][2])+((AiOiWi[3][0]*c3)+(AiOiWi[3][2]*s3)
          ));
        Atk[3][2] = (((AiOiWi[3][2]*c3)-(AiOiWi[3][0]*s3))-(wk[3][1]*Wkrpk[3][0]
          ));
        AiOiWi[4][0] = (Atk[3][0]+(Wirk[4][2]*wk[3][1]));
        AiOiWi[4][2] = (Atk[3][2]-(Wirk[4][0]*wk[3][1]));
        Atk[4][0] = (AiOiWi[4][0]+((wk[3][1]*Wkrpk[4][2])-(2.*(u[4]*wk[3][1]))))
          ;
        Atk[4][2] = (AiOiWi[4][2]-(wk[3][1]*Wkrpk[4][0]));
        inerflg = 1;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   23 adds/subtracts/negates
                     30 multiplies
                      0 divides
                     18 assignments
*/
}

void srdsdofs0(void)
{

/*
Compute effect of all applied loads
*/
    if (fs0flg == 0) {
        srdsdoltau();
        srdsdoiner();
/*
Compute Fstar (forces)
*/
        Fstar[0][0] = ((mk[0]*(Atk[0][0]+(9.81*s0)))-ufk[0][0]);
        Fstar[0][2] = ((mk[0]*(Atk[0][2]+(9.81*c0)))-ufk[0][2]);
        Fstar[1][0] = ((mk[1]*(Atk[1][0]+(9.81*s0)))-ufk[1][0]);
        Fstar[1][2] = ((mk[1]*(Atk[1][2]+(9.81*c0)))-ufk[1][2]);
        Fstar[2][0] = ((mk[2]*(Atk[2][0]-gk[2][0]))-ufk[2][0]);
        Fstar[2][2] = ((mk[2]*(Atk[2][2]-gk[2][2]))-ufk[2][2]);
        Fstar[3][0] = ((mk[3]*(Atk[3][0]-gk[3][0]))-ufk[3][0]);
        Fstar[3][2] = ((mk[3]*(Atk[3][2]-gk[3][2]))-ufk[3][2]);
        Fstar[4][0] = ((mk[4]*(Atk[4][0]-gk[3][0]))-ufk[4][0]);
        Fstar[4][2] = ((mk[4]*(Atk[4][2]-gk[3][2]))-ufk[4][2]);
/*
Compute Tstar (torques)
*/
        Tstar[4][1] = -(utk[4][1]-ltau[0]);
/*
Compute fs0 (RHS ignoring constraints)
*/
        srdsdovpk();
        fs0[0] = (utau[0]-(((utk[3][1]+((Fstar[3][0]*Vpk[0][3][0])+(Fstar[3][2]*
          Vpk[0][3][2])))+((utk[2][1]+((Fstar[2][0]*Vpk[0][2][0])+(Fstar[2][2]*
          Vpk[0][2][2])))+((utk[0][1]+((Fstar[0][0]*rk[0][2])-(Fstar[0][2]*
          rk[0][0])))+(utk[1][1]+((Fstar[1][0]*Vpk[0][1][0])+(Fstar[1][2]*
          Vpk[0][1][2]))))))+(((Fstar[4][0]*Vpk[0][4][0])+(Fstar[4][2]*
          Vpk[0][4][2]))-Tstar[4][1])));
        fs0[1] = (utau[1]-(((Fstar[1][2]+((Fstar[2][0]*s2)+(Fstar[2][2]*c2)))+((
          Fstar[3][0]*Vpk[1][3][0])+(Fstar[3][2]*Vpk[1][3][2])))+((Fstar[4][0]*
          Vpk[1][3][0])+(Fstar[4][2]*Vpk[1][3][2]))));
        fs0[2] = (utau[2]-(((utk[2][1]+((Fstar[2][0]*rk[2][2])-(Fstar[2][2]*
          rk[2][0])))+(utk[3][1]+((Fstar[3][0]*Vpk[2][3][0])+(Fstar[3][2]*
          Vpk[2][3][2]))))+(((Fstar[4][0]*Vpk[2][4][0])+(Fstar[4][2]*
          Vpk[2][4][2]))-Tstar[4][1])));
        fs0[3] = (utau[3]-((utk[3][1]+((Fstar[3][0]*rk[3][2])-(Fstar[3][2]*
          rk[3][0])))+(((Fstar[4][0]*Vpk[3][4][0])+(Fstar[4][2]*Vpk[3][4][2]))-
          Tstar[4][1])));
        fs0[4] = (Fstar[4][2]+utau[4]);
        fs0flg = 1;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   60 adds/subtracts/negates
                     40 multiplies
                      0 divides
                     16 assignments
*/
}

void srdsdomm(int routine)
{
    int dumroutine,errnum;
    int i;

    if (mmflg == 0) {
/*
Compute mass matrix (MM)
*/
        srdsdovpk();
        temp[0] = ((ik[3][1][1]+(mk[3]*((Vpk[0][3][0]*Vpk[0][3][0])+(
          Vpk[0][3][2]*Vpk[0][3][2]))))+((ik[2][1][1]+(mk[2]*((Vpk[0][2][0]*
          Vpk[0][2][0])+(Vpk[0][2][2]*Vpk[0][2][2]))))+((ik[0][1][1]+(mk[0]*((
          rk[0][0]*rk[0][0])+(rk[0][2]*rk[0][2]))))+(ik[1][1][1]+(mk[1]*((
          Vpk[0][1][0]*Vpk[0][1][0])+(Vpk[0][1][2]*Vpk[0][1][2])))))));
        mm[0][0] = ((ik[4][1][1]+(mk[4]*((Vpk[0][4][0]*Vpk[0][4][0])+(
          Vpk[0][4][2]*Vpk[0][4][2]))))+temp[0]);
        mm[0][1] = ((mk[4]*((Vpk[0][4][0]*Vpk[1][3][0])+(Vpk[0][4][2]*
          Vpk[1][3][2])))+((mk[3]*((Vpk[0][3][0]*Vpk[1][3][0])+(Vpk[0][3][2]*
          Vpk[1][3][2])))+((mk[1]*Vpk[0][1][2])+(mk[2]*((Vpk[0][2][0]*s2)+(
          Vpk[0][2][2]*c2))))));
        mm[0][2] = ((ik[4][1][1]+(mk[4]*((Vpk[0][4][0]*Vpk[2][4][0])+(
          Vpk[0][4][2]*Vpk[2][4][2]))))+((ik[2][1][1]+(mk[2]*((rk[2][2]*
          Vpk[0][2][0])-(rk[2][0]*Vpk[0][2][2]))))+(ik[3][1][1]+(mk[3]*((
          Vpk[0][3][0]*Vpk[2][3][0])+(Vpk[0][3][2]*Vpk[2][3][2]))))));
        mm[0][3] = ((ik[3][1][1]+(mk[3]*((rk[3][2]*Vpk[0][3][0])-(rk[3][0]*
          Vpk[0][3][2]))))+(ik[4][1][1]+(mk[4]*((Vpk[0][4][0]*Vpk[3][4][0])+(
          Vpk[0][4][2]*Vpk[3][4][2])))));
        mm[0][4] = -(mk[4]*Vpk[0][4][2]);
        mm[1][1] = ((mk[4]*((Vpk[1][3][0]*Vpk[1][3][0])+(Vpk[1][3][2]*
          Vpk[1][3][2])))+((mk[1]+mk[2])+(mk[3]*((Vpk[1][3][0]*Vpk[1][3][0])+(
          Vpk[1][3][2]*Vpk[1][3][2])))));
        mm[1][2] = ((mk[4]*((Vpk[1][3][0]*Vpk[2][4][0])+(Vpk[1][3][2]*
          Vpk[2][4][2])))+((mk[2]*((rk[2][2]*s2)-(rk[2][0]*c2)))+(mk[3]*((
          Vpk[1][3][0]*Vpk[2][3][0])+(Vpk[1][3][2]*Vpk[2][3][2])))));
        mm[1][3] = ((mk[3]*((rk[3][2]*Vpk[1][3][0])-(rk[3][0]*Vpk[1][3][2])))+(
          mk[4]*((Vpk[1][3][0]*Vpk[3][4][0])+(Vpk[1][3][2]*Vpk[3][4][2]))));
        mm[1][4] = -(mk[4]*Vpk[1][3][2]);
        mm[2][2] = ((ik[4][1][1]+(mk[4]*((Vpk[2][4][0]*Vpk[2][4][0])+(
          Vpk[2][4][2]*Vpk[2][4][2]))))+((ik[2][1][1]+(mk[2]*((rk[2][0]*rk[2][0]
          )+(rk[2][2]*rk[2][2]))))+(ik[3][1][1]+(mk[3]*((Vpk[2][3][0]*
          Vpk[2][3][0])+(Vpk[2][3][2]*Vpk[2][3][2]))))));
        mm[2][3] = ((ik[3][1][1]+(mk[3]*((rk[3][2]*Vpk[2][3][0])-(rk[3][0]*
          Vpk[2][3][2]))))+(ik[4][1][1]+(mk[4]*((Vpk[2][4][0]*Vpk[3][4][0])+(
          Vpk[2][4][2]*Vpk[3][4][2])))));
        mm[2][4] = -(mk[4]*Vpk[2][4][2]);
        mm[3][3] = ((ik[3][1][1]+(mk[3]*((rk[3][0]*rk[3][0])+(rk[3][2]*rk[3][2])
          )))+(ik[4][1][1]+(mk[4]*((Vpk[3][4][0]*Vpk[3][4][0])+(Vpk[3][4][2]*
          Vpk[3][4][2])))));
        mm[3][4] = -(mk[4]*Vpk[3][4][2]);
        mm[4][4] = mk[4];
/*
Check for singular mass matrix
*/
        for (i = 0; i < 5; i++) {
            if (mm[i][i] < 1e-13) {
                srdsseterr(routine,47);
            }
        }
        srdserror(&dumroutine,&errnum);
        if (errnum == 0) {
            mmflg = 1;
        }
    }
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   68 adds/subtracts/negates
                     86 multiplies
                      0 divides
                     16 assignments
*/
}

void srdsdommldu(int routine)
{
    int i;
    int dumroutine,errnum;

    if (mmlduflg == 0) {
        srdsdomm(routine);
/*
Numerically decompose the mass matrix
*/
        srdsldudcomp(5,5,mmap,1e-13,workss,works,mm,mlo,mdi);
/*
Check for singular mass matrix
*/
        for (i = 0; i < 5; i++) {
            if (mdi[i] <= 1e-13) {
                srdsseterr(routine,47);
            }
        }
        srdserror(&dumroutine,&errnum);
        if (errnum == 0) {
            mmlduflg = 1;
        }
    }
}

void srdslhs(int routine)
{
/* Compute all remaining state- and force-dependent quantities
*/

    roustate = 2;
    srdsdommldu(routine);
    srdsdofs0();
}

void srdsmfrc(double imult[5])
{
/*
Calculate forces due to constraint multipliers.

*/

    lfci[0][0] = imult[2];
    lfci[0][1] = imult[3];
    lfci[0][2] = imult[4];
    lfc[0][0] = -((cnk[3][0][0]*lfci[0][0])+(cnk[3][2][0]*lfci[0][2]));
    lfc[0][1] = -lfci[0][1];
    lfc[0][2] = -((cnk[3][0][2]*lfci[0][0])+(cnk[3][2][2]*lfci[0][2]));
    ltci[0][0] = imult[1];
    ltci[0][2] = -imult[0];
    ltc[0][0] = -((cnk[3][0][0]*ltci[0][0])+(cnk[3][2][0]*ltci[0][2]));
    ltc[0][2] = -((cnk[3][0][2]*ltci[0][0])+(cnk[3][2][2]*ltci[0][2]));
    Tinb[0][0] = (ltci[0][0]-(lfci[0][1]*vt10c[0][2]));
    Tinb[0][1] = ((lfci[0][0]*vt10c[0][2])-(lfci[0][2]*vt10c[0][0]));
    Tinb[0][2] = (ltci[0][2]+(lfci[0][1]*vt10c[0][0]));
    Toutb[0][0] = (ltc[0][0]+(.1426*lfc[0][1]));
    mfk[4][0] = lfc[0][0];
    mfk[4][1] = lfc[0][1];
    mfk[4][2] = lfc[0][2];
    mtk[4][0] = Toutb[0][0];
    mtk[4][1] = -(.1426*lfc[0][0]);
    mtk[4][2] = ltc[0][2];
    Toutb[0][1] = -(.1426*lfc[0][0]);
    Toutb[0][2] = ltc[0][2];
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   16 adds/subtracts/negates
                     15 multiplies
                      0 divides
                     22 assignments
*/
}

void srdsequivht(double tau[5])
{
/* Compute tree hinge torques to match effect of applied loads
*/
    double fstareq[5][3],tstareq[5][3];

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(56,23);
        return;
    }
/*
Compute forces due to loop-joint hinge torques
*/
    srdsdoltau();
/*
Compute fstareq (forces)
*/
    fstareq[0][0] = ((9.81*(mk[0]*s0))-ufk[0][0]);
    fstareq[0][2] = ((9.81*(mk[0]*c0))-ufk[0][2]);
    fstareq[1][0] = ((9.81*(mk[1]*s0))-ufk[1][0]);
    fstareq[1][2] = ((9.81*(mk[1]*c0))-ufk[1][2]);
    fstareq[2][0] = -(ufk[2][0]+(gk[2][0]*mk[2]));
    fstareq[2][2] = -(ufk[2][2]+(gk[2][2]*mk[2]));
    fstareq[3][0] = -(ufk[3][0]+(gk[3][0]*mk[3]));
    fstareq[3][2] = -(ufk[3][2]+(gk[3][2]*mk[3]));
    fstareq[4][0] = -(ufk[4][0]+(gk[3][0]*mk[4]));
    fstareq[4][2] = -(ufk[4][2]+(gk[3][2]*mk[4]));
/*
Compute tstareq (torques)
*/
    tstareq[4][1] = -(utk[4][1]-ltau[0]);
/*
Compute taus (RHS ignoring constraints and inertial forces)
*/
    srdsdovpk();
    tau[0] = (utau[0]-(((utk[3][1]+((fstareq[3][0]*Vpk[0][3][0])+(fstareq[3][2]*
      Vpk[0][3][2])))+((utk[2][1]+((fstareq[2][0]*Vpk[0][2][0])+(fstareq[2][2]*
      Vpk[0][2][2])))+((utk[0][1]+((fstareq[0][0]*rk[0][2])-(fstareq[0][2]*
      rk[0][0])))+(utk[1][1]+((fstareq[1][0]*Vpk[0][1][0])+(fstareq[1][2]*
      Vpk[0][1][2]))))))+(((fstareq[4][0]*Vpk[0][4][0])+(fstareq[4][2]*
      Vpk[0][4][2]))-tstareq[4][1])));
    tau[1] = (utau[1]-(((fstareq[1][2]+((fstareq[2][0]*s2)+(fstareq[2][2]*c2)))+
      ((fstareq[3][0]*Vpk[1][3][0])+(fstareq[3][2]*Vpk[1][3][2])))+((
      fstareq[4][0]*Vpk[1][3][0])+(fstareq[4][2]*Vpk[1][3][2]))));
    tau[2] = (utau[2]-(((utk[2][1]+((fstareq[2][0]*rk[2][2])-(fstareq[2][2]*
      rk[2][0])))+(utk[3][1]+((fstareq[3][0]*Vpk[2][3][0])+(fstareq[3][2]*
      Vpk[2][3][2]))))+(((fstareq[4][0]*Vpk[2][4][0])+(fstareq[4][2]*
      Vpk[2][4][2]))-tstareq[4][1])));
    tau[3] = (utau[3]-((utk[3][1]+((fstareq[3][0]*rk[3][2])-(fstareq[3][2]*
      rk[3][0])))+(((fstareq[4][0]*Vpk[3][4][0])+(fstareq[4][2]*Vpk[3][4][2]))-
      tstareq[4][1])));
    tau[4] = (fstareq[4][2]+utau[4]);
/*
Op counts below do not include called subroutines
*/
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   56 adds/subtracts/negates
                     40 multiplies
                      0 divides
                     16 assignments
*/
}

void srdsfs0(void)
{

/*
Compute Fs (ignoring multiplier forces)
*/
    fs[0] = fs0[0];
    fs[1] = fs0[1];
    fs[2] = fs0[2];
    fs[3] = fs0[3];
    fs[4] = fs0[4];
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srdsfsmult(void)
{

/*
Compute Fs (multiplier-generated forces only)
*/
    srdsdovpk();
    fs[0] = -(mtk[4][1]-((mfk[4][0]*Vpk[0][4][0])+(mfk[4][2]*Vpk[0][4][2])));
    fs[1] = ((mfk[4][0]*Vpk[1][3][0])+(mfk[4][2]*Vpk[1][3][2]));
    fs[2] = -(mtk[4][1]-((mfk[4][0]*Vpk[2][4][0])+(mfk[4][2]*Vpk[2][4][2])));
    fs[3] = -(mtk[4][1]-((mfk[4][0]*Vpk[3][4][0])+(mfk[4][2]*Vpk[3][4][2])));
    fs[4] = -mfk[4][2];
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   11 adds/subtracts/negates
                      8 multiplies
                      0 divides
                      5 assignments
*/
}

void srdsfsfull(void)
{

/*
Compute Fs (including all forces)
*/
    srdsfsmult();
    fs[0] = (fs[0]+fs0[0]);
    fs[1] = (fs[1]+fs0[1]);
    fs[2] = (fs[2]+fs0[2]);
    fs[3] = (fs[3]+fs0[3]);
    fs[4] = (fs[4]+fs0[4]);
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    5 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srdsfsgenmult(void)
{

/*
Compute Fs (generic multiplier-generated forces)
*/
    srdsdovpk();
    fs[0] = (mtau[0]-((mtk[4][1]-((mfk[4][0]*Vpk[0][4][0])+(mfk[4][2]*
      Vpk[0][4][2])))+((mtk[3][1]-((mfk[3][0]*Vpk[0][3][0])+(mfk[3][2]*
      Vpk[0][3][2])))+((mtk[2][1]-((mfk[2][0]*Vpk[0][2][0])+(mfk[2][2]*
      Vpk[0][2][2])))+((mtk[0][1]+((mfk[0][2]*rk[0][0])-(mfk[0][0]*rk[0][2])))+(
      mtk[1][1]-((mfk[1][0]*Vpk[0][1][0])+(mfk[1][2]*Vpk[0][1][2]))))))));
    fs[1] = (mtau[1]+(((mfk[1][2]+((mfk[2][0]*s2)+(mfk[2][2]*c2)))+((mfk[3][0]*
      Vpk[1][3][0])+(mfk[3][2]*Vpk[1][3][2])))+((mfk[4][0]*Vpk[1][3][0])+(
      mfk[4][2]*Vpk[1][3][2]))));
    fs[2] = (mtau[2]-((mtk[4][1]-((mfk[4][0]*Vpk[2][4][0])+(mfk[4][2]*
      Vpk[2][4][2])))+((mtk[2][1]+((mfk[2][2]*rk[2][0])-(mfk[2][0]*rk[2][2])))+(
      mtk[3][1]-((mfk[3][0]*Vpk[2][3][0])+(mfk[3][2]*Vpk[2][3][2]))))));
    fs[3] = (mtau[3]-((mtk[3][1]+((mfk[3][2]*rk[3][0])-(mfk[3][0]*rk[3][2])))+(
      mtk[4][1]-((mfk[4][0]*Vpk[3][4][0])+(mfk[4][2]*Vpk[3][4][2])))));
    fs[4] = (mtau[4]-mfk[4][2]);
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   38 adds/subtracts/negates
                     26 multiplies
                      0 divides
                      5 assignments
*/
}

void srdsfsgenfull(void)
{

/*
Compute Fs (incl generic mult & other forces)
*/
    srdsfsgenmult();
    fs[0] = (fs[0]+fs0[0]);
    fs[1] = (fs[1]+fs0[1]);
    fs[2] = (fs[2]+fs0[2]);
    fs[3] = (fs[3]+fs0[3]);
    fs[4] = (fs[4]+fs0[4]);
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    5 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srdsfulltrq(double udotin[5],
    double multin[5],
    double trqout[5])
{
/* Compute hinge torques which would produce indicated udots
*/
    double fstarr[5][3],tstarr[5][3],Otkr[5][3],Atir[5][3],Atkr[5][3];

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(61,23);
        return;
    }
/*
Compute forces due to loop-joint hinge torques
*/
    srdsdoltau();
/*
Compute multiplier-generated forces
*/
    srdsmfrc(multin);
/*
Account for inertial accelerations and supplied udots
*/
    Otkr[2][1] = -(udotin[0]+udotin[2]);
    Otkr[3][1] = (Otkr[2][1]-udotin[3]);
    Atkr[0][0] = ((rk[0][2]*udotin[0])-(u[0]*Wkrpk[0][2]));
    Atkr[0][2] = ((u[0]*Wkrpk[0][0])-(rk[0][0]*udotin[0]));
    Atir[1][0] = (Atkr[0][0]-((ri[1][2]*udotin[0])+(u[0]*Wirk[1][2])));
    Atir[1][2] = (Atkr[0][2]+((ri[1][0]*udotin[0])+(u[0]*Wirk[1][0])));
    Atkr[1][0] = (Atir[1][0]-((2.*(u[0]*u[1]))+((rpk[1][2]*udotin[0])+(u[0]*
      Wkrpk[1][2]))));
    Atkr[1][2] = (udotin[1]+(Atir[1][2]+((u[0]*Wkrpk[1][0])-(rk[1][0]*udotin[0])
      )));
    Atir[2][0] = (Atkr[1][0]-((ri[2][2]*udotin[0])+(u[0]*Wirk[2][2])));
    Atir[2][2] = (Atkr[1][2]+((ri[2][0]*udotin[0])+(u[0]*Wirk[2][0])));
    Atkr[2][0] = (((Atir[2][0]*c2)+(Atir[2][2]*s2))+((wk[2][1]*Wkrpk[2][2])-(
      Otkr[2][1]*rk[2][2])));
    Atkr[2][2] = (((Atir[2][2]*c2)-(Atir[2][0]*s2))+((Otkr[2][1]*rk[2][0])-(
      wk[2][1]*Wkrpk[2][0])));
    Atir[3][0] = (Atkr[2][0]+((Otkr[2][1]*ri[3][2])+(Wirk[3][2]*wk[2][1])));
    Atir[3][2] = (Atkr[2][2]-((Otkr[2][1]*ri[3][0])+(Wirk[3][0]*wk[2][1])));
    Atkr[3][0] = (((Atir[3][0]*c3)+(Atir[3][2]*s3))+((wk[3][1]*Wkrpk[3][2])-(
      Otkr[3][1]*rk[3][2])));
    Atkr[3][2] = (((Atir[3][2]*c3)-(Atir[3][0]*s3))+((Otkr[3][1]*rk[3][0])-(
      wk[3][1]*Wkrpk[3][0])));
    Atir[4][0] = (Atkr[3][0]+((Otkr[3][1]*ri[4][2])+(Wirk[4][2]*wk[3][1])));
    Atir[4][2] = (Atkr[3][2]-((Otkr[3][1]*ri[4][0])+(Wirk[4][0]*wk[3][1])));
    Atkr[4][0] = (Atir[4][0]+(((Otkr[3][1]*rpk[4][2])+(wk[3][1]*Wkrpk[4][2]))-(
      2.*(u[4]*wk[3][1]))));
    Atkr[4][2] = ((Atir[4][2]+((Otkr[3][1]*rk[4][0])-(wk[3][1]*Wkrpk[4][0])))-
      udotin[4]);
/*
Accumulate all forces and torques
*/
    fstarr[0][0] = (ufk[0][0]-(mk[0]*(Atkr[0][0]+(9.81*s0))));
    fstarr[0][2] = (ufk[0][2]-(mk[0]*(Atkr[0][2]+(9.81*c0))));
    fstarr[1][0] = (ufk[1][0]-(mk[1]*(Atkr[1][0]+(9.81*s0))));
    fstarr[1][2] = (ufk[1][2]-(mk[1]*(Atkr[1][2]+(9.81*c0))));
    fstarr[2][0] = (ufk[2][0]+(mk[2]*(gk[2][0]-Atkr[2][0])));
    fstarr[2][2] = (ufk[2][2]+(mk[2]*(gk[2][2]-Atkr[2][2])));
    fstarr[3][0] = (ufk[3][0]+(mk[3]*(gk[3][0]-Atkr[3][0])));
    fstarr[3][2] = (ufk[3][2]+(mk[3]*(gk[3][2]-Atkr[3][2])));
    fstarr[4][0] = ((mfk[4][0]+ufk[4][0])+(mk[4]*(gk[3][0]-Atkr[4][0])));
    fstarr[4][1] = (mfk[4][1]+ufk[4][1]);
    fstarr[4][2] = ((mfk[4][2]+ufk[4][2])+(mk[4]*(gk[3][2]-Atkr[4][2])));
    tstarr[0][1] = (utk[0][1]+(ik[0][1][1]*udotin[0]));
    tstarr[1][1] = (utk[1][1]+(ik[1][1][1]*udotin[0]));
    tstarr[2][1] = (utk[2][1]-(ik[2][1][1]*Otkr[2][1]));
    tstarr[3][1] = (utk[3][1]-(ik[3][1][1]*Otkr[3][1]));
    tstarr[4][0] = (mtk[4][0]+utk[4][0]);
    tstarr[4][1] = ((utk[4][1]+(mtk[4][1]-ltau[0]))-(ik[4][1][1]*Otkr[3][1]));
    tstarr[4][2] = (mtk[4][2]+utk[4][2]);
/*
Now calculate the torques
*/
    srdsdovpk();
    trqout[0] = -(utau[0]+((((fstarr[4][0]*Vpk[0][4][0])+(fstarr[4][2]*
      Vpk[0][4][2]))-tstarr[4][1])+((((fstarr[3][0]*Vpk[0][3][0])+(fstarr[3][2]*
      Vpk[0][3][2]))-tstarr[3][1])+((((fstarr[2][0]*Vpk[0][2][0])+(fstarr[2][2]*
      Vpk[0][2][2]))-tstarr[2][1])+((((fstarr[0][0]*rk[0][2])-(fstarr[0][2]*
      rk[0][0]))-tstarr[0][1])+(((fstarr[1][0]*Vpk[0][1][0])+(fstarr[1][2]*
      Vpk[0][1][2]))-tstarr[1][1]))))));
    trqout[1] = -(utau[1]+(((fstarr[1][2]+((fstarr[2][0]*s2)+(fstarr[2][2]*c2)))
      +((fstarr[3][0]*Vpk[1][3][0])+(fstarr[3][2]*Vpk[1][3][2])))+((fstarr[4][0]
      *Vpk[1][3][0])+(fstarr[4][2]*Vpk[1][3][2]))));
    trqout[2] = -(utau[2]+((((fstarr[4][0]*Vpk[2][4][0])+(fstarr[4][2]*
      Vpk[2][4][2]))-tstarr[4][1])+((((fstarr[2][0]*rk[2][2])-(fstarr[2][2]*
      rk[2][0]))-tstarr[2][1])+(((fstarr[3][0]*Vpk[2][3][0])+(fstarr[3][2]*
      Vpk[2][3][2]))-tstarr[3][1]))));
    trqout[3] = -(utau[3]+((((fstarr[3][0]*rk[3][2])-(fstarr[3][2]*rk[3][0]))-
      tstarr[3][1])+(((fstarr[4][0]*Vpk[3][4][0])+(fstarr[4][2]*Vpk[3][4][2]))-
      tstarr[4][1])));
    trqout[4] = (fstarr[4][2]-utau[4]);
/*
Op counts below do not include called subroutines
*/
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  119 adds/subtracts/negates
                     93 multiplies
                      0 divides
                     43 assignments
*/
}

void srdscomptrq(double udotin[5],
    double trqout[5])
{
/* Compute hinge torques to produce these udots, ignoring constraints
*/
    int i;
    double multin[5];

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(60,23);
        return;
    }
    for (i = 0; i < 5; i++) {
        multin[i] = 0.;
    }
    srdsfulltrq(udotin,multin,trqout);
}

void srdsmulttrq(double multin[5],
    double trqout[5])
{
/* Compute hinge trqs which would be produced by these mults.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(65,23);
        return;
    }
    srdsmfrc(multin);
    srdsfsmult();
    for (i = 0; i < 5; i++) {
        trqout[i] = fs[i];
    }
}

void srdsrhs(void)
{
/*
Generated 24-Jun-2008 21:10:41 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/

/*
Compute hinge torques for tree hinges
*/
    tauc[0] = utau[0];
    tauc[1] = utau[1];
    tauc[2] = utau[2];
    tauc[3] = utau[3];
    tauc[4] = utau[4];
/*
Compute hinge torques for loop joints
*/
    ltauc[0] = ltau[0];
    srdsdoiner();
/*
Compute onk & onb (angular accels in N)
*/
    Onkb[2][1] = -(udot[0]+udot[2]);
    Onkb[3][1] = (Onkb[2][1]-udot[3]);
    onb[0][0] = 0.;
    onb[0][1] = -udot[0];
    onb[0][2] = 0.;
    onb[1][0] = 0.;
    onb[1][1] = -udot[0];
    onb[1][2] = 0.;
    onb[2][0] = 0.;
    onb[2][1] = Onkb[2][1];
    onb[2][2] = 0.;
    onb[3][0] = 0.;
    onb[3][1] = Onkb[3][1];
    onb[3][2] = 0.;
    onb[4][0] = 0.;
    onb[4][1] = Onkb[3][1];
    onb[4][2] = 0.;
/*
Compute acceleration dyadics
*/
    dyad[0][0][0] = -w1w1[0];
    dyad[0][0][1] = 0.;
    dyad[0][0][2] = -udot[0];
    dyad[0][1][0] = 0.;
    dyad[0][1][1] = 0.;
    dyad[0][1][2] = 0.;
    dyad[0][2][0] = udot[0];
    dyad[0][2][1] = 0.;
    dyad[0][2][2] = -w1w1[0];
    dyad[1][0][0] = -w1w1[1];
    dyad[1][0][1] = 0.;
    dyad[1][0][2] = -udot[0];
    dyad[1][1][0] = 0.;
    dyad[1][1][1] = 0.;
    dyad[1][1][2] = 0.;
    dyad[1][2][0] = udot[0];
    dyad[1][2][1] = 0.;
    dyad[1][2][2] = -w1w1[1];
    dyad[2][0][0] = -w1w1[2];
    dyad[2][0][1] = 0.;
    dyad[2][0][2] = Onkb[2][1];
    dyad[2][1][0] = 0.;
    dyad[2][1][1] = 0.;
    dyad[2][1][2] = 0.;
    dyad[2][2][0] = -Onkb[2][1];
    dyad[2][2][1] = 0.;
    dyad[2][2][2] = -w1w1[2];
    dyad[3][0][0] = -w1w1[3];
    dyad[3][0][1] = 0.;
    dyad[3][0][2] = Onkb[3][1];
    dyad[3][1][0] = 0.;
    dyad[3][1][1] = 0.;
    dyad[3][1][2] = 0.;
    dyad[3][2][0] = -Onkb[3][1];
    dyad[3][2][1] = 0.;
    dyad[3][2][2] = -w1w1[3];
    dyad[4][0][0] = -w1w1[4];
    dyad[4][0][1] = 0.;
    dyad[4][0][2] = Onkb[3][1];
    dyad[4][1][0] = 0.;
    dyad[4][1][1] = 0.;
    dyad[4][1][2] = 0.;
    dyad[4][2][0] = -Onkb[3][1];
    dyad[4][2][1] = 0.;
    dyad[4][2][2] = -w1w1[4];
/*
Compute ank & anb (mass center linear accels in N)
*/
    Ankb[0][0] = (rk[0][2]*udot[0]);
    Ankb[0][2] = -(rk[0][0]*udot[0]);
    AOnkri[1][0] = (Ankb[0][0]-(ri[1][2]*udot[0]));
    AOnkri[1][2] = (Ankb[0][2]+(ri[1][0]*udot[0]));
    Ankb[1][0] = (AOnkri[1][0]-(rpk[1][2]*udot[0]));
    Ankb[1][2] = (AOnkri[1][2]+(udot[1]-(rk[1][0]*udot[0])));
    AOnkri[2][0] = (Ankb[1][0]-(ri[2][2]*udot[0]));
    AOnkri[2][2] = (Ankb[1][2]+(ri[2][0]*udot[0]));
    Ankb[2][0] = (((AOnkri[2][0]*c2)+(AOnkri[2][2]*s2))-(Onkb[2][1]*rk[2][2]));
    Ankb[2][2] = ((Onkb[2][1]*rk[2][0])+((AOnkri[2][2]*c2)-(AOnkri[2][0]*s2)));
    AOnkri[3][0] = (Ankb[2][0]+(Onkb[2][1]*ri[3][2]));
    AOnkri[3][2] = (Ankb[2][2]-(Onkb[2][1]*ri[3][0]));
    Ankb[3][0] = (((AOnkri[3][0]*c3)+(AOnkri[3][2]*s3))-(Onkb[3][1]*rk[3][2]));
    Ankb[3][2] = ((Onkb[3][1]*rk[3][0])+((AOnkri[3][2]*c3)-(AOnkri[3][0]*s3)));
    AOnkri[4][0] = (Ankb[3][0]+(Onkb[3][1]*ri[4][2]));
    AOnkri[4][2] = (Ankb[3][2]-(Onkb[3][1]*ri[4][0]));
    Ankb[4][0] = (AOnkri[4][0]+(Onkb[3][1]*rpk[4][2]));
    Ankb[4][2] = (AOnkri[4][2]+((Onkb[3][1]*rk[4][0])-udot[4]));
    AnkAtk[0][0] = (Ankb[0][0]+Atk[0][0]);
    AnkAtk[0][2] = (Ankb[0][2]+Atk[0][2]);
    ank[0][0] = ((AnkAtk[0][0]*c0)-(AnkAtk[0][2]*s0));
    ank[0][2] = ((AnkAtk[0][0]*s0)+(AnkAtk[0][2]*c0));
    AnkAtk[1][0] = (Ankb[1][0]+Atk[1][0]);
    AnkAtk[1][2] = (Ankb[1][2]+Atk[1][2]);
    ank[1][0] = ((AnkAtk[1][0]*c0)-(AnkAtk[1][2]*s0));
    ank[1][2] = ((AnkAtk[1][0]*s0)+(AnkAtk[1][2]*c0));
    AnkAtk[2][0] = (Ankb[2][0]+Atk[2][0]);
    AnkAtk[2][2] = (Ankb[2][2]+Atk[2][2]);
    ank[2][0] = ((AnkAtk[2][0]*cnk[2][0][0])+(AnkAtk[2][2]*cnk[2][0][2]));
    ank[2][2] = ((AnkAtk[2][0]*cnk[2][2][0])+(AnkAtk[2][2]*cnk[2][2][2]));
    AnkAtk[3][0] = (Ankb[3][0]+Atk[3][0]);
    AnkAtk[3][2] = (Ankb[3][2]+Atk[3][2]);
    ank[3][0] = ((AnkAtk[3][0]*cnk[3][0][0])+(AnkAtk[3][2]*cnk[3][0][2]));
    ank[3][2] = ((AnkAtk[3][0]*cnk[3][2][0])+(AnkAtk[3][2]*cnk[3][2][2]));
    AnkAtk[4][0] = (Ankb[4][0]+Atk[4][0]);
    AnkAtk[4][2] = (Ankb[4][2]+Atk[4][2]);
    ank[4][0] = ((AnkAtk[4][0]*cnk[3][0][0])+(AnkAtk[4][2]*cnk[3][0][2]));
    ank[4][2] = ((AnkAtk[4][0]*cnk[3][2][0])+(AnkAtk[4][2]*cnk[3][2][2]));
    anb[0][0] = ank[0][0];
    anb[0][1] = 0.;
    anb[0][2] = ank[0][2];
    anb[1][0] = ank[1][0];
    anb[1][1] = 0.;
    anb[1][2] = ank[1][2];
    anb[2][0] = ank[2][0];
    anb[2][1] = 0.;
    anb[2][2] = ank[2][2];
    anb[3][0] = ank[3][0];
    anb[3][1] = 0.;
    anb[3][2] = ank[3][2];
    anb[4][0] = ank[4][0];
    anb[4][1] = 0.;
    anb[4][2] = ank[4][2];
/*
Compute loop joint temps
*/
    vt19[0][0] = -(ank[4][0]+(.1426*((cnk[3][0][2]*w1w1[4])-(cnk[3][0][0]*
      Onkb[3][1]))));
    vt19[0][2] = -(ank[4][2]+(.1426*((cnk[3][2][2]*w1w1[4])-(cnk[3][2][0]*
      Onkb[3][1]))));
/*
Compute loop joint accelerations
*/
/*
Compute constraint acceleration errors
*/
    roustate = 3;
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   69 adds/subtracts/negates
                     52 multiplies
                      0 divides
                    123 assignments
*/
}

void srdsmassmat(double mmat[5][5])
{
/* Return the system mass matrix (LHS)
*/
    int i,j;

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(57,23);
        return;
    }
    srdsdomm(57);
    for (i = 0; i < 5; i++) {
        for (j = i; j <= 4; j++) {
            mmat[i][j] = mm[i][j];
            mmat[j][i] = mm[i][j];
        }
    }
}

void srdsfrcmat(double fmat[5])
{
/* Return the system force matrix (RHS), excluding constraints
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(58,23);
        return;
    }
    srdsdofs0();
    for (i = 0; i < 5; i++) {
        fmat[i] = fs0[i];
    }
}

void srdspseudo(double lqout[1],
    double luout[1])
{
/*
Return pseudo-coordinates for loop joints.

*/

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(18,23);
        return;
    }
    lqout[0] = eul1[0];
    luout[0] = -wk[3][1];
}

void srdspsqdot(double lqdout[1])
{
/*
Return pseudo-coordinate derivatives for loop joints.

*/

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(28,23);
        return;
    }
    lqdout[0] = -wk[3][1];
}

void srdspsudot(double ludout[1])
{
/*
Return pseudo-coordinate accelerations for loop joints.

*/

    if (roustate != 3) {
        srdsseterr(29,24);
        return;
    }
    ludout[0] = -Onkb[3][1];
}

void srdsperr(double errs[5])
{
/*
Return position constraint errors.

*/

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(26,23);
        return;
    }
    errs[0] = 0.;
    errs[1] = 0.;
    errs[2] = vt11[0][0];
    errs[3] = 0.;
    errs[4] = -vt10c[0][2];
}

void srdsverr(double errs[5])
{
/*
Return velocity constraint errors.

*/

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(27,23);
        return;
    }
    errs[0] = 0.;
    errs[1] = 0.;
    errs[2] = vt12[0][0];
    errs[3] = 0.;
    errs[4] = vt12[0][2];
}

void srdsaerr(double errs[5])
{
/*
Return acceleration constraint errors.

*/

    if (roustate != 3) {
        srdsseterr(35,24);
        return;
    }
    errs[0] = 0.;
    errs[1] = 0.;
    errs[2] = vt19[0][0];
    errs[3] = 0.;
    errs[4] = vt19[0][2];
}
int 
srdschkbnum(int routine,
    int bnum)
{

    if ((bnum < -1) || (bnum > 4)) {
        srdsseterr(routine,15);
        return 1;
    }
    return 0;
}
int 
srdschkjnum(int routine,
    int jnum)
{

    if ((jnum < 0) || (jnum > 5)) {
        srdsseterr(routine,16);
        return 1;
    }
    return 0;
}
int 
srdschkucnum(int routine,
    int ucnum)
{

    if ((ucnum < 0) || (ucnum > -1)) {
        srdsseterr(routine,21);
        return 1;
    }
    return 0;
}
int 
srdschkjaxis(int routine,
    int jnum,
    int axnum)
{
    int maxax;

    if (srdschkjnum(routine,jnum) != 0) {
        return 1;
    }
    if ((axnum < 0) || (axnum > 6)) {
        srdsseterr(routine,17);
        return 1;
    }
    maxax = njntdof[jnum]-1;
    if ((jtype[jnum] == 4) || (jtype[jnum] == 6) || (jtype[jnum] == 21)) {
        maxax = maxax+1;
    }
    if (axnum > maxax) {
        srdsseterr(routine,18);
        return 1;
    }
    return 0;
}
int 
srdschkjpin(int routine,
    int jnum,
    int pinno)
{
    int maxax,pinok;

    if (srdschkjnum(routine,jnum) != 0) {
        return 1;
    }
    if ((pinno < 0) || (pinno > 5)) {
        srdsseterr(routine,17);
        return 1;
    }
    if (njntdof[jnum] >= 3) {
        maxax = 2;
    } else {
        maxax = njntdof[jnum]-1;
    }
    if (jtype[jnum] == 4) {
        maxax = -1;
    }
    if (jtype[jnum] == 7) {
        maxax = 0;
    }
    pinok = 0;
    if (pinno <= maxax) {
        pinok = 1;
    }
    if (jnum > 4) {
        if ((pinno == 3) && ((jtype[jnum] == 1) || (jtype[jnum] == 5) || (jtype[
          jnum] == 7) || (jtype[jnum] == 9))) {
            pinok = 1;
        }
        if (((pinno == 4) || (pinno == 5)) && ((jtype[jnum] != 4) && (jtype[jnum
          ] != 6))) {
            pinok = 1;
        }
    }
    if (pinok == 0) {
        srdsseterr(routine,18);
        return 1;
    }
    return 0;
}
int 
srdsindx(int joint,
    int axis)
{
    int offs,gotit;

    if (srdschkjaxis(36,joint,axis) != 0) {
        return 0;
    }
    gotit = 0;
    if (jtype[joint] == 4) {
        if (axis == 3) {
            offs = ballq[joint];
            gotit = 1;
        }
    } else {
        if ((jtype[joint] == 6) || (jtype[joint] == 21)) {
            if (axis == 6) {
                offs = ballq[joint];
                gotit = 1;
            }
        }
    }
    if (gotit == 0) {
        offs = firstq[joint]+axis;
    }
    return offs;
}

void srdspresacc(int joint,
    int axis,
    double prval)
{

}

void srdspresvel(int joint,
    int axis,
    double prval)
{

}

void srdsprespos(int joint,
    int axis,
    double prval)
{

}

void srdsgetht(int joint,
    int axis,
    double *torque)
{

    if (srdschkjaxis(30,joint,axis) != 0) {
        return;
    }
    if (roustate != 3) {
        srdsseterr(30,24);
        return;
    }
    if (joint  >  4) {
        *torque = ltauc[srdsindx(joint,axis)];
    } else {
        *torque = tauc[srdsindx(joint,axis)];
    }
}

void srdshinget(int joint,
    int axis,
    double torque)
{

    if (srdschkjaxis(10,joint,axis) != 0) {
        return;
    }
    if (roustate != 2) {
        srdsseterr(10,23);
        return;
    }
    if (mfrcflg != 0) {
        if (joint > 4) {
            mltau[srdsindx(joint,axis)] = mltau[srdsindx(joint,axis)]+torque;
        } else {
            mtau[srdsindx(joint,axis)] = mtau[srdsindx(joint,axis)]+torque;
        }
    } else {
        fs0flg = 0;
        if (joint > 4) {
            ltau[srdsindx(joint,axis)] = ltau[srdsindx(joint,axis)]+torque;
            ltauflg = 0;
        } else {
            utau[srdsindx(joint,axis)] = utau[srdsindx(joint,axis)]+torque;
        }
    }
}

void srdspointf(int body,
    double point[3],
    double force[3])
{
    double torque[3];

    if (srdschkbnum(11,body) != 0) {
        return;
    }
    if (roustate != 2) {
        srdsseterr(11,23);
        return;
    }
    if (body == -1) {
        return;
    }
    torque[0] = point[1]*force[2]-point[2]*force[1];
    torque[1] = point[2]*force[0]-point[0]*force[2];
    torque[2] = point[0]*force[1]-point[1]*force[0];
    if (mfrcflg != 0) {
        mfk[body][0] = mfk[body][0]+force[0];
        mtk[body][0] = mtk[body][0]+torque[0];
        mfk[body][1] = mfk[body][1]+force[1];
        mtk[body][1] = mtk[body][1]+torque[1];
        mfk[body][2] = mfk[body][2]+force[2];
        mtk[body][2] = mtk[body][2]+torque[2];
    } else {
        fs0flg = 0;
        ufk[body][0] = ufk[body][0]+force[0];
        utk[body][0] = utk[body][0]+torque[0];
        ufk[body][1] = ufk[body][1]+force[1];
        utk[body][1] = utk[body][1]+torque[1];
        ufk[body][2] = ufk[body][2]+force[2];
        utk[body][2] = utk[body][2]+torque[2];
    }
}

void srdsbodyt(int body,
    double torque[3])
{

    if (srdschkbnum(12,body) != 0) {
        return;
    }
    if (roustate != 2) {
        srdsseterr(12,23);
        return;
    }
    if (body == -1) {
        return;
    }
    if (mfrcflg != 0) {
        mtk[body][0] = mtk[body][0]+torque[0];
        mtk[body][1] = mtk[body][1]+torque[1];
        mtk[body][2] = mtk[body][2]+torque[2];
    } else {
        fs0flg = 0;
        utk[body][0] = utk[body][0]+torque[0];
        utk[body][1] = utk[body][1]+torque[1];
        utk[body][2] = utk[body][2]+torque[2];
    }
}

void srdsdoww(int routine)
{
    double pp[5][5],dpp[5][5];
    int i,j,c;
    double sum;
    double dfk[5][3],dtk[5][3],dtau[5],dltci[1][3],dltc[1][3],dlfci[1][3],dlfc[1
      ][3];
    double dTinb[1][3],dToutb[1][3],dltaufi[1][3],dltaufo[1][3],dltauti[1][3],
      dltauto[1][3];
    double dfs[5],row[5],dinvrow[5];

    roustate = 2;
    if (wwflg == 0) {
/*
Compute constraint effects
*/
        srdsdovpk();
        srdsdommldu(routine);
/*
Constraint 0 (loop constraint)
*/
        dltc[0][0] = cnk[3][2][0];
        dltc[0][2] = cnk[3][2][2];
/* ... redundant */
/*
Constraint 1 (loop constraint)
*/
        dltc[0][0] = -cnk[3][0][0];
        dltc[0][2] = -cnk[3][0][2];
/* ... redundant */
/*
Constraint 2 (loop constraint)
*/
        dlfc[0][0] = -cnk[3][0][0];
        dlfc[0][2] = -cnk[3][0][2];
        dfs[0] = ((.1426*dlfc[0][0])+((dlfc[0][0]*Vpk[0][4][0])+(dlfc[0][2]*
          Vpk[0][4][2])));
        dfs[1] = ((dlfc[0][0]*Vpk[1][3][0])+(dlfc[0][2]*Vpk[1][3][2]));
        dfs[2] = ((.1426*dlfc[0][0])+((dlfc[0][0]*Vpk[2][4][0])+(dlfc[0][2]*
          Vpk[2][4][2])));
        dfs[3] = ((.1426*dlfc[0][0])+((dlfc[0][0]*Vpk[3][4][0])+(dlfc[0][2]*
          Vpk[3][4][2])));
        dfs[4] = -dlfc[0][2];
        srdsldubsl(5,5,mmap,mlo,dfs,row);
        srdsldubsd(5,5,mmap,mdi,row,dinvrow);
        for (i = 0; i <= 4; i++) {
            pp[2][i] = row[i];
            dpp[i][2] = dinvrow[i];
        }
        wmap[0] = 2;
/*
Constraint 3 (loop constraint)
*/
/* ... redundant */
/*
Constraint 4 (loop constraint)
*/
        dlfc[0][0] = -cnk[3][2][0];
        dlfc[0][2] = -cnk[3][2][2];
        dfs[0] = ((.1426*dlfc[0][0])+((dlfc[0][0]*Vpk[0][4][0])+(dlfc[0][2]*
          Vpk[0][4][2])));
        dfs[1] = ((dlfc[0][0]*Vpk[1][3][0])+(dlfc[0][2]*Vpk[1][3][2]));
        dfs[2] = ((.1426*dlfc[0][0])+((dlfc[0][0]*Vpk[2][4][0])+(dlfc[0][2]*
          Vpk[2][4][2])));
        dfs[3] = ((.1426*dlfc[0][0])+((dlfc[0][0]*Vpk[3][4][0])+(dlfc[0][2]*
          Vpk[3][4][2])));
        dfs[4] = -dlfc[0][2];
        srdsldubsl(5,5,mmap,mlo,dfs,row);
        srdsldubsd(5,5,mmap,mdi,row,dinvrow);
        for (i = 0; i <= 4; i++) {
            pp[4][i] = row[i];
            dpp[i][4] = dinvrow[i];
        }
        wmap[1] = 4;
/*
Produce constraint coefficient matrix WW
*/
        for (c = 0; c <= 1; c++) {
            for (i = c; i <= 1; i++) {
                sum = 0.;
                for (j = 0; j <= 4; j++) {
                    sum = sum+pp[wmap[c]][j]*dpp[j][wmap[i]];
                }
                ww[wmap[c]][wmap[i]] = sum;
                ww[wmap[i]][wmap[c]] = sum;
            }
        }
/*
Form QR decomposition of WW
*/
        srdsqrdcomp(5,5,2,2,wmap,wmap,ww,qraux,jpvt);
        wwflg = 1;
    }
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   37 adds/subtracts/negates
                     37 multiplies
                      0 divides
                     62 assignments
*/
}

void srdsxudot0(int routine,
    double oudot0[5])
{
/*
Compute unconstrained equations
*/
    int i;

    srdslhs(routine);
/*
Solve equations ignoring constraints
*/
    srdsfs0();
    srdsldubslv(5,5,mmap,works,mlo,mdi,fs,udot);
    for (i = 0; i <= 4; i++) {
        oudot0[i] = udot[i];
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srdsudot0(double oudot0[5])
{

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(66,23);
        return;
    }
    srdsxudot0(66,oudot0);
}

void srdssetudot(double iudot[5])
{
/*
Assign udots and advance to stage Dynamics Ready
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(68,23);
        return;
    }
    for (i = 0; i <= 4; i++) {
        udot[i] = iudot[i];
    }
    srdsrhs();
}

void srdsxudotm(int routine,
    double imult[5],
    double oudotm[5])
{
/*
Compute udots due only to multipliers
*/
    int i;

    srdslhs(routine);
    srdsmfrc(imult);
    srdsfsmult();
    srdsldubslv(5,5,mmap,works,mlo,mdi,fs,udot);
    for (i = 0; i <= 4; i++) {
        oudotm[i] = udot[i];
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      5 assignments
*/
}

void srdsudotm(double imult[5],
    double oudotm[5])
{

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(67,23);
        return;
    }
    srdsxudotm(67,imult,oudotm);
}

void srdsderiv(double oqdot[5],
    double oudot[5])
{
/*
This is the derivative section for a 5-body ground-based
system with 5 hinge degree(s) of freedom.
There are 5 constraints.
*/
    double workr[5],bb[5],b0[5],v0[5],p0[5];
    int iwork[5];
    int i,j;
    double udot0[5],udot1[5];

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(17,23);
        return;
    }
    if (stabvelq == 1) {
        srdsseterr(17,32);
    }
    if (stabposq == 1) {
        srdsseterr(17,33);
    }
    wsiz = 2;
/*
Compute unconstrained equations
*/
    srdsxudot0(17,udot0);
    srdsrhs();
    srdsaerr(b0);
    if (stabvel  !=  0.) {
        srdsverr(v0);
    }
    if (stabpos  !=  0.) {
        srdsperr(p0);
    }
/*
Stabilize constraints using Baumgarte's method
*/
    for (i = 0; i <= 4; i++) {
        bb[i] = -b0[i];
    }
    if (stabvel  !=  0.) {
        for (i = 0; i <= 4; i++) {
            bb[i] = bb[i]-stabvel*v0[i];
        }
    }
    if (stabpos  !=  0.) {
        for (i = 0; i <= 4; i++) {
            bb[i] = bb[i]-stabpos*p0[i];
        }
    }
/*
Compute and decompose constraint matrix WW
*/
    srdsdoww(17);
/*
Numerically solve for constraint multipliers
*/
    for (i = 0; i <= 4; i++) {
        mult[i] = 0.;
    }
    srdsqrbslv(5,5,2,2,wmap,wmap,1e-13,workr,iwork,ww,qraux,jpvt,bb,mult,&wrank)
      ;
    for (i = 0; i <= 1; i++) {
        multmap[i] = 0;
    }
    for (i = 0; i < wrank; i++) {
        multmap[jpvt[i]] = 1;
    }
    j = 0;
    for (i = 0; i <= 1; i++) {
        if (multmap[i] != 0) {
            multmap[j] = wmap[i];
            j = j+1;
        }
    }
/*
Compute final udots
*/
    srdsxudotm(17,mult,udot1);
    for (i = 0; i <= 4; i++) {
        udot[i] = udot0[i]+udot1[i];
    }
    srdsrhs();
    for (i = 0; i <= 4; i++) {
        oqdot[i] = qdot[i];
    }
    for (i = 0; i <= 4; i++) {
        oudot[i] = udot[i];
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   20 adds/subtracts/negates
                     10 multiplies
                      0 divides
                     35 assignments
*/
}
/*
Compute residuals for use with DAE integrator
*/

void srdsresid(double eqdot[5],
    double eudot[5],
    double emults[5],
    double resid[15])
{
    int i;
    double uderrs[5],p0[5];

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(16,23);
        return;
    }
    if (stabposq == 1) {
        srdsseterr(16,33);
    }
    srdsfulltrq(eudot,emults,uderrs);
    for (i = 0; i < 5; i++) {
        resid[i] = eqdot[i]-qdot[i];
    }
    for (i = 0; i < 5; i++) {
        resid[5+i] = uderrs[i];
    }
    srdsverr(&resid[10]);
    if (stabpos  !=  0.) {
        srdsperr(p0);
        for (i = 0; i < 5; i++) {
            resid[10+i] = resid[10+i]+stabpos*p0[i];
        }
    }
    for (i = 0; i < 5; i++) {
        udot[i] = eudot[i];
    }
    for (i = 0; i < 5; i++) {
        mult[i] = emults[i];
    }
    srdsrhs();
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   10 adds/subtracts/negates
                      5 multiplies
                      0 divides
                     25 assignments
*/
}

void srdsmult(double omults[5],
    int *owrank,
    int omultmap[5])
{
    int i;

    if (roustate != 3) {
        srdsseterr(34,24);
        return;
    }
    for (i = 0; i < 5; i++) {
        omults[i] = mult[i];
        if (i <= wrank-1) {
            omultmap[i] = multmap[i];
        } else {
            omultmap[i] = -1;
        }
    }
    *owrank = wrank;
}

void srdsreac(double force[6][3],
    double torque[6][3])
{
/*
Generated 24-Jun-2008 21:10:41 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/

    if (roustate != 3) {
        srdsseterr(31,24);
        return;
    }
/*
Compute reaction forces for non-weld tree joints
*/
    ffkb[4][0] = (mfk[4][0]+ufk[4][0]);
    ffkb[4][1] = (mfk[4][1]+ufk[4][1]);
    ffkb[4][2] = (mfk[4][2]+ufk[4][2]);
    ttkb[4][0] = (mtk[4][0]+utk[4][0]);
    ttkb[4][1] = (utk[4][1]+(mtk[4][1]-ltau[0]));
    ttkb[4][2] = (mtk[4][2]+utk[4][2]);
    fc[4][0] = ((mk[4]*(AnkAtk[4][0]-gk[3][0]))-ffkb[4][0]);
    fc[4][1] = -ffkb[4][1];
    fc[4][2] = ((mk[4]*(AnkAtk[4][2]-gk[3][2]))-ffkb[4][2]);
    tc[4][0] = -(ttkb[4][0]-(fc[4][1]*rk[4][2]));
    tc[4][1] = ((ik[4][1][1]*Onkb[3][1])-(ttkb[4][1]+((fc[4][0]*rk[4][2])-(
      fc[4][2]*rk[4][0]))));
    tc[4][2] = -(ttkb[4][2]+(fc[4][1]*rk[4][0]));
    fccikt[4][0] = fc[4][0];
    fccikt[4][1] = fc[4][1];
    fccikt[4][2] = fc[4][2];
    ffk[3][0] = (ufk[3][0]-fccikt[4][0]);
    ffk[3][1] = (ufk[3][1]-fccikt[4][1]);
    ffk[3][2] = (ufk[3][2]-fccikt[4][2]);
    ttk[3][0] = (utk[3][0]-(tc[4][0]-(fccikt[4][1]*rpri[4][2])));
    ttk[3][1] = (utk[3][1]-(tc[4][1]+((fccikt[4][0]*rpri[4][2])-(fccikt[4][2]*
      ri[4][0]))));
    ttk[3][2] = (utk[3][2]-(tc[4][2]+(fccikt[4][1]*ri[4][0])));
    fc[3][0] = ((mk[3]*(AnkAtk[3][0]-gk[3][0]))-ffk[3][0]);
    fc[3][1] = -ffk[3][1];
    fc[3][2] = ((mk[3]*(AnkAtk[3][2]-gk[3][2]))-ffk[3][2]);
    tc[3][0] = -(ttk[3][0]-(fc[3][1]*rk[3][2]));
    tc[3][1] = ((ik[3][1][1]*Onkb[3][1])-(ttk[3][1]+((fc[3][0]*rk[3][2])-(
      fc[3][2]*rk[3][0]))));
    tc[3][2] = -(ttk[3][2]+(fc[3][1]*rk[3][0]));
    fccikt[3][0] = ((fc[3][0]*c3)-(fc[3][2]*s3));
    fccikt[3][1] = fc[3][1];
    fccikt[3][2] = ((fc[3][0]*s3)+(fc[3][2]*c3));
    ffk[2][0] = (ufk[2][0]-fccikt[3][0]);
    ffk[2][1] = (ufk[2][1]-fccikt[3][1]);
    ffk[2][2] = (ufk[2][2]-fccikt[3][2]);
    ttk[2][0] = (utk[2][0]-(((tc[3][0]*c3)-(tc[3][2]*s3))-(fccikt[3][1]*ri[3][2]
      )));
    ttk[2][1] = (utk[2][1]-(tc[3][1]+((fccikt[3][0]*ri[3][2])-(fccikt[3][2]*
      ri[3][0]))));
    ttk[2][2] = (utk[2][2]-((fccikt[3][1]*ri[3][0])+((tc[3][0]*s3)+(tc[3][2]*c3)
      )));
    fc[2][0] = ((mk[2]*(AnkAtk[2][0]-gk[2][0]))-ffk[2][0]);
    fc[2][1] = -ffk[2][1];
    fc[2][2] = ((mk[2]*(AnkAtk[2][2]-gk[2][2]))-ffk[2][2]);
    tc[2][0] = -(ttk[2][0]-(fc[2][1]*rk[2][2]));
    tc[2][1] = ((ik[2][1][1]*Onkb[2][1])-(ttk[2][1]+((fc[2][0]*rk[2][2])-(
      fc[2][2]*rk[2][0]))));
    tc[2][2] = -(ttk[2][2]+(fc[2][1]*rk[2][0]));
    fccikt[2][0] = ((fc[2][0]*c2)-(fc[2][2]*s2));
    fccikt[2][1] = fc[2][1];
    fccikt[2][2] = ((fc[2][0]*s2)+(fc[2][2]*c2));
    ffk[1][0] = (ufk[1][0]-fccikt[2][0]);
    ffk[1][1] = (ufk[1][1]-fccikt[2][1]);
    ffk[1][2] = (ufk[1][2]-fccikt[2][2]);
    ttk[1][0] = (utk[1][0]-(((tc[2][0]*c2)-(tc[2][2]*s2))-(fccikt[2][1]*ri[2][2]
      )));
    ttk[1][1] = (utk[1][1]-(tc[2][1]+((fccikt[2][0]*ri[2][2])-(fccikt[2][2]*
      ri[2][0]))));
    ttk[1][2] = (utk[1][2]-((fccikt[2][1]*ri[2][0])+((tc[2][0]*s2)+(tc[2][2]*c2)
      )));
    fc[1][0] = ((mk[1]*(AnkAtk[1][0]+(9.81*s0)))-ffk[1][0]);
    fc[1][1] = -ffk[1][1];
    fc[1][2] = ((mk[1]*(AnkAtk[1][2]+(9.81*c0)))-ffk[1][2]);
    tc[1][0] = -(ttk[1][0]-(fc[1][1]*rk[1][2]));
    tc[1][1] = -((ik[1][1][1]*udot[0])+(ttk[1][1]+((fc[1][0]*rk[1][2])-(fc[1][2]
      *rk[1][0]))));
    tc[1][2] = -(ttk[1][2]+(fc[1][1]*rk[1][0]));
    fccikt[1][0] = fc[1][0];
    fccikt[1][1] = fc[1][1];
    fccikt[1][2] = fc[1][2];
    ffk[0][0] = (ufk[0][0]-fccikt[1][0]);
    ffk[0][1] = (ufk[0][1]-fccikt[1][1]);
    ffk[0][2] = (ufk[0][2]-fccikt[1][2]);
    ttk[0][0] = (utk[0][0]-(tc[1][0]-(fccikt[1][1]*rpri[1][2])));
    ttk[0][1] = (utk[0][1]-(tc[1][1]+((fccikt[1][0]*rpri[1][2])-(fccikt[1][2]*
      ri[1][0]))));
    ttk[0][2] = (utk[0][2]-(tc[1][2]+(fccikt[1][1]*ri[1][0])));
    fc[0][0] = ((mk[0]*(AnkAtk[0][0]+(9.81*s0)))-ffk[0][0]);
    fc[0][1] = -ffk[0][1];
    fc[0][2] = ((mk[0]*(AnkAtk[0][2]+(9.81*c0)))-ffk[0][2]);
    tc[0][0] = -(ttk[0][0]-(fc[0][1]*rk[0][2]));
    tc[0][1] = -((ik[0][1][1]*udot[0])+(ttk[0][1]+((fc[0][0]*rk[0][2])-(fc[0][2]
      *rk[0][0]))));
    tc[0][2] = -(ttk[0][2]+(fc[0][1]*rk[0][0]));
    force[0][0] = fc[0][0];
    torque[0][0] = tc[0][0];
    force[0][1] = fc[0][1];
    torque[0][1] = tc[0][1];
    force[0][2] = fc[0][2];
    torque[0][2] = tc[0][2];
    force[1][0] = fc[1][0];
    torque[1][0] = tc[1][0];
    force[1][1] = fc[1][1];
    torque[1][1] = tc[1][1];
    force[1][2] = fc[1][2];
    torque[1][2] = tc[1][2];
    force[2][0] = fc[2][0];
    torque[2][0] = tc[2][0];
    force[2][1] = fc[2][1];
    torque[2][1] = tc[2][1];
    force[2][2] = fc[2][2];
    torque[2][2] = tc[2][2];
    force[3][0] = fc[3][0];
    torque[3][0] = tc[3][0];
    force[3][1] = fc[3][1];
    torque[3][1] = tc[3][1];
    force[3][2] = fc[3][2];
    torque[3][2] = tc[3][2];
    force[4][0] = fc[4][0];
    torque[4][0] = tc[4][0];
    force[4][1] = fc[4][1];
    torque[4][1] = tc[4][1];
    force[4][2] = fc[4][2];
    torque[4][2] = tc[4][2];
/*
Compute reaction forces for loop joints
*/
    force[5][0] = lfc[0][0];
    torque[5][0] = ltc[0][0];
    force[5][1] = lfc[0][1];
    torque[5][1] = -ltau[0];
    force[5][2] = lfc[0][2];
    torque[5][2] = ltc[0][2];
/*
Compute reaction forces for tree weld joints
*/
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  118 adds/subtracts/negates
                     71 multiplies
                      0 divides
                    108 assignments
*/
}

void srdsmom(double lm[3],
    double am[3],
    double *ke)
{
/*
Compute system linear and angular momentum, and kinetic energy.

Generated 24-Jun-2008 21:10:41 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    double lk[5][3],hnk[5][3];

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(19,23);
        return;
    }
    lk[0][0] = (mk[0]*vnk[0][0]);
    lk[0][2] = (mk[0]*vnk[0][2]);
    lk[1][0] = (mk[1]*vnk[1][0]);
    lk[1][2] = (mk[1]*vnk[1][2]);
    lk[2][0] = (mk[2]*vnk[2][0]);
    lk[2][2] = (mk[2]*vnk[2][2]);
    lk[3][0] = (mk[3]*vnk[3][0]);
    lk[3][2] = (mk[3]*vnk[3][2]);
    lk[4][0] = (mk[4]*vnk[4][0]);
    lk[4][2] = (mk[4]*vnk[4][2]);
    hnk[0][1] = -(ik[0][1][1]*u[0]);
    hnk[1][1] = -(ik[1][1][1]*u[0]);
    hnk[2][1] = (ik[2][1][1]*wk[2][1]);
    hnk[3][1] = (ik[3][1][1]*wk[3][1]);
    hnk[4][1] = (ik[4][1][1]*wk[3][1]);
    lm[0] = (lk[4][0]+(lk[3][0]+(lk[2][0]+(lk[0][0]+lk[1][0]))));
    lm[1] = 0.;
    lm[2] = (lk[4][2]+(lk[3][2]+(lk[2][2]+(lk[0][2]+lk[1][2]))));
    am[0] = 0.;
    am[1] = (((hnk[4][1]+((lk[4][0]*rnk[4][2])-(lk[4][2]*rnk[4][0])))+((
      hnk[3][1]+((lk[3][0]*rnk[3][2])-(lk[3][2]*rnk[3][0])))+((hnk[2][1]+((
      lk[2][0]*rnk[2][2])-(lk[2][2]*rnk[2][0])))+((hnk[0][1]+((lk[0][0]*
      rnk[0][2])-(lk[0][2]*rnk[0][0])))+(hnk[1][1]+((lk[1][0]*rnk[1][2])-(
      lk[1][2]*rnk[1][0])))))))-((com[2]*lm[0])-(com[0]*lm[2])));
    am[2] = 0.;
    *ke = (.5*(((hnk[4][1]*wk[3][1])+((lk[4][0]*vnk[4][0])+(lk[4][2]*vnk[4][2]))
      )+(((hnk[3][1]*wk[3][1])+((lk[3][0]*vnk[3][0])+(lk[3][2]*vnk[3][2])))+(((
      hnk[2][1]*wk[2][1])+((lk[2][0]*vnk[2][0])+(lk[2][2]*vnk[2][2])))+((((
      lk[0][0]*vnk[0][0])+(lk[0][2]*vnk[0][2]))-(hnk[0][1]*u[0]))+(((lk[1][0]*
      vnk[1][0])+(lk[1][2]*vnk[1][2]))-(hnk[1][1]*u[0])))))));
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   40 adds/subtracts/negates
                     43 multiplies
                      0 divides
                     22 assignments
*/
}

void srdssys(double *mtoto,
    double cm[3],
    double icm[3][3])
{
/*
Compute system total mass, and instantaneous center of mass and
inertia matrix.

Generated 24-Jun-2008 21:10:41 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    double ikcnkt[5][3][3];

    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(20,23);
        return;
    }
    *mtoto = mtot;
    cm[0] = com[0];
    cm[1] = 0.;
    cm[2] = com[2];
    icm[0][0] = (2.+((((mk[4]*(rnk[4][2]*rnk[4][2]))+((cnk[3][0][0]*cnk[3][0][0]
      )+(cnk[3][0][2]*cnk[3][0][2])))+(((mk[3]*(rnk[3][2]*rnk[3][2]))+((
      cnk[3][0][0]*cnk[3][0][0])+(cnk[3][0][2]*cnk[3][0][2])))+(((mk[0]*(
      rnk[0][2]*rnk[0][2]))+(mk[1]*(rnk[1][2]*rnk[1][2])))+((mk[2]*(rnk[2][2]*
      rnk[2][2]))+((cnk[2][0][0]*cnk[2][0][0])+(cnk[2][0][2]*cnk[2][0][2]))))))-
      (mtot*(com[2]*com[2]))));
    icm[0][1] = 0.;
    icm[0][2] = ((mtot*(com[0]*com[2]))+((((cnk[3][0][0]*cnk[3][2][0])+(
      cnk[3][0][2]*cnk[3][2][2]))-(mk[4]*(rnk[4][0]*rnk[4][2])))+((((
      cnk[3][0][0]*cnk[3][2][0])+(cnk[3][0][2]*cnk[3][2][2]))-(mk[3]*(rnk[3][0]*
      rnk[3][2])))+((((cnk[2][0][0]*cnk[2][2][0])+(cnk[2][0][2]*cnk[2][2][2]))-(
      mk[2]*(rnk[2][0]*rnk[2][2])))-((mk[0]*(rnk[0][0]*rnk[0][2]))+(mk[1]*(
      rnk[1][0]*rnk[1][2])))))));
    icm[1][0] = icm[0][1];
    icm[1][1] = (((ik[4][1][1]+(mk[4]*((rnk[4][0]*rnk[4][0])+(rnk[4][2]*
      rnk[4][2]))))+((ik[3][1][1]+(mk[3]*((rnk[3][0]*rnk[3][0])+(rnk[3][2]*
      rnk[3][2]))))+((ik[2][1][1]+(mk[2]*((rnk[2][0]*rnk[2][0])+(rnk[2][2]*
      rnk[2][2]))))+((ik[0][1][1]+(mk[0]*((rnk[0][0]*rnk[0][0])+(rnk[0][2]*
      rnk[0][2]))))+(ik[1][1][1]+(mk[1]*((rnk[1][0]*rnk[1][0])+(rnk[1][2]*
      rnk[1][2]))))))))-(mtot*((com[0]*com[0])+(com[2]*com[2]))));
    icm[1][2] = 0.;
    icm[2][0] = icm[0][2];
    icm[2][1] = icm[1][2];
    icm[2][2] = (2.+((((mk[4]*(rnk[4][0]*rnk[4][0]))+((cnk[3][2][0]*cnk[3][2][0]
      )+(cnk[3][2][2]*cnk[3][2][2])))+(((mk[3]*(rnk[3][0]*rnk[3][0]))+((
      cnk[3][2][0]*cnk[3][2][0])+(cnk[3][2][2]*cnk[3][2][2])))+(((mk[0]*(
      rnk[0][0]*rnk[0][0]))+(mk[1]*(rnk[1][0]*rnk[1][0])))+((mk[2]*(rnk[2][0]*
      rnk[2][0]))+((cnk[2][2][0]*cnk[2][2][0])+(cnk[2][2][2]*cnk[2][2][2]))))))-
      (mtot*(com[0]*com[0]))));
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   51 adds/subtracts/negates
                     72 multiplies
                      0 divides
                     13 assignments
*/
}

void srdspos(int body,
    double pt[3],
    double loc[3])
{
/*
Return inertial frame location of a point on a body.

*/
    double pv[3];

    if (srdschkbnum(21,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(21,23);
        return;
    }
    if (body  ==  -1) {
        loc[0] = pt[0];
        loc[1] = pt[1];
        loc[2] = pt[2];
    } else {
        pv[0] = rnb[body][0]+pt[0]*cnb[body][0][0]+pt[1]*cnb[body][0][1]+pt[2]*
          cnb[body][0][2];
        pv[1] = rnb[body][1]+pt[0]*cnb[body][1][0]+pt[1]*cnb[body][1][1]+pt[2]*
          cnb[body][1][2];
        pv[2] = rnb[body][2]+pt[0]*cnb[body][2][0]+pt[1]*cnb[body][2][1]+pt[2]*
          cnb[body][2][2];
        loc[0] = pv[0];
        loc[1] = pv[1];
        loc[2] = pv[2];
    }
}

void srdsvel(int body,
    double pt[3],
    double velo[3])
{
/*
Return inertial frame velocity of a point on a body.

*/
    double pv[3];

    if (srdschkbnum(22,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(22,23);
        return;
    }
    if (body  ==  -1) {
        velo[0] = 0.;
        velo[1] = 0.;
        velo[2] = 0.;
    } else {
        pv[0] = wb[body][1]*pt[2]-wb[body][2]*pt[1];
        pv[1] = wb[body][2]*pt[0]-wb[body][0]*pt[2];
        pv[2] = wb[body][0]*pt[1]-wb[body][1]*pt[0];
        velo[0] = vnb[body][0]+pv[0]*cnb[body][0][0]+pv[1]*cnb[body][0][1]+pv[2]
          *cnb[body][0][2];
        velo[1] = vnb[body][1]+pv[0]*cnb[body][1][0]+pv[1]*cnb[body][1][1]+pv[2]
          *cnb[body][1][2];
        velo[2] = vnb[body][2]+pv[0]*cnb[body][2][0]+pv[1]*cnb[body][2][1]+pv[2]
          *cnb[body][2][2];
    }
}

void srdsorient(int body,
    double dircos[3][3])
{
/*
Return orientation of body w.r.t. ground frame.

*/

    if (srdschkbnum(23,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(23,23);
        return;
    }
    if (body == -1) {
        dircos[0][0] = 1.;
        dircos[0][1] = 0.;
        dircos[0][2] = 0.;
        dircos[1][0] = 0.;
        dircos[1][1] = 1.;
        dircos[1][2] = 0.;
        dircos[2][0] = 0.;
        dircos[2][1] = 0.;
        dircos[2][2] = 1.;
    } else {
        dircos[0][0] = cnb[body][0][0];
        dircos[0][1] = cnb[body][0][1];
        dircos[0][2] = cnb[body][0][2];
        dircos[1][0] = cnb[body][1][0];
        dircos[1][1] = cnb[body][1][1];
        dircos[1][2] = cnb[body][1][2];
        dircos[2][0] = cnb[body][2][0];
        dircos[2][1] = cnb[body][2][1];
        dircos[2][2] = cnb[body][2][2];
    }
}

void srdsangvel(int body,
    double avel[3])
{
/*
Return angular velocity of the body.

*/

    if (srdschkbnum(24,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(24,23);
        return;
    }
    if (body == -1) {
        avel[0] = 0.;
        avel[1] = 0.;
        avel[2] = 0.;
    } else {
        avel[0] = wb[body][0];
        avel[1] = wb[body][1];
        avel[2] = wb[body][2];
    }
}

void srdstrans(int frbod,
    double ivec[3],
    int tobod,
    double ovec[3])
{
/*
Transform ivec from frbod frame to tobod frame.

*/
    double pv[3];

    if (srdschkbnum(25,frbod) != 0) {
        return;
    }
    if (srdschkbnum(25,tobod) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(25,23);
        return;
    }
    if (frbod == tobod) {
        srdsvcopy(ivec,ovec);
        return;
    }
    if (frbod == -1) {
        srdsvcopy(ivec,pv);
        ovec[0] = pv[0]*cnb[tobod][0][0]+pv[1]*cnb[tobod][1][0]+pv[2]*cnb[tobod
          ][2][0];
        ovec[1] = pv[0]*cnb[tobod][0][1]+pv[1]*cnb[tobod][1][1]+pv[2]*cnb[tobod
          ][2][1];
        ovec[2] = pv[0]*cnb[tobod][0][2]+pv[1]*cnb[tobod][1][2]+pv[2]*cnb[tobod
          ][2][2];
        return;
    }
    if (tobod == -1) {
        srdsvcopy(ivec,pv);
        ovec[0] = pv[0]*cnb[frbod][0][0]+pv[1]*cnb[frbod][0][1]+pv[2]*cnb[frbod
          ][0][2];
        ovec[1] = pv[0]*cnb[frbod][1][0]+pv[1]*cnb[frbod][1][1]+pv[2]*cnb[frbod
          ][1][2];
        ovec[2] = pv[0]*cnb[frbod][2][0]+pv[1]*cnb[frbod][2][1]+pv[2]*cnb[frbod
          ][2][2];
        return;
    }
    pv[0] = ivec[0]*cnb[frbod][0][0]+ivec[1]*cnb[frbod][0][1]+ivec[2]*cnb[frbod
      ][0][2];
    pv[1] = ivec[0]*cnb[frbod][1][0]+ivec[1]*cnb[frbod][1][1]+ivec[2]*cnb[frbod
      ][1][2];
    pv[2] = ivec[0]*cnb[frbod][2][0]+ivec[1]*cnb[frbod][2][1]+ivec[2]*cnb[frbod
      ][2][2];
    ovec[0] = pv[0]*cnb[tobod][0][0]+pv[1]*cnb[tobod][1][0]+pv[2]*cnb[tobod][2][
      0];
    ovec[1] = pv[0]*cnb[tobod][0][1]+pv[1]*cnb[tobod][1][1]+pv[2]*cnb[tobod][2][
      1];
    ovec[2] = pv[0]*cnb[tobod][0][2]+pv[1]*cnb[tobod][1][2]+pv[2]*cnb[tobod][2][
      2];
}

void srdsrel2cart(int coord,
    int body,
    double point[3],
    double linchg[3],
    double rotchg[3])
{
/* Return derivative of pt loc and body orient w.r.t. hinge rate
*/
    int x,i,gnd;
    double lin[3],pv[3];

    if ((coord < 0) || (coord > 4)) {
        srdsseterr(59,45);
        return;
    }
    if (srdschkbnum(59,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        srdsseterr(59,23);
        return;
    }
    gnd = -1;
    if (body == gnd) {
        x = -1;
    } else {
        x = firstq[body]+njntdof[body]-1;
    }
    if (x < coord) {
        srdsvset(0.,0.,0.,linchg);
        srdsvset(0.,0.,0.,rotchg);
        return;
    }
    srdsdovpk();
    for (i = 0; i < 3; i++) {
        rotchg[i] = Wpk[coord][x][i];
        lin[i] = Vpk[coord][x][i];
    }
    if (body == gnd) {
        srdsvcopy(point,pv);
    } else {
        pv[0] = rcom[body][0]+point[0];
        pv[1] = rcom[body][1]+point[1];
        pv[2] = rcom[body][2]+point[2];
    }
    srdsvcross(rotchg,pv,linchg);
    srdsvadd(linchg,lin,linchg);
}

void srdsacc(int body,
    double pt[3],
    double accel[3])
{
/*
Return linear acceleration a point of the specified body.

*/
    double pv[3];

    if (srdschkbnum(32,body) != 0) {
        return;
    }
    if (roustate != 3) {
        srdsseterr(32,24);
        return;
    }
    if (body  ==  -1) {
        accel[0] = 0.;
        accel[1] = 0.;
        accel[2] = 0.;
    } else {
        pv[0] = pt[0]*dyad[body][0][0]+pt[1]*dyad[body][0][1]+pt[2]*dyad[body][0
          ][2];
        pv[1] = pt[0]*dyad[body][1][0]+pt[1]*dyad[body][1][1]+pt[2]*dyad[body][1
          ][2];
        pv[2] = pt[0]*dyad[body][2][0]+pt[1]*dyad[body][2][1]+pt[2]*dyad[body][2
          ][2];
        accel[0] = anb[body][0]+pv[0]*cnb[body][0][0]+pv[1]*cnb[body][0][1]+pv[2
          ]*cnb[body][0][2];
        accel[1] = anb[body][1]+pv[0]*cnb[body][1][0]+pv[1]*cnb[body][1][1]+pv[2
          ]*cnb[body][1][2];
        accel[2] = anb[body][2]+pv[0]*cnb[body][2][0]+pv[1]*cnb[body][2][1]+pv[2
          ]*cnb[body][2][2];
    }
}

void srdsangacc(int body,
    double aacc[3])
{
/*
Return angular acceleration of the body.

*/

    if (srdschkbnum(33,body) != 0) {
        return;
    }
    if (roustate != 3) {
        srdsseterr(33,24);
        return;
    }
    if (body == -1) {
        aacc[0] = 0.;
        aacc[1] = 0.;
        aacc[2] = 0.;
    } else {
        aacc[0] = onb[body][0];
        aacc[1] = onb[body][1];
        aacc[2] = onb[body][2];
    }
}

void srdsgrav(double gravin[3])
{

    srdsseterr(1,19);
    roustate = 0;
}

void srdsmass(int body,
    double massin)
{

    if (srdschkbnum(2,body) != 0) {
        return;
    }
    if (body == -1) {
        srdsseterr(2,15);
        return;
    }
    if (mkq[body] != 0) {
        mk[body] = massin;
        mkq[body] = 3;
    } else {
        srdsseterr(2,19);
    }
    roustate = 0;
}

void srdsiner(int body,
    double inerin[3][3])
{
    int anyques;

    if (srdschkbnum(3,body) != 0) {
        return;
    }
    if (body == -1) {
        srdsseterr(3,15);
        return;
    }
    anyques = 0;
    if (ikq[body][0][0]  !=  0) {
        ik[body][0][0] = inerin[0][0];
        ikq[body][0][0] = 3;
        anyques = 1;
    }
    if (ikq[body][0][1]  !=  0) {
        ik[body][0][1] = inerin[0][1];
        ikq[body][0][1] = 3;
        ik[body][1][0] = inerin[0][1];
        ikq[body][1][0] = 3;
        anyques = 1;
    }
    if (ikq[body][0][2]  !=  0) {
        ik[body][0][2] = inerin[0][2];
        ikq[body][0][2] = 3;
        ik[body][2][0] = inerin[0][2];
        ikq[body][2][0] = 3;
        anyques = 1;
    }
    if (ikq[body][1][1]  !=  0) {
        ik[body][1][1] = inerin[1][1];
        ikq[body][1][1] = 3;
        anyques = 1;
    }
    if (ikq[body][1][2]  !=  0) {
        ik[body][1][2] = inerin[1][2];
        ikq[body][1][2] = 3;
        ik[body][2][1] = inerin[1][2];
        ikq[body][2][1] = 3;
        anyques = 1;
    }
    if (ikq[body][2][2]  !=  0) {
        ik[body][2][2] = inerin[2][2];
        ikq[body][2][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        srdsseterr(3,19);
    }
    roustate = 0;
}

void srdsbtj(int joint,
    double btjin[3])
{
    int anyques;

    if (srdschkjnum(4,joint) != 0) {
        return;
    }
    anyques = 0;
    if (joint  >  4) {
        if (lbtjq[joint-5][0]  !=  0) {
            lbtj[joint-5][0] = btjin[0];
            lbtjq[joint-5][0] = 3;
            anyques = 1;
        }
        if (lbtjq[joint-5][1]  !=  0) {
            lbtj[joint-5][1] = btjin[1];
            lbtjq[joint-5][1] = 3;
            anyques = 1;
        }
        if (lbtjq[joint-5][2]  !=  0) {
            lbtj[joint-5][2] = btjin[2];
            lbtjq[joint-5][2] = 3;
            anyques = 1;
        }
    } else {
        if (rkq[joint][0]  !=  0) {
            rk[joint][0] = btjin[0];
            rkq[joint][0] = 3;
            anyques = 1;
        }
        if (rkq[joint][1]  !=  0) {
            rk[joint][1] = btjin[1];
            rkq[joint][1] = 3;
            anyques = 1;
        }
        if (rkq[joint][2]  !=  0) {
            rk[joint][2] = btjin[2];
            rkq[joint][2] = 3;
            anyques = 1;
        }
    }
    if (anyques == 0) {
        srdsseterr(4,19);
    }
    roustate = 0;
}

void srdsitj(int joint,
    double itjin[3])
{
    int anyques;

    if (srdschkjnum(5,joint) != 0) {
        return;
    }
    anyques = 0;
    if (joint  >  4) {
        if (litjq[joint-5][0]  !=  0) {
            litj[joint-5][0] = itjin[0];
            litjq[joint-5][0] = 3;
            anyques = 1;
        }
        if (litjq[joint-5][1]  !=  0) {
            litj[joint-5][1] = itjin[1];
            litjq[joint-5][1] = 3;
            anyques = 1;
        }
        if (litjq[joint-5][2]  !=  0) {
            litj[joint-5][2] = itjin[2];
            litjq[joint-5][2] = 3;
            anyques = 1;
        }
    } else {
        if (riq[joint][0]  !=  0) {
            ri[joint][0] = itjin[0];
            riq[joint][0] = 3;
            anyques = 1;
        }
        if (riq[joint][1]  !=  0) {
            ri[joint][1] = itjin[1];
            riq[joint][1] = 3;
            anyques = 1;
        }
        if (riq[joint][2]  !=  0) {
            ri[joint][2] = itjin[2];
            riq[joint][2] = 3;
            anyques = 1;
        }
    }
    if (anyques == 0) {
        srdsseterr(5,19);
    }
    roustate = 0;
}

void srdspin(int joint,
    int pinno,
    double pinin[3])
{
    int ljnum,anyques,offs;

    if (srdschkjpin(6,joint,pinno) != 0) {
        return;
    }
    anyques = 0;
    if (joint  >  4) {
        ljnum = joint-5;
        if (pinno  ==  0) {
            if (inbpin1q[ljnum][0]  !=  0) {
                inbpin1[ljnum][0] = pinin[0];
                inbpin1q[ljnum][0] = 3;
                anyques = 1;
            }
            if (inbpin1q[ljnum][1]  !=  0) {
                inbpin1[ljnum][1] = pinin[1];
                inbpin1q[ljnum][1] = 3;
                anyques = 1;
            }
            if (inbpin1q[ljnum][2]  !=  0) {
                inbpin1[ljnum][2] = pinin[2];
                inbpin1q[ljnum][2] = 3;
                anyques = 1;
            }
        }
        if (pinno  ==  1) {
            if (inbpin2q[ljnum][0]  !=  0) {
                inbpin2[ljnum][0] = pinin[0];
                inbpin2q[ljnum][0] = 3;
                anyques = 1;
            }
            if (inbpin2q[ljnum][1]  !=  0) {
                inbpin2[ljnum][1] = pinin[1];
                inbpin2q[ljnum][1] = 3;
                anyques = 1;
            }
            if (inbpin2q[ljnum][2]  !=  0) {
                inbpin2[ljnum][2] = pinin[2];
                inbpin2q[ljnum][2] = 3;
                anyques = 1;
            }
        }
        if (pinno  ==  2) {
            if (inbpin3q[ljnum][0]  !=  0) {
                inbpin3[ljnum][0] = pinin[0];
                inbpin3q[ljnum][0] = 3;
                anyques = 1;
            }
            if (inbpin3q[ljnum][1]  !=  0) {
                inbpin3[ljnum][1] = pinin[1];
                inbpin3q[ljnum][1] = 3;
                anyques = 1;
            }
            if (inbpin3q[ljnum][2]  !=  0) {
                inbpin3[ljnum][2] = pinin[2];
                inbpin3q[ljnum][2] = 3;
                anyques = 1;
            }
        }
        if (pinno  ==  3) {
            if (inbrefq[ljnum][0]  !=  0) {
                inbref[ljnum][0] = pinin[0];
                inbrefq[ljnum][0] = 3;
                anyques = 1;
            }
            if (inbrefq[ljnum][1]  !=  0) {
                inbref[ljnum][1] = pinin[1];
                inbrefq[ljnum][1] = 3;
                anyques = 1;
            }
            if (inbrefq[ljnum][2]  !=  0) {
                inbref[ljnum][2] = pinin[2];
                inbrefq[ljnum][2] = 3;
                anyques = 1;
            }
        }
        if (pinno  ==  4) {
            if (bodypinq[ljnum][0]  !=  0) {
                bodypin[ljnum][0] = pinin[0];
                bodypinq[ljnum][0] = 3;
                anyques = 1;
            }
            if (bodypinq[ljnum][1]  !=  0) {
                bodypin[ljnum][1] = pinin[1];
                bodypinq[ljnum][1] = 3;
                anyques = 1;
            }
            if (bodypinq[ljnum][2]  !=  0) {
                bodypin[ljnum][2] = pinin[2];
                bodypinq[ljnum][2] = 3;
                anyques = 1;
            }
        }
        if (pinno  ==  5) {
            if (bodyrefq[ljnum][0]  !=  0) {
                bodyref[ljnum][0] = pinin[0];
                bodyrefq[ljnum][0] = 3;
                anyques = 1;
            }
            if (bodyrefq[ljnum][1]  !=  0) {
                bodyref[ljnum][1] = pinin[1];
                bodyrefq[ljnum][1] = 3;
                anyques = 1;
            }
            if (bodyrefq[ljnum][2]  !=  0) {
                bodyref[ljnum][2] = pinin[2];
                bodyrefq[ljnum][2] = 3;
                anyques = 1;
            }
        }
    } else {
        offs = firstq[joint]+pinno;
        if (jtype[joint] == 21) {
            offs = offs+3;
        }
        if (jtype[joint] == 11) {
            offs = offs+1;
        }
        if (pinq[offs][0]  !=  0) {
            pin[offs][0] = pinin[0];
            pinq[offs][0] = 3;
            anyques = 1;
        }
        if (pinq[offs][1]  !=  0) {
            pin[offs][1] = pinin[1];
            pinq[offs][1] = 3;
            anyques = 1;
        }
        if (pinq[offs][2]  !=  0) {
            pin[offs][2] = pinin[2];
            pinq[offs][2] = 3;
            anyques = 1;
        }
    }
    if (anyques == 0) {
        srdsseterr(6,19);
    }
    roustate = 0;
}

void srdspres(int joint,
    int axis,
    int presin)
{
    int anyques;

    if (srdschkjaxis(37,joint,axis) != 0) {
        return;
    }
    if ((presin != 0) && (presin != 1)) {
        srdsseterr(37,20);
    }
    anyques = 0;
    if (joint  >  4) {
        if (lpresq[srdsindx(joint,axis)]  !=  0) {
            if (presin  !=  0) {
                lpres[srdsindx(joint,axis)] = 1.;
            } else {
                lpres[srdsindx(joint,axis)] = 0.;
            }
            lpresq[srdsindx(joint,axis)] = 3;
            anyques = 1;
        }
    } else {
        if (presq[srdsindx(joint,axis)]  !=  0) {
            if (presin  !=  0) {
                pres[srdsindx(joint,axis)] = 1.;
            } else {
                pres[srdsindx(joint,axis)] = 0.;
            }
            presq[srdsindx(joint,axis)] = 3;
            anyques = 1;
        }
    }
    if (anyques == 0) {
        srdsseterr(37,19);
    }
    wwflg = 0;
}

void srdsconschg(void)
{

    wwflg = 0;
}

void srdsstab(double velin,
    double posin)
{

    stabvel = velin;
    stabvelq = 3;
    stabpos = posin;
    stabposq = 3;
}

void srdsgetgrav(double gravout[3])
{

    gravout[0] = grav[0];
    gravout[1] = grav[1];
    gravout[2] = grav[2];
}

void srdsgetmass(int body,
    double *massout)
{

    if (srdschkbnum(40,body) != 0) {
        return;
    }
    if (body == -1) {
        srdsseterr(40,15);
        return;
    }
    *massout = mk[body];
}

void srdsgetiner(int body,
    double inerout[3][3])
{

    if (srdschkbnum(41,body) != 0) {
        return;
    }
    if (body == -1) {
        srdsseterr(41,15);
        return;
    }
    inerout[0][0] = ik[body][0][0];
    inerout[0][1] = ik[body][0][1];
    inerout[0][2] = ik[body][0][2];
    inerout[1][0] = ik[body][1][0];
    inerout[1][1] = ik[body][1][1];
    inerout[1][2] = ik[body][1][2];
    inerout[2][0] = ik[body][2][0];
    inerout[2][1] = ik[body][2][1];
    inerout[2][2] = ik[body][2][2];
}

void srdsgetbtj(int joint,
    double btjout[3])
{

    if (srdschkjnum(42,joint) != 0) {
        return;
    }
    if (joint  >  4) {
        btjout[0] = lbtj[joint-5][0];
        btjout[1] = lbtj[joint-5][1];
        btjout[2] = lbtj[joint-5][2];
    } else {
        btjout[0] = rk[joint][0];
        btjout[1] = rk[joint][1];
        btjout[2] = rk[joint][2];
    }
}

void srdsgetitj(int joint,
    double itjout[3])
{

    if (srdschkjnum(43,joint) != 0) {
        return;
    }
    if (joint  >  4) {
        itjout[0] = litj[joint-5][0];
        itjout[1] = litj[joint-5][1];
        itjout[2] = litj[joint-5][2];
    } else {
        itjout[0] = ri[joint][0];
        itjout[1] = ri[joint][1];
        itjout[2] = ri[joint][2];
    }
}

void srdsgetpin(int joint,
    int pinno,
    double pinout[3])
{
    int ljnum,offs;

    if (srdschkjpin(44,joint,pinno) != 0) {
        return;
    }
    if (joint  >  4) {
        ljnum = joint-5;
        if (pinno  ==  0) {
            pinout[0] = inbpin1[ljnum][0];
            pinout[1] = inbpin1[ljnum][1];
            pinout[2] = inbpin1[ljnum][2];
        }
        if (pinno  ==  1) {
            pinout[0] = inbpin2[ljnum][0];
            pinout[1] = inbpin2[ljnum][1];
            pinout[2] = inbpin2[ljnum][2];
        }
        if (pinno  ==  2) {
            pinout[0] = inbpin3[ljnum][0];
            pinout[1] = inbpin3[ljnum][1];
            pinout[2] = inbpin3[ljnum][2];
        }
        if (pinno  ==  3) {
            pinout[0] = inbref[ljnum][0];
            pinout[1] = inbref[ljnum][1];
            pinout[2] = inbref[ljnum][2];
        }
        if (pinno  ==  4) {
            pinout[0] = bodypin[ljnum][0];
            pinout[1] = bodypin[ljnum][1];
            pinout[2] = bodypin[ljnum][2];
        }
        if (pinno  ==  5) {
            pinout[0] = bodyref[ljnum][0];
            pinout[1] = bodyref[ljnum][1];
            pinout[2] = bodyref[ljnum][2];
        }
    } else {
        offs = firstq[joint]+pinno;
        if (jtype[joint] == 21) {
            offs = offs+3;
        }
        if (jtype[joint] == 11) {
            offs = offs+1;
        }
        pinout[0] = pin[offs][0];
        pinout[1] = pin[offs][1];
        pinout[2] = pin[offs][2];
    }
}

void srdsgetpres(int joint,
    int axis,
    int *presout)
{

    if (srdschkjaxis(45,joint,axis) != 0) {
        return;
    }
    if (joint  >  4) {
        if (lpres[srdsindx(joint,axis)]  !=  0.) {
            *presout = 1;
        } else {
            *presout = 0;
        }
    } else {
        if (pres[srdsindx(joint,axis)]  !=  0.) {
            *presout = 1;
        } else {
            *presout = 0;
        }
    }
}

void srdsgetstab(double *velout,
    double *posout)
{

    *velout = stabvel;
    *posout = stabpos;
}

void srdsinfo(int info[50])
{

    info[0] = ground;
    info[1] = nbod;
    info[2] = ndof;
    info[3] = ncons;
    info[4] = nloop;
    info[5] = nldof;
    info[6] = nloopc;
    info[7] = nball;
    info[8] = nlball;
    info[9] = npres;
    info[10] = nuser;
    info[11] = 2;
/* info entries from 12-49 are reserved */
}

void srdsjnt(int joint,
    int info[50],
    int tran[6])
{
    int i,offs;

    if (srdschkjnum(48,joint) != 0) {
        return;
    }
    info[0] = jtype[joint];
    if (joint  <=  4) {
        info[1] = 0;
        offs = 0;
    } else {
        info[1] = 1;
        offs = 5;
    }
    info[2] = inb[joint];
    info[3] = outb[joint];
    info[4] = njntdof[joint];
    info[5] = njntc[joint];
    info[6] = njntp[joint];
    info[7] = firstq[joint];
    info[8] = ballq[joint];
    info[9] = firstm[joint];
    info[10] = firstp[joint];
/* info entries from 11-49 are reserved */

    for (i = 0; i <= 5; i++) {
        if (i  <  njntdof[joint]) {
            tran[i] = trans[offs+firstq[joint]+i];
        } else {
            tran[i] = -1;
        }
    }
}

void srdscons(int consno,
    int info[50])
{

    if (srdschkucnum(49,consno) != 0) {
        return;
    }
/* There are no user constraints in this problem. */
}

void srdsgentime(int *gentm)
{

    *gentm = 211041;
}
/*
Done. CPU seconds used: 0.27  Memory used: 1687552 bytes.
Equation complexity:
  sdstate:   134 adds   152 multiplies     2 divides   230 assignments
  sdderiv:   523 adds   484 multiplies    14 divides   792 assignments
  sdresid:   253 adds   181 multiplies     0 divides   265 assignments
  sdreac:    118 adds    71 multiplies     0 divides   108 assignments
  sdmom:      40 adds    43 multiplies     0 divides    22 assignments
  sdsys:      51 adds    72 multiplies     0 divides    13 assignments
*/
