/*
Generated 27-Jun-2008 21:07:29 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041


ROADMAP (sra.sd)

Bodies        Inb
No  Name      body Joint type  Coords q
--- --------- ---- ----------- ----------------
 -1 $ground                                    
  0 torso      -1  Planar        0   1   2     
  1 l.thigh     0  Pin           3             
  2 l.calf      1  Sliding       4             
  3 r.thigh     0  Pin           5             
  4 r.calf      3  Sliding       6             

*/
#include <math.h>
#include <stdio.h>

typedef struct {
    int ground_,nbod_,ndof_,ncons_,nloop_,nldof_,nloopc_,nball_,nlball_,npres_,
      nuser_;
    int jtype_[5],inb_[5],outb_[5],njntdof_[5],njntc_[5],njntp_[5],firstq_[5],
      ballq_[5],firstm_[5],firstp_[5];
    int trans_[7];
} sragtopo_t;
#define ground (sragtopo.ground_)
#define nbod (sragtopo.nbod_)
#define ndof (sragtopo.ndof_)
#define ncons (sragtopo.ncons_)
#define nloop (sragtopo.nloop_)
#define nldof (sragtopo.nldof_)
#define nloopc (sragtopo.nloopc_)
#define nball (sragtopo.nball_)
#define nlball (sragtopo.nlball_)
#define npres (sragtopo.npres_)
#define nuser (sragtopo.nuser_)
#define jtype (sragtopo.jtype_)
#define inb (sragtopo.inb_)
#define outb (sragtopo.outb_)
#define njntdof (sragtopo.njntdof_)
#define njntc (sragtopo.njntc_)
#define njntp (sragtopo.njntp_)
#define firstq (sragtopo.firstq_)
#define ballq (sragtopo.ballq_)
#define firstm (sragtopo.firstm_)
#define firstp (sragtopo.firstp_)
#define trans (sragtopo.trans_)

typedef struct {
    double grav_[3],mk_[5],ik_[5][3][3],pin_[7][3];
    double rk_[5][3],ri_[5][3],pres_[7],stabvel_,stabpos_;
    int mfrcflg_,roustate_,vpkflg_,inerflg_,mmflg_,mmlduflg_,wwflg_,ltauflg_,
      fs0flg_,ii_,mmap_[7];
    int gravq_[3],mkq_[5],ikq_[5][3][3],pinq_[7][3],rkq_[5][3],riq_[5][3],presq_
      [7],stabvelq_,stabposq_;
    double mtot_,psmkg_,rhead_[5][3],rcom_[5][3],mkrcomt_[5][3][3],psikg_[3][3],
      psrcomg_[3],psrkg_[3],psrig_[3],psmk_[7],psik_[7][3][3],psrcom_[7][3],
      psrk_[7][3],psri_[7][3];
} sraginput_t;
#define grav (sraginput.grav_)
#define mk (sraginput.mk_)
#define ik (sraginput.ik_)
#define pin (sraginput.pin_)
#define rk (sraginput.rk_)
#define ri (sraginput.ri_)
#define pres (sraginput.pres_)
#define stabvel (sraginput.stabvel_)
#define stabpos (sraginput.stabpos_)
#define rhead (sraginput.rhead_)
#define rcom (sraginput.rcom_)
#define psrcomg (sraginput.psrcomg_)
#define psrcom (sraginput.psrcom_)
#define mkrcomt (sraginput.mkrcomt_)
#define psmk (sraginput.psmk_)
#define psik (sraginput.psik_)
#define psrk (sraginput.psrk_)
#define psri (sraginput.psri_)
#define psmkg (sraginput.psmkg_)
#define psikg (sraginput.psikg_)
#define psrkg (sraginput.psrkg_)
#define psrig (sraginput.psrig_)
#define mtot (sraginput.mtot_)
#define mfrcflg (sraginput.mfrcflg_)
#define roustate (sraginput.roustate_)
#define vpkflg (sraginput.vpkflg_)
#define inerflg (sraginput.inerflg_)
#define mmflg (sraginput.mmflg_)
#define mmlduflg (sraginput.mmlduflg_)
#define wwflg (sraginput.wwflg_)
#define ltauflg (sraginput.ltauflg_)
#define fs0flg (sraginput.fs0flg_)
#define ii (sraginput.ii_)
#define mmap (sraginput.mmap_)
#define gravq (sraginput.gravq_)
#define mkq (sraginput.mkq_)
#define ikq (sraginput.ikq_)
#define pinq (sraginput.pinq_)
#define rkq (sraginput.rkq_)
#define riq (sraginput.riq_)
#define presq (sraginput.presq_)
#define stabvelq (sraginput.stabvelq_)
#define stabposq (sraginput.stabposq_)

typedef struct {
    double curtim_,q_[7],qn_[7],u_[7],cnk_[7][3][3],cnb_[5][3][3];
    double rnk_[7][3],vnk_[7][3],wk_[7][3],rnb_[5][3],vnb_[5][3],wb_[5][3],
      wbrcom_[5][3],com_[3],rnkg_[3];
    double Cik_[7][3][3],rikt_[7][3][3],Iko_[7][3][3],mkrk_[7][3][3],Cib_[5][3][
      3];
    double Wkk_[7][3],Vkk_[7][3],dik_[7][3],rpp_[7][3],rpk_[7][3],rik_[7][3],
      rik2_[7][3];
    double rpri_[7][3],Wik_[7][3],Vik_[7][3],Wirk_[7][3],rkWkk_[7][3],Wkrpk_[7][
      3],VikWkr_[7][3];
    double perr_[1],verr_[1],aerr_[1],mult_[1],ufk_[5][3],utk_[5][3],mfk_[5][3],
      mtk_[5][3];
    double utau_[7],mtau_[7],uacc_[7],uvel_[7],upos_[7];
    double s2_,c2_,s3_,c3_,s5_,c5_;
} sragstate_t;
#define curtim (sragstate.curtim_)
#define q (sragstate.q_)
#define qn (sragstate.qn_)
#define u (sragstate.u_)
#define cnk (sragstate.cnk_)
#define cnb (sragstate.cnb_)
#define rnkg (sragstate.rnkg_)
#define rnk (sragstate.rnk_)
#define rnb (sragstate.rnb_)
#define vnk (sragstate.vnk_)
#define vnb (sragstate.vnb_)
#define wk (sragstate.wk_)
#define wb (sragstate.wb_)
#define com (sragstate.com_)
#define Cik (sragstate.Cik_)
#define Cib (sragstate.Cib_)
#define rikt (sragstate.rikt_)
#define Iko (sragstate.Iko_)
#define mkrk (sragstate.mkrk_)
#define Wkk (sragstate.Wkk_)
#define Vkk (sragstate.Vkk_)
#define dik (sragstate.dik_)
#define rpp (sragstate.rpp_)
#define rpk (sragstate.rpk_)
#define rik (sragstate.rik_)
#define rik2 (sragstate.rik2_)
#define rpri (sragstate.rpri_)
#define Wik (sragstate.Wik_)
#define Vik (sragstate.Vik_)
#define Wirk (sragstate.Wirk_)
#define rkWkk (sragstate.rkWkk_)
#define Wkrpk (sragstate.Wkrpk_)
#define VikWkr (sragstate.VikWkr_)
#define wbrcom (sragstate.wbrcom_)
#define perr (sragstate.perr_)
#define verr (sragstate.verr_)
#define aerr (sragstate.aerr_)
#define mult (sragstate.mult_)
#define ufk (sragstate.ufk_)
#define utk (sragstate.utk_)
#define utau (sragstate.utau_)
#define mfk (sragstate.mfk_)
#define mtk (sragstate.mtk_)
#define mtau (sragstate.mtau_)
#define uacc (sragstate.uacc_)
#define uvel (sragstate.uvel_)
#define upos (sragstate.upos_)
#define s2 (sragstate.s2_)
#define c2 (sragstate.c2_)
#define s3 (sragstate.s3_)
#define c3 (sragstate.c3_)
#define s5 (sragstate.s5_)
#define c5 (sragstate.c5_)

typedef struct {
    double fs0_[7],qdot_[7],Otk_[7][3],Atk_[7][3],AiOiWi_[7][3],Fstar_[7][3];
    double Tstar_[7][3],Fstark_[7][3],Tstark_[7][3],IkWk_[7][3],WkIkWk_[7][3],
      gk_[7][3],IkbWk_[5][3],WkIkbWk_[5][3];
    double w0w0_[5],w1w1_[5],w2w2_[5],w0w1_[5],w0w2_[5],w1w2_[5];
    double w00w11_[5],w00w22_[5],w11w22_[5],ww_[1][1],qraux_[1];
    double mm_[7][7],mlo_[7][7],mdi_[7],IkWpk_[7][7][3],works_[7],workss_[7][7];
    double Wpk_[7][7][3],Vpk_[7][7][3],VWri_[7][7][3];
    int wmap_[1],multmap_[1],jpvt_[1],wsiz_,wrank_;
} sraglhs_t;
#define qdot (sraglhs.qdot_)
#define Otk (sraglhs.Otk_)
#define Atk (sraglhs.Atk_)
#define AiOiWi (sraglhs.AiOiWi_)
#define Fstar (sraglhs.Fstar_)
#define Tstar (sraglhs.Tstar_)
#define fs0 (sraglhs.fs0_)
#define Fstark (sraglhs.Fstark_)
#define Tstark (sraglhs.Tstark_)
#define IkWk (sraglhs.IkWk_)
#define IkbWk (sraglhs.IkbWk_)
#define WkIkWk (sraglhs.WkIkWk_)
#define WkIkbWk (sraglhs.WkIkbWk_)
#define gk (sraglhs.gk_)
#define w0w0 (sraglhs.w0w0_)
#define w1w1 (sraglhs.w1w1_)
#define w2w2 (sraglhs.w2w2_)
#define w0w1 (sraglhs.w0w1_)
#define w0w2 (sraglhs.w0w2_)
#define w1w2 (sraglhs.w1w2_)
#define w00w11 (sraglhs.w00w11_)
#define w00w22 (sraglhs.w00w22_)
#define w11w22 (sraglhs.w11w22_)
#define ww (sraglhs.ww_)
#define qraux (sraglhs.qraux_)
#define mm (sraglhs.mm_)
#define mlo (sraglhs.mlo_)
#define mdi (sraglhs.mdi_)
#define IkWpk (sraglhs.IkWpk_)
#define works (sraglhs.works_)
#define workss (sraglhs.workss_)
#define Wpk (sraglhs.Wpk_)
#define Vpk (sraglhs.Vpk_)
#define VWri (sraglhs.VWri_)
#define wmap (sraglhs.wmap_)
#define multmap (sraglhs.multmap_)
#define jpvt (sraglhs.jpvt_)
#define wsiz (sraglhs.wsiz_)
#define wrank (sraglhs.wrank_)

typedef struct {
    double fs_[7],udot_[7],tauc_[7],dyad_[5][3][3],fc_[7][3],tc_[7][3];
    double ank_[7][3],onk_[7][3],Onkb_[7][3],AOnkri_[7][3],Ankb_[7][3],AnkAtk_[7
      ][3],anb_[5][3],onb_[5][3],dyrcom_[5][3];
    double ffk_[7][3],ttk_[7][3],fccikt_[7][3],ffkb_[5][3],ttkb_[5][3];
} sragrhs_t;
#define fs (sragrhs.fs_)
#define udot (sragrhs.udot_)
#define ank (sragrhs.ank_)
#define anb (sragrhs.anb_)
#define onk (sragrhs.onk_)
#define onb (sragrhs.onb_)
#define Onkb (sragrhs.Onkb_)
#define AOnkri (sragrhs.AOnkri_)
#define Ankb (sragrhs.Ankb_)
#define AnkAtk (sragrhs.AnkAtk_)
#define dyrcom (sragrhs.dyrcom_)
#define ffk (sragrhs.ffk_)
#define ttk (sragrhs.ttk_)
#define fccikt (sragrhs.fccikt_)
#define ffkb (sragrhs.ffkb_)
#define ttkb (sragrhs.ttkb_)
#define dyad (sragrhs.dyad_)
#define fc (sragrhs.fc_)
#define tc (sragrhs.tc_)
#define tauc (sragrhs.tauc_)

typedef struct {
    double temp_[3000],tmat1_[3][3],tmat2_[3][3],tvec1_[3],tvec2_[3],tvec3_[3],
      tvec4_[3],tvec5_[3];
    double tsc1_,tsc2_,tsc3_;
} sragtemp_t;
#define temp (sragtemp.temp_)
#define tmat1 (sragtemp.tmat1_)
#define tmat2 (sragtemp.tmat2_)
#define tvec1 (sragtemp.tvec1_)
#define tvec2 (sragtemp.tvec2_)
#define tvec3 (sragtemp.tvec3_)
#define tvec4 (sragtemp.tvec4_)
#define tvec5 (sragtemp.tvec5_)
#define tsc1 (sragtemp.tsc1_)
#define tsc2 (sragtemp.tsc2_)
#define tsc3 (sragtemp.tsc3_)

sragtopo_t sragtopo = {
/*  Topological information
*/
    /* ground */ 1,
    /* nbod */ 5,
    /* ndof */ 7,
    /* ncons */ 0,
    /* nloop */ 0,
    /* nldof */ 0,
    /* nloopc */ 0,
    /* nball */ 0,
    /* nlball */ 0,
    /* npres */ 0,
    /* nuser */ 0,
    /* jtype[0] */ 8,
    /* jtype[1] */ 1,
    /* jtype[2] */ 5,
    /* jtype[3] */ 1,
    /* jtype[4] */ 5,
    /* inb[0] */ -1,
    /* inb[1] */ 0,
    /* inb[2] */ 1,
    /* inb[3] */ 0,
    /* inb[4] */ 3,
    /* outb[0] */ 0,
    /* outb[1] */ 1,
    /* outb[2] */ 2,
    /* outb[3] */ 3,
    /* outb[4] */ 4,
    /* njntdof[0] */ 3,
    /* njntdof[1] */ 1,
    /* njntdof[2] */ 1,
    /* njntdof[3] */ 1,
    /* njntdof[4] */ 1,
    /* njntc[0] */ 0,
    /* njntc[1] */ 0,
    /* njntc[2] */ 0,
    /* njntc[3] */ 0,
    /* njntc[4] */ 0,
    /* njntp[0] */ 0,
    /* njntp[1] */ 0,
    /* njntp[2] */ 0,
    /* njntp[3] */ 0,
    /* njntp[4] */ 0,
    /* firstq[0] */ 0,
    /* firstq[1] */ 3,
    /* firstq[2] */ 4,
    /* firstq[3] */ 5,
    /* firstq[4] */ 6,
    /* ballq[0] */ -104,
    /* ballq[1] */ -104,
    /* ballq[2] */ -104,
    /* ballq[3] */ -104,
    /* ballq[4] */ -104,
    /* firstm[0] */ -1,
    /* firstm[1] */ -1,
    /* firstm[2] */ -1,
    /* firstm[3] */ -1,
    /* firstm[4] */ -1,
    /* firstp[0] */ -1,
    /* firstp[1] */ -1,
    /* firstp[2] */ -1,
    /* firstp[3] */ -1,
    /* firstp[4] */ -1,
    /* trans[0] */ 1,
    /* trans[1] */ 1,
    /* trans[2] */ 0,
    /* trans[3] */ 0,
    /* trans[4] */ 1,
    /* trans[5] */ 0,
    /* trans[6] */ 1,
};
sraginput_t sraginput = {
/* Model parameters from the input file */

/* gravity */
    /* grav[0] */ 0.,
    /* grav[1] */ 0.,
    /* grav[2] */ -9.81,

/* mass */
    /* mk[0] */ 50.,
    /* mk[1] */ 5.676,
    /* mk[2] */ 6.8952,
    /* mk[3] */ 5.676,
    /* mk[4] */ 6.8952,

/* inertia */
    /* ik[0][0][0] */ 1.,
    /* ik[0][0][1] */ 0.,
    /* ik[0][0][2] */ 0.,
    /* ik[0][1][0] */ 0.,
    /* ik[0][1][1] */ 1.5,
    /* ik[0][1][2] */ 0.,
    /* ik[0][2][0] */ 0.,
    /* ik[0][2][1] */ 0.,
    /* ik[0][2][2] */ 1.,
    /* ik[1][0][0] */ 1.,
    /* ik[1][0][1] */ 0.,
    /* ik[1][0][2] */ 0.,
    /* ik[1][1][0] */ 0.,
    /* ik[1][1][1] */ .09592,
    /* ik[1][1][2] */ 0.,
    /* ik[1][2][0] */ 0.,
    /* ik[1][2][1] */ 0.,
    /* ik[1][2][2] */ 1.,
    /* ik[2][0][0] */ 1.,
    /* ik[2][0][1] */ 0.,
    /* ik[2][0][2] */ 0.,
    /* ik[2][1][0] */ 0.,
    /* ik[2][1][1] */ .1535,
    /* ik[2][1][2] */ 0.,
    /* ik[2][2][0] */ 0.,
    /* ik[2][2][1] */ 0.,
    /* ik[2][2][2] */ 1.,
    /* ik[3][0][0] */ 1.,
    /* ik[3][0][1] */ 0.,
    /* ik[3][0][2] */ 0.,
    /* ik[3][1][0] */ 0.,
    /* ik[3][1][1] */ .09592,
    /* ik[3][1][2] */ 0.,
    /* ik[3][2][0] */ 0.,
    /* ik[3][2][1] */ 0.,
    /* ik[3][2][2] */ 1.,
    /* ik[4][0][0] */ 1.,
    /* ik[4][0][1] */ 0.,
    /* ik[4][0][2] */ 0.,
    /* ik[4][1][0] */ 0.,
    /* ik[4][1][1] */ .1535,
    /* ik[4][1][2] */ 0.,
    /* ik[4][2][0] */ 0.,
    /* ik[4][2][1] */ 0.,
    /* ik[4][2][2] */ 1.,

/* tree hinge axis vectors */
    /* pin[0][0] */ 1.,
    /* pin[0][1] */ 0.,
    /* pin[0][2] */ 0.,
    /* pin[1][0] */ 0.,
    /* pin[1][1] */ 0.,
    /* pin[1][2] */ 1.,
    /* pin[2][0] */ 0.,
    /* pin[2][1] */ -1.,
    /* pin[2][2] */ 0.,
    /* pin[3][0] */ 0.,
    /* pin[3][1] */ -1.,
    /* pin[3][2] */ 0.,
    /* pin[4][0] */ 0.,
    /* pin[4][1] */ 0.,
    /* pin[4][2] */ -1.,
    /* pin[5][0] */ 0.,
    /* pin[5][1] */ -1.,
    /* pin[5][2] */ 0.,
    /* pin[6][0] */ 0.,
    /* pin[6][1] */ 0.,
    /* pin[6][2] */ -1.,

/* tree bodytojoint vectors */
    /* rk[0][0] */ 0.,
    /* rk[0][1] */ 0.,
    /* rk[0][2] */ 0.,
    /* rk[1][0] */ 0.,
    /* rk[1][1] */ 0.,
    /* rk[1][2] */ .1898,
    /* rk[2][0] */ 0.,
    /* rk[2][1] */ 0.,
    /* rk[2][2] */ .2384,
    /* rk[3][0] */ 0.,
    /* rk[3][1] */ 0.,
    /* rk[3][2] */ .1898,
    /* rk[4][0] */ 0.,
    /* rk[4][1] */ 0.,
    /* rk[4][2] */ .2384,

/* tree inbtojoint vectors */
    /* ri[0][0] */ 0.,
    /* ri[0][1] */ 0.,
    /* ri[0][2] */ 0.,
    /* ri[1][0] */ -.0889,
    /* ri[1][1] */ 0.,
    /* ri[1][2] */ -.2868,
    /* ri[2][0] */ 0.,
    /* ri[2][1] */ 0.,
    /* ri[2][2] */ -.202,
    /* ri[3][0] */ .0889,
    /* ri[3][1] */ 0.,
    /* ri[3][2] */ -.2868,
    /* ri[4][0] */ 0.,
    /* ri[4][1] */ 0.,
    /* ri[4][2] */ -.202,

/* tree prescribed motion */
    /* pres[0] */ 0.,
    /* pres[1] */ 0.,
    /* pres[2] */ 0.,
    /* pres[3] */ 0.,
    /* pres[4] */ 0.,
    /* pres[5] */ 0.,
    /* pres[6] */ 0.,

/* stabilization parameters */
    /* stabvel */ 0.,
    /* stabpos */ 0.,

/* miscellaneous */
    /* mfrcflg */ 0,
    /* roustate */ 0,
    /* vpkflg */ 0,
    /* inerflg */ 0,
    /* mmflg */ 0,
    /* mmlduflg */ 0,
    /* wwflg */ 0,
    /* ltauflg */ 0,
    /* fs0flg */ 0,
    /* ii */ 0,
    /* mmap[0] */ 0,
    /* mmap[1] */ 1,
    /* mmap[2] */ 2,
    /* mmap[3] */ 3,
    /* mmap[4] */ 4,
    /* mmap[5] */ 5,
    /* mmap[6] */ 6,

/* Which parameters were "?" (1) or "<nominal>?" (3) */
    /* gravq[0] */ 0,
    /* gravq[1] */ 0,
    /* gravq[2] */ 0,
    /* mkq[0] */ 3,
    /* mkq[1] */ 3,
    /* mkq[2] */ 3,
    /* mkq[3] */ 3,
    /* mkq[4] */ 3,
    /* ikq[0][0][0] */ 0,
    /* ikq[0][0][1] */ 0,
    /* ikq[0][0][2] */ 0,
    /* ikq[0][1][0] */ 0,
    /* ikq[0][1][1] */ 3,
    /* ikq[0][1][2] */ 0,
    /* ikq[0][2][0] */ 0,
    /* ikq[0][2][1] */ 0,
    /* ikq[0][2][2] */ 0,
    /* ikq[1][0][0] */ 0,
    /* ikq[1][0][1] */ 0,
    /* ikq[1][0][2] */ 0,
    /* ikq[1][1][0] */ 0,
    /* ikq[1][1][1] */ 3,
    /* ikq[1][1][2] */ 0,
    /* ikq[1][2][0] */ 0,
    /* ikq[1][2][1] */ 0,
    /* ikq[1][2][2] */ 0,
    /* ikq[2][0][0] */ 0,
    /* ikq[2][0][1] */ 0,
    /* ikq[2][0][2] */ 0,
    /* ikq[2][1][0] */ 0,
    /* ikq[2][1][1] */ 3,
    /* ikq[2][1][2] */ 0,
    /* ikq[2][2][0] */ 0,
    /* ikq[2][2][1] */ 0,
    /* ikq[2][2][2] */ 0,
    /* ikq[3][0][0] */ 0,
    /* ikq[3][0][1] */ 0,
    /* ikq[3][0][2] */ 0,
    /* ikq[3][1][0] */ 0,
    /* ikq[3][1][1] */ 3,
    /* ikq[3][1][2] */ 0,
    /* ikq[3][2][0] */ 0,
    /* ikq[3][2][1] */ 0,
    /* ikq[3][2][2] */ 0,
    /* ikq[4][0][0] */ 0,
    /* ikq[4][0][1] */ 0,
    /* ikq[4][0][2] */ 0,
    /* ikq[4][1][0] */ 0,
    /* ikq[4][1][1] */ 3,
    /* ikq[4][1][2] */ 0,
    /* ikq[4][2][0] */ 0,
    /* ikq[4][2][1] */ 0,
    /* ikq[4][2][2] */ 0,
    /* pinq[0][0] */ 0,
    /* pinq[0][1] */ 0,
    /* pinq[0][2] */ 0,
    /* pinq[1][0] */ 0,
    /* pinq[1][1] */ 0,
    /* pinq[1][2] */ 0,
    /* pinq[2][0] */ 0,
    /* pinq[2][1] */ 0,
    /* pinq[2][2] */ 0,
    /* pinq[3][0] */ 0,
    /* pinq[3][1] */ 0,
    /* pinq[3][2] */ 0,
    /* pinq[4][0] */ 0,
    /* pinq[4][1] */ 0,
    /* pinq[4][2] */ 0,
    /* pinq[5][0] */ 0,
    /* pinq[5][1] */ 0,
    /* pinq[5][2] */ 0,
    /* pinq[6][0] */ 0,
    /* pinq[6][1] */ 0,
    /* pinq[6][2] */ 0,
    /* rkq[0][0] */ 3,
    /* rkq[0][1] */ 0,
    /* rkq[0][2] */ 3,
    /* rkq[1][0] */ 3,
    /* rkq[1][1] */ 0,
    /* rkq[1][2] */ 3,
    /* rkq[2][0] */ 3,
    /* rkq[2][1] */ 0,
    /* rkq[2][2] */ 3,
    /* rkq[3][0] */ 3,
    /* rkq[3][1] */ 0,
    /* rkq[3][2] */ 3,
    /* rkq[4][0] */ 3,
    /* rkq[4][1] */ 0,
    /* rkq[4][2] */ 3,
    /* riq[0][0] */ 0,
    /* riq[0][1] */ 0,
    /* riq[0][2] */ 0,
    /* riq[1][0] */ 3,
    /* riq[1][1] */ 0,
    /* riq[1][2] */ 3,
    /* riq[2][0] */ 3,
    /* riq[2][1] */ 0,
    /* riq[2][2] */ 3,
    /* riq[3][0] */ 3,
    /* riq[3][1] */ 0,
    /* riq[3][2] */ 3,
    /* riq[4][0] */ 3,
    /* riq[4][1] */ 0,
    /* riq[4][2] */ 3,
    /* presq[0] */ 0,
    /* presq[1] */ 0,
    /* presq[2] */ 0,
    /* presq[3] */ 0,
    /* presq[4] */ 0,
    /* presq[5] */ 0,
    /* presq[6] */ 0,
    /* stabvelq */ 3,
    /* stabposq */ 3,

/* End of values from input file */

};
sragstate_t sragstate;
sraglhs_t sraglhs;
sragrhs_t sragrhs;
sragtemp_t sragtemp;


void srainit(void)
{
/*
Initialization routine


 This routine must be called before the first call to sdstate(), after
 supplying values for any `?' parameters in the input.
*/
    double sumsq,norminv;
    int i,j,k;


/* Check that all `?' parameters have been assigned values */

    for (k = 0; k < 3; k++) {
        if (gravq[k] == 1) {
            sraseterr(7,25);
        }
    }
    for (k = 0; k < 5; k++) {
        if (mkq[k] == 1) {
            sraseterr(7,26);
        }
        for (i = 0; i < 3; i++) {
            if (rkq[k][i] == 1) {
                sraseterr(7,29);
            }
            if (riq[k][i] == 1) {
                sraseterr(7,30);
            }
            for (j = 0; j < 3; j++) {
                if (ikq[k][i][j] == 1) {
                    sraseterr(7,27);
                }
            }
        }
    }
    for (k = 0; k < 7; k++) {
        for (i = 0; i < 3; i++) {
            if (pinq[k][i] == 1) {
                sraseterr(7,28);
            }
        }
    }

/* Normalize pin vectors if necessary */


/* Zero out Vpk and Wpk */

    for (i = 0; i < 7; i++) {
        for (j = i; j <= 6; j++) {
            for (k = 0; k < 3; k++) {
                Vpk[i][j][k] = 0.;
                Wpk[i][j][k] = 0.;
            }
        }
    }

/* Compute pseudobody-related constants */

    rcom[0][0] = 0.;
    rcom[0][1] = 0.;
    rcom[0][2] = 0.;
    rcom[1][0] = 0.;
    rcom[1][1] = 0.;
    rcom[1][2] = 0.;
    rcom[2][0] = 0.;
    rcom[2][1] = 0.;
    rcom[2][2] = 0.;
    rcom[3][0] = 0.;
    rcom[3][1] = 0.;
    rcom[3][2] = 0.;
    rcom[4][0] = 0.;
    rcom[4][1] = 0.;
    rcom[4][2] = 0.;
    dik[3][0] = (ri[1][0]-rk[0][0]);
    dik[3][2] = (ri[1][2]-rk[0][2]);
    dik[4][0] = (ri[2][0]-rk[1][0]);
    dik[4][2] = (ri[2][2]-rk[1][2]);
    dik[5][0] = (ri[3][0]-rk[0][0]);
    dik[5][2] = (ri[3][2]-rk[0][2]);
    dik[6][0] = (ri[4][0]-rk[3][0]);
    dik[6][2] = (ri[4][2]-rk[3][2]);

/* Compute mass properties-related constants */

    mtot = (mk[4]+(mk[3]+(mk[2]+(mk[0]+mk[1]))));
    mkrk[2][0][1] = -(mk[0]*rk[0][2]);
    mkrk[2][1][0] = (mk[0]*rk[0][2]);
    mkrk[2][1][2] = -(mk[0]*rk[0][0]);
    mkrk[2][2][1] = (mk[0]*rk[0][0]);
    mkrk[3][0][1] = -(mk[1]*rk[1][2]);
    mkrk[3][1][0] = (mk[1]*rk[1][2]);
    mkrk[3][1][2] = -(mk[1]*rk[1][0]);
    mkrk[3][2][1] = (mk[1]*rk[1][0]);
    mkrk[4][0][1] = -(mk[2]*rk[2][2]);
    mkrk[4][1][0] = (mk[2]*rk[2][2]);
    mkrk[4][1][2] = -(mk[2]*rk[2][0]);
    mkrk[4][2][1] = (mk[2]*rk[2][0]);
    mkrk[5][0][1] = -(mk[3]*rk[3][2]);
    mkrk[5][1][0] = (mk[3]*rk[3][2]);
    mkrk[5][1][2] = -(mk[3]*rk[3][0]);
    mkrk[5][2][1] = (mk[3]*rk[3][0]);
    mkrk[6][0][1] = -(mk[4]*rk[4][2]);
    mkrk[6][1][0] = (mk[4]*rk[4][2]);
    mkrk[6][1][2] = -(mk[4]*rk[4][0]);
    mkrk[6][2][1] = (mk[4]*rk[4][0]);
    Iko[2][0][0] = (1.-(mkrk[2][0][1]*rk[0][2]));
    Iko[2][0][2] = (mkrk[2][0][1]*rk[0][0]);
    Iko[2][1][1] = (ik[0][1][1]-((mkrk[2][1][2]*rk[0][0])-(mkrk[2][1][0]*
      rk[0][2])));
    Iko[2][2][0] = -(mkrk[2][2][1]*rk[0][2]);
    Iko[2][2][2] = (1.+(mkrk[2][2][1]*rk[0][0]));
    Iko[3][0][0] = (1.-(mkrk[3][0][1]*rk[1][2]));
    Iko[3][0][2] = (mkrk[3][0][1]*rk[1][0]);
    Iko[3][1][1] = (ik[1][1][1]-((mkrk[3][1][2]*rk[1][0])-(mkrk[3][1][0]*
      rk[1][2])));
    Iko[3][2][0] = -(mkrk[3][2][1]*rk[1][2]);
    Iko[3][2][2] = (1.+(mkrk[3][2][1]*rk[1][0]));
    Iko[4][0][0] = (1.-(mkrk[4][0][1]*rk[2][2]));
    Iko[4][0][2] = (mkrk[4][0][1]*rk[2][0]);
    Iko[4][1][1] = (ik[2][1][1]-((mkrk[4][1][2]*rk[2][0])-(mkrk[4][1][0]*
      rk[2][2])));
    Iko[4][2][0] = -(mkrk[4][2][1]*rk[2][2]);
    Iko[4][2][2] = (1.+(mkrk[4][2][1]*rk[2][0]));
    Iko[5][0][0] = (1.-(mkrk[5][0][1]*rk[3][2]));
    Iko[5][0][2] = (mkrk[5][0][1]*rk[3][0]);
    Iko[5][1][1] = (ik[3][1][1]-((mkrk[5][1][2]*rk[3][0])-(mkrk[5][1][0]*
      rk[3][2])));
    Iko[5][2][0] = -(mkrk[5][2][1]*rk[3][2]);
    Iko[5][2][2] = (1.+(mkrk[5][2][1]*rk[3][0]));
    Iko[6][0][0] = (1.-(mkrk[6][0][1]*rk[4][2]));
    Iko[6][0][2] = (mkrk[6][0][1]*rk[4][0]);
    Iko[6][1][1] = (ik[4][1][1]-((mkrk[6][1][2]*rk[4][0])-(mkrk[6][1][0]*
      rk[4][2])));
    Iko[6][2][0] = -(mkrk[6][2][1]*rk[4][2]);
    Iko[6][2][2] = (1.+(mkrk[6][2][1]*rk[4][0]));
    sraserialno(&i);
    if (i != 30123) {
        sraseterr(7,41);
    }
    roustate = 1;
}

/* Convert state to form using 1-2-3 Euler angles for ball joints. */

void srast2ang(double st[7],
    double stang[7])
{
    int i;

    for (i = 0; i < 7; i++) {
        stang[i] = st[i];
    }
}

/* Convert 1-2-3 form of state back to Euler parameters for ball joints. */

void sraang2st(double stang[7],
    double st[7])
{
    int i;

    for (i = 0; i < 7; i++) {
        st[i] = stang[i];
    }
}

/* Normalize Euler parameters in state. */

void sranrmsterr(double st[7],
    double normst[7],
    int routine)
{
    int i;

    for (i = 0; i < 7; i++) {
        normst[i] = st[i];
    }
}

void sranormst(double st[7],
    double normst[7])
{

    sranrmsterr(st,normst,0);
}

void srastate(double timein,
    double qin[7],
    double uin[7])
{
/*
Compute kinematic information and store it in sdgstate.

Generated 27-Jun-2008 21:07:30 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    int i,j,qchg,uchg;

    if ((roustate != 1) && (roustate != 2) && (roustate != 3)) {
        sraseterr(8,22);
        return;
    }
    if (roustate == 1) {
        for (i = 0; i < 7; i++) {
            if (presq[i] == 1) {
                sraseterr(8,31);
            }
        }
    }
/*
See if time or any qs have changed since last call
*/
    if ((roustate != 1) && (timein == curtim)) {
        qchg = 0;
        for (i = 0; i < 7; i++) {
            if (qin[i] != q[i]) {
                qchg = 1;
                break;
            }
        }
    } else {
        qchg = 1;
    }
/*
If time and qs are unchanged, check us
*/
    if (qchg == 0) {
        uchg = 0;
        for (i = 0; i < 7; i++) {
            if (uin[i] != u[i]) {
                uchg = 1;
                break;
            }
        }
    } else {
        uchg = 1;
    }
    curtim = timein;
    roustate = 2;
    if (qchg == 0) {
        goto skipqs;
    }
/*
Position-related variables need to be computed
*/
    vpkflg = 0;
    mmflg = 0;
    mmlduflg = 0;
    wwflg = 0;
    for (i = 0; i < 7; i++) {
        q[i] = qin[i];
    }
/*
Compute sines and cosines of q
*/
    s2 = sin(q[2]);
    c2 = cos(q[2]);
    s3 = sin(q[3]);
    c3 = cos(q[3]);
    s5 = sin(q[5]);
    c5 = cos(q[5]);
/*
Compute across-axis direction cosines Cik
*/
/*
Compute across-joint direction cosines Cib
*/
/*
Compute gravity
*/
    gk[3][0] = -(9.81*((s2*c3)+(s3*c2)));
    gk[3][2] = (9.81*((s2*s3)-(c2*c3)));
    gk[5][0] = -(9.81*((s2*c5)+(s5*c2)));
    gk[5][2] = (9.81*((s2*s5)-(c2*c5)));
/*
Compute cnk & cnb (direction cosines in N)
*/
    cnk[3][0][0] = ((c2*c3)-(s2*s3));
    cnk[3][0][2] = -((s2*c3)+(s3*c2));
    cnk[3][2][0] = ((s2*c3)+(s3*c2));
    cnk[3][2][2] = ((c2*c3)-(s2*s3));
    cnk[5][0][0] = ((c2*c5)-(s2*s5));
    cnk[5][0][2] = -((s2*c5)+(s5*c2));
    cnk[5][2][0] = ((s2*c5)+(s5*c2));
    cnk[5][2][2] = ((c2*c5)-(s2*s5));
    cnb[0][0][0] = c2;
    cnb[0][0][1] = 0.;
    cnb[0][0][2] = -s2;
    cnb[0][1][0] = 0.;
    cnb[0][1][1] = 1.;
    cnb[0][1][2] = 0.;
    cnb[0][2][0] = s2;
    cnb[0][2][1] = 0.;
    cnb[0][2][2] = c2;
    cnb[1][0][0] = cnk[3][0][0];
    cnb[1][0][1] = 0.;
    cnb[1][0][2] = cnk[3][0][2];
    cnb[1][1][0] = 0.;
    cnb[1][1][1] = 1.;
    cnb[1][1][2] = 0.;
    cnb[1][2][0] = cnk[3][2][0];
    cnb[1][2][1] = 0.;
    cnb[1][2][2] = cnk[3][2][2];
    cnb[2][0][0] = cnk[3][0][0];
    cnb[2][0][1] = 0.;
    cnb[2][0][2] = cnk[3][0][2];
    cnb[2][1][0] = 0.;
    cnb[2][1][1] = 1.;
    cnb[2][1][2] = 0.;
    cnb[2][2][0] = cnk[3][2][0];
    cnb[2][2][1] = 0.;
    cnb[2][2][2] = cnk[3][2][2];
    cnb[3][0][0] = cnk[5][0][0];
    cnb[3][0][1] = 0.;
    cnb[3][0][2] = cnk[5][0][2];
    cnb[3][1][0] = 0.;
    cnb[3][1][1] = 1.;
    cnb[3][1][2] = 0.;
    cnb[3][2][0] = cnk[5][2][0];
    cnb[3][2][1] = 0.;
    cnb[3][2][2] = cnk[5][2][2];
    cnb[4][0][0] = cnk[5][0][0];
    cnb[4][0][1] = 0.;
    cnb[4][0][2] = cnk[5][0][2];
    cnb[4][1][0] = 0.;
    cnb[4][1][1] = 1.;
    cnb[4][1][2] = 0.;
    cnb[4][2][0] = cnk[5][2][0];
    cnb[4][2][1] = 0.;
    cnb[4][2][2] = cnk[5][2][2];
/*
Compute q-related auxiliary variables
*/
    rpri[4][2] = (ri[2][2]-q[4]);
    rpri[6][2] = (ri[4][2]-q[6]);
    rpk[4][2] = -(q[4]+rk[2][2]);
    rpk[6][2] = -(q[6]+rk[4][2]);
    rik[3][0] = (((ri[1][0]*c3)+(ri[1][2]*s3))-rk[1][0]);
    rik[3][2] = (((ri[1][2]*c3)-(ri[1][0]*s3))-rk[1][2]);
    rik[4][0] = (ri[2][0]-rk[2][0]);
    rik[4][2] = (ri[2][2]+rpk[4][2]);
    rik[5][0] = (((ri[3][0]*c5)+(ri[3][2]*s5))-rk[3][0]);
    rik[5][2] = (((ri[3][2]*c5)-(ri[3][0]*s5))-rk[3][2]);
    rik[6][0] = (ri[4][0]-rk[4][0]);
    rik[6][2] = (ri[4][2]+rpk[6][2]);
/*
Compute rnk & rnb (mass center locations in N)
*/
    rnk[2][0] = (q[0]+((rk[0][2]*s2)-(rk[0][0]*c2)));
    rnk[2][2] = (q[1]-((rk[0][0]*s2)+(rk[0][2]*c2)));
    rnk[3][0] = ((rnk[2][0]+((ri[1][0]*c2)-(ri[1][2]*s2)))-((cnk[3][0][0]*
      rk[1][0])+(cnk[3][0][2]*rk[1][2])));
    rnk[3][2] = ((rnk[2][2]+((ri[1][0]*s2)+(ri[1][2]*c2)))-((cnk[3][2][0]*
      rk[1][0])+(cnk[3][2][2]*rk[1][2])));
    rnk[4][0] = ((rnk[3][0]+((cnk[3][0][0]*ri[2][0])+(cnk[3][0][2]*ri[2][2])))+(
      (cnk[3][0][2]*rpk[4][2])-(cnk[3][0][0]*rk[2][0])));
    rnk[4][2] = ((rnk[3][2]+((cnk[3][2][0]*ri[2][0])+(cnk[3][2][2]*ri[2][2])))+(
      (cnk[3][2][2]*rpk[4][2])-(cnk[3][2][0]*rk[2][0])));
    rnk[5][0] = ((rnk[2][0]+((ri[3][0]*c2)-(ri[3][2]*s2)))-((cnk[5][0][0]*
      rk[3][0])+(cnk[5][0][2]*rk[3][2])));
    rnk[5][2] = ((rnk[2][2]+((ri[3][0]*s2)+(ri[3][2]*c2)))-((cnk[5][2][0]*
      rk[3][0])+(cnk[5][2][2]*rk[3][2])));
    rnk[6][0] = ((rnk[5][0]+((cnk[5][0][0]*ri[4][0])+(cnk[5][0][2]*ri[4][2])))+(
      (cnk[5][0][2]*rpk[6][2])-(cnk[5][0][0]*rk[4][0])));
    rnk[6][2] = ((rnk[5][2]+((cnk[5][2][0]*ri[4][0])+(cnk[5][2][2]*ri[4][2])))+(
      (cnk[5][2][2]*rpk[6][2])-(cnk[5][2][0]*rk[4][0])));
    rnb[0][0] = rnk[2][0];
    rnb[0][1] = 0.;
    rnb[0][2] = rnk[2][2];
    rnb[1][0] = rnk[3][0];
    rnb[1][1] = 0.;
    rnb[1][2] = rnk[3][2];
    rnb[2][0] = rnk[4][0];
    rnb[2][1] = 0.;
    rnb[2][2] = rnk[4][2];
    rnb[3][0] = rnk[5][0];
    rnb[3][1] = 0.;
    rnb[3][2] = rnk[5][2];
    rnb[4][0] = rnk[6][0];
    rnb[4][1] = 0.;
    rnb[4][2] = rnk[6][2];
/*
Compute com (system mass center location in N)
*/
    com[0] = ((1./mtot)*((mk[4]*rnk[6][0])+((mk[3]*rnk[5][0])+((mk[2]*rnk[4][0])
      +((mk[0]*rnk[2][0])+(mk[1]*rnk[3][0]))))));
    com[1] = 0.;
    com[2] = ((1./mtot)*((mk[4]*rnk[6][2])+((mk[3]*rnk[5][2])+((mk[2]*rnk[4][2])
      +((mk[0]*rnk[2][2])+(mk[1]*rnk[3][2]))))));
    skipqs: ;
    if (uchg == 0) {
        goto skipus;
    }
/*
Velocity-related variables need to be computed
*/
    inerflg = 0;
    for (i = 0; i < 7; i++) {
        u[i] = uin[i];
    }
/*
Compute u-related auxiliary variables
*/
/*
Compute wk & wb (angular velocities)
*/
    wk[3][1] = -(u[2]+u[3]);
    wk[5][1] = -(u[2]+u[5]);
    wb[0][0] = 0.;
    wb[0][1] = -u[2];
    wb[0][2] = 0.;
    wb[1][0] = 0.;
    wb[1][1] = wk[3][1];
    wb[1][2] = 0.;
    wb[2][0] = 0.;
    wb[2][1] = wk[3][1];
    wb[2][2] = 0.;
    wb[3][0] = 0.;
    wb[3][1] = wk[5][1];
    wb[3][2] = 0.;
    wb[4][0] = 0.;
    wb[4][1] = wk[5][1];
    wb[4][2] = 0.;
/*
Compute auxiliary variables involving wk
*/
    Wirk[3][0] = -(ri[1][2]*u[2]);
    Wirk[3][2] = (ri[1][0]*u[2]);
    Wirk[4][0] = (ri[2][2]*wk[3][1]);
    Wirk[4][2] = -(ri[2][0]*wk[3][1]);
    Wirk[5][0] = -(ri[3][2]*u[2]);
    Wirk[5][2] = (ri[3][0]*u[2]);
    Wirk[6][0] = (ri[4][2]*wk[5][1]);
    Wirk[6][2] = -(ri[4][0]*wk[5][1]);
    Wkrpk[2][0] = (rk[0][2]*u[2]);
    Wkrpk[2][2] = -(rk[0][0]*u[2]);
    Wkrpk[3][0] = -(rk[1][2]*wk[3][1]);
    Wkrpk[3][2] = (rk[1][0]*wk[3][1]);
    Wkrpk[4][0] = (rpk[4][2]*wk[3][1]);
    Wkrpk[4][2] = (rk[2][0]*wk[3][1]);
    Wkrpk[5][0] = -(rk[3][2]*wk[5][1]);
    Wkrpk[5][2] = (rk[3][0]*wk[5][1]);
    Wkrpk[6][0] = (rpk[6][2]*wk[5][1]);
    Wkrpk[6][2] = (rk[4][0]*wk[5][1]);
    VikWkr[4][2] = (Wkrpk[4][2]-u[4]);
    VikWkr[6][2] = (Wkrpk[6][2]-u[6]);
    IkWk[2][1] = -(ik[0][1][1]*u[2]);
    IkWk[3][1] = (ik[1][1][1]*wk[3][1]);
    IkWk[4][1] = (ik[2][1][1]*wk[3][1]);
    IkWk[5][1] = (ik[3][1][1]*wk[5][1]);
    IkWk[6][1] = (ik[4][1][1]*wk[5][1]);
/*
Compute temporaries for use in SDRHS
*/
    w1w1[0] = (u[2]*u[2]);
    w1w1[1] = (wk[3][1]*wk[3][1]);
    w1w1[2] = (wk[3][1]*wk[3][1]);
    w1w1[3] = (wk[5][1]*wk[5][1]);
    w1w1[4] = (wk[5][1]*wk[5][1]);
/*
Compute vnk & vnb (mass center linear velocities in N)
*/
    vnk[2][0] = (u[0]+((Wkrpk[2][0]*c2)-(Wkrpk[2][2]*s2)));
    vnk[2][2] = (u[1]+((Wkrpk[2][0]*s2)+(Wkrpk[2][2]*c2)));
    vnk[3][0] = ((vnk[2][0]+((Wirk[3][0]*c2)-(Wirk[3][2]*s2)))+((cnk[3][0][0]*
      Wkrpk[3][0])+(cnk[3][0][2]*Wkrpk[3][2])));
    vnk[3][2] = ((vnk[2][2]+((Wirk[3][0]*s2)+(Wirk[3][2]*c2)))+((cnk[3][2][0]*
      Wkrpk[3][0])+(cnk[3][2][2]*Wkrpk[3][2])));
    vnk[4][0] = ((vnk[3][0]+((cnk[3][0][0]*Wirk[4][0])+(cnk[3][0][2]*Wirk[4][2])
      ))+((cnk[3][0][0]*Wkrpk[4][0])+(cnk[3][0][2]*VikWkr[4][2])));
    vnk[4][2] = ((vnk[3][2]+((cnk[3][2][0]*Wirk[4][0])+(cnk[3][2][2]*Wirk[4][2])
      ))+((cnk[3][2][0]*Wkrpk[4][0])+(cnk[3][2][2]*VikWkr[4][2])));
    vnk[5][0] = ((vnk[2][0]+((Wirk[5][0]*c2)-(Wirk[5][2]*s2)))+((cnk[5][0][0]*
      Wkrpk[5][0])+(cnk[5][0][2]*Wkrpk[5][2])));
    vnk[5][2] = ((vnk[2][2]+((Wirk[5][0]*s2)+(Wirk[5][2]*c2)))+((cnk[5][2][0]*
      Wkrpk[5][0])+(cnk[5][2][2]*Wkrpk[5][2])));
    vnk[6][0] = ((vnk[5][0]+((cnk[5][0][0]*Wirk[6][0])+(cnk[5][0][2]*Wirk[6][2])
      ))+((cnk[5][0][0]*Wkrpk[6][0])+(cnk[5][0][2]*VikWkr[6][2])));
    vnk[6][2] = ((vnk[5][2]+((cnk[5][2][0]*Wirk[6][0])+(cnk[5][2][2]*Wirk[6][2])
      ))+((cnk[5][2][0]*Wkrpk[6][0])+(cnk[5][2][2]*VikWkr[6][2])));
    vnb[0][0] = vnk[2][0];
    vnb[0][1] = 0.;
    vnb[0][2] = vnk[2][2];
    vnb[1][0] = vnk[3][0];
    vnb[1][1] = 0.;
    vnb[1][2] = vnk[3][2];
    vnb[2][0] = vnk[4][0];
    vnb[2][1] = 0.;
    vnb[2][2] = vnk[4][2];
    vnb[3][0] = vnk[5][0];
    vnb[3][1] = 0.;
    vnb[3][2] = vnk[5][2];
    vnb[4][0] = vnk[6][0];
    vnb[4][1] = 0.;
    vnb[4][2] = vnk[6][2];
/*
Compute qdot (kinematical equations)
*/
    qdot[0] = u[0];
    qdot[1] = u[1];
    qdot[2] = u[2];
    qdot[3] = u[3];
    qdot[4] = u[4];
    qdot[5] = u[5];
    qdot[6] = u[6];
    skipus: ;
/*
Initialize applied forces and torques to zero
*/
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 3; j++) {
            ufk[i][j] = 0.;
            utk[i][j] = 0.;
        }
    }
    for (i = 0; i < 7; i++) {
        utau[i] = 0.;
    }
    ltauflg = 0;
    fs0flg = 0;
/*
 Used 0.02 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  130 adds/subtracts/negates
                    148 multiplies
                      2 divides
                    227 assignments
*/
}

void sraqdot(double oqdot[7])
{
/*
Return position coordinate derivatives for tree joints.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(63,23);
        return;
    }
    for (i = 0; i <= 6; i++) {
        oqdot[i] = qdot[i];
    }
}

void srau2qdot(double uin[7],
    double oqdot[7])
{
/*
Convert velocities to qdots.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(64,23);
        return;
    }
    for (i = 0; i <= 6; i++) {
        oqdot[i] = uin[i];
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      7 assignments
*/
}

void srapsstate(double lqin[1])
{

    if (roustate != 2) {
        sraseterr(9,23);
        return;
    }
}

void sradovpk(void)
{

    if (vpkflg == 0) {
/*
Compute Wpk (partial angular velocities)
*/
        Wpk[2][2][1] = -1.;
        Wpk[2][3][1] = -1.;
        Wpk[2][4][1] = -1.;
        Wpk[2][5][1] = -1.;
        Wpk[2][6][1] = -1.;
        Wpk[3][3][1] = -1.;
        Wpk[3][4][1] = -1.;
        Wpk[5][5][1] = -1.;
        Wpk[5][6][1] = -1.;
/*
Compute Vpk (partial velocities)
*/
        Vpk[0][0][0] = 1.;
        Vpk[0][1][0] = 1.;
        Vpk[0][2][0] = c2;
        Vpk[0][2][2] = -s2;
        Vpk[0][3][0] = ((c2*c3)-(s2*s3));
        Vpk[0][3][2] = -((s2*c3)+(s3*c2));
        Vpk[0][4][0] = Vpk[0][3][0];
        Vpk[0][4][2] = Vpk[0][3][2];
        Vpk[0][5][0] = ((c2*c5)-(s2*s5));
        Vpk[0][5][2] = -((s2*c5)+(s5*c2));
        Vpk[0][6][0] = Vpk[0][5][0];
        Vpk[0][6][2] = Vpk[0][5][2];
        Vpk[1][1][2] = 1.;
        Vpk[1][2][0] = s2;
        Vpk[1][2][2] = c2;
        Vpk[1][3][0] = ((s2*c3)+(s3*c2));
        Vpk[1][3][2] = ((c2*c3)-(s2*s3));
        Vpk[1][4][0] = Vpk[1][3][0];
        Vpk[1][4][2] = Vpk[1][3][2];
        Vpk[1][5][0] = ((s2*c5)+(s5*c2));
        Vpk[1][5][2] = ((c2*c5)-(s2*s5));
        Vpk[1][6][0] = Vpk[1][5][0];
        Vpk[1][6][2] = Vpk[1][5][2];
        Vpk[2][2][0] = rk[0][2];
        Vpk[2][2][2] = -rk[0][0];
        VWri[2][3][0] = (rk[0][2]-ri[1][2]);
        VWri[2][3][2] = (ri[1][0]-rk[0][0]);
        Vpk[2][3][0] = (rk[1][2]+((VWri[2][3][0]*c3)+(VWri[2][3][2]*s3)));
        Vpk[2][3][2] = (((VWri[2][3][2]*c3)-(VWri[2][3][0]*s3))-rk[1][0]);
        VWri[2][4][0] = (Vpk[2][3][0]-ri[2][2]);
        VWri[2][4][2] = (ri[2][0]+Vpk[2][3][2]);
        Vpk[2][4][0] = (VWri[2][4][0]-rpk[4][2]);
        Vpk[2][4][2] = (VWri[2][4][2]-rk[2][0]);
        VWri[2][5][0] = (rk[0][2]-ri[3][2]);
        VWri[2][5][2] = (ri[3][0]-rk[0][0]);
        Vpk[2][5][0] = (rk[3][2]+((VWri[2][5][0]*c5)+(VWri[2][5][2]*s5)));
        Vpk[2][5][2] = (((VWri[2][5][2]*c5)-(VWri[2][5][0]*s5))-rk[3][0]);
        VWri[2][6][0] = (Vpk[2][5][0]-ri[4][2]);
        VWri[2][6][2] = (ri[4][0]+Vpk[2][5][2]);
        Vpk[2][6][0] = (VWri[2][6][0]-rpk[6][2]);
        Vpk[2][6][2] = (VWri[2][6][2]-rk[4][0]);
        Vpk[3][3][0] = rk[1][2];
        Vpk[3][3][2] = -rk[1][0];
        VWri[3][4][0] = (rk[1][2]-ri[2][2]);
        VWri[3][4][2] = (ri[2][0]-rk[1][0]);
        Vpk[3][4][0] = (VWri[3][4][0]-rpk[4][2]);
        Vpk[3][4][2] = (VWri[3][4][2]-rk[2][0]);
        Vpk[4][4][2] = -1.;
        Vpk[5][5][0] = rk[3][2];
        Vpk[5][5][2] = -rk[3][0];
        VWri[5][6][0] = (rk[3][2]-ri[4][2]);
        VWri[5][6][2] = (ri[4][0]-rk[3][0]);
        Vpk[5][6][0] = (VWri[5][6][0]-rpk[6][2]);
        Vpk[5][6][2] = (VWri[5][6][2]-rk[4][0]);
        Vpk[6][6][2] = -1.;
        vpkflg = 1;
    }
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   42 adds/subtracts/negates
                     24 multiplies
                      0 divides
                     64 assignments
*/
}

void sradoltau(void)
{

/*
Compute effect of loop hinge torques
*/
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      0 assignments
*/
}

void sradoiner(void)
{

/*
Compute inertial accelerations and related temps
*/
    if (inerflg == 0) {
/*
Compute Otk (inertial angular acceleration)
*/
/*
Compute Atk (inertial linear acceleration)
*/
        Atk[2][0] = -(u[2]*Wkrpk[2][2]);
        Atk[2][2] = (u[2]*Wkrpk[2][0]);
        AiOiWi[3][0] = (Atk[2][0]-(u[2]*Wirk[3][2]));
        AiOiWi[3][2] = (Atk[2][2]+(u[2]*Wirk[3][0]));
        Atk[3][0] = ((wk[3][1]*Wkrpk[3][2])+((AiOiWi[3][0]*c3)+(AiOiWi[3][2]*s3)
          ));
        Atk[3][2] = (((AiOiWi[3][2]*c3)-(AiOiWi[3][0]*s3))-(wk[3][1]*Wkrpk[3][0]
          ));
        AiOiWi[4][0] = (Atk[3][0]+(Wirk[4][2]*wk[3][1]));
        AiOiWi[4][2] = (Atk[3][2]-(Wirk[4][0]*wk[3][1]));
        Atk[4][0] = (AiOiWi[4][0]+((wk[3][1]*Wkrpk[4][2])-(2.*(u[4]*wk[3][1]))))
          ;
        Atk[4][2] = (AiOiWi[4][2]-(wk[3][1]*Wkrpk[4][0]));
        AiOiWi[5][0] = (Atk[2][0]-(u[2]*Wirk[5][2]));
        AiOiWi[5][2] = (Atk[2][2]+(u[2]*Wirk[5][0]));
        Atk[5][0] = ((wk[5][1]*Wkrpk[5][2])+((AiOiWi[5][0]*c5)+(AiOiWi[5][2]*s5)
          ));
        Atk[5][2] = (((AiOiWi[5][2]*c5)-(AiOiWi[5][0]*s5))-(wk[5][1]*Wkrpk[5][0]
          ));
        AiOiWi[6][0] = (Atk[5][0]+(Wirk[6][2]*wk[5][1]));
        AiOiWi[6][2] = (Atk[5][2]-(Wirk[6][0]*wk[5][1]));
        Atk[6][0] = (AiOiWi[6][0]+((wk[5][1]*Wkrpk[6][2])-(2.*(u[6]*wk[5][1]))))
          ;
        Atk[6][2] = (AiOiWi[6][2]-(wk[5][1]*Wkrpk[6][0]));
        inerflg = 1;
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   23 adds/subtracts/negates
                     30 multiplies
                      0 divides
                     18 assignments
*/
}

void sradofs0(void)
{

/*
Compute effect of all applied loads
*/
    if (fs0flg == 0) {
        sradoltau();
        sradoiner();
/*
Compute Fstar (forces)
*/
        Fstar[2][0] = ((mk[0]*(Atk[2][0]+(9.81*s2)))-ufk[0][0]);
        Fstar[2][2] = ((mk[0]*(Atk[2][2]+(9.81*c2)))-ufk[0][2]);
        Fstar[3][0] = ((mk[1]*(Atk[3][0]-gk[3][0]))-ufk[1][0]);
        Fstar[3][2] = ((mk[1]*(Atk[3][2]-gk[3][2]))-ufk[1][2]);
        Fstar[4][0] = ((mk[2]*(Atk[4][0]-gk[3][0]))-ufk[2][0]);
        Fstar[4][2] = ((mk[2]*(Atk[4][2]-gk[3][2]))-ufk[2][2]);
        Fstar[5][0] = ((mk[3]*(Atk[5][0]-gk[5][0]))-ufk[3][0]);
        Fstar[5][2] = ((mk[3]*(Atk[5][2]-gk[5][2]))-ufk[3][2]);
        Fstar[6][0] = ((mk[4]*(Atk[6][0]-gk[5][0]))-ufk[4][0]);
        Fstar[6][2] = ((mk[4]*(Atk[6][2]-gk[5][2]))-ufk[4][2]);
/*
Compute Tstar (torques)
*/
/*
Compute fs0 (RHS ignoring constraints)
*/
        sradovpk();
        fs0[0] = (utau[0]-(((Fstar[6][0]*Vpk[0][5][0])+(Fstar[6][2]*Vpk[0][5][2]
          ))+(((Fstar[5][0]*Vpk[0][5][0])+(Fstar[5][2]*Vpk[0][5][2]))+(((
          Fstar[4][0]*Vpk[0][3][0])+(Fstar[4][2]*Vpk[0][3][2]))+(((Fstar[2][0]*
          c2)-(Fstar[2][2]*s2))+((Fstar[3][0]*Vpk[0][3][0])+(Fstar[3][2]*
          Vpk[0][3][2])))))));
        fs0[1] = (utau[1]-(((Fstar[6][0]*Vpk[1][5][0])+(Fstar[6][2]*Vpk[1][5][2]
          ))+(((Fstar[5][0]*Vpk[1][5][0])+(Fstar[5][2]*Vpk[1][5][2]))+(((
          Fstar[4][0]*Vpk[1][3][0])+(Fstar[4][2]*Vpk[1][3][2]))+(((Fstar[2][0]*
          s2)+(Fstar[2][2]*c2))+((Fstar[3][0]*Vpk[1][3][0])+(Fstar[3][2]*
          Vpk[1][3][2])))))));
        fs0[2] = (utau[2]-((utk[4][1]+((Fstar[6][0]*Vpk[2][6][0])+(Fstar[6][2]*
          Vpk[2][6][2])))+((utk[3][1]+((Fstar[5][0]*Vpk[2][5][0])+(Fstar[5][2]*
          Vpk[2][5][2])))+((utk[2][1]+((Fstar[4][0]*Vpk[2][4][0])+(Fstar[4][2]*
          Vpk[2][4][2])))+((utk[0][1]+((Fstar[2][0]*rk[0][2])-(Fstar[2][2]*
          rk[0][0])))+(utk[1][1]+((Fstar[3][0]*Vpk[2][3][0])+(Fstar[3][2]*
          Vpk[2][3][2]))))))));
        fs0[3] = (utau[3]-((utk[1][1]+((Fstar[3][0]*rk[1][2])-(Fstar[3][2]*
          rk[1][0])))+(utk[2][1]+((Fstar[4][0]*Vpk[3][4][0])+(Fstar[4][2]*
          Vpk[3][4][2])))));
        fs0[4] = (Fstar[4][2]+utau[4]);
        fs0[5] = (utau[5]-((utk[3][1]+((Fstar[5][0]*rk[3][2])-(Fstar[5][2]*
          rk[3][0])))+(utk[4][1]+((Fstar[6][0]*Vpk[5][6][0])+(Fstar[6][2]*
          Vpk[5][6][2])))));
        fs0[6] = (Fstar[6][2]+utau[6]);
        fs0flg = 1;
    }
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   69 adds/subtracts/negates
                     50 multiplies
                      0 divides
                     17 assignments
*/
}

void sradomm(int routine)
{
    int dumroutine,errnum;
    int i;

    if (mmflg == 0) {
/*
Compute mass matrix (MM)
*/
        sradovpk();
        mm[0][0] = ((mk[4]*((Vpk[0][5][0]*Vpk[0][5][0])+(Vpk[0][5][2]*
          Vpk[0][5][2])))+((mk[3]*((Vpk[0][5][0]*Vpk[0][5][0])+(Vpk[0][5][2]*
          Vpk[0][5][2])))+((mk[0]+(mk[1]*((Vpk[0][3][0]*Vpk[0][3][0])+(
          Vpk[0][3][2]*Vpk[0][3][2]))))+(mk[2]*((Vpk[0][3][0]*Vpk[0][3][0])+(
          Vpk[0][3][2]*Vpk[0][3][2]))))));
        mm[0][1] = ((mk[4]*((Vpk[0][5][0]*Vpk[1][5][0])+(Vpk[0][5][2]*
          Vpk[1][5][2])))+((mk[3]*((Vpk[0][5][0]*Vpk[1][5][0])+(Vpk[0][5][2]*
          Vpk[1][5][2])))+((mk[1]*((Vpk[0][3][0]*Vpk[1][3][0])+(Vpk[0][3][2]*
          Vpk[1][3][2])))+(mk[2]*((Vpk[0][3][0]*Vpk[1][3][0])+(Vpk[0][3][2]*
          Vpk[1][3][2]))))));
        mm[0][2] = ((mk[4]*((Vpk[0][5][0]*Vpk[2][6][0])+(Vpk[0][5][2]*
          Vpk[2][6][2])))+((mk[3]*((Vpk[0][5][0]*Vpk[2][5][0])+(Vpk[0][5][2]*
          Vpk[2][5][2])))+((mk[2]*((Vpk[0][3][0]*Vpk[2][4][0])+(Vpk[0][3][2]*
          Vpk[2][4][2])))+((mk[0]*((rk[0][0]*s2)+(rk[0][2]*c2)))+(mk[1]*((
          Vpk[0][3][0]*Vpk[2][3][0])+(Vpk[0][3][2]*Vpk[2][3][2])))))));
        mm[0][3] = ((mk[1]*((rk[1][2]*Vpk[0][3][0])-(rk[1][0]*Vpk[0][3][2])))+(
          mk[2]*((Vpk[0][3][0]*Vpk[3][4][0])+(Vpk[0][3][2]*Vpk[3][4][2]))));
        mm[0][4] = -(mk[2]*Vpk[0][3][2]);
        mm[0][5] = ((mk[3]*((rk[3][2]*Vpk[0][5][0])-(rk[3][0]*Vpk[0][5][2])))+(
          mk[4]*((Vpk[0][5][0]*Vpk[5][6][0])+(Vpk[0][5][2]*Vpk[5][6][2]))));
        mm[0][6] = -(mk[4]*Vpk[0][5][2]);
        mm[1][1] = ((mk[4]*((Vpk[1][5][0]*Vpk[1][5][0])+(Vpk[1][5][2]*
          Vpk[1][5][2])))+((mk[3]*((Vpk[1][5][0]*Vpk[1][5][0])+(Vpk[1][5][2]*
          Vpk[1][5][2])))+((mk[0]+(mk[1]*((Vpk[1][3][0]*Vpk[1][3][0])+(
          Vpk[1][3][2]*Vpk[1][3][2]))))+(mk[2]*((Vpk[1][3][0]*Vpk[1][3][0])+(
          Vpk[1][3][2]*Vpk[1][3][2]))))));
        mm[1][2] = ((mk[4]*((Vpk[1][5][0]*Vpk[2][6][0])+(Vpk[1][5][2]*
          Vpk[2][6][2])))+((mk[3]*((Vpk[1][5][0]*Vpk[2][5][0])+(Vpk[1][5][2]*
          Vpk[2][5][2])))+((mk[2]*((Vpk[1][3][0]*Vpk[2][4][0])+(Vpk[1][3][2]*
          Vpk[2][4][2])))+((mk[0]*((rk[0][2]*s2)-(rk[0][0]*c2)))+(mk[1]*((
          Vpk[1][3][0]*Vpk[2][3][0])+(Vpk[1][3][2]*Vpk[2][3][2])))))));
        mm[1][3] = ((mk[1]*((rk[1][2]*Vpk[1][3][0])-(rk[1][0]*Vpk[1][3][2])))+(
          mk[2]*((Vpk[1][3][0]*Vpk[3][4][0])+(Vpk[1][3][2]*Vpk[3][4][2]))));
        mm[1][4] = -(mk[2]*Vpk[1][3][2]);
        mm[1][5] = ((mk[3]*((rk[3][2]*Vpk[1][5][0])-(rk[3][0]*Vpk[1][5][2])))+(
          mk[4]*((Vpk[1][5][0]*Vpk[5][6][0])+(Vpk[1][5][2]*Vpk[5][6][2]))));
        mm[1][6] = -(mk[4]*Vpk[1][5][2]);
        temp[0] = ((ik[3][1][1]+(mk[3]*((Vpk[2][5][0]*Vpk[2][5][0])+(
          Vpk[2][5][2]*Vpk[2][5][2]))))+((ik[2][1][1]+(mk[2]*((Vpk[2][4][0]*
          Vpk[2][4][0])+(Vpk[2][4][2]*Vpk[2][4][2]))))+((ik[0][1][1]+(mk[0]*((
          rk[0][0]*rk[0][0])+(rk[0][2]*rk[0][2]))))+(ik[1][1][1]+(mk[1]*((
          Vpk[2][3][0]*Vpk[2][3][0])+(Vpk[2][3][2]*Vpk[2][3][2])))))));
        mm[2][2] = ((ik[4][1][1]+(mk[4]*((Vpk[2][6][0]*Vpk[2][6][0])+(
          Vpk[2][6][2]*Vpk[2][6][2]))))+temp[0]);
        mm[2][3] = ((ik[1][1][1]+(mk[1]*((rk[1][2]*Vpk[2][3][0])-(rk[1][0]*
          Vpk[2][3][2]))))+(ik[2][1][1]+(mk[2]*((Vpk[2][4][0]*Vpk[3][4][0])+(
          Vpk[2][4][2]*Vpk[3][4][2])))));
        mm[2][4] = -(mk[2]*Vpk[2][4][2]);
        mm[2][5] = ((ik[3][1][1]+(mk[3]*((rk[3][2]*Vpk[2][5][0])-(rk[3][0]*
          Vpk[2][5][2]))))+(ik[4][1][1]+(mk[4]*((Vpk[2][6][0]*Vpk[5][6][0])+(
          Vpk[2][6][2]*Vpk[5][6][2])))));
        mm[2][6] = -(mk[4]*Vpk[2][6][2]);
        mm[3][3] = ((ik[1][1][1]+(mk[1]*((rk[1][0]*rk[1][0])+(rk[1][2]*rk[1][2])
          )))+(ik[2][1][1]+(mk[2]*((Vpk[3][4][0]*Vpk[3][4][0])+(Vpk[3][4][2]*
          Vpk[3][4][2])))));
        mm[3][4] = -(mk[2]*Vpk[3][4][2]);
        mm[3][5] = 0.;
        mm[3][6] = 0.;
        mm[4][4] = mk[2];
        mm[4][5] = 0.;
        mm[4][6] = 0.;
        mm[5][5] = ((ik[3][1][1]+(mk[3]*((rk[3][0]*rk[3][0])+(rk[3][2]*rk[3][2])
          )))+(ik[4][1][1]+(mk[4]*((Vpk[5][6][0]*Vpk[5][6][0])+(Vpk[5][6][2]*
          Vpk[5][6][2])))));
        mm[5][6] = -(mk[4]*Vpk[5][6][2]);
        mm[6][6] = mk[4];
/*
Check for singular mass matrix
*/
        for (i = 0; i < 7; i++) {
            if (mm[i][i] < 1e-13) {
                sraseterr(routine,47);
            }
        }
        sraerror(&dumroutine,&errnum);
        if (errnum == 0) {
            mmflg = 1;
        }
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   95 adds/subtracts/negates
                    137 multiplies
                      0 divides
                     29 assignments
*/
}

void sradommldu(int routine)
{
    int i;
    int dumroutine,errnum;

    if (mmlduflg == 0) {
        sradomm(routine);
/*
Numerically decompose the mass matrix
*/
        sraldudcomp(7,7,mmap,1e-13,workss,works,mm,mlo,mdi);
/*
Check for singular mass matrix
*/
        for (i = 0; i < 7; i++) {
            if (mdi[i] <= 1e-13) {
                sraseterr(routine,47);
            }
        }
        sraerror(&dumroutine,&errnum);
        if (errnum == 0) {
            mmlduflg = 1;
        }
    }
}

void sralhs(int routine)
{
/* Compute all remaining state- and force-dependent quantities
*/

    roustate = 2;
    sradommldu(routine);
    sradofs0();
}

void sramfrc(double imult[1])
{

}

void sraequivht(double tau[7])
{
/* Compute tree hinge torques to match effect of applied loads
*/
    double fstareq[7][3],tstareq[7][3];

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(56,23);
        return;
    }
/*
Compute fstareq (forces)
*/
    fstareq[2][0] = ((9.81*(mk[0]*s2))-ufk[0][0]);
    fstareq[2][2] = ((9.81*(mk[0]*c2))-ufk[0][2]);
    fstareq[3][0] = -(ufk[1][0]+(gk[3][0]*mk[1]));
    fstareq[3][2] = -(ufk[1][2]+(gk[3][2]*mk[1]));
    fstareq[4][0] = -(ufk[2][0]+(gk[3][0]*mk[2]));
    fstareq[4][2] = -(ufk[2][2]+(gk[3][2]*mk[2]));
    fstareq[5][0] = -(ufk[3][0]+(gk[5][0]*mk[3]));
    fstareq[5][2] = -(ufk[3][2]+(gk[5][2]*mk[3]));
    fstareq[6][0] = -(ufk[4][0]+(gk[5][0]*mk[4]));
    fstareq[6][2] = -(ufk[4][2]+(gk[5][2]*mk[4]));
/*
Compute tstareq (torques)
*/
/*
Compute taus (RHS ignoring constraints and inertial forces)
*/
    sradovpk();
    tau[0] = (utau[0]-(((fstareq[6][0]*Vpk[0][5][0])+(fstareq[6][2]*Vpk[0][5][2]
      ))+(((fstareq[5][0]*Vpk[0][5][0])+(fstareq[5][2]*Vpk[0][5][2]))+(((
      fstareq[4][0]*Vpk[0][3][0])+(fstareq[4][2]*Vpk[0][3][2]))+(((fstareq[2][0]
      *c2)-(fstareq[2][2]*s2))+((fstareq[3][0]*Vpk[0][3][0])+(fstareq[3][2]*
      Vpk[0][3][2])))))));
    tau[1] = (utau[1]-(((fstareq[6][0]*Vpk[1][5][0])+(fstareq[6][2]*Vpk[1][5][2]
      ))+(((fstareq[5][0]*Vpk[1][5][0])+(fstareq[5][2]*Vpk[1][5][2]))+(((
      fstareq[4][0]*Vpk[1][3][0])+(fstareq[4][2]*Vpk[1][3][2]))+(((fstareq[2][0]
      *s2)+(fstareq[2][2]*c2))+((fstareq[3][0]*Vpk[1][3][0])+(fstareq[3][2]*
      Vpk[1][3][2])))))));
    tau[2] = (utau[2]-((utk[4][1]+((fstareq[6][0]*Vpk[2][6][0])+(fstareq[6][2]*
      Vpk[2][6][2])))+((utk[3][1]+((fstareq[5][0]*Vpk[2][5][0])+(fstareq[5][2]*
      Vpk[2][5][2])))+((utk[2][1]+((fstareq[4][0]*Vpk[2][4][0])+(fstareq[4][2]*
      Vpk[2][4][2])))+((utk[0][1]+((fstareq[2][0]*rk[0][2])-(fstareq[2][2]*
      rk[0][0])))+(utk[1][1]+((fstareq[3][0]*Vpk[2][3][0])+(fstareq[3][2]*
      Vpk[2][3][2]))))))));
    tau[3] = (utau[3]-((utk[1][1]+((fstareq[3][0]*rk[1][2])-(fstareq[3][2]*
      rk[1][0])))+(utk[2][1]+((fstareq[4][0]*Vpk[3][4][0])+(fstareq[4][2]*
      Vpk[3][4][2])))));
    tau[4] = (fstareq[4][2]+utau[4]);
    tau[5] = (utau[5]-((utk[3][1]+((fstareq[5][0]*rk[3][2])-(fstareq[5][2]*
      rk[3][0])))+(utk[4][1]+((fstareq[6][0]*Vpk[5][6][0])+(fstareq[6][2]*
      Vpk[5][6][2])))));
    tau[6] = (fstareq[6][2]+utau[6]);
/*
Op counts below do not include called subroutines
*/
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   67 adds/subtracts/negates
                     50 multiplies
                      0 divides
                     17 assignments
*/
}

void srafs0(void)
{

/*
Compute Fs (ignoring multiplier forces)
*/
    fs[0] = fs0[0];
    fs[1] = fs0[1];
    fs[2] = fs0[2];
    fs[3] = fs0[3];
    fs[4] = fs0[4];
    fs[5] = fs0[5];
    fs[6] = fs0[6];
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      7 assignments
*/
}

void srafsmult(void)
{
    int i;

/*
Compute Fs (multiplier-generated forces only)
*/
    for (i = 0; i < 7; i++) {
        fs[i] = 0.;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      7 assignments
*/
}

void srafsfull(void)
{

/*
Compute Fs (including all forces)
*/
    srafsmult();
    fs[0] = (fs[0]+fs0[0]);
    fs[1] = (fs[1]+fs0[1]);
    fs[2] = (fs[2]+fs0[2]);
    fs[3] = (fs[3]+fs0[3]);
    fs[4] = (fs[4]+fs0[4]);
    fs[5] = (fs[5]+fs0[5]);
    fs[6] = (fs[6]+fs0[6]);
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    7 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      7 assignments
*/
}

void srafsgenmult(void)
{
    int i;

/*
Compute Fs (generic multiplier-generated forces)
*/
    for (i = 0; i < 7; i++) {
        fs[i] = 0.;
    }
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      7 assignments
*/
}

void srafsgenfull(void)
{

/*
Compute Fs (incl generic mult & other forces)
*/
    srafsgenmult();
    fs[0] = (fs[0]+fs0[0]);
    fs[1] = (fs[1]+fs0[1]);
    fs[2] = (fs[2]+fs0[2]);
    fs[3] = (fs[3]+fs0[3]);
    fs[4] = (fs[4]+fs0[4]);
    fs[5] = (fs[5]+fs0[5]);
    fs[6] = (fs[6]+fs0[6]);
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    7 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      7 assignments
*/
}

void srafulltrq(double udotin[7],
    double multin[1],
    double trqout[7])
{
/* Compute hinge torques which would produce indicated udots
*/
    double fstarr[7][3],tstarr[7][3],Otkr[7][3],Atir[7][3],Atkr[7][3];

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(61,23);
        return;
    }
/*
Account for inertial accelerations and supplied udots
*/
    Otkr[3][1] = -(udotin[2]+udotin[3]);
    Otkr[5][1] = -(udotin[2]+udotin[5]);
    Atkr[2][0] = (((rk[0][2]*udotin[2])-(u[2]*Wkrpk[2][2]))+((udotin[0]*c2)+(
      udotin[1]*s2)));
    Atkr[2][2] = (((u[2]*Wkrpk[2][0])-(rk[0][0]*udotin[2]))+((udotin[1]*c2)-(
      udotin[0]*s2)));
    Atir[3][0] = (Atkr[2][0]-((ri[1][2]*udotin[2])+(u[2]*Wirk[3][2])));
    Atir[3][2] = (Atkr[2][2]+((ri[1][0]*udotin[2])+(u[2]*Wirk[3][0])));
    Atkr[3][0] = (((Atir[3][0]*c3)+(Atir[3][2]*s3))+((wk[3][1]*Wkrpk[3][2])-(
      Otkr[3][1]*rk[1][2])));
    Atkr[3][2] = (((Atir[3][2]*c3)-(Atir[3][0]*s3))+((Otkr[3][1]*rk[1][0])-(
      wk[3][1]*Wkrpk[3][0])));
    Atir[4][0] = (Atkr[3][0]+((Otkr[3][1]*ri[2][2])+(Wirk[4][2]*wk[3][1])));
    Atir[4][2] = (Atkr[3][2]-((Otkr[3][1]*ri[2][0])+(Wirk[4][0]*wk[3][1])));
    Atkr[4][0] = (Atir[4][0]+(((Otkr[3][1]*rpk[4][2])+(wk[3][1]*Wkrpk[4][2]))-(
      2.*(u[4]*wk[3][1]))));
    Atkr[4][2] = ((Atir[4][2]+((Otkr[3][1]*rk[2][0])-(wk[3][1]*Wkrpk[4][0])))-
      udotin[4]);
    Atir[5][0] = (Atkr[2][0]-((ri[3][2]*udotin[2])+(u[2]*Wirk[5][2])));
    Atir[5][2] = (Atkr[2][2]+((ri[3][0]*udotin[2])+(u[2]*Wirk[5][0])));
    Atkr[5][0] = (((Atir[5][0]*c5)+(Atir[5][2]*s5))+((wk[5][1]*Wkrpk[5][2])-(
      Otkr[5][1]*rk[3][2])));
    Atkr[5][2] = (((Atir[5][2]*c5)-(Atir[5][0]*s5))+((Otkr[5][1]*rk[3][0])-(
      wk[5][1]*Wkrpk[5][0])));
    Atir[6][0] = (Atkr[5][0]+((Otkr[5][1]*ri[4][2])+(Wirk[6][2]*wk[5][1])));
    Atir[6][2] = (Atkr[5][2]-((Otkr[5][1]*ri[4][0])+(Wirk[6][0]*wk[5][1])));
    Atkr[6][0] = (Atir[6][0]+(((Otkr[5][1]*rpk[6][2])+(wk[5][1]*Wkrpk[6][2]))-(
      2.*(u[6]*wk[5][1]))));
    Atkr[6][2] = ((Atir[6][2]+((Otkr[5][1]*rk[4][0])-(wk[5][1]*Wkrpk[6][0])))-
      udotin[6]);
/*
Accumulate all forces and torques
*/
    fstarr[2][0] = (ufk[0][0]-(mk[0]*(Atkr[2][0]+(9.81*s2))));
    fstarr[2][2] = (ufk[0][2]-(mk[0]*(Atkr[2][2]+(9.81*c2))));
    fstarr[3][0] = (ufk[1][0]+(mk[1]*(gk[3][0]-Atkr[3][0])));
    fstarr[3][2] = (ufk[1][2]+(mk[1]*(gk[3][2]-Atkr[3][2])));
    fstarr[4][0] = (ufk[2][0]+(mk[2]*(gk[3][0]-Atkr[4][0])));
    fstarr[4][2] = (ufk[2][2]+(mk[2]*(gk[3][2]-Atkr[4][2])));
    fstarr[5][0] = (ufk[3][0]+(mk[3]*(gk[5][0]-Atkr[5][0])));
    fstarr[5][2] = (ufk[3][2]+(mk[3]*(gk[5][2]-Atkr[5][2])));
    fstarr[6][0] = (ufk[4][0]+(mk[4]*(gk[5][0]-Atkr[6][0])));
    fstarr[6][2] = (ufk[4][2]+(mk[4]*(gk[5][2]-Atkr[6][2])));
    tstarr[2][1] = (utk[0][1]+(ik[0][1][1]*udotin[2]));
    tstarr[3][1] = (utk[1][1]-(ik[1][1][1]*Otkr[3][1]));
    tstarr[4][1] = (utk[2][1]-(ik[2][1][1]*Otkr[3][1]));
    tstarr[5][1] = (utk[3][1]-(ik[3][1][1]*Otkr[5][1]));
    tstarr[6][1] = (utk[4][1]-(ik[4][1][1]*Otkr[5][1]));
/*
Now calculate the torques
*/
    sradovpk();
    trqout[0] = -(utau[0]+(((fstarr[6][0]*Vpk[0][5][0])+(fstarr[6][2]*
      Vpk[0][5][2]))+(((fstarr[5][0]*Vpk[0][5][0])+(fstarr[5][2]*Vpk[0][5][2]))+
      (((fstarr[4][0]*Vpk[0][3][0])+(fstarr[4][2]*Vpk[0][3][2]))+(((fstarr[2][0]
      *c2)-(fstarr[2][2]*s2))+((fstarr[3][0]*Vpk[0][3][0])+(fstarr[3][2]*
      Vpk[0][3][2])))))));
    trqout[1] = -(utau[1]+(((fstarr[6][0]*Vpk[1][5][0])+(fstarr[6][2]*
      Vpk[1][5][2]))+(((fstarr[5][0]*Vpk[1][5][0])+(fstarr[5][2]*Vpk[1][5][2]))+
      (((fstarr[4][0]*Vpk[1][3][0])+(fstarr[4][2]*Vpk[1][3][2]))+(((fstarr[2][0]
      *s2)+(fstarr[2][2]*c2))+((fstarr[3][0]*Vpk[1][3][0])+(fstarr[3][2]*
      Vpk[1][3][2])))))));
    trqout[2] = -(utau[2]+((((fstarr[6][0]*Vpk[2][6][0])+(fstarr[6][2]*
      Vpk[2][6][2]))-tstarr[6][1])+((((fstarr[5][0]*Vpk[2][5][0])+(fstarr[5][2]*
      Vpk[2][5][2]))-tstarr[5][1])+((((fstarr[4][0]*Vpk[2][4][0])+(fstarr[4][2]*
      Vpk[2][4][2]))-tstarr[4][1])+((((fstarr[2][0]*rk[0][2])-(fstarr[2][2]*
      rk[0][0]))-tstarr[2][1])+(((fstarr[3][0]*Vpk[2][3][0])+(fstarr[3][2]*
      Vpk[2][3][2]))-tstarr[3][1]))))));
    trqout[3] = -(utau[3]+((((fstarr[3][0]*rk[1][2])-(fstarr[3][2]*rk[1][0]))-
      tstarr[3][1])+(((fstarr[4][0]*Vpk[3][4][0])+(fstarr[4][2]*Vpk[3][4][2]))-
      tstarr[4][1])));
    trqout[4] = (fstarr[4][2]-utau[4]);
    trqout[5] = -(utau[5]+((((fstarr[5][0]*rk[3][2])-(fstarr[5][2]*rk[3][0]))-
      tstarr[5][1])+(((fstarr[6][0]*Vpk[5][6][0])+(fstarr[6][2]*Vpk[5][6][2]))-
      tstarr[6][1])));
    trqout[6] = (fstarr[6][2]-utau[6]);
/*
Op counts below do not include called subroutines
*/
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  129 adds/subtracts/negates
                    107 multiplies
                      0 divides
                     42 assignments
*/
}

void sracomptrq(double udotin[7],
    double trqout[7])
{
/* Compute hinge torques to produce these udots, ignoring constraints
*/
    double multin[1];

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(60,23);
        return;
    }
    srafulltrq(udotin,multin,trqout);
}

void sramulttrq(double multin[1],
    double trqout[7])
{
/* Compute hinge trqs which would be produced by these mults.
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(65,23);
        return;
    }
    for (i = 0; i < 7; i++) {
        trqout[i] = 0.;
    }
}

void srarhs(void)
{
/*
Generated 27-Jun-2008 21:07:30 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/

/*
Compute hinge torques for tree hinges
*/
    tauc[0] = utau[0];
    tauc[1] = utau[1];
    tauc[2] = utau[2];
    tauc[3] = utau[3];
    tauc[4] = utau[4];
    tauc[5] = utau[5];
    tauc[6] = utau[6];
    sradoiner();
/*
Compute onk & onb (angular accels in N)
*/
    Onkb[3][1] = -(udot[2]+udot[3]);
    Onkb[5][1] = -(udot[2]+udot[5]);
    onb[0][0] = 0.;
    onb[0][1] = -udot[2];
    onb[0][2] = 0.;
    onb[1][0] = 0.;
    onb[1][1] = Onkb[3][1];
    onb[1][2] = 0.;
    onb[2][0] = 0.;
    onb[2][1] = Onkb[3][1];
    onb[2][2] = 0.;
    onb[3][0] = 0.;
    onb[3][1] = Onkb[5][1];
    onb[3][2] = 0.;
    onb[4][0] = 0.;
    onb[4][1] = Onkb[5][1];
    onb[4][2] = 0.;
/*
Compute acceleration dyadics
*/
    dyad[0][0][0] = -w1w1[0];
    dyad[0][0][1] = 0.;
    dyad[0][0][2] = -udot[2];
    dyad[0][1][0] = 0.;
    dyad[0][1][1] = 0.;
    dyad[0][1][2] = 0.;
    dyad[0][2][0] = udot[2];
    dyad[0][2][1] = 0.;
    dyad[0][2][2] = -w1w1[0];
    dyad[1][0][0] = -w1w1[1];
    dyad[1][0][1] = 0.;
    dyad[1][0][2] = Onkb[3][1];
    dyad[1][1][0] = 0.;
    dyad[1][1][1] = 0.;
    dyad[1][1][2] = 0.;
    dyad[1][2][0] = -Onkb[3][1];
    dyad[1][2][1] = 0.;
    dyad[1][2][2] = -w1w1[1];
    dyad[2][0][0] = -w1w1[2];
    dyad[2][0][1] = 0.;
    dyad[2][0][2] = Onkb[3][1];
    dyad[2][1][0] = 0.;
    dyad[2][1][1] = 0.;
    dyad[2][1][2] = 0.;
    dyad[2][2][0] = -Onkb[3][1];
    dyad[2][2][1] = 0.;
    dyad[2][2][2] = -w1w1[2];
    dyad[3][0][0] = -w1w1[3];
    dyad[3][0][1] = 0.;
    dyad[3][0][2] = Onkb[5][1];
    dyad[3][1][0] = 0.;
    dyad[3][1][1] = 0.;
    dyad[3][1][2] = 0.;
    dyad[3][2][0] = -Onkb[5][1];
    dyad[3][2][1] = 0.;
    dyad[3][2][2] = -w1w1[3];
    dyad[4][0][0] = -w1w1[4];
    dyad[4][0][1] = 0.;
    dyad[4][0][2] = Onkb[5][1];
    dyad[4][1][0] = 0.;
    dyad[4][1][1] = 0.;
    dyad[4][1][2] = 0.;
    dyad[4][2][0] = -Onkb[5][1];
    dyad[4][2][1] = 0.;
    dyad[4][2][2] = -w1w1[4];
/*
Compute ank & anb (mass center linear accels in N)
*/
    Ankb[2][0] = ((rk[0][2]*udot[2])+((udot[0]*c2)+(udot[1]*s2)));
    Ankb[2][2] = (((udot[1]*c2)-(udot[0]*s2))-(rk[0][0]*udot[2]));
    AOnkri[3][0] = (Ankb[2][0]-(ri[1][2]*udot[2]));
    AOnkri[3][2] = (Ankb[2][2]+(ri[1][0]*udot[2]));
    Ankb[3][0] = (((AOnkri[3][0]*c3)+(AOnkri[3][2]*s3))-(Onkb[3][1]*rk[1][2]));
    Ankb[3][2] = ((Onkb[3][1]*rk[1][0])+((AOnkri[3][2]*c3)-(AOnkri[3][0]*s3)));
    AOnkri[4][0] = (Ankb[3][0]+(Onkb[3][1]*ri[2][2]));
    AOnkri[4][2] = (Ankb[3][2]-(Onkb[3][1]*ri[2][0]));
    Ankb[4][0] = (AOnkri[4][0]+(Onkb[3][1]*rpk[4][2]));
    Ankb[4][2] = (AOnkri[4][2]+((Onkb[3][1]*rk[2][0])-udot[4]));
    AOnkri[5][0] = (Ankb[2][0]-(ri[3][2]*udot[2]));
    AOnkri[5][2] = (Ankb[2][2]+(ri[3][0]*udot[2]));
    Ankb[5][0] = (((AOnkri[5][0]*c5)+(AOnkri[5][2]*s5))-(Onkb[5][1]*rk[3][2]));
    Ankb[5][2] = ((Onkb[5][1]*rk[3][0])+((AOnkri[5][2]*c5)-(AOnkri[5][0]*s5)));
    AOnkri[6][0] = (Ankb[5][0]+(Onkb[5][1]*ri[4][2]));
    AOnkri[6][2] = (Ankb[5][2]-(Onkb[5][1]*ri[4][0]));
    Ankb[6][0] = (AOnkri[6][0]+(Onkb[5][1]*rpk[6][2]));
    Ankb[6][2] = (AOnkri[6][2]+((Onkb[5][1]*rk[4][0])-udot[6]));
    AnkAtk[2][0] = (Ankb[2][0]+Atk[2][0]);
    AnkAtk[2][2] = (Ankb[2][2]+Atk[2][2]);
    ank[2][0] = ((AnkAtk[2][0]*c2)-(AnkAtk[2][2]*s2));
    ank[2][2] = ((AnkAtk[2][0]*s2)+(AnkAtk[2][2]*c2));
    AnkAtk[3][0] = (Ankb[3][0]+Atk[3][0]);
    AnkAtk[3][2] = (Ankb[3][2]+Atk[3][2]);
    ank[3][0] = ((AnkAtk[3][0]*cnk[3][0][0])+(AnkAtk[3][2]*cnk[3][0][2]));
    ank[3][2] = ((AnkAtk[3][0]*cnk[3][2][0])+(AnkAtk[3][2]*cnk[3][2][2]));
    AnkAtk[4][0] = (Ankb[4][0]+Atk[4][0]);
    AnkAtk[4][2] = (Ankb[4][2]+Atk[4][2]);
    ank[4][0] = ((AnkAtk[4][0]*cnk[3][0][0])+(AnkAtk[4][2]*cnk[3][0][2]));
    ank[4][2] = ((AnkAtk[4][0]*cnk[3][2][0])+(AnkAtk[4][2]*cnk[3][2][2]));
    AnkAtk[5][0] = (Ankb[5][0]+Atk[5][0]);
    AnkAtk[5][2] = (Ankb[5][2]+Atk[5][2]);
    ank[5][0] = ((AnkAtk[5][0]*cnk[5][0][0])+(AnkAtk[5][2]*cnk[5][0][2]));
    ank[5][2] = ((AnkAtk[5][0]*cnk[5][2][0])+(AnkAtk[5][2]*cnk[5][2][2]));
    AnkAtk[6][0] = (Ankb[6][0]+Atk[6][0]);
    AnkAtk[6][2] = (Ankb[6][2]+Atk[6][2]);
    ank[6][0] = ((AnkAtk[6][0]*cnk[5][0][0])+(AnkAtk[6][2]*cnk[5][0][2]));
    ank[6][2] = ((AnkAtk[6][0]*cnk[5][2][0])+(AnkAtk[6][2]*cnk[5][2][2]));
    anb[0][0] = ank[2][0];
    anb[0][1] = 0.;
    anb[0][2] = ank[2][2];
    anb[1][0] = ank[3][0];
    anb[1][1] = 0.;
    anb[1][2] = ank[3][2];
    anb[2][0] = ank[4][0];
    anb[2][1] = 0.;
    anb[2][2] = ank[4][2];
    anb[3][0] = ank[5][0];
    anb[3][1] = 0.;
    anb[3][2] = ank[5][2];
    anb[4][0] = ank[6][0];
    anb[4][1] = 0.;
    anb[4][2] = ank[6][2];
    roustate = 3;
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   66 adds/subtracts/negates
                     50 multiplies
                      0 divides
                    122 assignments
*/
}

void sramassmat(double mmat[7][7])
{
/* Return the system mass matrix (LHS)
*/
    int i,j;

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(57,23);
        return;
    }
    sradomm(57);
    for (i = 0; i < 7; i++) {
        for (j = i; j <= 6; j++) {
            mmat[i][j] = mm[i][j];
            mmat[j][i] = mm[i][j];
        }
    }
}

void srafrcmat(double fmat[7])
{
/* Return the system force matrix (RHS), excluding constraints
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(58,23);
        return;
    }
    sradofs0();
    for (i = 0; i < 7; i++) {
        fmat[i] = fs0[i];
    }
}

void srapseudo(double lqout[1],
    double luout[1])
{
/*
Return pseudo-coordinates for loop joints.

*/
/*
There are no loop joints in this system.

*/
}

void srapsqdot(double lqdout[1])
{
/*
Return pseudo-coordinate derivatives for loop joints.

*/
/*
There are no loop joints in this system.

*/
}

void srapsudot(double ludout[1])
{
/*
Return pseudo-coordinate accelerations for loop joints.

*/
/*
There are no loop joints in this system.

*/
}

void sraperr(double errs[1])
{

}

void sraverr(double errs[1])
{

}

void sraaerr(double errs[1])
{

}
int 
srachkbnum(int routine,
    int bnum)
{

    if ((bnum < -1) || (bnum > 4)) {
        sraseterr(routine,15);
        return 1;
    }
    return 0;
}
int 
srachkjnum(int routine,
    int jnum)
{

    if ((jnum < 0) || (jnum > 4)) {
        sraseterr(routine,16);
        return 1;
    }
    return 0;
}
int 
srachkucnum(int routine,
    int ucnum)
{

    if ((ucnum < 0) || (ucnum > -1)) {
        sraseterr(routine,21);
        return 1;
    }
    return 0;
}
int 
srachkjaxis(int routine,
    int jnum,
    int axnum)
{
    int maxax;

    if (srachkjnum(routine,jnum) != 0) {
        return 1;
    }
    if ((axnum < 0) || (axnum > 6)) {
        sraseterr(routine,17);
        return 1;
    }
    maxax = njntdof[jnum]-1;
    if ((jtype[jnum] == 4) || (jtype[jnum] == 6) || (jtype[jnum] == 21)) {
        maxax = maxax+1;
    }
    if (axnum > maxax) {
        sraseterr(routine,18);
        return 1;
    }
    return 0;
}
int 
srachkjpin(int routine,
    int jnum,
    int pinno)
{
    int maxax,pinok;

    if (srachkjnum(routine,jnum) != 0) {
        return 1;
    }
    if ((pinno < 0) || (pinno > 5)) {
        sraseterr(routine,17);
        return 1;
    }
    if (njntdof[jnum] >= 3) {
        maxax = 2;
    } else {
        maxax = njntdof[jnum]-1;
    }
    if (jtype[jnum] == 4) {
        maxax = -1;
    }
    if (jtype[jnum] == 7) {
        maxax = 0;
    }
    pinok = 0;
    if (pinno <= maxax) {
        pinok = 1;
    }
    if (pinok == 0) {
        sraseterr(routine,18);
        return 1;
    }
    return 0;
}
int 
sraindx(int joint,
    int axis)
{
    int offs,gotit;

    if (srachkjaxis(36,joint,axis) != 0) {
        return 0;
    }
    gotit = 0;
    if (jtype[joint] == 4) {
        if (axis == 3) {
            offs = ballq[joint];
            gotit = 1;
        }
    } else {
        if ((jtype[joint] == 6) || (jtype[joint] == 21)) {
            if (axis == 6) {
                offs = ballq[joint];
                gotit = 1;
            }
        }
    }
    if (gotit == 0) {
        offs = firstq[joint]+axis;
    }
    return offs;
}

void srapresacc(int joint,
    int axis,
    double prval)
{

}

void srapresvel(int joint,
    int axis,
    double prval)
{

}

void sraprespos(int joint,
    int axis,
    double prval)
{

}

void sragetht(int joint,
    int axis,
    double *torque)
{

    if (srachkjaxis(30,joint,axis) != 0) {
        return;
    }
    if (roustate != 3) {
        sraseterr(30,24);
        return;
    }
    *torque = tauc[sraindx(joint,axis)];
}

void srahinget(int joint,
    int axis,
    double torque)
{

    if (srachkjaxis(10,joint,axis) != 0) {
        return;
    }
    if (roustate != 2) {
        sraseterr(10,23);
        return;
    }
    if (mfrcflg != 0) {
        mtau[sraindx(joint,axis)] = mtau[sraindx(joint,axis)]+torque;
    } else {
        fs0flg = 0;
        utau[sraindx(joint,axis)] = utau[sraindx(joint,axis)]+torque;
    }
}

void srapointf(int body,
    double point[3],
    double force[3])
{
    double torque[3];

    if (srachkbnum(11,body) != 0) {
        return;
    }
    if (roustate != 2) {
        sraseterr(11,23);
        return;
    }
    if (body == -1) {
        return;
    }
    torque[0] = point[1]*force[2]-point[2]*force[1];
    torque[1] = point[2]*force[0]-point[0]*force[2];
    torque[2] = point[0]*force[1]-point[1]*force[0];
    if (mfrcflg != 0) {
        mfk[body][0] = mfk[body][0]+force[0];
        mtk[body][0] = mtk[body][0]+torque[0];
        mfk[body][1] = mfk[body][1]+force[1];
        mtk[body][1] = mtk[body][1]+torque[1];
        mfk[body][2] = mfk[body][2]+force[2];
        mtk[body][2] = mtk[body][2]+torque[2];
    } else {
        fs0flg = 0;
        ufk[body][0] = ufk[body][0]+force[0];
        utk[body][0] = utk[body][0]+torque[0];
        ufk[body][1] = ufk[body][1]+force[1];
        utk[body][1] = utk[body][1]+torque[1];
        ufk[body][2] = ufk[body][2]+force[2];
        utk[body][2] = utk[body][2]+torque[2];
    }
}

void srabodyt(int body,
    double torque[3])
{

    if (srachkbnum(12,body) != 0) {
        return;
    }
    if (roustate != 2) {
        sraseterr(12,23);
        return;
    }
    if (body == -1) {
        return;
    }
    if (mfrcflg != 0) {
        mtk[body][0] = mtk[body][0]+torque[0];
        mtk[body][1] = mtk[body][1]+torque[1];
        mtk[body][2] = mtk[body][2]+torque[2];
    } else {
        fs0flg = 0;
        utk[body][0] = utk[body][0]+torque[0];
        utk[body][1] = utk[body][1]+torque[1];
        utk[body][2] = utk[body][2]+torque[2];
    }
}

void sradoww(int routine)
{

    roustate = 2;
    if (wwflg == 0) {
        wwflg = 1;
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      0 assignments
*/
}

void sraxudot0(int routine,
    double oudot0[7])
{
/*
Compute unconstrained equations
*/
    int i;

    sralhs(routine);
/*
Solve equations for udots
*/
    srafs0();
    sraldubslv(7,7,mmap,works,mlo,mdi,fs,udot);
    for (i = 0; i <= 6; i++) {
        oudot0[i] = udot[i];
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                      7 assignments
*/
}

void sraudot0(double oudot0[7])
{

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(66,23);
        return;
    }
    sraxudot0(66,oudot0);
}

void srasetudot(double iudot[7])
{
/*
Assign udots and advance to stage Dynamics Ready
*/
    int i;

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(68,23);
        return;
    }
    for (i = 0; i <= 6; i++) {
        udot[i] = iudot[i];
    }
    srarhs();
}

void sraxudotm(int routine,
    double imult[1],
    double oudotm[7])
{
/*
Compute udots due only to multipliers
*/
    int i;

    sralhs(routine);
    for (i = 0; i <= 6; i++) {
        udot[i] = 0.;
    }
    for (i = 0; i <= 6; i++) {
        oudotm[i] = udot[i];
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                     14 assignments
*/
}

void sraudotm(double imult[1],
    double oudotm[7])
{

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(67,23);
        return;
    }
    sraxudotm(67,imult,oudotm);
}

void sraderiv(double oqdot[7],
    double oudot[7])
{
/*
This is the derivative section for a 5-body ground-based
system with 7 hinge degree(s) of freedom.
*/
    int i;
    double udot0[7],udot1[7];

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(17,23);
        return;
    }
    if (stabvelq == 1) {
        sraseterr(17,32);
    }
    if (stabposq == 1) {
        sraseterr(17,33);
    }
    wsiz = 0;
/*
Compute unconstrained equations
*/
    sraxudot0(17,udot0);
    srarhs();
    wrank = 0;
    for (i = 0; i <= 6; i++) {
        oqdot[i] = qdot[i];
    }
    for (i = 0; i <= 6; i++) {
        oudot[i] = udot[i];
    }
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    0 adds/subtracts/negates
                      0 multiplies
                      0 divides
                     14 assignments
*/
}
/*
Compute residuals for use with DAE integrator
*/

void sraresid(double eqdot[7],
    double eudot[7],
    double emults[1],
    double resid[14])
{
    int i;
    double uderrs[7];

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(16,23);
        return;
    }
    if (stabposq == 1) {
        sraseterr(16,33);
    }
    srafulltrq(eudot,emults,uderrs);
    for (i = 0; i < 7; i++) {
        resid[i] = eqdot[i]-qdot[i];
    }
    for (i = 0; i < 7; i++) {
        resid[7+i] = uderrs[i];
    }
    for (i = 0; i < 7; i++) {
        udot[i] = eudot[i];
    }
    srarhs();
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain    7 adds/subtracts/negates
                      0 multiplies
                      0 divides
                     21 assignments
*/
}

void sramult(double omults[1],
    int *owrank,
    int omultmap[1])
{

    if (roustate != 3) {
        sraseterr(34,24);
        return;
    }
    *owrank = wrank;
}

void srareac(double force[5][3],
    double torque[5][3])
{
/*
Generated 27-Jun-2008 21:07:30 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/

    if (roustate != 3) {
        sraseterr(31,24);
        return;
    }
/*
Compute reaction forces for non-weld tree joints
*/
    fc[6][0] = ((mk[4]*(AnkAtk[6][0]-gk[5][0]))-ufk[4][0]);
    fc[6][1] = -ufk[4][1];
    fc[6][2] = ((mk[4]*(AnkAtk[6][2]-gk[5][2]))-ufk[4][2]);
    tc[6][0] = -(utk[4][0]-(fc[6][1]*rk[4][2]));
    tc[6][1] = ((ik[4][1][1]*Onkb[5][1])-(utk[4][1]+((fc[6][0]*rk[4][2])-(
      fc[6][2]*rk[4][0]))));
    tc[6][2] = -(utk[4][2]+(fc[6][1]*rk[4][0]));
    fccikt[6][0] = fc[6][0];
    fccikt[6][1] = fc[6][1];
    fccikt[6][2] = fc[6][2];
    ffk[5][0] = (ufk[3][0]-fccikt[6][0]);
    ffk[5][1] = (ufk[3][1]-fccikt[6][1]);
    ffk[5][2] = (ufk[3][2]-fccikt[6][2]);
    ttk[5][0] = (utk[3][0]-(tc[6][0]-(fccikt[6][1]*rpri[6][2])));
    ttk[5][1] = (utk[3][1]-(tc[6][1]+((fccikt[6][0]*rpri[6][2])-(fccikt[6][2]*
      ri[4][0]))));
    ttk[5][2] = (utk[3][2]-(tc[6][2]+(fccikt[6][1]*ri[4][0])));
    fc[5][0] = ((mk[3]*(AnkAtk[5][0]-gk[5][0]))-ffk[5][0]);
    fc[5][1] = -ffk[5][1];
    fc[5][2] = ((mk[3]*(AnkAtk[5][2]-gk[5][2]))-ffk[5][2]);
    tc[5][0] = -(ttk[5][0]-(fc[5][1]*rk[3][2]));
    tc[5][1] = ((ik[3][1][1]*Onkb[5][1])-(ttk[5][1]+((fc[5][0]*rk[3][2])-(
      fc[5][2]*rk[3][0]))));
    tc[5][2] = -(ttk[5][2]+(fc[5][1]*rk[3][0]));
    fccikt[5][0] = ((fc[5][0]*c5)-(fc[5][2]*s5));
    fccikt[5][1] = fc[5][1];
    fccikt[5][2] = ((fc[5][0]*s5)+(fc[5][2]*c5));
    ffk[2][0] = (ufk[0][0]-fccikt[5][0]);
    ffk[2][1] = (ufk[0][1]-fccikt[5][1]);
    ffk[2][2] = (ufk[0][2]-fccikt[5][2]);
    ttk[2][0] = (utk[0][0]-(((tc[5][0]*c5)-(tc[5][2]*s5))-(fccikt[5][1]*ri[3][2]
      )));
    ttk[2][1] = (utk[0][1]-(tc[5][1]+((fccikt[5][0]*ri[3][2])-(fccikt[5][2]*
      ri[3][0]))));
    ttk[2][2] = (utk[0][2]-((fccikt[5][1]*ri[3][0])+((tc[5][0]*s5)+(tc[5][2]*c5)
      )));
    fc[4][0] = ((mk[2]*(AnkAtk[4][0]-gk[3][0]))-ufk[2][0]);
    fc[4][1] = -ufk[2][1];
    fc[4][2] = ((mk[2]*(AnkAtk[4][2]-gk[3][2]))-ufk[2][2]);
    tc[4][0] = -(utk[2][0]-(fc[4][1]*rk[2][2]));
    tc[4][1] = ((ik[2][1][1]*Onkb[3][1])-(utk[2][1]+((fc[4][0]*rk[2][2])-(
      fc[4][2]*rk[2][0]))));
    tc[4][2] = -(utk[2][2]+(fc[4][1]*rk[2][0]));
    fccikt[4][0] = fc[4][0];
    fccikt[4][1] = fc[4][1];
    fccikt[4][2] = fc[4][2];
    ffk[3][0] = (ufk[1][0]-fccikt[4][0]);
    ffk[3][1] = (ufk[1][1]-fccikt[4][1]);
    ffk[3][2] = (ufk[1][2]-fccikt[4][2]);
    ttk[3][0] = (utk[1][0]-(tc[4][0]-(fccikt[4][1]*rpri[4][2])));
    ttk[3][1] = (utk[1][1]-(tc[4][1]+((fccikt[4][0]*rpri[4][2])-(fccikt[4][2]*
      ri[2][0]))));
    ttk[3][2] = (utk[1][2]-(tc[4][2]+(fccikt[4][1]*ri[2][0])));
    fc[3][0] = ((mk[1]*(AnkAtk[3][0]-gk[3][0]))-ffk[3][0]);
    fc[3][1] = -ffk[3][1];
    fc[3][2] = ((mk[1]*(AnkAtk[3][2]-gk[3][2]))-ffk[3][2]);
    tc[3][0] = -(ttk[3][0]-(fc[3][1]*rk[1][2]));
    tc[3][1] = ((ik[1][1][1]*Onkb[3][1])-(ttk[3][1]+((fc[3][0]*rk[1][2])-(
      fc[3][2]*rk[1][0]))));
    tc[3][2] = -(ttk[3][2]+(fc[3][1]*rk[1][0]));
    fccikt[3][0] = ((fc[3][0]*c3)-(fc[3][2]*s3));
    fccikt[3][1] = fc[3][1];
    fccikt[3][2] = ((fc[3][0]*s3)+(fc[3][2]*c3));
    ffk[2][0] = (ffk[2][0]-fccikt[3][0]);
    ffk[2][1] = (ffk[2][1]-fccikt[3][1]);
    ffk[2][2] = (ffk[2][2]-fccikt[3][2]);
    ttk[2][0] = (ttk[2][0]-(((tc[3][0]*c3)-(tc[3][2]*s3))-(fccikt[3][1]*ri[1][2]
      )));
    ttk[2][1] = (ttk[2][1]-(tc[3][1]+((fccikt[3][0]*ri[1][2])-(fccikt[3][2]*
      ri[1][0]))));
    ttk[2][2] = (ttk[2][2]-((fccikt[3][1]*ri[1][0])+((tc[3][0]*s3)+(tc[3][2]*c3)
      )));
    fc[2][0] = ((mk[0]*(AnkAtk[2][0]+(9.81*s2)))-ffk[2][0]);
    fc[2][1] = -ffk[2][1];
    fc[2][2] = ((mk[0]*(AnkAtk[2][2]+(9.81*c2)))-ffk[2][2]);
    tc[2][0] = -(ttk[2][0]-(fc[2][1]*rk[0][2]));
    tc[2][1] = -((ik[0][1][1]*udot[2])+(ttk[2][1]+((fc[2][0]*rk[0][2])-(fc[2][2]
      *rk[0][0]))));
    tc[2][2] = -(ttk[2][2]+(fc[2][1]*rk[0][0]));
    fccikt[2][0] = ((fc[2][0]*c2)-(fc[2][2]*s2));
    fccikt[2][1] = fc[2][1];
    fccikt[2][2] = ((fc[2][0]*s2)+(fc[2][2]*c2));
    ffk[1][0] = -fccikt[2][0];
    ffk[1][1] = -fccikt[2][1];
    ffk[1][2] = -fccikt[2][2];
    ttk[1][0] = -((tc[2][0]*c2)-(tc[2][2]*s2));
    ttk[1][1] = -tc[2][1];
    ttk[1][2] = -((tc[2][0]*s2)+(tc[2][2]*c2));
    fc[1][0] = -ffk[1][0];
    fc[1][1] = -ffk[1][1];
    fc[1][2] = -ffk[1][2];
    tc[1][0] = -ttk[1][0];
    tc[1][1] = -ttk[1][1];
    tc[1][2] = -ttk[1][2];
    fccikt[1][0] = fc[1][0];
    fccikt[1][1] = fc[1][1];
    fccikt[1][2] = fc[1][2];
    ffk[0][0] = -fccikt[1][0];
    ffk[0][1] = -fccikt[1][1];
    ffk[0][2] = -fccikt[1][2];
    ttk[0][0] = -(tc[1][0]-(fccikt[1][1]*q[1]));
    ttk[0][1] = -(tc[1][1]+(fccikt[1][0]*q[1]));
    ttk[0][2] = -tc[1][2];
    fc[0][0] = -ffk[0][0];
    fc[0][1] = -ffk[0][1];
    fc[0][2] = -ffk[0][2];
    tc[0][0] = -ttk[0][0];
    tc[0][1] = -ttk[0][1];
    tc[0][2] = -ttk[0][2];
    force[0][0] = fc[2][0];
    torque[0][0] = tc[2][0];
    force[0][1] = fc[2][1];
    torque[0][1] = tc[2][1];
    force[0][2] = fc[2][2];
    torque[0][2] = tc[2][2];
    force[1][0] = fc[3][0];
    torque[1][0] = tc[3][0];
    force[1][1] = fc[3][1];
    torque[1][1] = tc[3][1];
    force[1][2] = fc[3][2];
    torque[1][2] = tc[3][2];
    force[2][0] = fc[4][0];
    torque[2][0] = tc[4][0];
    force[2][1] = fc[4][1];
    torque[2][1] = tc[4][1];
    force[2][2] = fc[4][2];
    torque[2][2] = tc[4][2];
    force[3][0] = fc[5][0];
    torque[3][0] = tc[5][0];
    force[3][1] = fc[5][1];
    torque[3][1] = tc[5][1];
    force[3][2] = fc[5][2];
    torque[3][2] = tc[5][2];
    force[4][0] = fc[6][0];
    torque[4][0] = tc[6][0];
    force[4][1] = fc[6][1];
    torque[4][1] = tc[6][1];
    force[4][2] = fc[6][2];
    torque[4][2] = tc[6][2];
/*
Compute reaction forces for tree weld joints
*/
/*
 Used -0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain  139 adds/subtracts/negates
                     79 multiplies
                      0 divides
                    126 assignments
*/
}

void sramom(double lm[3],
    double am[3],
    double *ke)
{
/*
Compute system linear and angular momentum, and kinetic energy.

Generated 27-Jun-2008 21:07:30 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    double lk[5][3],hnk[5][3];

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(19,23);
        return;
    }
    lk[0][0] = (mk[0]*vnk[2][0]);
    lk[0][2] = (mk[0]*vnk[2][2]);
    lk[1][0] = (mk[1]*vnk[3][0]);
    lk[1][2] = (mk[1]*vnk[3][2]);
    lk[2][0] = (mk[2]*vnk[4][0]);
    lk[2][2] = (mk[2]*vnk[4][2]);
    lk[3][0] = (mk[3]*vnk[5][0]);
    lk[3][2] = (mk[3]*vnk[5][2]);
    lk[4][0] = (mk[4]*vnk[6][0]);
    lk[4][2] = (mk[4]*vnk[6][2]);
    hnk[0][1] = -(ik[0][1][1]*u[2]);
    hnk[1][1] = (ik[1][1][1]*wk[3][1]);
    hnk[2][1] = (ik[2][1][1]*wk[3][1]);
    hnk[3][1] = (ik[3][1][1]*wk[5][1]);
    hnk[4][1] = (ik[4][1][1]*wk[5][1]);
    lm[0] = (lk[4][0]+(lk[3][0]+(lk[2][0]+(lk[0][0]+lk[1][0]))));
    lm[1] = 0.;
    lm[2] = (lk[4][2]+(lk[3][2]+(lk[2][2]+(lk[0][2]+lk[1][2]))));
    am[0] = 0.;
    am[1] = (((hnk[4][1]+((lk[4][0]*rnk[6][2])-(lk[4][2]*rnk[6][0])))+((
      hnk[3][1]+((lk[3][0]*rnk[5][2])-(lk[3][2]*rnk[5][0])))+((hnk[2][1]+((
      lk[2][0]*rnk[4][2])-(lk[2][2]*rnk[4][0])))+((hnk[0][1]+((lk[0][0]*
      rnk[2][2])-(lk[0][2]*rnk[2][0])))+(hnk[1][1]+((lk[1][0]*rnk[3][2])-(
      lk[1][2]*rnk[3][0])))))))-((com[2]*lm[0])-(com[0]*lm[2])));
    am[2] = 0.;
    *ke = (.5*(((hnk[4][1]*wk[5][1])+((lk[4][0]*vnk[6][0])+(lk[4][2]*vnk[6][2]))
      )+(((hnk[3][1]*wk[5][1])+((lk[3][0]*vnk[5][0])+(lk[3][2]*vnk[5][2])))+(((
      hnk[2][1]*wk[3][1])+((lk[2][0]*vnk[4][0])+(lk[2][2]*vnk[4][2])))+(((
      hnk[1][1]*wk[3][1])+((lk[1][0]*vnk[3][0])+(lk[1][2]*vnk[3][2])))+(((
      lk[0][0]*vnk[2][0])+(lk[0][2]*vnk[2][2]))-(hnk[0][1]*u[2])))))));
/*
 Used 0.01 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   39 adds/subtracts/negates
                     43 multiplies
                      0 divides
                     22 assignments
*/
}

void srasys(double *mtoto,
    double cm[3],
    double icm[3][3])
{
/*
Compute system total mass, and instantaneous center of mass and
inertia matrix.

Generated 27-Jun-2008 21:07:30 by SD/FAST, Kane's formulation
(sdfast B.2.8 #30123) on machine ID unknown
Copyright (c) 1990-1997 Symbolic Dynamics, Inc.
Copyright (c) 1990-1997 Parametric Technology Corp.
RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the U.S.
Government is subject to restrictions as set forth in subparagraph
(c)(1)(ii) of the Rights in Technical Data and Computer Software
clause at DFARS 52.227-7013 and similar clauses in the FAR and NASA
FAR Supplement.  Symbolic Dynamics, Inc., Mountain View, CA 94041
*/
    double ikcnkt[7][3][3];

    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(20,23);
        return;
    }
    *mtoto = mtot;
    cm[0] = com[0];
    cm[1] = 0.;
    cm[2] = com[2];
    temp[0] = (((mk[3]*(rnk[5][2]*rnk[5][2]))+((cnk[5][0][0]*cnk[5][0][0])+(
      cnk[5][0][2]*cnk[5][0][2])))+(((mk[0]*(rnk[2][2]*rnk[2][2]))+((mk[1]*(
      rnk[3][2]*rnk[3][2]))+((cnk[3][0][0]*cnk[3][0][0])+(cnk[3][0][2]*
      cnk[3][0][2]))))+((mk[2]*(rnk[4][2]*rnk[4][2]))+((cnk[3][0][0]*
      cnk[3][0][0])+(cnk[3][0][2]*cnk[3][0][2])))));
    icm[0][0] = (1.+((((mk[4]*(rnk[6][2]*rnk[6][2]))+((cnk[5][0][0]*cnk[5][0][0]
      )+(cnk[5][0][2]*cnk[5][0][2])))+temp[0])-(mtot*(com[2]*com[2]))));
    icm[0][1] = 0.;
    temp[0] = ((((cnk[5][0][0]*cnk[5][2][0])+(cnk[5][0][2]*cnk[5][2][2]))-(mk[3]
      *(rnk[5][0]*rnk[5][2])))+((((cnk[3][0][0]*cnk[3][2][0])+(cnk[3][0][2]*
      cnk[3][2][2]))-(mk[2]*(rnk[4][0]*rnk[4][2])))+((((cnk[3][0][0]*
      cnk[3][2][0])+(cnk[3][0][2]*cnk[3][2][2]))-(mk[1]*(rnk[3][0]*rnk[3][2])))-
      (mk[0]*(rnk[2][0]*rnk[2][2])))));
    icm[0][2] = ((mtot*(com[0]*com[2]))+((((cnk[5][0][0]*cnk[5][2][0])+(
      cnk[5][0][2]*cnk[5][2][2]))-(mk[4]*(rnk[6][0]*rnk[6][2])))+temp[0]));
    icm[1][0] = icm[0][1];
    icm[1][1] = (((ik[4][1][1]+(mk[4]*((rnk[6][0]*rnk[6][0])+(rnk[6][2]*
      rnk[6][2]))))+((ik[3][1][1]+(mk[3]*((rnk[5][0]*rnk[5][0])+(rnk[5][2]*
      rnk[5][2]))))+((ik[2][1][1]+(mk[2]*((rnk[4][0]*rnk[4][0])+(rnk[4][2]*
      rnk[4][2]))))+((ik[0][1][1]+(mk[0]*((rnk[2][0]*rnk[2][0])+(rnk[2][2]*
      rnk[2][2]))))+(ik[1][1][1]+(mk[1]*((rnk[3][0]*rnk[3][0])+(rnk[3][2]*
      rnk[3][2]))))))))-(mtot*((com[0]*com[0])+(com[2]*com[2]))));
    icm[1][2] = 0.;
    icm[2][0] = icm[0][2];
    icm[2][1] = icm[1][2];
    temp[0] = (((mk[3]*(rnk[5][0]*rnk[5][0]))+((cnk[5][2][0]*cnk[5][2][0])+(
      cnk[5][2][2]*cnk[5][2][2])))+(((mk[0]*(rnk[2][0]*rnk[2][0]))+((mk[1]*(
      rnk[3][0]*rnk[3][0]))+((cnk[3][2][0]*cnk[3][2][0])+(cnk[3][2][2]*
      cnk[3][2][2]))))+((mk[2]*(rnk[4][0]*rnk[4][0]))+((cnk[3][2][0]*
      cnk[3][2][0])+(cnk[3][2][2]*cnk[3][2][2])))));
    icm[2][2] = (1.+((((mk[4]*(rnk[6][0]*rnk[6][0]))+((cnk[5][2][0]*cnk[5][2][0]
      )+(cnk[5][2][2]*cnk[5][2][2])))+temp[0])-(mtot*(com[0]*com[0]))));
/*
 Used 0.00 seconds CPU time,
 0 additional bytes of memory.
 Equations contain   57 adds/subtracts/negates
                     78 multiplies
                      0 divides
                     16 assignments
*/
}

void srapos(int body,
    double pt[3],
    double loc[3])
{
/*
Return inertial frame location of a point on a body.

*/
    double pv[3];

    if (srachkbnum(21,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(21,23);
        return;
    }
    if (body  ==  -1) {
        loc[0] = pt[0];
        loc[1] = pt[1];
        loc[2] = pt[2];
    } else {
        pv[0] = rnb[body][0]+pt[0]*cnb[body][0][0]+pt[1]*cnb[body][0][1]+pt[2]*
          cnb[body][0][2];
        pv[1] = rnb[body][1]+pt[0]*cnb[body][1][0]+pt[1]*cnb[body][1][1]+pt[2]*
          cnb[body][1][2];
        pv[2] = rnb[body][2]+pt[0]*cnb[body][2][0]+pt[1]*cnb[body][2][1]+pt[2]*
          cnb[body][2][2];
        loc[0] = pv[0];
        loc[1] = pv[1];
        loc[2] = pv[2];
    }
}

void sravel(int body,
    double pt[3],
    double velo[3])
{
/*
Return inertial frame velocity of a point on a body.

*/
    double pv[3];

    if (srachkbnum(22,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(22,23);
        return;
    }
    if (body  ==  -1) {
        velo[0] = 0.;
        velo[1] = 0.;
        velo[2] = 0.;
    } else {
        pv[0] = wb[body][1]*pt[2]-wb[body][2]*pt[1];
        pv[1] = wb[body][2]*pt[0]-wb[body][0]*pt[2];
        pv[2] = wb[body][0]*pt[1]-wb[body][1]*pt[0];
        velo[0] = vnb[body][0]+pv[0]*cnb[body][0][0]+pv[1]*cnb[body][0][1]+pv[2]
          *cnb[body][0][2];
        velo[1] = vnb[body][1]+pv[0]*cnb[body][1][0]+pv[1]*cnb[body][1][1]+pv[2]
          *cnb[body][1][2];
        velo[2] = vnb[body][2]+pv[0]*cnb[body][2][0]+pv[1]*cnb[body][2][1]+pv[2]
          *cnb[body][2][2];
    }
}

void sraorient(int body,
    double dircos[3][3])
{
/*
Return orientation of body w.r.t. ground frame.

*/

    if (srachkbnum(23,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(23,23);
        return;
    }
    if (body == -1) {
        dircos[0][0] = 1.;
        dircos[0][1] = 0.;
        dircos[0][2] = 0.;
        dircos[1][0] = 0.;
        dircos[1][1] = 1.;
        dircos[1][2] = 0.;
        dircos[2][0] = 0.;
        dircos[2][1] = 0.;
        dircos[2][2] = 1.;
    } else {
        dircos[0][0] = cnb[body][0][0];
        dircos[0][1] = cnb[body][0][1];
        dircos[0][2] = cnb[body][0][2];
        dircos[1][0] = cnb[body][1][0];
        dircos[1][1] = cnb[body][1][1];
        dircos[1][2] = cnb[body][1][2];
        dircos[2][0] = cnb[body][2][0];
        dircos[2][1] = cnb[body][2][1];
        dircos[2][2] = cnb[body][2][2];
    }
}

void sraangvel(int body,
    double avel[3])
{
/*
Return angular velocity of the body.

*/

    if (srachkbnum(24,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(24,23);
        return;
    }
    if (body == -1) {
        avel[0] = 0.;
        avel[1] = 0.;
        avel[2] = 0.;
    } else {
        avel[0] = wb[body][0];
        avel[1] = wb[body][1];
        avel[2] = wb[body][2];
    }
}

void sratrans(int frbod,
    double ivec[3],
    int tobod,
    double ovec[3])
{
/*
Transform ivec from frbod frame to tobod frame.

*/
    double pv[3];

    if (srachkbnum(25,frbod) != 0) {
        return;
    }
    if (srachkbnum(25,tobod) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(25,23);
        return;
    }
    if (frbod == tobod) {
        sravcopy(ivec,ovec);
        return;
    }
    if (frbod == -1) {
        sravcopy(ivec,pv);
        ovec[0] = pv[0]*cnb[tobod][0][0]+pv[1]*cnb[tobod][1][0]+pv[2]*cnb[tobod
          ][2][0];
        ovec[1] = pv[0]*cnb[tobod][0][1]+pv[1]*cnb[tobod][1][1]+pv[2]*cnb[tobod
          ][2][1];
        ovec[2] = pv[0]*cnb[tobod][0][2]+pv[1]*cnb[tobod][1][2]+pv[2]*cnb[tobod
          ][2][2];
        return;
    }
    if (tobod == -1) {
        sravcopy(ivec,pv);
        ovec[0] = pv[0]*cnb[frbod][0][0]+pv[1]*cnb[frbod][0][1]+pv[2]*cnb[frbod
          ][0][2];
        ovec[1] = pv[0]*cnb[frbod][1][0]+pv[1]*cnb[frbod][1][1]+pv[2]*cnb[frbod
          ][1][2];
        ovec[2] = pv[0]*cnb[frbod][2][0]+pv[1]*cnb[frbod][2][1]+pv[2]*cnb[frbod
          ][2][2];
        return;
    }
    pv[0] = ivec[0]*cnb[frbod][0][0]+ivec[1]*cnb[frbod][0][1]+ivec[2]*cnb[frbod
      ][0][2];
    pv[1] = ivec[0]*cnb[frbod][1][0]+ivec[1]*cnb[frbod][1][1]+ivec[2]*cnb[frbod
      ][1][2];
    pv[2] = ivec[0]*cnb[frbod][2][0]+ivec[1]*cnb[frbod][2][1]+ivec[2]*cnb[frbod
      ][2][2];
    ovec[0] = pv[0]*cnb[tobod][0][0]+pv[1]*cnb[tobod][1][0]+pv[2]*cnb[tobod][2][
      0];
    ovec[1] = pv[0]*cnb[tobod][0][1]+pv[1]*cnb[tobod][1][1]+pv[2]*cnb[tobod][2][
      1];
    ovec[2] = pv[0]*cnb[tobod][0][2]+pv[1]*cnb[tobod][1][2]+pv[2]*cnb[tobod][2][
      2];
}

void srarel2cart(int coord,
    int body,
    double point[3],
    double linchg[3],
    double rotchg[3])
{
/* Return derivative of pt loc and body orient w.r.t. hinge rate
*/
    int x,i,gnd;
    double lin[3],pv[3];

    if ((coord < 0) || (coord > 6)) {
        sraseterr(59,45);
        return;
    }
    if (srachkbnum(59,body) != 0) {
        return;
    }
    if ((roustate != 2) && (roustate != 3)) {
        sraseterr(59,23);
        return;
    }
    gnd = -1;
    if (body == gnd) {
        x = -1;
    } else {
        x = firstq[body]+njntdof[body]-1;
    }
    if (x < coord) {
        sravset(0.,0.,0.,linchg);
        sravset(0.,0.,0.,rotchg);
        return;
    }
    sradovpk();
    for (i = 0; i < 3; i++) {
        rotchg[i] = Wpk[coord][x][i];
        lin[i] = Vpk[coord][x][i];
    }
    if (body == gnd) {
        sravcopy(point,pv);
    } else {
        pv[0] = rcom[body][0]+point[0];
        pv[1] = rcom[body][1]+point[1];
        pv[2] = rcom[body][2]+point[2];
    }
    sravcross(rotchg,pv,linchg);
    sravadd(linchg,lin,linchg);
}

void sraacc(int body,
    double pt[3],
    double accel[3])
{
/*
Return linear acceleration a point of the specified body.

*/
    double pv[3];

    if (srachkbnum(32,body) != 0) {
        return;
    }
    if (roustate != 3) {
        sraseterr(32,24);
        return;
    }
    if (body  ==  -1) {
        accel[0] = 0.;
        accel[1] = 0.;
        accel[2] = 0.;
    } else {
        pv[0] = pt[0]*dyad[body][0][0]+pt[1]*dyad[body][0][1]+pt[2]*dyad[body][0
          ][2];
        pv[1] = pt[0]*dyad[body][1][0]+pt[1]*dyad[body][1][1]+pt[2]*dyad[body][1
          ][2];
        pv[2] = pt[0]*dyad[body][2][0]+pt[1]*dyad[body][2][1]+pt[2]*dyad[body][2
          ][2];
        accel[0] = anb[body][0]+pv[0]*cnb[body][0][0]+pv[1]*cnb[body][0][1]+pv[2
          ]*cnb[body][0][2];
        accel[1] = anb[body][1]+pv[0]*cnb[body][1][0]+pv[1]*cnb[body][1][1]+pv[2
          ]*cnb[body][1][2];
        accel[2] = anb[body][2]+pv[0]*cnb[body][2][0]+pv[1]*cnb[body][2][1]+pv[2
          ]*cnb[body][2][2];
    }
}

void sraangacc(int body,
    double aacc[3])
{
/*
Return angular acceleration of the body.

*/

    if (srachkbnum(33,body) != 0) {
        return;
    }
    if (roustate != 3) {
        sraseterr(33,24);
        return;
    }
    if (body == -1) {
        aacc[0] = 0.;
        aacc[1] = 0.;
        aacc[2] = 0.;
    } else {
        aacc[0] = onb[body][0];
        aacc[1] = onb[body][1];
        aacc[2] = onb[body][2];
    }
}

void sragrav(double gravin[3])
{

    sraseterr(1,19);
    roustate = 0;
}

void sramass(int body,
    double massin)
{

    if (srachkbnum(2,body) != 0) {
        return;
    }
    if (body == -1) {
        sraseterr(2,15);
        return;
    }
    if (mkq[body] != 0) {
        mk[body] = massin;
        mkq[body] = 3;
    } else {
        sraseterr(2,19);
    }
    roustate = 0;
}

void srainer(int body,
    double inerin[3][3])
{
    int anyques;

    if (srachkbnum(3,body) != 0) {
        return;
    }
    if (body == -1) {
        sraseterr(3,15);
        return;
    }
    anyques = 0;
    if (ikq[body][0][0]  !=  0) {
        ik[body][0][0] = inerin[0][0];
        ikq[body][0][0] = 3;
        anyques = 1;
    }
    if (ikq[body][0][1]  !=  0) {
        ik[body][0][1] = inerin[0][1];
        ikq[body][0][1] = 3;
        ik[body][1][0] = inerin[0][1];
        ikq[body][1][0] = 3;
        anyques = 1;
    }
    if (ikq[body][0][2]  !=  0) {
        ik[body][0][2] = inerin[0][2];
        ikq[body][0][2] = 3;
        ik[body][2][0] = inerin[0][2];
        ikq[body][2][0] = 3;
        anyques = 1;
    }
    if (ikq[body][1][1]  !=  0) {
        ik[body][1][1] = inerin[1][1];
        ikq[body][1][1] = 3;
        anyques = 1;
    }
    if (ikq[body][1][2]  !=  0) {
        ik[body][1][2] = inerin[1][2];
        ikq[body][1][2] = 3;
        ik[body][2][1] = inerin[1][2];
        ikq[body][2][1] = 3;
        anyques = 1;
    }
    if (ikq[body][2][2]  !=  0) {
        ik[body][2][2] = inerin[2][2];
        ikq[body][2][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        sraseterr(3,19);
    }
    roustate = 0;
}

void srabtj(int joint,
    double btjin[3])
{
    int anyques;

    if (srachkjnum(4,joint) != 0) {
        return;
    }
    anyques = 0;
    if (rkq[joint][0]  !=  0) {
        rk[joint][0] = btjin[0];
        rkq[joint][0] = 3;
        anyques = 1;
    }
    if (rkq[joint][1]  !=  0) {
        rk[joint][1] = btjin[1];
        rkq[joint][1] = 3;
        anyques = 1;
    }
    if (rkq[joint][2]  !=  0) {
        rk[joint][2] = btjin[2];
        rkq[joint][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        sraseterr(4,19);
    }
    roustate = 0;
}

void sraitj(int joint,
    double itjin[3])
{
    int anyques;

    if (srachkjnum(5,joint) != 0) {
        return;
    }
    anyques = 0;
    if (riq[joint][0]  !=  0) {
        ri[joint][0] = itjin[0];
        riq[joint][0] = 3;
        anyques = 1;
    }
    if (riq[joint][1]  !=  0) {
        ri[joint][1] = itjin[1];
        riq[joint][1] = 3;
        anyques = 1;
    }
    if (riq[joint][2]  !=  0) {
        ri[joint][2] = itjin[2];
        riq[joint][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        sraseterr(5,19);
    }
    roustate = 0;
}

void srapin(int joint,
    int pinno,
    double pinin[3])
{
    int anyques,offs;

    if (srachkjpin(6,joint,pinno) != 0) {
        return;
    }
    anyques = 0;
    offs = firstq[joint]+pinno;
    if (jtype[joint] == 21) {
        offs = offs+3;
    }
    if (jtype[joint] == 11) {
        offs = offs+1;
    }
    if (pinq[offs][0]  !=  0) {
        pin[offs][0] = pinin[0];
        pinq[offs][0] = 3;
        anyques = 1;
    }
    if (pinq[offs][1]  !=  0) {
        pin[offs][1] = pinin[1];
        pinq[offs][1] = 3;
        anyques = 1;
    }
    if (pinq[offs][2]  !=  0) {
        pin[offs][2] = pinin[2];
        pinq[offs][2] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        sraseterr(6,19);
    }
    roustate = 0;
}

void srapres(int joint,
    int axis,
    int presin)
{
    int anyques;

    if (srachkjaxis(37,joint,axis) != 0) {
        return;
    }
    if ((presin != 0) && (presin != 1)) {
        sraseterr(37,20);
    }
    anyques = 0;
    if (presq[sraindx(joint,axis)]  !=  0) {
        if (presin  !=  0) {
            pres[sraindx(joint,axis)] = 1.;
        } else {
            pres[sraindx(joint,axis)] = 0.;
        }
        presq[sraindx(joint,axis)] = 3;
        anyques = 1;
    }
    if (anyques == 0) {
        sraseterr(37,19);
    }
    wwflg = 0;
}

void sraconschg(void)
{

    wwflg = 0;
}

void srastab(double velin,
    double posin)
{

    stabvel = velin;
    stabvelq = 3;
    stabpos = posin;
    stabposq = 3;
}

void sragetgrav(double gravout[3])
{

    gravout[0] = grav[0];
    gravout[1] = grav[1];
    gravout[2] = grav[2];
}

void sragetmass(int body,
    double *massout)
{

    if (srachkbnum(40,body) != 0) {
        return;
    }
    if (body == -1) {
        sraseterr(40,15);
        return;
    }
    *massout = mk[body];
}

void sragetiner(int body,
    double inerout[3][3])
{

    if (srachkbnum(41,body) != 0) {
        return;
    }
    if (body == -1) {
        sraseterr(41,15);
        return;
    }
    inerout[0][0] = ik[body][0][0];
    inerout[0][1] = ik[body][0][1];
    inerout[0][2] = ik[body][0][2];
    inerout[1][0] = ik[body][1][0];
    inerout[1][1] = ik[body][1][1];
    inerout[1][2] = ik[body][1][2];
    inerout[2][0] = ik[body][2][0];
    inerout[2][1] = ik[body][2][1];
    inerout[2][2] = ik[body][2][2];
}

void sragetbtj(int joint,
    double btjout[3])
{

    if (srachkjnum(42,joint) != 0) {
        return;
    }
    btjout[0] = rk[joint][0];
    btjout[1] = rk[joint][1];
    btjout[2] = rk[joint][2];
}

void sragetitj(int joint,
    double itjout[3])
{

    if (srachkjnum(43,joint) != 0) {
        return;
    }
    itjout[0] = ri[joint][0];
    itjout[1] = ri[joint][1];
    itjout[2] = ri[joint][2];
}

void sragetpin(int joint,
    int pinno,
    double pinout[3])
{
    int offs;

    if (srachkjpin(44,joint,pinno) != 0) {
        return;
    }
    offs = firstq[joint]+pinno;
    if (jtype[joint] == 21) {
        offs = offs+3;
    }
    if (jtype[joint] == 11) {
        offs = offs+1;
    }
    pinout[0] = pin[offs][0];
    pinout[1] = pin[offs][1];
    pinout[2] = pin[offs][2];
}

void sragetpres(int joint,
    int axis,
    int *presout)
{

    if (srachkjaxis(45,joint,axis) != 0) {
        return;
    }
    if (pres[sraindx(joint,axis)]  !=  0.) {
        *presout = 1;
    } else {
        *presout = 0;
    }
}

void sragetstab(double *velout,
    double *posout)
{

    *velout = stabvel;
    *posout = stabpos;
}

void srainfo(int info[50])
{

    info[0] = ground;
    info[1] = nbod;
    info[2] = ndof;
    info[3] = ncons;
    info[4] = nloop;
    info[5] = nldof;
    info[6] = nloopc;
    info[7] = nball;
    info[8] = nlball;
    info[9] = npres;
    info[10] = nuser;
    info[11] = 0;
/* info entries from 12-49 are reserved */
}

void srajnt(int joint,
    int info[50],
    int tran[6])
{
    int i,offs;

    if (srachkjnum(48,joint) != 0) {
        return;
    }
    info[0] = jtype[joint];
    info[1] = 0;
    offs = 0;
    info[2] = inb[joint];
    info[3] = outb[joint];
    info[4] = njntdof[joint];
    info[5] = njntc[joint];
    info[6] = njntp[joint];
    info[7] = firstq[joint];
    info[8] = ballq[joint];
    info[9] = firstm[joint];
    info[10] = firstp[joint];
/* info entries from 11-49 are reserved */

    for (i = 0; i <= 5; i++) {
        if (i  <  njntdof[joint]) {
            tran[i] = trans[offs+firstq[joint]+i];
        } else {
            tran[i] = -1;
        }
    }
}

void sracons(int consno,
    int info[50])
{

    if (srachkucnum(49,consno) != 0) {
        return;
    }
/* There are no user constraints in this problem. */
}

void sragentime(int *gentm)
{

    *gentm = 210729;
}
/*
Done. CPU seconds used: 0.13  Memory used: 1687552 bytes.
Equation complexity:
  sdstate:   130 adds   148 multiplies     2 divides   227 assignments
  sdderiv:   400 adds   424 multiplies     7 divides   577 assignments
  sdresid:   244 adds   181 multiplies     0 divides   249 assignments
  sdreac:    139 adds    79 multiplies     0 divides   126 assignments
  sdmom:      39 adds    43 multiplies     0 divides    22 assignments
  sdsys:      57 adds    78 multiplies     0 divides    16 assignments
*/
