/*****************************************************************************/
/* See notes file */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "../dm/dm.h"
#include "lqrd.h"

/*****************************************************************************/
/*****************************************************************************/

int my_integrate_one_step( void *s, double *state, double *action, int index,
			   double *next_state )
{
  int i;
  double result[2];

  result[0] = 0.999291963315052*state[0] + 0.00962740370979986*state[1] + 0.000149625933865138*action[0];
  result[1] = -0.141607337761918*state[0] + 0.925480741747187*state[1] + 0.029925187032419*action[0];
  if ( next_state != NULL )
    for ( i = 0; i < 2; i++ )
      next_state[i] = result[i];
}

/*****************************************************************************/

double my_one_step_cost( void *s, double *state, double *action, int index )
{
  int i;
  double cost;

  cost = 0.5*(0.001*state[0]*state[0] + 0.001*state[1]*state[1] + 0.01*action[0]*action[0]);

  return cost;
}

/*****************************************************************************/

main()
{
  LQRD *z = NULL;
  double x[2];
  double u[1];

  z = initialize_lqrd( 2,
		       1,
                       1000,
                       my_integrate_one_step,
		       my_one_step_cost,
		       NULL );
  dm_zero( z->P_ss, z->n_states, z->n_states );
  x[0] = x[1] = 0;
  u[0] = 0;
  design_steady_state_lqr_controller( z, x, u );
}

/*****************************************************************************/
