/************************************************************************/
/* 8/22/02: fixed indices of d3v_x_, d3m_x_, d4v_x_, and d4m_x_ to start with 0
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>

/************************************************************************/

double *xdv( rows )
int rows;
{

  int i;
  double *v;

  v=(double *) malloc((unsigned) (rows)*sizeof(double));
  if (!v)
    {
      fprintf( stderr, "allocation failure 1 in dv()");
      exit( -1 );
    }
  return v;
}

/************************************************************************/

double **dm( rows, columns )
int rows, columns;
{

  int i;
  double **m;

  m=(double **) malloc((unsigned) (rows)*sizeof(double*));
  if (!m)
    {
      fprintf( stderr, "allocation failure 1 in dm()");
      exit( -1 );
    }

  for(i=0;i<rows;i++)
    {
      m[i]=(double *) malloc((unsigned) (columns)*sizeof(double));
      if (!m[i])
	{
	  fprintf( stderr, "allocation failure 2 in dm()");
	  exit( -1 );
	}
    }
  return m;
}

/************************************************************************/

double ***d3( i1, i2, i3 )
     int i1, i2, i3;
{
  int i;
  double ***m;

  m=(double ***) malloc((unsigned) (i1)*sizeof(double**));
  if (!m)
    {
      fprintf( stderr, "allocation failure 1 in d3()");
      exit( -1 );
    }
  for (i=0; i<i1; i++)
    {
      m[i] = dm( i2, i3 );
    }
  return m;
}

/************************************************************************/

double ****d4( i1, i2, i3, i4 )
     int i1, i2, i3, i4;
{
  int i;
  double ****m;

  m=(double ****) malloc((unsigned) (i1)*sizeof(double***));
  if (!m)
    {
      fprintf( stderr, "allocation failure 1 in d4()");
      exit( -1 );
    }
  for (i=0; i<i1; i++)
    {
      m[i] = d3( i2, i3, i4 );
    }
  return m;
}

/************************************************************************/

double *****d5( i1, i2, i3, i4, i5 )
     int i1, i2, i3, i4, i5;
{
  int i;
  double *****m;

  m=(double *****) malloc((unsigned) (i1)*sizeof(double****));
  if (!m)
    {
      fprintf( stderr, "allocation failure 1 in d5()");
      exit( -1 );
    }
  for (i=0; i<i1; i++)
    {
      m[i] = d4( i2, i3, i4, i5 );
    }
  return m;
}

/************************************************************************/
/* Formerly dv_read. */

dv_scanf( fp, v, n )
     FILE *fp;
     double *v;
     int n;
{
  int i;

  for( i = 0; i < n; i++ )
    {
      if ( fscanf( fp, "%lf", &(v[i]) ) < 1 )
	{
	  fprintf( stderr, "dv_scanf error: %d\n", i );
	  exit( -1 );
	}
    }
}

/************************************************************************/
/* Should have been dv_printf */

dv_print( fp, spec, v, n )
     FILE *fp;
     char *spec;
     double *v;
     int n;
{
  int i;

  for( i = 0; i < n; i++ )
    {
      fprintf( fp, spec, v[i] );
    }
}

/************************************************************************/

dv_read( fp, v, n )
     FILE *fp;
     double *v;
     int n;
{
  return ( fread( (void *) v, sizeof( double ), n, fp ) == n );
}

/************************************************************************/

dv_write( fp, v, n )
     FILE *fp;
     double *v;
     int n;
{
  return ( fwrite( (void *) v, sizeof( double ), n, fp ) == n );
}

/************************************************************************/

dv_zero( v, r )
     double *v;
     int r;
{
  int i;

  for( i = 0; i < r; i++ )
    v[i] = 0.0;
}

dv_copy( v1, v2, r)
     double *v1, *v2;
     int r;
{
  int i;

  for( i = 0; i < r; i++ )
      {
	v2[i] = v1[i];
      }
}

dv_equal( v1, v2, r)
     double *v1, *v2;
     int r;
{
  int i;

  for( i = 0; i < r; i++ )
      {
	if ( v2[i] != v1[i] )
	  return 0;
      }
  return 1;
}

dv_scale( v1, s, v2, r)
     double *v1, *v2;
     double s;
     int r;
{
  int i;

  for( i = 0; i < r; i++ )
      {
	v2[i] = s*v1[i];
      }
}

dv_acc( v1, v2, r)
     double *v1, *v2;
     int r;
{
  int i;

  for( i = 0; i < r; i++ )
      {
	v2[i] += v1[i];
      }
}

dv_add( v1, v2, v3, r )
     double *v1, *v2, *v3;
     int r;
{
  int i;

  for( i = 0; i < r; i++ )
      {
	v3[i] = v1[i] + v2[i];
      }
}

dv_subtract( v1, v2, v3, r )
     double *v1, *v2, *v3;
     int r;
{
  int i;

  for( i = 0; i < r; i++ )
      {
	v3[i] = v1[i] - v2[i];
      }
}

/* Should change the name of this to dv_dot */
dvv1_mult( v1, v2, result, size )
     double *v1, *v2;
     double *result;
     int size;
{
  int i;
  double sum = 0;
  
  for( i = 0; i < size; i++ )
      {
	sum += v1[i]*v2[i];
      }
  *result = sum;
}

dv_dot( v1, v2, result, size )
     double *v1, *v2;
     double *result;
     int size;
{
  int i;
  double sum = 0;
  
  for( i = 0; i < size; i++ )
      {
	sum += v1[i]*v2[i];
      }
  *result = sum;
}

dv_distance2( v1, v2, result, size )
     double *v1, *v2;
     double *result;
     int size;
{
  int i;
  double sum = 0;
  
  for( i = 0; i < size; i++ )
      {
	sum += (v1[i]-v2[i])*(v1[i]-v2[i]);
      }
  *result = sum;
}


dv_norm( v1, result, size )
     double *v1;
     double *result;
     int size;
{
  int i;
  double sum = 0;
  
  for( i = 0; i < size; i++ )
      {
	sum += v1[i]*v1[i];
      }
  *result = sum;
}

dvvt( v, result, size )
     double *v;
     double **result;
     int size;
{
  int i, k;

  for( i = 0; i < size; i++ )
    for( k = 0; k < size; k++ )
      result[i][k] = v[i]*v[k];
}     

/* Not really sure what this one is for, see dvvt */
dv1v2t( v1, v2, result, size1, size2 )
     double *v1, *v2;
     double **result;
     int size1, size2;
{
  int row, column;

  for( row = 0; row < size1; row++ )
    for( column = 0; column < size2; column++ )
      result[row][column] = v1[row]*v2[column];
}     

dvm_mult( v1, m1, v2, r, c)
     double *v1, **m1, *v2;
     int r, c;
{
  int i, k;

  for( i = 0; i < c; i++ )
      {
	v2[i] = 0.0;
	for( k = 0; k < r; k++ )
	  v2[i] += v1[k] * m1[k][i];
      }
}

dmv_mult( m1, v1, v2, r, c )
     double **m1, *v1, *v2;
     int r, c;
{
  int i, k;

  for( i = 0; i < r; i++ )
      {
	v2[i] = 0.0;
	for( k = 0; k < c; k++ )
	  v2[i] += v1[k] * m1[i][k];
      }
}

/************************************************************************/
/* Formerly dm_read. */

dm_scanf( fp, m, r, c )
     FILE *fp;
     double **m;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	if ( fscanf( fp, "%lf", &(m[i][j]) ) < 1 )
	  {
	    fprintf( stderr, "dm_scanf error: %d %d\n", i, j );
	    exit( -1 );
	  }
      }
}

/************************************************************************/
/* Should have been dm_printf */

dm_print( fp, spec, newline, m, r, c )
     FILE *fp;
     char *spec, *newline;
     double **m;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    {
      for( j = 0; j < c; j++ )
	{
	  fprintf( fp, spec, m[i][j] );
	}
      fprintf( fp, newline );
    }
}

/************************************************************************/

dm_read( fp, m, r, c )
     FILE *fp;
     double **m;
     int r, c;
{
  int i;

  for ( i = 0; i < r; i++ )
    {
      if ( fread( (void *) &(m[i][0]), sizeof( double ), c, fp ) != c )
	{
	  fprintf( stderr, "dm_read error: %d\n", i );
	  exit( -1 );
	}
    }
}

/************************************************************************/

dm_write( fp, m, r, c )
     FILE *fp;
     double **m;
     int r, c;
{
  int i;

  for ( i = 0; i < r; i++ )
    {
      if ( fwrite( (void *) &(m[i][0]), sizeof( double ), c, fp ) != c )
	{
	  fprintf( stderr, "dm_write error: %d\n", i );
	  exit( -1 );
	}
    }
}

/************************************************************************/

dm_zero( m1, r, c )
     double **m1;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	m1[i][j] = 0.0;
      }
}

dm_equal( m1, m2, r, c )
     double **m1, **m2;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	if ( m2[i][j] != m1[i][j] )
	  return 0;
      }
  return 1;
}

dm_copy( m1, m2, r, c )
     double **m1, **m2;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	m2[i][j] = m1[i][j];
      }
}


dm_scale( m1, s, m2, r, c )
     double **m1, **m2;
     double s;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	m2[i][j] = s*m1[i][j];
      }
}


dm_transpose( m1, m2, r, c )
     double **m1, **m2;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	m2[j][i] = m1[i][j];
      }
}

dm_acc( m1, m2, r, c )
     double **m1, **m2;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	m2[i][j] += m1[i][j];
      }
}

dm_add( m1, m2, m3, r, c )
     double **m1, **m2, **m3;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	m3[i][j] = m1[i][j] + m2[i][j];
      }
}

dm_subtract( m1, m2, m3, r, c )
     double **m1, **m2, **m3;
     int r, c;
{
  int i, j;

  for( i = 0; i < r; i++ )
    for( j = 0; j < c; j++ )
      {
	m3[i][j] = m1[i][j] - m2[i][j];
      }
}

dm_mult( m1, m2, m3, r1, c1, c2 )
     double **m1, **m2, **m3;
     int r1, c1, c2;
{
  int i, j, k;

  for( i = 0; i < r1; i++ )
    for( j = 0; j < c2; j++ )
      {
	m3[i][j] = 0.0;
	for( k = 0; k < c1; k++ )
	  m3[i][j] += m1[i][k]*m2[k][j];
      }
}

dm_mult_acc( m1, m2, m3, r1, c1, c2 )
     double **m1, **m2, **m3;
     int r1, c1, c2;
{
  int i, j, k;

  for( i = 0; i < r1; i++ )
    for( j = 0; j < c2; j++ )
      {
	for( k = 0; k < c1; k++ )
	  m3[i][j] += m1[i][k]*m2[k][j];
      }
}

dm_norm( m, result, r, c )
     double **m;
     double *result;
     int r, c;
{
  int i, j;

  double norm = 0;

  for ( i = 0; i < r; i++ )
    for ( j = 0; j < c; j++ )
      norm += m[i][j] * m[i][j];
  *result = norm;
}

dm_distance2( m1, m2, result, r, c )
     double **m1;
     double **m2;
     double *result;
     int r, c;
{
  int i, j;

  double norm = 0;

  for ( i = 0; i < r; i++ )
    for ( j = 0; j < c; j++ )
      norm += (m1[i][j] - m2[i][j])*(m1[i][j] - m2[i][j]);
  *result = norm;
}

/************************************************************************/

dm_invert( m, result, r )
     double **m;
     double **result;
     int r;
{
  double one_over_determinant;

  switch( r )
    {
    case 1: /* 1x1 case: */ 
      result[0][0] = 1.0/m[0][0];
      break;
    case 2: /* 2x2 case: */  
      one_over_determinant = 1/(m[0][0]*m[1][1] - m[1][0]*m[0][1]);
      result[0][0] = m[1][1]*one_over_determinant;
      result[0][1] = -m[0][1]*one_over_determinant;
      result[1][0] = -m[1][0]*one_over_determinant;
      result[1][1] = m[0][0]*one_over_determinant;
      break;
    case 3: /* 3x3 case: */
      one_over_determinant = 1/(- m[0][2]*m[1][1]*m[2][0] + m[0][1]*m[1][2]*m[2][0] 
				+ m[0][2]*m[1][0]*m[2][1] - m[0][0]*m[1][2]*m[2][1]
				- m[0][1]*m[1][0]*m[2][2] + m[0][0]*m[1][1]*m[2][2]);
      result[0][0] = (- m[1][2]*m[2][1] + m[1][1]*m[2][2])*one_over_determinant;
      result[0][1] = (m[0][2]*m[2][1] - m[0][1]*m[2][2])*one_over_determinant;
      result[0][2] = (- m[0][2]*m[1][1] + m[0][1]*m[1][2])*one_over_determinant; 
      result[1][0] = (m[1][2]*m[2][0] - m[1][0]*m[2][2])*one_over_determinant;
      result[1][1] = (- m[0][2]*m[2][0] + m[0][0]*m[2][2])*one_over_determinant;
      result[1][2] = (m[0][2]*m[1][0] - m[0][0]*m[1][2])*one_over_determinant;
      result[2][0] = (- m[1][1]*m[2][0] + m[1][0]*m[2][1])*one_over_determinant;
      result[2][1] = (m[0][1]*m[2][0] - m[0][0]*m[2][1])*one_over_determinant;
      result[2][2] = (- m[0][1]*m[1][0] + m[0][0]*m[1][1])*one_over_determinant;
      break;
    case 4: /* 4x4 case: */
      one_over_determinant =
	1/(m[0][3]*m[1][2]*m[2][1]*m[3][0] - m[0][2]*m[1][3]*m[2][1]*m[3][0] 
	   - m[0][3]*m[1][1]*m[2][2]*m[3][0] + m[0][1]*m[1][3]*m[2][2]*m[3][0] 
	   + m[0][2]*m[1][1]*m[2][3]*m[3][0] - m[0][1]*m[1][2]*m[2][3]*m[3][0] 
	   - m[0][3]*m[1][2]*m[2][0]*m[3][1] + m[0][2]*m[1][3]*m[2][0]*m[3][1] 
	   + m[0][3]*m[1][0]*m[2][2]*m[3][1] - m[0][0]*m[1][3]*m[2][2]*m[3][1] 
	   - m[0][2]*m[1][0]*m[2][3]*m[3][1] + m[0][0]*m[1][2]*m[2][3]*m[3][1] 
	   + m[0][3]*m[1][1]*m[2][0]*m[3][2] - m[0][1]*m[1][3]*m[2][0]*m[3][2]
	   - m[0][3]*m[1][0]*m[2][1]*m[3][2] + m[0][0]*m[1][3]*m[2][1]*m[3][2] 
	   + m[0][1]*m[1][0]*m[2][3]*m[3][2] - m[0][0]*m[1][1]*m[2][3]*m[3][2] 
	   - m[0][2]*m[1][1]*m[2][0]*m[3][3] + m[0][1]*m[1][2]*m[2][0]*m[3][3] 
	   + m[0][2]*m[1][0]*m[2][1]*m[3][3] - m[0][0]*m[1][2]*m[2][1]*m[3][3] 
	   - m[0][1]*m[1][0]*m[2][2]*m[3][3] + m[0][0]*m[1][1]*m[2][2]*m[3][3]);
      result[0][0] = (-(m[1][3]*m[2][2]*m[3][1]) + m[1][2]*m[2][3]*m[3][1] 
		      + m[1][3]*m[2][1]*m[3][2] - m[1][1]*m[2][3]*m[3][2] 
		      - m[1][2]*m[2][1]*m[3][3] + m[1][1]*m[2][2]*m[3][3])*one_over_determinant;
      result[0][1] = (m[0][3]*m[2][2]*m[3][1] - m[0][2]*m[2][3]*m[3][1] 
		      - m[0][3]*m[2][1]*m[3][2] + m[0][1]*m[2][3]*m[3][2] 
		      + m[0][2]*m[2][1]*m[3][3] - m[0][1]*m[2][2]*m[3][3])*one_over_determinant;
      result[0][2] = (-(m[0][3]*m[1][2]*m[3][1]) + m[0][2]*m[1][3]*m[3][1] 
		      + m[0][3]*m[1][1]*m[3][2] - m[0][1]*m[1][3]*m[3][2] 
		      - m[0][2]*m[1][1]*m[3][3] + m[0][1]*m[1][2]*m[3][3])*one_over_determinant;
      result[0][3] = (m[0][3]*m[1][2]*m[2][1] - m[0][2]*m[1][3]*m[2][1] 
		      - m[0][3]*m[1][1]*m[2][2] + m[0][1]*m[1][3]*m[2][2] 
		      + m[0][2]*m[1][1]*m[2][3] - m[0][1]*m[1][2]*m[2][3])*one_over_determinant;
      result[1][0] = (m[1][3]*m[2][2]*m[3][0] - m[1][2]*m[2][3]*m[3][0] 
		      - m[1][3]*m[2][0]*m[3][2] + m[1][0]*m[2][3]*m[3][2] 
		      + m[1][2]*m[2][0]*m[3][3] - m[1][0]*m[2][2]*m[3][3])*one_over_determinant;
      result[1][1] = (-(m[0][3]*m[2][2]*m[3][0]) + m[0][2]*m[2][3]*m[3][0] 
		      + m[0][3]*m[2][0]*m[3][2] - m[0][0]*m[2][3]*m[3][2] 
		      - m[0][2]*m[2][0]*m[3][3] + m[0][0]*m[2][2]*m[3][3])*one_over_determinant;
      result[1][2] = (m[0][3]*m[1][2]*m[3][0] - m[0][2]*m[1][3]*m[3][0] 
		      - m[0][3]*m[1][0]*m[3][2] + m[0][0]*m[1][3]*m[3][2] 
		      + m[0][2]*m[1][0]*m[3][3] - m[0][0]*m[1][2]*m[3][3])*one_over_determinant;
      result[1][3] = (-(m[0][3]*m[1][2]*m[2][0]) + m[0][2]*m[1][3]*m[2][0] 
		      + m[0][3]*m[1][0]*m[2][2] - m[0][0]*m[1][3]*m[2][2] 
		      - m[0][2]*m[1][0]*m[2][3] + m[0][0]*m[1][2]*m[2][3])*one_over_determinant;
      result[2][0] = (-(m[1][3]*m[2][1]*m[3][0]) + m[1][1]*m[2][3]*m[3][0] 
		      + m[1][3]*m[2][0]*m[3][1] - m[1][0]*m[2][3]*m[3][1] 
		      - m[1][1]*m[2][0]*m[3][3] + m[1][0]*m[2][1]*m[3][3])*one_over_determinant;
      result[2][1] = (m[0][3]*m[2][1]*m[3][0] - m[0][1]*m[2][3]*m[3][0] 
		      - m[0][3]*m[2][0]*m[3][1] + m[0][0]*m[2][3]*m[3][1] 
		      + m[0][1]*m[2][0]*m[3][3] - m[0][0]*m[2][1]*m[3][3])*one_over_determinant;
      result[2][2] = (-(m[0][3]*m[1][1]*m[3][0]) + m[0][1]*m[1][3]*m[3][0] 
		      + m[0][3]*m[1][0]*m[3][1] - m[0][0]*m[1][3]*m[3][1] 
		      - m[0][1]*m[1][0]*m[3][3] + m[0][0]*m[1][1]*m[3][3])*one_over_determinant;
      result[2][3] = (m[0][3]*m[1][1]*m[2][0] - m[0][1]*m[1][3]*m[2][0] 
		      - m[0][3]*m[1][0]*m[2][1] + m[0][0]*m[1][3]*m[2][1] 
		      + m[0][1]*m[1][0]*m[2][3] - m[0][0]*m[1][1]*m[2][3])*one_over_determinant;
      result[3][0] = (m[1][2]*m[2][1]*m[3][0] - m[1][1]*m[2][2]*m[3][0] 
		      - m[1][2]*m[2][0]*m[3][1] + m[1][0]*m[2][2]*m[3][1] 
		      + m[1][1]*m[2][0]*m[3][2] - m[1][0]*m[2][1]*m[3][2])*one_over_determinant;
      result[3][1] = (-(m[0][2]*m[2][1]*m[3][0]) + m[0][1]*m[2][2]*m[3][0] 
		      + m[0][2]*m[2][0]*m[3][1] - m[0][0]*m[2][2]*m[3][1] 
		      - m[0][1]*m[2][0]*m[3][2] + m[0][0]*m[2][1]*m[3][2])*one_over_determinant;
      result[3][2] = (m[0][2]*m[1][1]*m[3][0] - m[0][1]*m[1][2]*m[3][0] 
		      - m[0][2]*m[1][0]*m[3][1] + m[0][0]*m[1][2]*m[3][1] 
		      + m[0][1]*m[1][0]*m[3][2] - m[0][0]*m[1][1]*m[3][2])*one_over_determinant;
      result[3][3] = (-(m[0][2]*m[1][1]*m[2][0]) + m[0][1]*m[1][2]*m[2][0] 
		      + m[0][2]*m[1][0]*m[2][1] - m[0][0]*m[1][2]*m[2][1] 
		      - m[0][1]*m[1][0]*m[2][2] + m[0][0]*m[1][1]*m[2][2])*one_over_determinant;
      break;
    case 5: /* 5x5 case: */
      one_over_determinant =
	1/(m[0][4]*m[1][3]*m[2][2]*m[3][1]*m[4][0] - m[0][3]*m[1][4]*m[2][2]*m[3][1]*m[4][0] - m[0][4]*m[1][2]*m[2][3]*m[3][1]*m[4][0] + 
	   m[0][2]*m[1][4]*m[2][3]*m[3][1]*m[4][0] + m[0][3]*m[1][2]*m[2][4]*m[3][1]*m[4][0] - m[0][2]*m[1][3]*m[2][4]*m[3][1]*m[4][0] - 
	   m[0][4]*m[1][3]*m[2][1]*m[3][2]*m[4][0] + m[0][3]*m[1][4]*m[2][1]*m[3][2]*m[4][0] + m[0][4]*m[1][1]*m[2][3]*m[3][2]*m[4][0] - 
	   m[0][1]*m[1][4]*m[2][3]*m[3][2]*m[4][0] - m[0][3]*m[1][1]*m[2][4]*m[3][2]*m[4][0] + m[0][1]*m[1][3]*m[2][4]*m[3][2]*m[4][0] + 
	   m[0][4]*m[1][2]*m[2][1]*m[3][3]*m[4][0] - m[0][2]*m[1][4]*m[2][1]*m[3][3]*m[4][0] - m[0][4]*m[1][1]*m[2][2]*m[3][3]*m[4][0] + 
	   m[0][1]*m[1][4]*m[2][2]*m[3][3]*m[4][0] + m[0][2]*m[1][1]*m[2][4]*m[3][3]*m[4][0] - m[0][1]*m[1][2]*m[2][4]*m[3][3]*m[4][0] - 
	   m[0][3]*m[1][2]*m[2][1]*m[3][4]*m[4][0] + m[0][2]*m[1][3]*m[2][1]*m[3][4]*m[4][0] + m[0][3]*m[1][1]*m[2][2]*m[3][4]*m[4][0] - 
	   m[0][1]*m[1][3]*m[2][2]*m[3][4]*m[4][0] - m[0][2]*m[1][1]*m[2][3]*m[3][4]*m[4][0] + m[0][1]*m[1][2]*m[2][3]*m[3][4]*m[4][0] - 
	   m[0][4]*m[1][3]*m[2][2]*m[3][0]*m[4][1] + m[0][3]*m[1][4]*m[2][2]*m[3][0]*m[4][1] + m[0][4]*m[1][2]*m[2][3]*m[3][0]*m[4][1] - 
	   m[0][2]*m[1][4]*m[2][3]*m[3][0]*m[4][1] - m[0][3]*m[1][2]*m[2][4]*m[3][0]*m[4][1] + m[0][2]*m[1][3]*m[2][4]*m[3][0]*m[4][1] + 
	   m[0][4]*m[1][3]*m[2][0]*m[3][2]*m[4][1] - m[0][3]*m[1][4]*m[2][0]*m[3][2]*m[4][1] - m[0][4]*m[1][0]*m[2][3]*m[3][2]*m[4][1] + 
	   m[0][0]*m[1][4]*m[2][3]*m[3][2]*m[4][1] + m[0][3]*m[1][0]*m[2][4]*m[3][2]*m[4][1] - m[0][0]*m[1][3]*m[2][4]*m[3][2]*m[4][1] - 
	   m[0][4]*m[1][2]*m[2][0]*m[3][3]*m[4][1] + m[0][2]*m[1][4]*m[2][0]*m[3][3]*m[4][1] + m[0][4]*m[1][0]*m[2][2]*m[3][3]*m[4][1] - 
	   m[0][0]*m[1][4]*m[2][2]*m[3][3]*m[4][1] - m[0][2]*m[1][0]*m[2][4]*m[3][3]*m[4][1] + m[0][0]*m[1][2]*m[2][4]*m[3][3]*m[4][1] + 
	   m[0][3]*m[1][2]*m[2][0]*m[3][4]*m[4][1] - m[0][2]*m[1][3]*m[2][0]*m[3][4]*m[4][1] - m[0][3]*m[1][0]*m[2][2]*m[3][4]*m[4][1] + 
	   m[0][0]*m[1][3]*m[2][2]*m[3][4]*m[4][1] + m[0][2]*m[1][0]*m[2][3]*m[3][4]*m[4][1] - m[0][0]*m[1][2]*m[2][3]*m[3][4]*m[4][1] + 
	   m[0][4]*m[1][3]*m[2][1]*m[3][0]*m[4][2] - m[0][3]*m[1][4]*m[2][1]*m[3][0]*m[4][2] - m[0][4]*m[1][1]*m[2][3]*m[3][0]*m[4][2] + 
	   m[0][1]*m[1][4]*m[2][3]*m[3][0]*m[4][2] + m[0][3]*m[1][1]*m[2][4]*m[3][0]*m[4][2] - m[0][1]*m[1][3]*m[2][4]*m[3][0]*m[4][2] - 
	   m[0][4]*m[1][3]*m[2][0]*m[3][1]*m[4][2] + m[0][3]*m[1][4]*m[2][0]*m[3][1]*m[4][2] + m[0][4]*m[1][0]*m[2][3]*m[3][1]*m[4][2] - 
	   m[0][0]*m[1][4]*m[2][3]*m[3][1]*m[4][2] - m[0][3]*m[1][0]*m[2][4]*m[3][1]*m[4][2] + m[0][0]*m[1][3]*m[2][4]*m[3][1]*m[4][2] + 
	   m[0][4]*m[1][1]*m[2][0]*m[3][3]*m[4][2] - m[0][1]*m[1][4]*m[2][0]*m[3][3]*m[4][2] - m[0][4]*m[1][0]*m[2][1]*m[3][3]*m[4][2] + 
	   m[0][0]*m[1][4]*m[2][1]*m[3][3]*m[4][2] + m[0][1]*m[1][0]*m[2][4]*m[3][3]*m[4][2] - m[0][0]*m[1][1]*m[2][4]*m[3][3]*m[4][2] - 
	   m[0][3]*m[1][1]*m[2][0]*m[3][4]*m[4][2] + m[0][1]*m[1][3]*m[2][0]*m[3][4]*m[4][2] + m[0][3]*m[1][0]*m[2][1]*m[3][4]*m[4][2] - 
	   m[0][0]*m[1][3]*m[2][1]*m[3][4]*m[4][2] - m[0][1]*m[1][0]*m[2][3]*m[3][4]*m[4][2] + m[0][0]*m[1][1]*m[2][3]*m[3][4]*m[4][2] - 
	   m[0][4]*m[1][2]*m[2][1]*m[3][0]*m[4][3] + m[0][2]*m[1][4]*m[2][1]*m[3][0]*m[4][3] + m[0][4]*m[1][1]*m[2][2]*m[3][0]*m[4][3] - 
	   m[0][1]*m[1][4]*m[2][2]*m[3][0]*m[4][3] - m[0][2]*m[1][1]*m[2][4]*m[3][0]*m[4][3] + m[0][1]*m[1][2]*m[2][4]*m[3][0]*m[4][3] + 
	   m[0][4]*m[1][2]*m[2][0]*m[3][1]*m[4][3] - m[0][2]*m[1][4]*m[2][0]*m[3][1]*m[4][3] - m[0][4]*m[1][0]*m[2][2]*m[3][1]*m[4][3] + 
	   m[0][0]*m[1][4]*m[2][2]*m[3][1]*m[4][3] + m[0][2]*m[1][0]*m[2][4]*m[3][1]*m[4][3] - m[0][0]*m[1][2]*m[2][4]*m[3][1]*m[4][3] - 
	   m[0][4]*m[1][1]*m[2][0]*m[3][2]*m[4][3] + m[0][1]*m[1][4]*m[2][0]*m[3][2]*m[4][3] + m[0][4]*m[1][0]*m[2][1]*m[3][2]*m[4][3] - 
	   m[0][0]*m[1][4]*m[2][1]*m[3][2]*m[4][3] - m[0][1]*m[1][0]*m[2][4]*m[3][2]*m[4][3] + m[0][0]*m[1][1]*m[2][4]*m[3][2]*m[4][3] + 
	   m[0][2]*m[1][1]*m[2][0]*m[3][4]*m[4][3] - m[0][1]*m[1][2]*m[2][0]*m[3][4]*m[4][3] - m[0][2]*m[1][0]*m[2][1]*m[3][4]*m[4][3] + 
	   m[0][0]*m[1][2]*m[2][1]*m[3][4]*m[4][3] + m[0][1]*m[1][0]*m[2][2]*m[3][4]*m[4][3] - m[0][0]*m[1][1]*m[2][2]*m[3][4]*m[4][3] + 
	   m[0][3]*m[1][2]*m[2][1]*m[3][0]*m[4][4] - m[0][2]*m[1][3]*m[2][1]*m[3][0]*m[4][4] - m[0][3]*m[1][1]*m[2][2]*m[3][0]*m[4][4] + 
	   m[0][1]*m[1][3]*m[2][2]*m[3][0]*m[4][4] + m[0][2]*m[1][1]*m[2][3]*m[3][0]*m[4][4] - m[0][1]*m[1][2]*m[2][3]*m[3][0]*m[4][4] - 
	   m[0][3]*m[1][2]*m[2][0]*m[3][1]*m[4][4] + m[0][2]*m[1][3]*m[2][0]*m[3][1]*m[4][4] + m[0][3]*m[1][0]*m[2][2]*m[3][1]*m[4][4] - 
	   m[0][0]*m[1][3]*m[2][2]*m[3][1]*m[4][4] - m[0][2]*m[1][0]*m[2][3]*m[3][1]*m[4][4] + m[0][0]*m[1][2]*m[2][3]*m[3][1]*m[4][4] + 
	   m[0][3]*m[1][1]*m[2][0]*m[3][2]*m[4][4] - m[0][1]*m[1][3]*m[2][0]*m[3][2]*m[4][4] - m[0][3]*m[1][0]*m[2][1]*m[3][2]*m[4][4] + 
	   m[0][0]*m[1][3]*m[2][1]*m[3][2]*m[4][4] + m[0][1]*m[1][0]*m[2][3]*m[3][2]*m[4][4] - m[0][0]*m[1][1]*m[2][3]*m[3][2]*m[4][4] - 
	   m[0][2]*m[1][1]*m[2][0]*m[3][3]*m[4][4] + m[0][1]*m[1][2]*m[2][0]*m[3][3]*m[4][4] + m[0][2]*m[1][0]*m[2][1]*m[3][3]*m[4][4] - 
	   m[0][0]*m[1][2]*m[2][1]*m[3][3]*m[4][4] - m[0][1]*m[1][0]*m[2][2]*m[3][3]*m[4][4] + m[0][0]*m[1][1]*m[2][2]*m[3][3]*m[4][4]);

      result[0][0] = (m[1][4]*m[2][3]*m[3][2]*m[4][1] - m[1][3]*m[2][4]*m[3][2]*m[4][1] - 
		      m[1][4]*m[2][2]*m[3][3]*m[4][1] + m[1][2]*m[2][4]*m[3][3]*m[4][1] + m[1][3]*m[2][2]*m[3][4]*m[4][1] - m[1][2]*m[2][3]*m[3][4]*m[4][1] - 
		      m[1][4]*m[2][3]*m[3][1]*m[4][2] + m[1][3]*m[2][4]*m[3][1]*m[4][2] + m[1][4]*m[2][1]*m[3][3]*m[4][2] - m[1][1]*m[2][4]*m[3][3]*m[4][2] - 
		      m[1][3]*m[2][1]*m[3][4]*m[4][2] + m[1][1]*m[2][3]*m[3][4]*m[4][2] + m[1][4]*m[2][2]*m[3][1]*m[4][3] - m[1][2]*m[2][4]*m[3][1]*m[4][3] - 
		      m[1][4]*m[2][1]*m[3][2]*m[4][3] + m[1][1]*m[2][4]*m[3][2]*m[4][3] + m[1][2]*m[2][1]*m[3][4]*m[4][3] - m[1][1]*m[2][2]*m[3][4]*m[4][3] - 
		      m[1][3]*m[2][2]*m[3][1]*m[4][4] + m[1][2]*m[2][3]*m[3][1]*m[4][4] + m[1][3]*m[2][1]*m[3][2]*m[4][4] - m[1][1]*m[2][3]*m[3][2]*m[4][4] - 
		      m[1][2]*m[2][1]*m[3][3]*m[4][4] + m[1][1]*m[2][2]*m[3][3]*m[4][4])*one_over_determinant;
      result[0][1] = (-(m[0][4]*m[2][3]*m[3][2]*m[4][1]) + m[0][3]*m[2][4]*m[3][2]*m[4][1] + m[0][4]*m[2][2]*m[3][3]*m[4][1] - 
		      m[0][2]*m[2][4]*m[3][3]*m[4][1] - m[0][3]*m[2][2]*m[3][4]*m[4][1] + m[0][2]*m[2][3]*m[3][4]*m[4][1] + m[0][4]*m[2][3]*m[3][1]*m[4][2] - 
		      m[0][3]*m[2][4]*m[3][1]*m[4][2] - m[0][4]*m[2][1]*m[3][3]*m[4][2] + m[0][1]*m[2][4]*m[3][3]*m[4][2] + m[0][3]*m[2][1]*m[3][4]*m[4][2] - 
		      m[0][1]*m[2][3]*m[3][4]*m[4][2] - m[0][4]*m[2][2]*m[3][1]*m[4][3] + m[0][2]*m[2][4]*m[3][1]*m[4][3] + m[0][4]*m[2][1]*m[3][2]*m[4][3] - 
		      m[0][1]*m[2][4]*m[3][2]*m[4][3] - m[0][2]*m[2][1]*m[3][4]*m[4][3] + m[0][1]*m[2][2]*m[3][4]*m[4][3] + m[0][3]*m[2][2]*m[3][1]*m[4][4] - 
		      m[0][2]*m[2][3]*m[3][1]*m[4][4] - m[0][3]*m[2][1]*m[3][2]*m[4][4] + m[0][1]*m[2][3]*m[3][2]*m[4][4] + m[0][2]*m[2][1]*m[3][3]*m[4][4] - 
		      m[0][1]*m[2][2]*m[3][3]*m[4][4])*one_over_determinant;
      result[0][2] = (m[0][4]*m[1][3]*m[3][2]*m[4][1] - m[0][3]*m[1][4]*m[3][2]*m[4][1] - m[0][4]*m[1][2]*m[3][3]*m[4][1] + 
		      m[0][2]*m[1][4]*m[3][3]*m[4][1] + m[0][3]*m[1][2]*m[3][4]*m[4][1] - m[0][2]*m[1][3]*m[3][4]*m[4][1] - m[0][4]*m[1][3]*m[3][1]*m[4][2] + 
		      m[0][3]*m[1][4]*m[3][1]*m[4][2] + m[0][4]*m[1][1]*m[3][3]*m[4][2] - m[0][1]*m[1][4]*m[3][3]*m[4][2] - m[0][3]*m[1][1]*m[3][4]*m[4][2] + 
		      m[0][1]*m[1][3]*m[3][4]*m[4][2] + m[0][4]*m[1][2]*m[3][1]*m[4][3] - m[0][2]*m[1][4]*m[3][1]*m[4][3] - m[0][4]*m[1][1]*m[3][2]*m[4][3] + 
		      m[0][1]*m[1][4]*m[3][2]*m[4][3] + m[0][2]*m[1][1]*m[3][4]*m[4][3] - m[0][1]*m[1][2]*m[3][4]*m[4][3] - m[0][3]*m[1][2]*m[3][1]*m[4][4] + 
		      m[0][2]*m[1][3]*m[3][1]*m[4][4] + m[0][3]*m[1][1]*m[3][2]*m[4][4] - m[0][1]*m[1][3]*m[3][2]*m[4][4] - m[0][2]*m[1][1]*m[3][3]*m[4][4] + 
		      m[0][1]*m[1][2]*m[3][3]*m[4][4])*one_over_determinant;
      result[0][3] = (-(m[0][4]*m[1][3]*m[2][2]*m[4][1]) + m[0][3]*m[1][4]*m[2][2]*m[4][1] + 
		      m[0][4]*m[1][2]*m[2][3]*m[4][1] - m[0][2]*m[1][4]*m[2][3]*m[4][1] - m[0][3]*m[1][2]*m[2][4]*m[4][1] + m[0][2]*m[1][3]*m[2][4]*m[4][1] + 
		      m[0][4]*m[1][3]*m[2][1]*m[4][2] - m[0][3]*m[1][4]*m[2][1]*m[4][2] - m[0][4]*m[1][1]*m[2][3]*m[4][2] + m[0][1]*m[1][4]*m[2][3]*m[4][2] + 
		      m[0][3]*m[1][1]*m[2][4]*m[4][2] - m[0][1]*m[1][3]*m[2][4]*m[4][2] - m[0][4]*m[1][2]*m[2][1]*m[4][3] + m[0][2]*m[1][4]*m[2][1]*m[4][3] + 
		      m[0][4]*m[1][1]*m[2][2]*m[4][3] - m[0][1]*m[1][4]*m[2][2]*m[4][3] - m[0][2]*m[1][1]*m[2][4]*m[4][3] + m[0][1]*m[1][2]*m[2][4]*m[4][3] + 
		      m[0][3]*m[1][2]*m[2][1]*m[4][4] - m[0][2]*m[1][3]*m[2][1]*m[4][4] - m[0][3]*m[1][1]*m[2][2]*m[4][4] + m[0][1]*m[1][3]*m[2][2]*m[4][4] + 
		      m[0][2]*m[1][1]*m[2][3]*m[4][4] - m[0][1]*m[1][2]*m[2][3]*m[4][4])*one_over_determinant;
      result[0][4] = (m[0][4]*m[1][3]*m[2][2]*m[3][1] - m[0][3]*m[1][4]*m[2][2]*m[3][1] - m[0][4]*m[1][2]*m[2][3]*m[3][1] + m[0][2]*m[1][4]*m[2][3]*m[3][1] + 
		      m[0][3]*m[1][2]*m[2][4]*m[3][1] - m[0][2]*m[1][3]*m[2][4]*m[3][1] - m[0][4]*m[1][3]*m[2][1]*m[3][2] + m[0][3]*m[1][4]*m[2][1]*m[3][2] + 
		      m[0][4]*m[1][1]*m[2][3]*m[3][2] - m[0][1]*m[1][4]*m[2][3]*m[3][2] - m[0][3]*m[1][1]*m[2][4]*m[3][2] + m[0][1]*m[1][3]*m[2][4]*m[3][2] + 
		      m[0][4]*m[1][2]*m[2][1]*m[3][3] - m[0][2]*m[1][4]*m[2][1]*m[3][3] - m[0][4]*m[1][1]*m[2][2]*m[3][3] + m[0][1]*m[1][4]*m[2][2]*m[3][3] + 
		      m[0][2]*m[1][1]*m[2][4]*m[3][3] - m[0][1]*m[1][2]*m[2][4]*m[3][3] - m[0][3]*m[1][2]*m[2][1]*m[3][4] + m[0][2]*m[1][3]*m[2][1]*m[3][4] + 
		      m[0][3]*m[1][1]*m[2][2]*m[3][4] - m[0][1]*m[1][3]*m[2][2]*m[3][4] - m[0][2]*m[1][1]*m[2][3]*m[3][4] + m[0][1]*m[1][2]*m[2][3]*m[3][4])*one_over_determinant;

      result[1][0] = (-(m[1][4]*m[2][3]*m[3][2]*m[4][0]) + m[1][3]*m[2][4]*m[3][2]*m[4][0] + m[1][4]*m[2][2]*m[3][3]*m[4][0] - 
		      m[1][2]*m[2][4]*m[3][3]*m[4][0] - m[1][3]*m[2][2]*m[3][4]*m[4][0] + m[1][2]*m[2][3]*m[3][4]*m[4][0] + m[1][4]*m[2][3]*m[3][0]*m[4][2] - 
		      m[1][3]*m[2][4]*m[3][0]*m[4][2] - m[1][4]*m[2][0]*m[3][3]*m[4][2] + m[1][0]*m[2][4]*m[3][3]*m[4][2] + m[1][3]*m[2][0]*m[3][4]*m[4][2] - 
		      m[1][0]*m[2][3]*m[3][4]*m[4][2] - m[1][4]*m[2][2]*m[3][0]*m[4][3] + m[1][2]*m[2][4]*m[3][0]*m[4][3] + m[1][4]*m[2][0]*m[3][2]*m[4][3] - 
		      m[1][0]*m[2][4]*m[3][2]*m[4][3] - m[1][2]*m[2][0]*m[3][4]*m[4][3] + m[1][0]*m[2][2]*m[3][4]*m[4][3] + m[1][3]*m[2][2]*m[3][0]*m[4][4] - 
		      m[1][2]*m[2][3]*m[3][0]*m[4][4] - m[1][3]*m[2][0]*m[3][2]*m[4][4] + m[1][0]*m[2][3]*m[3][2]*m[4][4] + m[1][2]*m[2][0]*m[3][3]*m[4][4] - 
		      m[1][0]*m[2][2]*m[3][3]*m[4][4])*one_over_determinant;
      result[1][1] = (m[0][4]*m[2][3]*m[3][2]*m[4][0] - m[0][3]*m[2][4]*m[3][2]*m[4][0] - m[0][4]*m[2][2]*m[3][3]*m[4][0] + 
		      m[0][2]*m[2][4]*m[3][3]*m[4][0] + m[0][3]*m[2][2]*m[3][4]*m[4][0] - m[0][2]*m[2][3]*m[3][4]*m[4][0] - m[0][4]*m[2][3]*m[3][0]*m[4][2] + 
		      m[0][3]*m[2][4]*m[3][0]*m[4][2] + m[0][4]*m[2][0]*m[3][3]*m[4][2] - m[0][0]*m[2][4]*m[3][3]*m[4][2] - m[0][3]*m[2][0]*m[3][4]*m[4][2] + 
		      m[0][0]*m[2][3]*m[3][4]*m[4][2] + m[0][4]*m[2][2]*m[3][0]*m[4][3] - m[0][2]*m[2][4]*m[3][0]*m[4][3] - m[0][4]*m[2][0]*m[3][2]*m[4][3] + 
		      m[0][0]*m[2][4]*m[3][2]*m[4][3] + m[0][2]*m[2][0]*m[3][4]*m[4][3] - m[0][0]*m[2][2]*m[3][4]*m[4][3] - m[0][3]*m[2][2]*m[3][0]*m[4][4] + 
		      m[0][2]*m[2][3]*m[3][0]*m[4][4] + m[0][3]*m[2][0]*m[3][2]*m[4][4] - m[0][0]*m[2][3]*m[3][2]*m[4][4] - m[0][2]*m[2][0]*m[3][3]*m[4][4] + 
		      m[0][0]*m[2][2]*m[3][3]*m[4][4])*one_over_determinant;
      result[1][2] = (-(m[0][4]*m[1][3]*m[3][2]*m[4][0]) + m[0][3]*m[1][4]*m[3][2]*m[4][0] + 
		      m[0][4]*m[1][2]*m[3][3]*m[4][0] - m[0][2]*m[1][4]*m[3][3]*m[4][0] - m[0][3]*m[1][2]*m[3][4]*m[4][0] + m[0][2]*m[1][3]*m[3][4]*m[4][0] + 
		      m[0][4]*m[1][3]*m[3][0]*m[4][2] - m[0][3]*m[1][4]*m[3][0]*m[4][2] - m[0][4]*m[1][0]*m[3][3]*m[4][2] + m[0][0]*m[1][4]*m[3][3]*m[4][2] + 
		      m[0][3]*m[1][0]*m[3][4]*m[4][2] - m[0][0]*m[1][3]*m[3][4]*m[4][2] - m[0][4]*m[1][2]*m[3][0]*m[4][3] + m[0][2]*m[1][4]*m[3][0]*m[4][3] + 
		      m[0][4]*m[1][0]*m[3][2]*m[4][3] - m[0][0]*m[1][4]*m[3][2]*m[4][3] - m[0][2]*m[1][0]*m[3][4]*m[4][3] + m[0][0]*m[1][2]*m[3][4]*m[4][3] + 
		      m[0][3]*m[1][2]*m[3][0]*m[4][4] - m[0][2]*m[1][3]*m[3][0]*m[4][4] - m[0][3]*m[1][0]*m[3][2]*m[4][4] + m[0][0]*m[1][3]*m[3][2]*m[4][4] + 
		      m[0][2]*m[1][0]*m[3][3]*m[4][4] - m[0][0]*m[1][2]*m[3][3]*m[4][4])*one_over_determinant;
      result[1][3] = (m[0][4]*m[1][3]*m[2][2]*m[4][0] - m[0][3]*m[1][4]*m[2][2]*m[4][0] - m[0][4]*m[1][2]*m[2][3]*m[4][0] + m[0][2]*m[1][4]*m[2][3]*m[4][0] + 
		      m[0][3]*m[1][2]*m[2][4]*m[4][0] - m[0][2]*m[1][3]*m[2][4]*m[4][0] - m[0][4]*m[1][3]*m[2][0]*m[4][2] + m[0][3]*m[1][4]*m[2][0]*m[4][2] + 
		      m[0][4]*m[1][0]*m[2][3]*m[4][2] - m[0][0]*m[1][4]*m[2][3]*m[4][2] - m[0][3]*m[1][0]*m[2][4]*m[4][2] + m[0][0]*m[1][3]*m[2][4]*m[4][2] + 
		      m[0][4]*m[1][2]*m[2][0]*m[4][3] - m[0][2]*m[1][4]*m[2][0]*m[4][3] - m[0][4]*m[1][0]*m[2][2]*m[4][3] + m[0][0]*m[1][4]*m[2][2]*m[4][3] + 
		      m[0][2]*m[1][0]*m[2][4]*m[4][3] - m[0][0]*m[1][2]*m[2][4]*m[4][3] - m[0][3]*m[1][2]*m[2][0]*m[4][4] + m[0][2]*m[1][3]*m[2][0]*m[4][4] + 
		      m[0][3]*m[1][0]*m[2][2]*m[4][4] - m[0][0]*m[1][3]*m[2][2]*m[4][4] - m[0][2]*m[1][0]*m[2][3]*m[4][4] + m[0][0]*m[1][2]*m[2][3]*m[4][4])*one_over_determinant;
      result[1][4] = (-(m[0][4]*m[1][3]*m[2][2]*m[3][0]) + m[0][3]*m[1][4]*m[2][2]*m[3][0] + m[0][4]*m[1][2]*m[2][3]*m[3][0] - 
		      m[0][2]*m[1][4]*m[2][3]*m[3][0] - m[0][3]*m[1][2]*m[2][4]*m[3][0] + m[0][2]*m[1][3]*m[2][4]*m[3][0] + m[0][4]*m[1][3]*m[2][0]*m[3][2] - 
		      m[0][3]*m[1][4]*m[2][0]*m[3][2] - m[0][4]*m[1][0]*m[2][3]*m[3][2] + m[0][0]*m[1][4]*m[2][3]*m[3][2] + m[0][3]*m[1][0]*m[2][4]*m[3][2] - 
		      m[0][0]*m[1][3]*m[2][4]*m[3][2] - m[0][4]*m[1][2]*m[2][0]*m[3][3] + m[0][2]*m[1][4]*m[2][0]*m[3][3] + m[0][4]*m[1][0]*m[2][2]*m[3][3] - 
		      m[0][0]*m[1][4]*m[2][2]*m[3][3] - m[0][2]*m[1][0]*m[2][4]*m[3][3] + m[0][0]*m[1][2]*m[2][4]*m[3][3] + m[0][3]*m[1][2]*m[2][0]*m[3][4] - 
		      m[0][2]*m[1][3]*m[2][0]*m[3][4] - m[0][3]*m[1][0]*m[2][2]*m[3][4] + m[0][0]*m[1][3]*m[2][2]*m[3][4] + m[0][2]*m[1][0]*m[2][3]*m[3][4] - 
		      m[0][0]*m[1][2]*m[2][3]*m[3][4])*one_over_determinant;

      result[2][0] = (m[1][4]*m[2][3]*m[3][1]*m[4][0] - m[1][3]*m[2][4]*m[3][1]*m[4][0] - 
		      m[1][4]*m[2][1]*m[3][3]*m[4][0] + m[1][1]*m[2][4]*m[3][3]*m[4][0] + m[1][3]*m[2][1]*m[3][4]*m[4][0] - m[1][1]*m[2][3]*m[3][4]*m[4][0] - 
		      m[1][4]*m[2][3]*m[3][0]*m[4][1] + m[1][3]*m[2][4]*m[3][0]*m[4][1] + m[1][4]*m[2][0]*m[3][3]*m[4][1] - m[1][0]*m[2][4]*m[3][3]*m[4][1] - 
		      m[1][3]*m[2][0]*m[3][4]*m[4][1] + m[1][0]*m[2][3]*m[3][4]*m[4][1] + m[1][4]*m[2][1]*m[3][0]*m[4][3] - m[1][1]*m[2][4]*m[3][0]*m[4][3] - 
		      m[1][4]*m[2][0]*m[3][1]*m[4][3] + m[1][0]*m[2][4]*m[3][1]*m[4][3] + m[1][1]*m[2][0]*m[3][4]*m[4][3] - m[1][0]*m[2][1]*m[3][4]*m[4][3] - 
		      m[1][3]*m[2][1]*m[3][0]*m[4][4] + m[1][1]*m[2][3]*m[3][0]*m[4][4] + m[1][3]*m[2][0]*m[3][1]*m[4][4] - m[1][0]*m[2][3]*m[3][1]*m[4][4] - 
		      m[1][1]*m[2][0]*m[3][3]*m[4][4] + m[1][0]*m[2][1]*m[3][3]*m[4][4])*one_over_determinant;
      result[2][1] = (-(m[0][4]*m[2][3]*m[3][1]*m[4][0]) + m[0][3]*m[2][4]*m[3][1]*m[4][0] + m[0][4]*m[2][1]*m[3][3]*m[4][0] - 
		      m[0][1]*m[2][4]*m[3][3]*m[4][0] - m[0][3]*m[2][1]*m[3][4]*m[4][0] + m[0][1]*m[2][3]*m[3][4]*m[4][0] + m[0][4]*m[2][3]*m[3][0]*m[4][1] - 
		      m[0][3]*m[2][4]*m[3][0]*m[4][1] - m[0][4]*m[2][0]*m[3][3]*m[4][1] + m[0][0]*m[2][4]*m[3][3]*m[4][1] + m[0][3]*m[2][0]*m[3][4]*m[4][1] - 
		      m[0][0]*m[2][3]*m[3][4]*m[4][1] - m[0][4]*m[2][1]*m[3][0]*m[4][3] + m[0][1]*m[2][4]*m[3][0]*m[4][3] + m[0][4]*m[2][0]*m[3][1]*m[4][3] - 
		      m[0][0]*m[2][4]*m[3][1]*m[4][3] - m[0][1]*m[2][0]*m[3][4]*m[4][3] + m[0][0]*m[2][1]*m[3][4]*m[4][3] + m[0][3]*m[2][1]*m[3][0]*m[4][4] - 
		      m[0][1]*m[2][3]*m[3][0]*m[4][4] - m[0][3]*m[2][0]*m[3][1]*m[4][4] + m[0][0]*m[2][3]*m[3][1]*m[4][4] + m[0][1]*m[2][0]*m[3][3]*m[4][4] - 
		      m[0][0]*m[2][1]*m[3][3]*m[4][4])*one_over_determinant;
      result[2][2] = (m[0][4]*m[1][3]*m[3][1]*m[4][0] - m[0][3]*m[1][4]*m[3][1]*m[4][0] - m[0][4]*m[1][1]*m[3][3]*m[4][0] + 
		      m[0][1]*m[1][4]*m[3][3]*m[4][0] + m[0][3]*m[1][1]*m[3][4]*m[4][0] - m[0][1]*m[1][3]*m[3][4]*m[4][0] - m[0][4]*m[1][3]*m[3][0]*m[4][1] + 
		      m[0][3]*m[1][4]*m[3][0]*m[4][1] + m[0][4]*m[1][0]*m[3][3]*m[4][1] - m[0][0]*m[1][4]*m[3][3]*m[4][1] - m[0][3]*m[1][0]*m[3][4]*m[4][1] + 
		      m[0][0]*m[1][3]*m[3][4]*m[4][1] + m[0][4]*m[1][1]*m[3][0]*m[4][3] - m[0][1]*m[1][4]*m[3][0]*m[4][3] - m[0][4]*m[1][0]*m[3][1]*m[4][3] + 
		      m[0][0]*m[1][4]*m[3][1]*m[4][3] + m[0][1]*m[1][0]*m[3][4]*m[4][3] - m[0][0]*m[1][1]*m[3][4]*m[4][3] - m[0][3]*m[1][1]*m[3][0]*m[4][4] + 
		      m[0][1]*m[1][3]*m[3][0]*m[4][4] + m[0][3]*m[1][0]*m[3][1]*m[4][4] - m[0][0]*m[1][3]*m[3][1]*m[4][4] - m[0][1]*m[1][0]*m[3][3]*m[4][4] + 
		      m[0][0]*m[1][1]*m[3][3]*m[4][4])*one_over_determinant;
      result[2][3] = (-(m[0][4]*m[1][3]*m[2][1]*m[4][0]) + m[0][3]*m[1][4]*m[2][1]*m[4][0] + 
		      m[0][4]*m[1][1]*m[2][3]*m[4][0] - m[0][1]*m[1][4]*m[2][3]*m[4][0] - m[0][3]*m[1][1]*m[2][4]*m[4][0] + m[0][1]*m[1][3]*m[2][4]*m[4][0] + 
		      m[0][4]*m[1][3]*m[2][0]*m[4][1] - m[0][3]*m[1][4]*m[2][0]*m[4][1] - m[0][4]*m[1][0]*m[2][3]*m[4][1] + m[0][0]*m[1][4]*m[2][3]*m[4][1] + 
		      m[0][3]*m[1][0]*m[2][4]*m[4][1] - m[0][0]*m[1][3]*m[2][4]*m[4][1] - m[0][4]*m[1][1]*m[2][0]*m[4][3] + m[0][1]*m[1][4]*m[2][0]*m[4][3] + 
		      m[0][4]*m[1][0]*m[2][1]*m[4][3] - m[0][0]*m[1][4]*m[2][1]*m[4][3] - m[0][1]*m[1][0]*m[2][4]*m[4][3] + m[0][0]*m[1][1]*m[2][4]*m[4][3] + 
		      m[0][3]*m[1][1]*m[2][0]*m[4][4] - m[0][1]*m[1][3]*m[2][0]*m[4][4] - m[0][3]*m[1][0]*m[2][1]*m[4][4] + m[0][0]*m[1][3]*m[2][1]*m[4][4] + 
		      m[0][1]*m[1][0]*m[2][3]*m[4][4] - m[0][0]*m[1][1]*m[2][3]*m[4][4])*one_over_determinant;
      result[2][4] = (m[0][4]*m[1][3]*m[2][1]*m[3][0] - m[0][3]*m[1][4]*m[2][1]*m[3][0] - m[0][4]*m[1][1]*m[2][3]*m[3][0] + m[0][1]*m[1][4]*m[2][3]*m[3][0] + 
		      m[0][3]*m[1][1]*m[2][4]*m[3][0] - m[0][1]*m[1][3]*m[2][4]*m[3][0] - m[0][4]*m[1][3]*m[2][0]*m[3][1] + m[0][3]*m[1][4]*m[2][0]*m[3][1] + 
		      m[0][4]*m[1][0]*m[2][3]*m[3][1] - m[0][0]*m[1][4]*m[2][3]*m[3][1] - m[0][3]*m[1][0]*m[2][4]*m[3][1] + m[0][0]*m[1][3]*m[2][4]*m[3][1] + 
		      m[0][4]*m[1][1]*m[2][0]*m[3][3] - m[0][1]*m[1][4]*m[2][0]*m[3][3] - m[0][4]*m[1][0]*m[2][1]*m[3][3] + m[0][0]*m[1][4]*m[2][1]*m[3][3] + 
		      m[0][1]*m[1][0]*m[2][4]*m[3][3] - m[0][0]*m[1][1]*m[2][4]*m[3][3] - m[0][3]*m[1][1]*m[2][0]*m[3][4] + m[0][1]*m[1][3]*m[2][0]*m[3][4] + 
		      m[0][3]*m[1][0]*m[2][1]*m[3][4] - m[0][0]*m[1][3]*m[2][1]*m[3][4] - m[0][1]*m[1][0]*m[2][3]*m[3][4] + m[0][0]*m[1][1]*m[2][3]*m[3][4])*one_over_determinant;

      result[3][0] = (-(m[1][4]*m[2][2]*m[3][1]*m[4][0]) + m[1][2]*m[2][4]*m[3][1]*m[4][0] + m[1][4]*m[2][1]*m[3][2]*m[4][0] - 
		      m[1][1]*m[2][4]*m[3][2]*m[4][0] - m[1][2]*m[2][1]*m[3][4]*m[4][0] + m[1][1]*m[2][2]*m[3][4]*m[4][0] + m[1][4]*m[2][2]*m[3][0]*m[4][1] - 
		      m[1][2]*m[2][4]*m[3][0]*m[4][1] - m[1][4]*m[2][0]*m[3][2]*m[4][1] + m[1][0]*m[2][4]*m[3][2]*m[4][1] + m[1][2]*m[2][0]*m[3][4]*m[4][1] - 
		      m[1][0]*m[2][2]*m[3][4]*m[4][1] - m[1][4]*m[2][1]*m[3][0]*m[4][2] + m[1][1]*m[2][4]*m[3][0]*m[4][2] + m[1][4]*m[2][0]*m[3][1]*m[4][2] - 
		      m[1][0]*m[2][4]*m[3][1]*m[4][2] - m[1][1]*m[2][0]*m[3][4]*m[4][2] + m[1][0]*m[2][1]*m[3][4]*m[4][2] + m[1][2]*m[2][1]*m[3][0]*m[4][4] - 
		      m[1][1]*m[2][2]*m[3][0]*m[4][4] - m[1][2]*m[2][0]*m[3][1]*m[4][4] + m[1][0]*m[2][2]*m[3][1]*m[4][4] + m[1][1]*m[2][0]*m[3][2]*m[4][4] - 
		      m[1][0]*m[2][1]*m[3][2]*m[4][4])*one_over_determinant;
      result[3][1] = (m[0][4]*m[2][2]*m[3][1]*m[4][0] - m[0][2]*m[2][4]*m[3][1]*m[4][0] - m[0][4]*m[2][1]*m[3][2]*m[4][0] + 
		      m[0][1]*m[2][4]*m[3][2]*m[4][0] + m[0][2]*m[2][1]*m[3][4]*m[4][0] - m[0][1]*m[2][2]*m[3][4]*m[4][0] - m[0][4]*m[2][2]*m[3][0]*m[4][1] + 
		      m[0][2]*m[2][4]*m[3][0]*m[4][1] + m[0][4]*m[2][0]*m[3][2]*m[4][1] - m[0][0]*m[2][4]*m[3][2]*m[4][1] - m[0][2]*m[2][0]*m[3][4]*m[4][1] + 
		      m[0][0]*m[2][2]*m[3][4]*m[4][1] + m[0][4]*m[2][1]*m[3][0]*m[4][2] - m[0][1]*m[2][4]*m[3][0]*m[4][2] - m[0][4]*m[2][0]*m[3][1]*m[4][2] + 
		      m[0][0]*m[2][4]*m[3][1]*m[4][2] + m[0][1]*m[2][0]*m[3][4]*m[4][2] - m[0][0]*m[2][1]*m[3][4]*m[4][2] - m[0][2]*m[2][1]*m[3][0]*m[4][4] + 
		      m[0][1]*m[2][2]*m[3][0]*m[4][4] + m[0][2]*m[2][0]*m[3][1]*m[4][4] - m[0][0]*m[2][2]*m[3][1]*m[4][4] - m[0][1]*m[2][0]*m[3][2]*m[4][4] + 
		      m[0][0]*m[2][1]*m[3][2]*m[4][4])*one_over_determinant;
      result[3][2] = (-(m[0][4]*m[1][2]*m[3][1]*m[4][0]) + m[0][2]*m[1][4]*m[3][1]*m[4][0] + 
		      m[0][4]*m[1][1]*m[3][2]*m[4][0] - m[0][1]*m[1][4]*m[3][2]*m[4][0] - m[0][2]*m[1][1]*m[3][4]*m[4][0] + m[0][1]*m[1][2]*m[3][4]*m[4][0] + 
		      m[0][4]*m[1][2]*m[3][0]*m[4][1] - m[0][2]*m[1][4]*m[3][0]*m[4][1] - m[0][4]*m[1][0]*m[3][2]*m[4][1] + m[0][0]*m[1][4]*m[3][2]*m[4][1] + 
		      m[0][2]*m[1][0]*m[3][4]*m[4][1] - m[0][0]*m[1][2]*m[3][4]*m[4][1] - m[0][4]*m[1][1]*m[3][0]*m[4][2] + m[0][1]*m[1][4]*m[3][0]*m[4][2] + 
		      m[0][4]*m[1][0]*m[3][1]*m[4][2] - m[0][0]*m[1][4]*m[3][1]*m[4][2] - m[0][1]*m[1][0]*m[3][4]*m[4][2] + m[0][0]*m[1][1]*m[3][4]*m[4][2] + 
		      m[0][2]*m[1][1]*m[3][0]*m[4][4] - m[0][1]*m[1][2]*m[3][0]*m[4][4] - m[0][2]*m[1][0]*m[3][1]*m[4][4] + m[0][0]*m[1][2]*m[3][1]*m[4][4] + 
		      m[0][1]*m[1][0]*m[3][2]*m[4][4] - m[0][0]*m[1][1]*m[3][2]*m[4][4])*one_over_determinant;
      result[3][3] = (m[0][4]*m[1][2]*m[2][1]*m[4][0] - m[0][2]*m[1][4]*m[2][1]*m[4][0] - m[0][4]*m[1][1]*m[2][2]*m[4][0] + m[0][1]*m[1][4]*m[2][2]*m[4][0] + 
		      m[0][2]*m[1][1]*m[2][4]*m[4][0] - m[0][1]*m[1][2]*m[2][4]*m[4][0] - m[0][4]*m[1][2]*m[2][0]*m[4][1] + m[0][2]*m[1][4]*m[2][0]*m[4][1] + 
		      m[0][4]*m[1][0]*m[2][2]*m[4][1] - m[0][0]*m[1][4]*m[2][2]*m[4][1] - m[0][2]*m[1][0]*m[2][4]*m[4][1] + m[0][0]*m[1][2]*m[2][4]*m[4][1] + 
		      m[0][4]*m[1][1]*m[2][0]*m[4][2] - m[0][1]*m[1][4]*m[2][0]*m[4][2] - m[0][4]*m[1][0]*m[2][1]*m[4][2] + m[0][0]*m[1][4]*m[2][1]*m[4][2] + 
		      m[0][1]*m[1][0]*m[2][4]*m[4][2] - m[0][0]*m[1][1]*m[2][4]*m[4][2] - m[0][2]*m[1][1]*m[2][0]*m[4][4] + m[0][1]*m[1][2]*m[2][0]*m[4][4] + 
		      m[0][2]*m[1][0]*m[2][1]*m[4][4] - m[0][0]*m[1][2]*m[2][1]*m[4][4] - m[0][1]*m[1][0]*m[2][2]*m[4][4] + m[0][0]*m[1][1]*m[2][2]*m[4][4])*one_over_determinant;
      result[3][4] = (-(m[0][4]*m[1][2]*m[2][1]*m[3][0]) + m[0][2]*m[1][4]*m[2][1]*m[3][0] + m[0][4]*m[1][1]*m[2][2]*m[3][0] - 
		      m[0][1]*m[1][4]*m[2][2]*m[3][0] - m[0][2]*m[1][1]*m[2][4]*m[3][0] + m[0][1]*m[1][2]*m[2][4]*m[3][0] + m[0][4]*m[1][2]*m[2][0]*m[3][1] - 
		      m[0][2]*m[1][4]*m[2][0]*m[3][1] - m[0][4]*m[1][0]*m[2][2]*m[3][1] + m[0][0]*m[1][4]*m[2][2]*m[3][1] + m[0][2]*m[1][0]*m[2][4]*m[3][1] - 
		      m[0][0]*m[1][2]*m[2][4]*m[3][1] - m[0][4]*m[1][1]*m[2][0]*m[3][2] + m[0][1]*m[1][4]*m[2][0]*m[3][2] + m[0][4]*m[1][0]*m[2][1]*m[3][2] - 
		      m[0][0]*m[1][4]*m[2][1]*m[3][2] - m[0][1]*m[1][0]*m[2][4]*m[3][2] + m[0][0]*m[1][1]*m[2][4]*m[3][2] + m[0][2]*m[1][1]*m[2][0]*m[3][4] - 
		      m[0][1]*m[1][2]*m[2][0]*m[3][4] - m[0][2]*m[1][0]*m[2][1]*m[3][4] + m[0][0]*m[1][2]*m[2][1]*m[3][4] + m[0][1]*m[1][0]*m[2][2]*m[3][4] - 
		      m[0][0]*m[1][1]*m[2][2]*m[3][4])*one_over_determinant;

      result[4][0] = (m[1][3]*m[2][2]*m[3][1]*m[4][0] - m[1][2]*m[2][3]*m[3][1]*m[4][0] - 
		      m[1][3]*m[2][1]*m[3][2]*m[4][0] + m[1][1]*m[2][3]*m[3][2]*m[4][0] + m[1][2]*m[2][1]*m[3][3]*m[4][0] - m[1][1]*m[2][2]*m[3][3]*m[4][0] - 
		      m[1][3]*m[2][2]*m[3][0]*m[4][1] + m[1][2]*m[2][3]*m[3][0]*m[4][1] + m[1][3]*m[2][0]*m[3][2]*m[4][1] - m[1][0]*m[2][3]*m[3][2]*m[4][1] - 
		      m[1][2]*m[2][0]*m[3][3]*m[4][1] + m[1][0]*m[2][2]*m[3][3]*m[4][1] + m[1][3]*m[2][1]*m[3][0]*m[4][2] - m[1][1]*m[2][3]*m[3][0]*m[4][2] - 
		      m[1][3]*m[2][0]*m[3][1]*m[4][2] + m[1][0]*m[2][3]*m[3][1]*m[4][2] + m[1][1]*m[2][0]*m[3][3]*m[4][2] - m[1][0]*m[2][1]*m[3][3]*m[4][2] - 
		      m[1][2]*m[2][1]*m[3][0]*m[4][3] + m[1][1]*m[2][2]*m[3][0]*m[4][3] + m[1][2]*m[2][0]*m[3][1]*m[4][3] - m[1][0]*m[2][2]*m[3][1]*m[4][3] - 
		      m[1][1]*m[2][0]*m[3][2]*m[4][3] + m[1][0]*m[2][1]*m[3][2]*m[4][3])*one_over_determinant;
      result[4][1] = (-(m[0][3]*m[2][2]*m[3][1]*m[4][0]) + m[0][2]*m[2][3]*m[3][1]*m[4][0] + m[0][3]*m[2][1]*m[3][2]*m[4][0] - 
		      m[0][1]*m[2][3]*m[3][2]*m[4][0] - m[0][2]*m[2][1]*m[3][3]*m[4][0] + m[0][1]*m[2][2]*m[3][3]*m[4][0] + m[0][3]*m[2][2]*m[3][0]*m[4][1] - 
		      m[0][2]*m[2][3]*m[3][0]*m[4][1] - m[0][3]*m[2][0]*m[3][2]*m[4][1] + m[0][0]*m[2][3]*m[3][2]*m[4][1] + m[0][2]*m[2][0]*m[3][3]*m[4][1] - 
		      m[0][0]*m[2][2]*m[3][3]*m[4][1] - m[0][3]*m[2][1]*m[3][0]*m[4][2] + m[0][1]*m[2][3]*m[3][0]*m[4][2] + m[0][3]*m[2][0]*m[3][1]*m[4][2] - 
		      m[0][0]*m[2][3]*m[3][1]*m[4][2] - m[0][1]*m[2][0]*m[3][3]*m[4][2] + m[0][0]*m[2][1]*m[3][3]*m[4][2] + m[0][2]*m[2][1]*m[3][0]*m[4][3] - 
		      m[0][1]*m[2][2]*m[3][0]*m[4][3] - m[0][2]*m[2][0]*m[3][1]*m[4][3] + m[0][0]*m[2][2]*m[3][1]*m[4][3] + m[0][1]*m[2][0]*m[3][2]*m[4][3] - 
		      m[0][0]*m[2][1]*m[3][2]*m[4][3])*one_over_determinant;
      result[4][2] = (m[0][3]*m[1][2]*m[3][1]*m[4][0] - m[0][2]*m[1][3]*m[3][1]*m[4][0] - m[0][3]*m[1][1]*m[3][2]*m[4][0] + 
		      m[0][1]*m[1][3]*m[3][2]*m[4][0] + m[0][2]*m[1][1]*m[3][3]*m[4][0] - m[0][1]*m[1][2]*m[3][3]*m[4][0] - m[0][3]*m[1][2]*m[3][0]*m[4][1] + 
		      m[0][2]*m[1][3]*m[3][0]*m[4][1] + m[0][3]*m[1][0]*m[3][2]*m[4][1] - m[0][0]*m[1][3]*m[3][2]*m[4][1] - m[0][2]*m[1][0]*m[3][3]*m[4][1] + 
		      m[0][0]*m[1][2]*m[3][3]*m[4][1] + m[0][3]*m[1][1]*m[3][0]*m[4][2] - m[0][1]*m[1][3]*m[3][0]*m[4][2] - m[0][3]*m[1][0]*m[3][1]*m[4][2] + 
		      m[0][0]*m[1][3]*m[3][1]*m[4][2] + m[0][1]*m[1][0]*m[3][3]*m[4][2] - m[0][0]*m[1][1]*m[3][3]*m[4][2] - m[0][2]*m[1][1]*m[3][0]*m[4][3] + 
		      m[0][1]*m[1][2]*m[3][0]*m[4][3] + m[0][2]*m[1][0]*m[3][1]*m[4][3] - m[0][0]*m[1][2]*m[3][1]*m[4][3] - m[0][1]*m[1][0]*m[3][2]*m[4][3] + 
		      m[0][0]*m[1][1]*m[3][2]*m[4][3])*one_over_determinant;
      result[4][3] = (-(m[0][3]*m[1][2]*m[2][1]*m[4][0]) + m[0][2]*m[1][3]*m[2][1]*m[4][0] + 
		      m[0][3]*m[1][1]*m[2][2]*m[4][0] - m[0][1]*m[1][3]*m[2][2]*m[4][0] - m[0][2]*m[1][1]*m[2][3]*m[4][0] + m[0][1]*m[1][2]*m[2][3]*m[4][0] + 
		      m[0][3]*m[1][2]*m[2][0]*m[4][1] - m[0][2]*m[1][3]*m[2][0]*m[4][1] - m[0][3]*m[1][0]*m[2][2]*m[4][1] + m[0][0]*m[1][3]*m[2][2]*m[4][1] + 
		      m[0][2]*m[1][0]*m[2][3]*m[4][1] - m[0][0]*m[1][2]*m[2][3]*m[4][1] - m[0][3]*m[1][1]*m[2][0]*m[4][2] + m[0][1]*m[1][3]*m[2][0]*m[4][2] + 
		      m[0][3]*m[1][0]*m[2][1]*m[4][2] - m[0][0]*m[1][3]*m[2][1]*m[4][2] - m[0][1]*m[1][0]*m[2][3]*m[4][2] + m[0][0]*m[1][1]*m[2][3]*m[4][2] + 
		      m[0][2]*m[1][1]*m[2][0]*m[4][3] - m[0][1]*m[1][2]*m[2][0]*m[4][3] - m[0][2]*m[1][0]*m[2][1]*m[4][3] + m[0][0]*m[1][2]*m[2][1]*m[4][3] + 
		      m[0][1]*m[1][0]*m[2][2]*m[4][3] - m[0][0]*m[1][1]*m[2][2]*m[4][3])*one_over_determinant;
      result[4][4] = (m[0][3]*m[1][2]*m[2][1]*m[3][0] - m[0][2]*m[1][3]*m[2][1]*m[3][0] - m[0][3]*m[1][1]*m[2][2]*m[3][0] + m[0][1]*m[1][3]*m[2][2]*m[3][0] + 
		      m[0][2]*m[1][1]*m[2][3]*m[3][0] - m[0][1]*m[1][2]*m[2][3]*m[3][0] - m[0][3]*m[1][2]*m[2][0]*m[3][1] + m[0][2]*m[1][3]*m[2][0]*m[3][1] + 
		      m[0][3]*m[1][0]*m[2][2]*m[3][1] - m[0][0]*m[1][3]*m[2][2]*m[3][1] - m[0][2]*m[1][0]*m[2][3]*m[3][1] + m[0][0]*m[1][2]*m[2][3]*m[3][1] + 
		      m[0][3]*m[1][1]*m[2][0]*m[3][2] - m[0][1]*m[1][3]*m[2][0]*m[3][2] - m[0][3]*m[1][0]*m[2][1]*m[3][2] + m[0][0]*m[1][3]*m[2][1]*m[3][2] + 
		      m[0][1]*m[1][0]*m[2][3]*m[3][2] - m[0][0]*m[1][1]*m[2][3]*m[3][2] - m[0][2]*m[1][1]*m[2][0]*m[3][3] + m[0][1]*m[1][2]*m[2][0]*m[3][3] + 
		      m[0][2]*m[1][0]*m[2][1]*m[3][3] - m[0][0]*m[1][2]*m[2][1]*m[3][3] - m[0][1]*m[1][0]*m[2][2]*m[3][3] + m[0][0]*m[1][1]*m[2][2]*m[3][3])*one_over_determinant;
      break;
    default:
      fprintf( stderr, "Need to handle inverting matrix of dimension %d\n",
	      r );
      exit(-1);
    }
}

/************************************************************************/
/* Should have been d3_printf */

d3_print( fp, spec, sep1, sep2, m, i1, i2, i3 )
     FILE *fp;
     char *spec, *sep1, *sep2;
     double ***m;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    {
      for( j = 0; j < i2; j++ )
	{
	  for( k = 0; k < i3; k++ )
	    {
	      fprintf( fp, spec, m[i][j][k] );
	    }
	  fprintf( fp, sep1 );
	}
      fprintf( fp, sep2 );
    }
}

/************************************************************************/

d3_scanf( fp, m, i1, i2, i3 )
     FILE *fp;
     double ***m;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  if ( fscanf( fp, "%lf", &(m[i][j][k]) ) < 1 )
	    {
	      fprintf( stderr, "d3_scanf_error: %d %d %d\n", i, j, k );
	      exit( -1 );
	    }
	}
}

/************************************************************************/

d3_read( fp, m, i1, i2, i3 )
     FILE *fp;
     double ***m;
     int i1, i2, i3;
{
  int i, j;

  for ( i = 0; i < i1; i++ )
    {
      for ( j = 0; j < i2; j++ )
	{
	  if ( fread( (void *) &(m[i][j][0]), sizeof( double ), i3, fp )
	       != i3 )
	    {
	      fprintf( stderr, "d3_read error: %d %d\n", i, j );
	      exit( -1 );
	    }
	}
    }
}

/************************************************************************/

d3_write( fp, m, i1, i2, i3 )
     FILE *fp;
     double ***m;
     int i1, i2, i3;
{
  int i, j;

  for ( i = 0; i < i1; i++ )
    {
      for ( j = 0; j < i2; j++ )
	{
	  if ( fwrite( (void *) &(m[i][j][0]), sizeof( double ), i3, fp )
	       != i3 )
	    {
	      fprintf( stderr, "d3_write error: %d %d\n", i, j );
	      exit( -1 );
	    }
	}
    }
}

/************************************************************************/

d3_zero( m, i1, i2, i3 )
     double ***m;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  m[i][j][k] = 0.0;
	}
}

/************************************************************************/

d3_copy( m1, m2, i1, i2, i3 )
     double ***m1, ***m2;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  m2[i][j][k] = m1[i][j][k];
	}
}

/************************************************************************/

d3_scale( m1, s, m2, i1, i2, i3 )
     double ***m1;
     double s;
     double ***m2;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  m2[i][j][k] = s*m1[i][j][k];
	}
}

/************************************************************************/

d3_add( m1, m2, m3, i1, i2, i3 )
     double ***m1, ***m2, ***m3;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  m3[i][j][k] = m2[i][j][k] + m1[i][j][k];
	}
}

/************************************************************************/

d3_subtract( m1, m2, m3, i1, i2, i3 )
     double ***m1, ***m2, ***m3;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  m3[i][j][k] = m1[i][j][k] - m2[i][j][k];
	}
}

/************************************************************************/

d3v_0_mult( m1, m2, m3, i1, i2, i3 )
     double ***m1, *m2, **m3;
     int i1, i2, i3;
{
  int i, j, k;

  for( j = 0; j < i2; j++ )
    for( k = 0; k < i3; k++ )
      {
	m3[j][k] = 0.0;
	for( i = 0; i < i1; i++ )
	  m3[j][k] += m1[i][j][k]*m2[i];
      }
}

/************************************************************************/

d3v_1_mult( m1, m2, m3, i1, i2, i3 )
     double ***m1, *m2, **m3;
     int i1, i2, i3;
{
  int i, j, k;

  for( i = 0; i < i1; i++ )
    for( k = 0; k < i3; k++ )
      {
	m3[i][k] = 0.0;
	for( j = 0; j < i2; j++ )
	  m3[i][k] += m1[i][j][k]*m2[j];
      }
}

/************************************************************************/

d3v_2_mult( m1, m2, m3, i1, i2, i3 )
     double ***m1, *m2, **m3;
     int i1, i2, i3;
{
  int i, j, k;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      {
	m3[i][j] = 0.0;
	for( k = 0; k < i3; k++ )
	  m3[i][j] += m1[i][j][k]*m2[k];
      }
}

/************************************************************************/

d3m_0_mult( m1, m2, m3, i1, i2, i3, c )
     double ***m1, **m2, ***m3;
     int i1, i2, i3, c;
{
  int i, j, k, l;

  for( l = 0; l < c; l++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  m3[l][j][k] = 0.0;
	  for( i = 0; i < i1; i++ )
	    m3[l][j][k] += m1[i][j][k]*m2[i][l];
	}
}

/************************************************************************/

d3m_1_mult( m1, m2, m3, i1, i2, i3, c )
     double ***m1, **m2, ***m3;
     int i1, i2, i3, c;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    for( l = 0; l < c; l++ )
      for( k = 0; k < i3; k++ )
	{
	  m3[i][l][k] = 0.0;
	  for( j = 0; j < i2; j++ )
	    m3[i][l][k] += m1[i][j][k]*m2[j][l];
	}
}

/************************************************************************/

d3m_2_mult( m1, m2, m3, i1, i2, i3, c )
     double ***m1, **m2, ***m3;
     int i1, i2, i3, c;
{
  int i, j, k, l;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( l = 0; l < c; l++ )
	{
	  m3[i][j][l] = 0.0;
	  for( k = 0; k < i3; k++ )
	    m3[i][j][l] += m1[i][j][k]*m2[k][l];
	}
}

/************************************************************************/

d33_0_mult( m1, m2, m3, i1, i2, i3, c2, c3 )
     double ***m1, ***m2, ****m3;
     int i1, i2, i3, c2, c3;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( m = 0; m < c3; m++ )
      for( j = 0; j < i2; j++ )
	for( k = 0; k < i3; k++ )
	  {
	    m3[l][m][j][k] = 0.0;
	    for( i = 0; i < i1; i++ )
	      m3[l][m][j][k] += m1[i][j][k]*m2[i][l][m];
	  }
}

/************************************************************************/

d33_0_t2nd_mult( m1, m2, m3, i1, i2, i3, c2, c3 )
     double ***m1, ***m2, ****m3;
     int i1, i2, i3, c2, c3;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( m = 0; m < c3; m++ )
      for( j = 0; j < i2; j++ )
	for( k = 0; k < i3; k++ )
	  {
	    m3[l][m][j][k] = 0.0;
	    for( i = 0; i < i1; i++ )
	      m3[l][m][j][k] += m1[i][j][k]*m2[i][m][l];
	  }
}

/************************************************************************/

d33_1_mult( m1, m2, m3, i1, i2, i3, c2, c3 )
     double ***m1, ***m2, ****m3;
     int i1, i2, i3, c2, c3;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( m = 0; m < c3; m++ )
      for( i = 0; i < i1; i++ )
	for( k = 0; k < i3; k++ )
	  {
	    m3[l][m][i][k] = 0.0;
	    for( j = 0; j < i2; j++ )
	      m3[l][m][i][k] += m1[i][j][k]*m2[j][l][m];
	  }
}

/************************************************************************/

d33_2_mult( m1, m2, m3, i1, i2, i3, c2, c3 )
     double ***m1, ***m2, ****m3;
     int i1, i2, i3, c2, c3;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( m = 0; m < c3; m++ )
      for( i = 0; i < i1; i++ )
	for( j = 0; j < i2; j++ )
	  {
	    m3[l][m][i][j] = 0.0;
	    for( k = 0; k < i3; k++ )
	      m3[l][m][i][j] += m1[i][j][k]*m2[k][l][m];
	  }
}

/************************************************************************/

d33_0_t12_mult( m1, m2, m3, i1, i2, i3, c2, c3 )
     double ***m1, ***m2, ****m3;
     int i1, i2, i3, c2, c3;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( m = 0; m < c3; m++ )
      for( j = 0; j < i2; j++ )
	for( k = 0; k < i3; k++ )
	  {
	    m3[l][j][m][k] = 0.0;
	    for( i = 0; i < i1; i++ )
	      m3[l][j][m][k] += m1[i][j][k]*m2[i][l][m];
	  }
}

/************************************************************************/

d33_0_t13_mult( m1, m2, m3, i1, i2, i3, c2, c3 )
     double ***m1, ***m2, ****m3;
     int i1, i2, i3, c2, c3;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( m = 0; m < c3; m++ )
      for( j = 0; j < i2; j++ )
	for( k = 0; k < i3; k++ )
	  {
	    m3[l][k][j][m] = 0.0;
	    for( i = 0; i < i1; i++ )
	      m3[l][k][j][m] += m1[i][j][k]*m2[i][l][m];
	  }
}

/************************************************************************/

dm3_0_mult( m1, m2, m3, i1, i2, c2, c3 )
     double **m1, ***m2, ***m3;
     int i1, i2, c2, c3;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( m = 0; m < c3; m++ )
      for( j = 0; j < i2; j++ )
	  {
	    m3[l][m][j] = 0.0;
	    for( i = 0; i < i1; i++ )
	      m3[l][m][j] += m1[i][j]*m2[i][l][m];
	  }
}

/************************************************************************/

dm3_1_mult( m1, m2, m3, i1, i2, c2, c3 )
     double **m1, ***m2, ***m3;
     int i1, i2, c2, c3;
{
  int i, j, k, l, m;

  for( i = 0; i < i1; i++ )
    for( l = 0; l < c2; l++ )
      for( m = 0; m < c3; m++ )
	{
	  m3[i][l][m] = 0.0;
	  for( j = 0; j < i2; j++ )
	    m3[i][l][m] += m1[i][j]*m2[j][l][m];
	}
}

/************************************************************************/

dm3_1_t01_mult( m1, m2, m3, i1, i2, c2, c3 )
     double **m1, ***m2, ***m3;
     int i1, i2, c2, c3;
{
  int i, j, k, l, m;

  for( i = 0; i < i1; i++ )
    for( l = 0; l < c2; l++ )
      for( m = 0; m < c3; m++ )
	{
	  m3[l][i][m] = 0.0;
	  for( j = 0; j < i2; j++ )
	    m3[l][i][m] += m1[i][j]*m2[j][l][m];
	}
}

/************************************************************************/

dm3_0_2_mult( m1, m2, m3, i1, i2, c1, c2 )
     double **m1, ***m2, ***m3;
{
  int i, j, k, l, m;
  
  for( j = 0; j < i2; j++ )
    for( k = 0; k < c1; k++ )
      for( l = 0; l < c2; l++ )
	{
	  m3[k][l][j] = 0.0;
	  for( i = 0; i < i1; i++ )
	    m3[k][l][j] += m1[i][j]*m2[k][l][i];
	}
}

/************************************************************************/

dmm_0_mult( m1, m2, m3, i1, i2, c2 )
     double **m1, **m2, **m3;
     int i1, i2, c2;
{
  int i, j, k, l, m;

  for( l = 0; l < c2; l++ )
    for( j = 0; j < i2; j++ )
      {
	m3[l][j] = 0.0;
	for( i = 0; i < i1; i++ )
	  m3[l][j] += m1[i][j]*m2[i][l];
      }
}

/************************************************************************/
/************************************************************************/
/* Should have been d4_printf */

d4_print( fp, spec, sep1, sep2, sep3, m, i1, i2, i3, i4 )
     FILE *fp;
     char *spec, *sep1, *sep2, *sep3;
     double ****m;
     int i1, i2, i3, i4;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    {
      for( j = 0; j < i2; j++ )
	{
	  for( k = 0; k < i3; k++ )
	    {
	      for( l = 0; l < i4; l++ )
		{
		  fprintf( fp, spec, m[i][j][k][l] );
		}
	      fprintf( fp, sep1 );
	    }
	  fprintf( fp, sep2 );
	}
      fprintf( fp, sep3 );
    }
}

/************************************************************************/

d4_scanf( fp, m, i1, i2, i3, i4 )
     FILE *fp;
     double ****m;
     int i1, i2, i3, i4;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    if ( fscanf( fp, "%lf", &(m[i][j][k][l]) ) < 1 )
	      {
		fprintf( stderr, "d4_scanf_error: %d %d %d %d\n", i, j, k, l );
		exit( -1 );
	      }
	  }
}

/************************************************************************/

d4_read( fp, m, i1, i2, i3, i4 )
     FILE *fp;
     double ****m;
     int i1, i2, i3, i4;
{
  int i, j, k;

  for ( i = 0; i < i1; i++ )
    {
      for ( j = 0; j < i2; j++ )
	{
	  for ( k = 0; k < i3; k++ )
	    {
	      if ( fread( (void *) &(m[i][j][k][0]), sizeof( double ), i4, fp )
		   != i4 )
		{
		  fprintf( stderr, "d4_read error: %d %d %d\n", i, j, k );
		  exit( -1 );
		}
	    }
	}
    }
}

/************************************************************************/

d4_write( fp, m, i1, i2, i3, i4 )
     FILE *fp;
     double ****m;
     int i1, i2, i3, i4;
{
  int i, j, k;

  for ( i = 0; i < i1; i++ )
    {
      for ( j = 0; j < i2; j++ )
	{
	  for ( k = 0; k < i3; k++ )
	    {
	      if ( fwrite( (void *) &(m[i][j][k][0]), sizeof( double ),
			   i4, fp ) != i4 )
		{
		  fprintf( stderr, "d4_write error: %d %d %d\n", i, j, k );
		  exit( -1 );
		}
	    }
	}
    }
}

/************************************************************************/

d4_zero( m, i1, i2, i3, i4 )
     double ****m;
     int i1, i2, i3, i4;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    m[i][j][k][l] = 0.0;
	  }
}

/************************************************************************/

d4_copy( m1, m2, i1, i2, i3, i4 )
     double ****m1, ****m2;
     int i1, i2, i3, i4;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    m2[i][j][k][l] = m1[i][j][k][l];
	  }
}

/************************************************************************/

d4_scale( m1, s, m2, i1, i2, i3, i4 )
     double ****m1;
     double s;
     double ****m2;
     int i1, i2, i3, i4;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    m2[i][j][k][l] = s*m1[i][j][k][l];
	  }
}

/************************************************************************/

d4_add( m1, m2, m3, i1, i2, i3, i4 )
     double ****m1, ****m2, ****m3;
     int i1, i2, i3, i4;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    m3[i][j][k][l] = m2[i][j][k][l] + m1[i][j][k][l];
	  }
}

/************************************************************************/

d4_subtract( m1, m2, m3, i1, i2, i3, i4 )
     double ****m1, ****m2, ****m3;
     int i1, i2, i3, i4;
{
  int i, j, k, l;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    m3[i][j][k][l] = m1[i][j][k][l] - m2[i][j][k][l];
	  }
}

/************************************************************************/

d4v_0_mult( m1, v, m3, i1, i2, i3, i4 )
     double ****m1, *v, ***m3;
     int i1, i2, i3, i4;
{
  int i, j, k, l;
  
  for( j = 0; j < i2; j++ )
    for( k = 0; k < i3; k++ )
      for( l = 0; l < i4; l++ )
	{
	  m3[j][k][l] = 0.0;
	  for( i = 0; i < i1; i++ )
	    m3[j][k][l] += m1[i][j][k][l]*v[i];
	}
}

/************************************************************************/

d4v_3_mult( m1, m2, m3, i1, i2, i3, i4 )
     double ****m1, *m2, ***m3;
     int i1, i2, i3, i4;
{
  int i, j, k, l;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	{
	  m3[i][j][k] = 0.0;
	  for( l = 0; l < i4; l++ )
	    m3[i][j][k] += m1[i][j][k][l]*m2[l];
	}
}

/************************************************************************/

d4m_0_mult( m1, m2, m3, i1, i2, i3, i4, c )
     double ****m1, **m2, ****m3;
     int i1, i2, i3, i4, c;
{
  int i, j, k, l, m;
  
  for( m = 0; m < c; m++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    m3[m][j][k][l] = 0.0;
	    for( i = 0; i < i1; i++ )
	      m3[m][j][k][l] += m1[i][j][k][l]*m2[i][m];
	  }
}

/************************************************************************/

d4m_1_mult( m1, m2, m3, i1, i2, i3, i4, c )
     double ****m1, **m2, ****m3;
     int i1, i2, i3, i4, c;
{
  int i, j, k, l, m;
  
  for( i = 0; i < i1; i++ )
    for( m = 0; m < c; m++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  {
	    m3[i][m][k][l] = 0.0;
	    for( j = 0; j < i2; j++ )
	      m3[i][m][k][l] += m1[i][j][k][l]*m2[j][m];
	  }
}

/************************************************************************/

d4m_2_mult( m1, m2, m3, i1, i2, i3, i4, c )
     double ****m1, **m2, ****m3;
     int i1, i2, i3, i4, c;
{
  int i, j, k, l, m;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( m = 0; m < c; m++ )
	for( l = 0; l < i4; l++ )
	  {
	    m3[i][j][m][l] = 0.0;
	    for( k = 0; k < i3; k++ )
	      m3[i][j][m][l] += m1[i][j][k][l]*m2[k][m];
	  }
}

/************************************************************************/

d4m_3_mult( m1, m2, m3, i1, i2, i3, i4, c )
     double ****m1, **m2, ****m3;
     int i1, i2, i3, i4, c;
{
  int i, j, k, l, m;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( m = 0; m < c; m++ )
	  {
	    m3[i][j][k][m] = 0.0;
	    for( l = 0; l < i4; l++ )
	      m3[i][j][k][m] += m1[i][j][k][l]*m2[l][m];
	  }
}

/************************************************************************/
/************************************************************************/
/************************************************************************/

d5_zero( m1, i1, i2, i3, i4, i5 )
     double *****m1;
     int i1, i2, i3, i4, i5;
{
  int i, j, k, l, m;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m1[i][j][k][l][m] = 0;
	    }
}

/************************************************************************/

d5_copy( m1, m2, i1, i2, i3, i4, i5 )
     double *****m1, *****m2;
     int i1, i2, i3, i4, i5;
{
  int i, j, k, l, m;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m2[i][j][k][l][m] = m1[i][j][k][l][m];
	    }
}

/************************************************************************/

d5_scale( m1, s, m2, i1, i2, i3, i4, i5 )
     double *****m1;
     double s;
     double *****m2;
     int i1, i2, i3, i4, i5;
{
  int i, j, k, l, m;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m2[i][j][k][l][m] = s*m1[i][j][k][l][m];
	    }
}

/************************************************************************/

d5_add( m1, m2, m3, i1, i2, i3, i4, i5 )
     double *****m1, *****m2, *****m3;
     int i1, i2, i3, i4, i5;
{
  int i, j, k, l, m;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m3[i][j][k][l][m] = m2[i][j][k][l][m] + m1[i][j][k][l][m];
	    }
}

/************************************************************************/

d5_subtract( m1, m2, m3, i1, i2, i3, i4, i5 )
     double *****m1, *****m2, *****m3;
     int i1, i2, i3, i4, i5;
{
  int i, j, k, l, m;

  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m3[i][j][k][l][m] = m1[i][j][k][l][m] - m2[i][j][k][l][m];
	    }
}

/************************************************************************/

d5v_0_mult( m1, v, m3, i1, i2, i3, i4, i5 )
     double *****m1, *v, ****m3;
     int i1, i2, i3, i4, i5;
{
  int i, j, k, l, m;
  
  for( j = 0; j < i2; j++ )
    for( k = 0; k < i3; k++ )
      for( l = 0; l < i4; l++ )
	for( m = 0; m < i5; m++ )
	  {
	    m3[j][k][l][m] = 0.0;
	    for( i = 0; i < i1; i++ )
	      m3[j][k][l][m] += m1[i][j][k][l][m]*v[i];
	  }
}

/************************************************************************/
/************************************************************************/
/************************************************************************/

d5m_1_mult( m1, m2, m3, i1, i2, i3, i4, i5, c )
     double *****m1, **m2, *****m3;
     int i1, i2, i3, i4, i5, c;
{
  int i, j, k, l, m, n;
  
  for( i = 0; i < i1; i++ )
    for( n = 0; n < c; n++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m3[i][n][k][l][m] = 0.0;
	      for( j = 0; j < i2; j++ )
		m3[i][n][k][l][m] += m1[i][j][k][l][m]*m2[j][n];
	    }
}

/************************************************************************/

d5m_2_mult( m1, m2, m3, i1, i2, i3, i4, i5, c )
     double *****m1, **m2, *****m3;
     int i1, i2, i3, i4, i5, c;
{
  int i, j, k, l, m, n;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( n = 0; n < c; n++ )
	for( l = 0; l < i4; l++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m3[i][j][n][l][m] = 0.0;
	      for( k = 0; k < i3; k++ )
		m3[i][j][n][l][m] += m1[i][j][k][l][m]*m2[k][n];
	    }
}

/************************************************************************/

d5m_3_mult( m1, m2, m3, i1, i2, i3, i4, i5, c )
     double *****m1, **m2, *****m3;
     int i1, i2, i3, i4, i5, c;
{
  int i, j, k, l, m, n;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( n = 0; n < c; n++ )
	  for( m = 0; m < i5; m++ )
	    {
	      m3[i][j][k][n][m] = 0.0;
	      for( l = 0; l < i4; l++ )
		m3[i][j][k][n][m] += m1[i][j][k][l][m]*m2[l][n];
	    }
}

/************************************************************************/

d5m_4_mult( m1, m2, m3, i1, i2, i3, i4, i5, c )
     double *****m1, **m2, *****m3;
     int i1, i2, i3, i4, i5, c;
{
  int i, j, k, l, m, n;
  
  for( i = 0; i < i1; i++ )
    for( j = 0; j < i2; j++ )
      for( k = 0; k < i3; k++ )
	for( l = 0; l < i4; l++ )
	  for( n = 0; n < c; n++ )
	    {
	      m3[i][j][k][l][n] = 0.0;
	      for( m = 0; m < i5; m++ )
		m3[i][j][k][l][n] += m1[i][j][k][l][m]*m2[m][n];
	    }
}

/************************************************************************/
