/* 
Fix all left and right things to be [2] instead of l_ and r_
*/

/* Define for 30in screen 2600 pixels wide */
// #define CGA_HOME 1

#define LEFT 0
#define RIGHT 1

/* These are handy constants. XX rather than X to avoid math.h conflicts */
#define XX 0
#define YY 1
#define ZZ 2

#define OK 1
#define CRASHED 2

// parameters for simulation
typedef struct {
  double time_step;          // simulation physics time step    
  double time;               // current time in simulation
  double desireds_index;      // time index into desireds(t)
  double last_time;          // a variable used by controller.

  double duration;  // simulation duration
  double slowdown;  // hack to slow down simulation so we can see graphics

  // Angles
  double pitch;
  double hip_angle[2];
  double knee_angle[2];
  double ankle_angle[2];

  // Location of various body parts. */
  double head[3];
  double hip[3];
  double knee[2][3];
  double foot[2][3];
  
  // Angular velocities
  double pitchd;
  double hip_angled[2];
  double knee_angled[2];
  double ankle_angled[2];

  // Linear velocities
  double headd[3];
  double hipd[3];
  double kneed[2][3];
  double footd[2][3];

  // ground model
  double gnd_k_z;
  double gnd_k_x;
  double gnd_b_z;
  double gnd_b_x;

  // original ground contact point.
  double foot_zero[2][3];

  // foot positions and forces
  double footpos[2][3];
  double footvel[2][3];
  double gndforce[2][3];

  // gains
  double k_hip;
  double b_hip;
  double k_knee;
  double b_knee;
  double k_ankle;
  double b_ankle;

  // desired positions
  double head_d[3];
  double hip_d[3];
  double knee_d[2][3];
  double foot_d[2][3];
  float pitch_d;
  double hip_angle_d[2];
  double knee_angle_d[2];
  double ankle_angle_d[2];

  // desired velocities
  double headd_d[3];
  double hipd_d[3];
  double kneed_d[2][3];
  double footd_d[2][3];
  double pitchd_d;
  double hip_angled_d[2];
  double knee_angled_d[2];
  double ankle_angled_d[2];

  // absolute angles
  double torso_abs_angle;
  double thigh_abs_angle[2];
  double calf_abs_angle[2];

  // commanded torques
  double hip_command[2];
  double knee_command[2];
  double ankle_command[2];

  // Torque feedforwards
  double hip_command_ff[2];
  double knee_command_ff[2];
  double ankle_command_ff[2];

  // torques (actually applied)
  double hip_torque[2];
  double knee_torque[2];
  double ankle_torque[2];

  // controller variables
  int controller_state;
  double state_start_time;
  double state_elapsed_time;

  // debugging variables
  double step_length;

  // Are we CRASHED? 
  int status;

  // dynamics stuff
  int sdfast_flag;
  int sdfast_mode;
  int sdfast_last_mode;
  double state_sdfast[100];
  double ds_state[100];
  double ss_state[100];
  double x_offset;
  int ss_foot_down;

  // kinematics
  double torso_length;
  double torso_cm;
  double torso_mass;
  double torso_I;
  double thigh_length;
  double thigh_cm;
  double thigh_mass;
  double thigh_I;
  double calf_length;
  double calf_cm;
  double calf_mass;
  double calf_I;

  double head_offset[3];
  double hip_offset[3];
  double knee_offset[3];
  double foot_offset[3];

  // random stuff
  int rand_seed;
  double rand_scale;

  /* Overall parameters */
  double total_duration;

  /* Objective function */
  double desired_speed;
  /* these need to be floats for parameter initialization */
  float crashed_penalty_weight;
  float speed_penalty_weight;
  float torque_penalty_weight;

  /* Servo modes */
  int hip_servo_mode[2];
  int knee_servo_mode[2];
  int ankle_servo_mode[2];

  /* Initial posture */
  double wait_duration;
  double wait_l_hip;
  double wait_l_knee;
  double wait_l_ankle;
  double wait_r_hip;
  double wait_r_knee;
  double wait_r_ankle;

  /* Launch1 parameters: lift left leg */
  float l1_duration;
  float l1_lhip_target;
  float l1_lknee_target;
  float l1_rankle_torque;

  /* Launch2 parameters: swing left leg */
  float l2_duration;
  float l2_lhip_target;
  float l2_lknee_target;
  float l2_rhip_target;
  float l2_rknee_target;
  
  /* Steady state gait parameters */
  float swing_time; /* how long it takes to swing leg */
  float thrust1; /* How much to straighted knee on pushoff */
  float swing_hip_target; /* Where to swing leg to */
  float stance_hip_target; /* Where to move stance hip to */
  float swing_hip_overshoot; /* What it says */
  float swing_hip_overshoot_time; /* When to have maximum forward hip */
  /* float pitch_d; see above */ /* Desired pitch angle */
  float pushoff_time; /* When to push off */
  float swing_knee1; /* Some intermediate knee targets and times */
  float swing_knee1_time;
  float swing_knee2;
  float swing_knee2_time;
  float stance_ankle_torque; /* How much to torque at stance angle */
  float swing_hv1; /* Some swing velocities */
  float swing_kv1;
  float swing_kv2;

} SIM;
