function joints = ik2( tip )
% do inverse kinematics of 2 link arm

global l1 l2

x = tip(1);
y = tip(2);

a2 = acos( (x*x + y*y - l1*l1 - l2*l2)/(2*l1*l2) );

a1 = atan2( y, x ) - atan2( l2*sin(a2), l1 + l2*cos(a2) );

joints = [ a1 a2 ];


