function tip = draw2( joints )
% do forward kinematics of 2 link arm

global l1 l2
global h_axes link1 link2

a1 = joints(1);
a12 = joints(1) + joints(2);

elbow = [l1*cos(a1) l1*sin(a1)]';
tip = elbow + [l2*cos(a12) l2*sin(a12)]';

set(link1,'Parent',h_axes,'Xdata',[0 elbow(1)], ...
'Ydata',[0 elbow(2)],'visible','on');

set(link2,'Parent',h_axes,'Xdata',[elbow(1) tip(1)], ...
'Ydata', [elbow(2)  tip(2)],'visible','on');

drawnow

end
