import numpy as np 
from matplotlib import pyplot as plt

def T0(thetas):
	return([])

class TwoLinkArm:
	def __init__(self,l1=.1,l2=.11):
		self.l1 = l1
		self.l2 = l2
		self.fig = None
		self.max_rad = (l1+l2)*1.2

	def make_plot(self):
		self.fig = plt.Figure(figsize=(8,8))
		self.ax = plt.gca()

	def T0(self,thetas):
		return([np.cos(thetas[0])*self.l1,np.sin(thetas[0])*self.l1])

	def T1(self,thetas):
		t1 = thetas[0]
		t2 = thetas[1]

		x = np.array([self.l1*np.cos(t1)+self.l2*np.cos(t1+t2),self.l1*np.sin(t1)+self.l2*np.sin(t1+t2)])
		return(x)

	def render_pos(self, target_thetas, target_point, start_thetas = np.array([0,0]), num_points=20):
		points = np.linspace(start_thetas,target_thetas,num_points)
		for t in range(num_points):
			arm_points = np.vstack((np.zeros(2),self.T0(points[t,:]),self.T1(points[t,:])))
			self.ax.clear()
			self.ax.set_xlim(-self.max_rad,self.max_rad)
			self.ax.set_ylim(-self.max_rad,self.max_rad)

			self.ax.scatter(arm_points[:,0],arm_points[:,1],c='b')
			self.ax.plot(arm_points[:2,0],arm_points[:2,1],c='b')
			self.ax.plot(arm_points[1:,0],arm_points[1:,1],c='b')
			self.ax.scatter(target_point[0],target_point[1],c='r')
			plt.pause(0.05)
		plt.show()

if __name__ == '__main__':
	vis = TwoLinkArm()
	vis.make_plot()
	vis.render_pos(np.array([np.pi/4,np.pi/4]),vis.T1(np.array([np.pi/4,np.pi/4])))

