#ifndef UTILITY_INCLUDED
#define UTILITY_INCLUDED
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <fstream>

namespace util {
using namespace std;



const double PI = atan(1.0)*4.0;
const double zero[100]={0.0};


double *zeroArray();

//int isNaN( double x ) { return _isnan(x); }

void printArray(const double * const a, int l=3);
void printArray(const int * const a, int l=3);
void copyArray(const double *toCopy, double *copyInto, int n=3);
void subArray(const double *A, const double *B, double *C, int n=3);
void addArray(const double *A, const double *B, double *C, int n=3);
void multArray(const double *V, const double a, double *Va, int n=3);

void cross(const double A[3], const double B[3], double *C);

double mag(const double *V, int n=3);

int intPow(int base, int exp);

double cubicAccel(double nowP, double nowV, double endP, double endV, double T);
double bangBangAccel(double x0, double v0, double xf, double vf, double T);
double minQuadratic(double A, double B, double C);

inline double rand1() {	return (double) rand()/ (double) RAND_MAX;	}
inline double randMM(double min, double max) { return ((double)rand()/(double) RAND_MAX)*(max-min)+ min; }

double getTime();
void startClock();
double readClock();

inline void flipSign(double &val) { val = -val; }
inline void limit(double &val, double min, double max) {	if(val>max) val = max;		if(val<min) val = min;	}
inline double limitD(double val, double min, double max) {	if(val>max) val = max;		if(val<min) val = min;	 return val;	}
bool limitB(double &val, double min, double max);
inline void limitMag(double &val, double maxMag) { if(val>maxMag) val = maxMag;		if(val<-maxMag) val = -maxMag; }
inline double limitMagD(double val, double maxMag) { if(val>maxMag) val = maxMag;		if(val<-maxMag) val = -maxMag; return val;}
bool limitMagB(double &val, double maxMag);
inline bool inRange(double val, double min, double max)		 { return val > min && val < max; }
inline bool inUnorderedRange(double val, double side1, double side2) { return ((val<=side1 && val>=side2) || (val>=side1 && val<=side2)); }
inline double regAng(double ang) {	while(ang>PI)	ang -= 2.0*PI;		while(ang<-PI)	ang += 2.0*PI; return ang; }
inline double regAng1(double ang) {	if(ang>PI)	ang -= 2.0*PI;		if(ang<-PI)	ang += 2.0*PI; return ang; }
inline double regAngHalf(double ang) {	while(ang>PI/2.0)	ang -= PI;		while(ang<-PI/2.0)	ang += PI; return ang; }

void rotate2Vec(double *vec, double ang);

inline bool almostEqual(double val1, double val2, double thresh=1e-6) { return fabs(val1-val2) <= thresh; }
inline bool almostEqualZero(double val, double thresh=1e-6)	{	return almostEqual(val, 0.0, thresh); }
inline int round(double x) { return int(x > 0.0 ? x + 0.5 : x - 0.5); }

void printBlankLine(ostream& f, int n);

const char *getExtension(const char *fileName);
char *getExtension(char *fileName);

//assumes m=b=k=1.0
void getPDgains(double w0, double damp, double &Kp, double &Kd);

}
#endif