#include "util.h"
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
using namespace std;

void util::printArray(const double * const a, int l) {
	printf("(");
	for(int i = 0; i < l; i++) {
		printf("%f",a[i]);
		if(i != l-1)	printf(", ");
	}
	printf(")\n");
}

void util::printArray(const int * const a, int l) {
	printf("(");
	for(int i = 0; i < l; i++) {
		printf("%d",a[i]);
		if(i != l-1)	printf(", ");
	}
	printf(")\n");
}

int util::intPow(int base, int exp) {
	if(exp == 0)	return 1;
	int RES = base;
	for(int i = 1; i < exp; i++)	RES*= base;
	return RES;
}

void util::copyArray(const double *toCopy, double *copyInto, int n) {
	for(int i = 0; i < n; i++) {
		copyInto[i] = toCopy[i];
	}
}

void util::addArray(const double *A, const double *B, double *C, int n) {
	for(int i = 0; i < n; i++) {
		C[i] = A[i] + B[i];
	}
}

void util::subArray(const double *A, const double *B, double *C, int n) {
	for(int i = 0; i < n; i++) {
		C[i] = A[i] - B[i];
	}
}

void util::multArray(const double *V, const double a, double *Va, int n) {
	for(int i = 0; i < n; i++) {
		Va[i] = V[i]*a;
	}
}

void util::cross(const double A[3], const double B[3], double *C) {
	C[0] =  A[1]*B[2] - A[2]*B[1];
	C[1] =  A[2]*B[0] - A[0]*B[2];
	C[2] =  A[0]*B[1] - A[1]*B[0];
}

double util::mag(const double *V, int n) {
	double tot = 0;
	for(int i = 0; i < 3; i++)	tot += V[i]*V[i];
	return sqrt(tot);
}

double lotsOfZeros[1000]={0.0};
//for when you can't officially use a constant
//must not change it though
double *util::zeroArray() {
	return lotsOfZeros;
}

//more general thing in  fullsys: fullCon.cpp: cubicSpline()
double util::cubicAccel(double nowP, double nowV, double endP, double endV, double T) {
	
	double b = 3*(endP-nowP) - endV*T - 2*nowV*T;
//	printf("%f %f %f %f %f %f %f\n", nowP, nowV, endP, endV, T, b,(2*b)/(T*T));
	return (2*b)/(T*T);
}


//may potentially require immediate or near-immediate flipping of sign
double util::bangBangAccel(double x0, double v0, double xf, double vf, double T) {
	double A = -vf+v0;
	double B = -2.0*xf + 2.0*x0 + 2*vf*T;
	double C = xf*T - x0*T - 0.5*vf*T*T - 0.5*v0*T*T;

	//solve the quadratic
	double p1 = -B/(2*A), p2 = sqrt(B*B-4.0*A*C)/(2*A);

	double ts1 = p1+p2, ts2 = p1-p2;		//2 answers

	//pick correct switch time
	double ts;
	if(ts1 >= 0 && ts1 <= T)			ts = ts1;
	else								ts = ts2;

	double a = (vf-v0)/(2*ts-T);
//	if(ts < TIME_STEP/2.0)		flipSign(a);	//if time for flipover

	return a;
}

double util::minQuadratic(double A, double B, double C) {
	return (4*A*C-B*B)/(4*A);
}

double util::getTime() {
	LARGE_INTEGER ticksPerSecond;
	LARGE_INTEGER tick;   
	QueryPerformanceFrequency(&ticksPerSecond);
	QueryPerformanceCounter(&tick);
	return tick.QuadPart/double(ticksPerSecond.QuadPart);
}

double CLOCK;
void util::startClock() { CLOCK = getTime(); }
double util::readClock() { return getTime()-CLOCK; }

void util::printBlankLine(ostream& f, int n) {
	for(int i = 0; i < n; i++) f << "0 ";
	f << endl;
}

//returns a pointer to the character after the first period
//return NULL if there is no period
const char *util::getExtension(const char *fileName) {
	size_t len = strlen(fileName);
	for(int i = 0; i < len; i++) {
		if(fileName[i] == '.')	return &(fileName[i+1]);
	}
	return NULL;
}

char *util::getExtension(char *fileName) {
	size_t len = strlen(fileName);
	for(int i = 0; i < len; i++) {
		if(fileName[i] == '.')	return &(fileName[i+1]);
	}
	return NULL;
}

void util::getPDgains(double w0, double damp, double &Kp, double &Kd) {
	Kp = w0*w0;
	Kd = damp*2.0*w0;
}

bool util::limitMagB(double &val, double maxMag) {
	if(val > maxMag) {
		val = maxMag;
		return true;
	}
	if(val < -maxMag) {
		val = -maxMag;
		return true;
	}
	return false;
}

bool util::limitB(double &val, double min, double max) {
	if(val > max) {
		val = max;
		return true;
	}
	if(val < min) {
		val = min;
		return true;
	}
	return false;
}

void util::rotate2Vec(double *vec, double ang) {
	double tmp = vec[0];
	double c = cos(ang);
	double s = sin(ang);
	vec[0] = c*vec[0] - s*vec[1];
	vec[1] = s*tmp    + c*vec[1];
}