#include "DP.h"
#include "invPend.h"

#include <iostream>
#include <fstream>
using namespace std;




//simulates a trajectory
void simTraj(Dynamics *dyn, DP *dp, int steps, char *name) {
	ofstream outFile(name);
	double x[2] = {util::PI+0.001, 0.0};
	double a[1];
	double cumCost = 0.0, cost = 0.0;
	int typeTmp;
	int totGood = 0;
	//using namespace IP;
	
	//double E0 = m*g*L;
	for(int i = 0; i < steps; i++) {
		//double E = getE(x);
		dp->lookupPolicy(a,x);
		outFile << x[0]  <<" "<< x[1] << " " << a[0] <<" "<< cost <<" "<< cumCost  <<endl;

		cost = dyn->integrateCost(x,a,x,typeTmp, &typeTmp);
		cumCost += cost;
	}
	outFile.close();
}



DP dpForWrap;

void DPpolWrap(double *a, const double *x) {
	dpForWrap.lookupPolicy(a,x);
}


void DPsetup() {
	IP::invPend *dyn = new IP::invPend;
	dpForWrap = DP(dyn, "invPend.dpc");
	dpForWrap.setRandomActionFunction(IP::raInvPend);
}

void DPgenPol() {

	dpForWrap.clearU();
	dpForWrap.clearV();
	dpForWrap.doManySweeps(5,0,NULL,12);

}


void main(int argc, char **argv) {
	DPsetup();	//set up dynamic programming object
	DPgenPol();	//generate a policy
	
	dpForWrap.saveUV("policyAndValue");	//save a policy

	//set up a new dynamic programming object
	Dynamics *dyn = new IP::invPend();
	DP dp(dyn, "invPend.dpc");
	//load in saved policy
	dp.loadUV("policyAndValue");
	//simulate and save a trajectory
	simTraj(dyn, &dp, 10000, "SwingUp");
}