#include "DP.h"
#include "absDyn.h"
#include "util.h"
#include <assert.h>

namespace IP {
using namespace util;

const double TIME_STEP = 0.001;
const double TIME_STEP2 = TIME_STEP*TIME_STEP;

//#define COUNT_SWINGS

//states
const int TH = 0;
const int THD = 1;


//actions
const int TAU = 0;

//constants
const double defm = 1;
const double g = 9.81;
const double defL = 1;
const double defI = defm*defL*defL;
const double defth0=0;
const double defvisc = 0.0;

const double MAX_TAU = 1.5;	//allows ZMP to deviate 4 cm from center of foot

//cost
double TAU_W = 3.0;
double POS_W = 1.0;
double VEL_W = 0.0;







class invPend : public Dynamics {
	public:
		invPend() {
			m = defm;
			L = defL;
			I = m*L*L;
			th0 = defth0;
			visc = defvisc;
			da = 0;
		}
		double integrateCost(const double *si, double *a, double *sf, const int typeI, int *typeF);
		invPend *copy();
		double getTimeStep() { return TIME_STEP; };
		void setI() { I = m*L*L; }
		void setM(double mm) { m = mm; setI(); }
		void setL(double LL) { L = LL; setI(); }
		void setVisc(double vv) { visc = vv; }
		void setTh0(double tt) { th0 = tt; }
		void setDA(double DA) {da = DA; }

		void resetParams() {
			setM(1.0);
			setL(1.0);
			setVisc(0.0);
			setTh0(0.0);
			setDA(0.0);
		}
		bool isGood(double *state) {
			return (state[TH]-th0)<0.5;
		}


		double m;
		double L;
		double I;
		double th0;
		double visc;
		double da;
};

invPend *invPend::copy() {
	invPend *sc = new invPend();
	return sc;
}


#ifdef COUNT_SWINGS
bool JC3 = false;
#endif

double invPend::integrateCost(const double *si, double *a, double *sf, const int typeI, int *typeF) {
	*typeF = typeI;	//default is to keep the same

	double cost = TAU_W*a[TAU]*a[TAU] + POS_W*si[TH]*si[TH] + VEL_W*si[THD]*si[THD];

	double gTau = L*sin(si[TH]-th0)*m*g;

	double acc = (gTau+a[TAU]-visc*si[THD])/I + da;

	
	sf[TH] = si[TH] + si[THD]*TIME_STEP + 0.5*acc*TIME_STEP2;
	sf[THD] = si[THD] + acc*TIME_STEP;

	//regularize
	while(sf[TH] < 2.0)						sf[TH] += util::PI*2.0;
	while(sf[TH] > util::PI*2.0-2.0)		sf[TH] -= util::PI*2.0;

	return cost;
}


void raInvPend(const double *state, int type, double *action, const DP *dp) {
	action[TAU] = randMM(-MAX_TAU,MAX_TAU);
}


}

