#include <stdio.h>
#include <stdlib.h>

int writeSSV( const char *name, const double *a, int n_x, int n_y ) {
	FILE *stream = NULL;
	int i, j;
	double value;

	stream = fopen( name, "w" );
	if ( stream == NULL ) {
		fprintf( stderr, "Can't open %s for write.\n" );
		exit( -1 );
	}
	for( j = 0; j < n_y; j++ ) {
		for( i = 0; i < n_x; i++ ) {
			value = a[j*n_x + i];
			fprintf( stream, " %g", value );
		}
		fprintf( stream, "\n" );
	}

	fclose( stream );
	return 1;
}

int writeSSVlayer( const char *name, double **a, int n_x, int n_y, int layer ) {
	FILE *stream = NULL;
	int i, j;
	double value;

	stream = fopen( name, "w" );
	if ( stream == NULL ) {
		fprintf( stderr, "Can't open %s for write.\n" );
		exit( -1 );
	}
	for( j = 0; j < n_y; j++ ) {
		for( i = 0; i < n_x; i++ ) {
			value = a[j*n_x + i][layer];
			fprintf( stream, " %g", value );
		}
		fprintf( stream, "\n" );
	}

	fclose( stream );
	return 1;
}





	//not nearly as safe as it ought to be
//loads the 2D data from a matlab file into a 1D array
//reads like text: left to right, then top to bottom
int readSSV( const char *name, double *fillArray, unsigned long size ) {
	FILE *input;
	char buffer[10000];
	char *inputLine;
	int i = 0;
	char *result;

	input = fopen( name, "r" );
	if ( input == NULL ) {
		return 0;
	}
	
	inputLine = buffer;
	inputLine = fgets(buffer, sizeof(buffer), input);
	while(inputLine != NULL) {
		result = strtok( inputLine, " " );
		while( result != NULL && *result != '\n' ) {
			if( i > size) {
				printf("Loaded file was too long.\n");
				fclose( input );
				return 0;
			}
			fillArray[i++] = (double)atof(result);
			//printf("<%s>\n",result);
			result = strtok( NULL, " " );
		}

		inputLine = buffer;
		inputLine = fgets(buffer, sizeof(buffer), input);
	}
	if( i != size) {
		printf("Loaded file was too short.\n");
		printf("Loaded %d.  Expected %d.\n",i,size);
		return 0;
	}
	
	fclose( input );
	return 1;
}
	

	//not nearly as safe as it ought to be
//loads the 2D data from a matlab file into a 1D array
//reads like text: left to right, then top to bottom
int readSSVlayer( const char *name, double **fillArray, unsigned long size, int layer ) {
	FILE *input;
	char buffer[10000];
	char *inputLine;
	int i = 0;
	char *result;

	input = fopen( name, "r" );
	if ( input == NULL ) {
		return 0;
	}
	
	inputLine = buffer;
	inputLine = fgets(buffer, sizeof(buffer), input);
	while(inputLine != NULL) {
		result = strtok( inputLine, " " );
		while( result != NULL && *result != '\n' ) {
			if( i > size) {
				printf("Loaded file was too long.\n");
				return 0;
			}
			fillArray[i++][layer] = (double)atof(result);
//			printf("<%s>\n",result);
			result = strtok( NULL, " " );
		}

		inputLine = buffer;
		inputLine = fgets(buffer, sizeof(buffer), input);
	}
	if( i != size) {
		printf("Loaded file was too short.\n");
		printf("Loaded %d.  Expected %d.\n",i,size);
		return 0;
	}
	
	fclose( input );
	return 1;
}
