#ifndef DP_DEFINED
#define DP_DEFINED
#include <cmath>
#include <string>
#include <windows.h>
#include "absDyn.h"


#define THREADING
//#define ENABLE_MAPPING
//#define MULTI_MODEL


#ifdef THREADING
	#include <process.h>
#endif


using namespace std;


//macros

#define dimIndex2(dim,type,dp) (type*dp->MAX_DIMS+dim)

class SweepStats {
public:
	double dV2;
	int nowGood;
	int nowBad;
	int polChanges;

	SweepStats();
	SweepStats operator+(const SweepStats &other) const;
	SweepStats operator+=(const SweepStats &other);
	void print() const;
	void printV() const;
};


class DP {
public:
	//set stuff up
#ifdef MULTI_MODEL
	DP(Dynamics **dyn, int N_MOD, const char *configName);
	void addDyn(Dynamics *dyn, int refV);
#endif
	DP(Dynamics *dyn, const char *configName);

	void construct(Dynamics *dyn, const char *configName);

	DP();
	void readConfigFile(const char *name);
	void setRandomActionFunction(void (*funk)(const double *, int, double *, const DP *));
	void setPolicy(void (*polFunk)(const double *state, int type, double *action));
	void seedLegalPolicy();
	void loadUVfromConfig(const char *config, const char *pol);

	//precompute
	void calcCornerOffsets(int *offsets, int dims);

	//core computation
	void doManySweeps(int N, int recFreq, const char *fileName=NULL, int numThreads=1, bool justV=false);
	void doSweep(int numThreads = 0);
	void updateState(int ind, SweepStats &ss);
#ifdef MULTI_MODEL
	double actionValue(const double *state, double *action, int mod, int type=0, const int *indices=NULL, bool verbose=false) const;
	double actionValueML(const double *state, double *action, int mod, int type=0, const int *indices=NULL, bool verbose=false) const;
	double lookupValue(const double *state, int mod, int type=0) const;
#else
	double actionValue(const double *state, double *action, int type=0, const int *indices=NULL, bool verbose=false) const;
	double actionValueML(const double *state, double *action, int type=0, const int *indices=NULL, bool verbose=false) const;
	double lookupValue(const double *state, int type=0) const;
#endif
	bool sameTile(const double *s1, const double *s2, int type1=0, int type2=0) const;
	inline int dimIndex(int dim, int type) const {return type*MAX_DIMS+dim;}

	//double interpActionValue(const double *state, double *action, int type, const int *indices, bool verbose=false) const;

#ifdef THREADING	
	//multithreading
	void doManySweepsMT(int N, int recFreq, const char *fileName=NULL, int numThreads=4);
	void doSweepMT(int threads);
	void doVsweepMT(int threads);
	void doSweepFrag(int start, int end, int threadNum, SweepStats &ss);
	void doVsweepFrag(int start, int end, int threadNum, SweepStats &ss);
#endif 

#ifdef ENABLE_MAPPING
	void setMaps(void (*grid2nat)(const double *gridState, double *natState, int type), void (*nat2grid)(const double *natState, double *gridState, int type));
#endif

	//running
	int lookupPolicy(double *action, const double * const state, int type=0, bool verbose=false) const;
	
	//analysis
	double getCellVolume(int type) const;
	int nearestInds(const double *state, int type=0, int *inds=NULL, bool verbose=false) const;
	void explainValue(double *state, int type=0) const;
	void explainValue(int ind) const;
	void printValueSlice(double *pt, int dim1, int dim2, int type, const char *name) const;
	void printValueSliceGrid(double *pt, int dim1, int dim2, int type, const char *name) const;
	void printPolSlice(double *pt, int dim1, int dim2, int type, const char *name, int polIndex=0) const;
	void printPolSliceGrid(double *pt, int dim1, int dim2, int type, const char *name, int polIndex=0) const;
	void printResolutions() const;
	void adjustAll();
	void plotQvsU(const double *state, double min, double max, char *fileName, int type=0, int polInd=0, const double *defAct=NULL, bool verbose=false) const;
	
	//define the goal region
	void setGoalRegion(	bool (*IGRfunk)(const double *, int, const DP *), double (*GRVfunk)(const double *, int, const DP *),	void (*GRAfunk)(const double *, int, double * const, const DP *));
	void setRestartPoint(double timeToRestart, double *point, int type=0);
	double goalRegionValue(const double *state, int type) const;


	//setup an LQR goal with region, policy, and value
	void setSimpleLQRgoal( double *state, int type, double *K, double *Qdiag);
	
	//aux
	void setAux(void (*auxFunk)(DP *dp, double *aux, double *state, int type));
	void writeAux(const char *prefix) const;
	void readAux(const char *prefix);
	int lookupAux(double *aux, const double *state, int type=0) const;

	void applyToAll(void (*func)(int ind, DP *dp));

	//compare 2 DP solutions
	static int compareValues(DP dp1, DP dp2, double thresh);

	//io functions
	//binary functions
	int saveUV(const char *name) const;
	int loadUV(const char *name);
	int saveUVX(const char *name) const;
	int loadUVX(const char *name);
	//ASCII functions
	void writeV(const char *name) const;
	void writeU(const char *name) const;
	void readV(const char *name);
	void readU(const char *name);
	void writeUV(const char *prefix, int suffix) const;
	void writeUV(const char *prefix) const;
	void readUV(const char *prefix, int suffix);
	void readUV(const char *prefix);


	//for minimizing memory usage
	void freeV();
	void freeVtmp();

	//interpolation
	int setupInterp(const double * state, int type, int dims, double *fracs) const;
	double doInterpML(const double *coVal, double *fracs, int dims) const;
	double doInterpDW(const double *coVal, double *fracs, int dims, bool *mask) const;

	//indexing
	int getI1dFromState(const double *state, int type) const;
	int getI1dFromState(const double *state, int type, int *baseInd) const;
	int getI1d(const int *indices, int type) const;
	void getImd(int ind1d, int &type, int *indices) const;
	bool getBaseInds(const double *state, int type, int *indices) const;
	double *getState(const int *indices, int type, double *state) const;
	void getState(int ind1d, double *state, int &type) const;

	bool isCorner(const int *base, const int *indices, int dims) const;

	bool inBounds(double val, int dim, int type=0) const;
	bool inBounds(const double *state, int type=0) const;
	bool putInBounds(double &val, int dim, int type=0) const;
	bool isGoodValue(const double *state, int type=0) const;

	//update only V
	void findValue(void (*polFunk)(const double *, int, double * const));
	void doVsweep(int numThreads = 1);
#ifdef MULTI_MODEL
	void updateV(int ind1d, int mod, SweepStats &ss);
#else
	void updateV(int ind1d, SweepStats &ss);
#endif
	double getValueBySim(double *state, int type, int ts);

	void swapVVtmp();

	void getAllValuesBySim(int ts);
	void multV(double a);
	void clearV();
	void clearU();
	void cleanBadPol();
	void allVbad();
	void allocateVtmp();

	void setAVML(bool mode);

	//debugging
	mutable int hits;

#ifdef MULTI_MODEL
	void setActiveModel(int mod);
	int activeModel;
#endif



/*****************************************/
//variables
/*****************************************/

	//stuff from DPconfig
	int N_DYN_TYPES;
	int *N_DIMS;
	int MAX_DIMS;	//the largest values in N_DIMS
	int *N_ACTION_DIMS;
	int MAX_ACTION_DIMS;	//the largest values in N_ACTION_DIMS
	//define state space
	int *RES;
	double *MIN_STATE;
	double *MAX_STATE;
	double DISCOUNT;
	int N_AUX;
	double *MIN_ACTION;
	double *MAX_ACTION;
	bool hasMA;

	//data
	double *V;
	double *Vtmp;
	double **U;
	double **aux;
#ifdef MULTI_MODEL
	double **Vlist;
	double **VtmpList;
#endif

	//for speeding things up
	double *dx;
	int *N_TYPE_STATES;
	int *statesBeforeType;
	int *FREQ1D;
	long long N_TOTAL_STATES;
	int **cornerOffsets;
	int *corners;

	//the dynamic system
	Dynamics *dynamics;
#ifdef MULTI_MODEL
	Dynamics **dynList;
	int N_MODEL;
#endif
	
	

	//function pointers
	void (*randActPtr)(const double * const, int, double * const, const DP *);
	bool (*inGoalRegion)(const double *, int, const DP *);
	double (*goalRegVal)(const double *, int, const DP *);
	void (*goalRegAction)(const double *, int, double * const, const DP *);
#ifdef ENABLE_MAPPING
	void (*grid2natFunk)(const double *gridState, double *natState, int type);
	void (*nat2gridFunk)(const double *natState, double *gridState, int type);
#endif

	//restart stuff
	bool useRestart;
	int restartType;
	double *restartPt;
	double timeToRestart;

	bool avML;

	int sweep;
};



#endif

