/******************************************************************/

// Run a simple P servo (position gain only).
// Rely on friction to provide damping

/******************************************************************/
// Include files. You can ignore their contents

#include "PicoEncoder-cga.h"
#include "constants.h"
#include "system_stuff.h"
#include "encoder.h"
#include "motor.h"
#include "process_user_input.h"

/******************************************************************/

#define TARGET (FULL_REVOLUTION_11/2)

/******************************************************************/
/******************************************************************/
/******************************************************************/
/******************************************************************/
/******************************************************************/
/******************************************************************/
/******************************************************************/

void setup()
{
  init_system_stuff();
  
  Serial.begin( BAUD_RATE );
  while( !Serial );
  delay( 2000 ); // Delay to make sure message below prints out.
  Serial.println( "Servo test" );
  Serial.println( "Make sure robot is upside down, so wheels are off the ground," );
  Serial.println( "and that the battery is charged and turned on." );
  delay( 2000 ); // Delay to make sure message above prints out.

  motor_init();
  Serial.println( "Motor init done." );
  Serial.println( "If we hang here power cycle the robot. Expect more printout" );
  delay( 1000 ); // Delay to make sure above messages print out.

  left_encoder.begin( left_a_pin );
  right_encoder.begin( right_a_pin );
  Serial.println( "Encoder_init done." );

  Serial.println( "Wheels should be off the ground and battery turned on."  );
  Serial.println( "Type g <return> to run test, s <return> to stop."  );
  Serial.println( "Typing window is at the top of the serial monitor window" );
}

/******************************************************************/
/******************************************************************/
// no timing on this loop. It just runs as fast as it can

void loop()
{
  // how long have we been running? Safety feature
  static unsigned long loop_counter = 0;
  static int count_desired = 0.0; // This is in encoder units
  float k_pos = 0.01;

  loop_counter++;

  // Serial.println( loop_counter );

  left_encoder.update();
  right_encoder.update();

  // forward is positive rotation
  int left_count = left_encoder.position;
  int right_count = right_encoder.position;

  float left_error = left_count - count_desired;
  float right_error = right_count - count_desired;

  // int left_command = 0;
  int left_command = -k_pos*left_error;
  if ( left_command > MAX_COMMAND )
    left_command = MAX_COMMAND;
  if ( left_command < -MAX_COMMAND )
    left_command = -MAX_COMMAND;

  // int right_command = 0;
  int right_command = k_pos*right_error;
  if ( right_command > MAX_COMMAND )
    right_command = MAX_COMMAND;
  if ( right_command < -MAX_COMMAND )
    right_command = -MAX_COMMAND;

  if ( go && (loop_counter%1001 == 0) )
    {
       Serial.print( loop_counter );
       Serial.print( " " );
       Serial.print( go );
       Serial.print( " " );
       Serial.print( left_count );
       Serial.print( " " );
       Serial.print( right_count );
       Serial.print( "; " );
       Serial.print( left_error );
       Serial.print( " " );
       Serial.print( right_error );
       Serial.print( "; " );
       Serial.print( left_command );
       Serial.print( " " );
       Serial.println( right_command );
       return;
    }
  
  if ( loop_counter%1000 == 0 )
    process_user_input();

  if ( !go )
    {
      motor_left_command( 0 );
      motor_right_command( 0 );
      process_user_input();
      loop_counter = 0;
      return;
    }

  /*
  if ( loop_counter%21000 == 0 )
    {
      if ( count_desired > 0 )
        count_desired = 0;
      else
        count_desired = TARGET;
    }
   */
   
  // Turn off after a while to keep from running forever
  if ( loop_counter > 500000 )
    {
      motor_left_command( 0 );
      motor_right_command( 0 );
      Serial.println( "Motor stopped." );
      Serial.println( "Wheels should be off the ground."  );
      Serial.println( "Type g <return> to run test, s <return> to stop."  );
      go = false;
      loop_counter = 0;
      return;
    }
    
  motor_left_command( left_command );
  motor_right_command( right_command );
}

/******************************************************************/
