PicoEncoder left_encoder;
PicoEncoder right_encoder;

// Pin numbers must be declared const int ...; #defines don't work?
// const int left_a_pin = p3;
// const int right_a_pin = p10;
// const int right_a_pin = DigitalPinToPinName( D10 );
const int left_a_pin = A0;
const int right_a_pin = DigitalPinToPinName( D3 );

typedef struct calib_data
{
  float data[4];
  int n_values;
}
  CALIB_DATA;

void init_calib_data( CALIB_DATA *cd )
{
  for ( int i = 0; i < 4; i++ )
    cd->data[ i ] = 0.0;
  cd->n_values = 0;
}

void update_calib_data( int phases, CALIB_DATA *cd )
{
  int cd1 = (phases & 0xFF);
  int cd2 = cd1 + ((phases >> 8) & 0xFF);
  int cd3 = cd2 + ((phases >> 16) & 0xFF);
  cd->data[1] += cd1;
  cd->data[2] += cd2;
  cd->data[3] += cd3;
  (cd->n_values)++;
}

void print_calib_data( CALIB_DATA *cd )
{
  if ( cd->n_values < 1 )
    return;
  int cd1 = cd->data[1]/cd->n_values;
  int cd2 = cd->data[2]/cd->n_values;
  int cd3 = cd->data[3]/cd->n_values;
  int phases = cd1 | ((cd2 - cd1) << 8) | ((cd3 - cd2) << 16);
  Serial.print( phases );
  Serial.print( ", 0x" );
  Serial.print( phases, HEX );
  Serial.print( ", " );
  Serial.print( 256 - cd3 );
  Serial.print( ", " );
  Serial.print( cd3 - cd2 );
  Serial.print( ", " );
  Serial.print( cd2 - cd1 );
  Serial.print( ", " );
  Serial.println( cd1 ); 
}

