// Test PicoEncoder library reading of encoders

/*************************************************/
// Include files. You can ignore their contents

#include <Arduino.h>
// #include <pinDefinitions.h>
#include "PicoEncoder-cga.h"
#include "constants.h"
#include "system_stuff.h"
#include "encoder.h"

/*************************************************/
/*************************************************/
/*************************************************/
/*************************************************/

void setup()
{

  init_system_stuff();

  Serial.begin( BAUD_RATE );
  while( !Serial );

  // Encoder setup
  left_encoder.begin( left_a_pin );
  right_encoder.begin( right_a_pin );

  // CALIBRATE YOUR ENCODER - WILL BE DIFFERENT
  // left_encoder.setPhases( 0x52452A );
  // right_encoder.setPhases( 0x554026 );

  delay( 2000 );
  Serial.println( "Testing PicoEncoder library" );
  Serial.println( "Assuming 11 count encoder\n" );
  Serial.println( "Initialized encoders" );
}

/*************************************************/

void loop()
{
  static int count = 0;

  left_encoder.update();
  right_encoder.update();

  // forward is positive rotation
  // Encoder13 - encoder with 13 counts
  // int left_position = left_encoder.position;
  // int right_position = right_encoder.position;
  // Encoder11 - encoder with 11 counts has opposite sign
  int left_position = -left_encoder.position;
  int right_position = -right_encoder.position;

  Serial.print( count );
  Serial.print( " " );
  Serial.print( left_position );
  Serial.print( " " );
  Serial.print( right_position );
  Serial.println();
  delay( 1000 );
  count++;
}
