// Demonstrate use of the multicolor LED on the Arduino Nano RP2040 Connect

#include <WiFiNINA.h> // We have to use this library for multicolor LED
#include "system_stuff.h"

void setup( void )
{
  init_system_stuff();

  pinMode( LEDR, OUTPUT );
  pinMode( LEDG, OUTPUT );
  pinMode( LEDB, OUTPUT );

  // RED
  digitalWrite( LEDR, HIGH ); // RED
  digitalWrite( LEDG, LOW ); // GREEN
  digitalWrite( LEDB, LOW ); // BLUE
}

void loop( void )
{

  // RED
  digitalWrite( LEDR, HIGH ); // RED
  digitalWrite( LEDG, LOW ); // GREEN
  digitalWrite( LEDB, LOW ); // BLUE
  delay( 1000 );
  // GREEN
  digitalWrite( LEDR, LOW ); // RED
  digitalWrite( LEDG, HIGH ); // GREEN
  digitalWrite( LEDB, LOW ); // BLUE
  delay( 1000 );
  // BLUE
  digitalWrite( LEDR, LOW ); // RED
  digitalWrite( LEDG, LOW ); // GREEN
  digitalWrite( LEDB, HIGH ); // BLUE
  delay( 1000 );
}

/*
We can also choose a value between 255 - 0 to write to the LED:
	analogWrite(LEDR, 72);  //GREEN 
	analogWrite(LEDG, 122); //BLUE 
	analogWrite(LEDB, 234); //RED
*/
