/******************************************************************/

// Drive the motors forward (slowly)

/******************************************************************/

// you don't need to look at the gory details of these
#include "constants.h"
#include "motor.h"
#include "system_stuff.h"
#include "process_user_input.h"

/******************************************************************/
/******************************************************************/
/******************************************************************/

// how long have we been running? Safety feature
unsigned long loop_counter = 0;

/******************************************************************/
/******************************************************************/

void setup()
{
  init_system_stuff();

  Serial.begin( BAUD_RATE );
  while( !Serial );
  delay( 2000 ); // Delay to make sure message below prints out.
  Serial.println( "test_motor" );
  motor_init();
  Serial.println( "motor_init done." );
  Serial.println( "Wheels should be off the ground."  );
  Serial.println( "Type g <return> to run test, s <return> to stop."  );
  Serial.println( "Input window is at the top of the serial monitor window" );
}

/******************************************************************/
/******************************************************************/
// no timing on this loop. It just runs as fast as it can

void loop()
{
  process_user_input();

  ++loop_counter;

  if ( !go )
    {
      motor_left_command( 0 );
      motor_right_command( 0 );
      delay( 1000 );
      loop_counter = 0;
      return;
    }

  // Turn off after a while to keep from running forever
  if ( loop_counter > 5 )
    {
      motor_left_command( 0 );
      motor_right_command( 0 );
      Serial.println( "Motor stopped." );
      Serial.println( "Wheels should be off the ground."  );
      Serial.println( "Type g <return> to run test, s <return> to stop."  );
      go = false;
      return;
    }
    
  int command = 100;
  motor_left_command( command );
  motor_right_command( command );
  delay( 1000 );
  command = 0;
  motor_left_command( command );
  motor_right_command( command );
  delay( 1000 );
}

/******************************************************************/
/******************************************************************/
