#include <Arduino_LSM6DSOX-cga.h>

void setup(void)
  {
    Serial.begin( 2000000 );
    while ( !Serial )
      delay( 100 );

  Serial.println( "IMU LSM6DSOX test!" );

  if ( !IMU.begin() )
    {
      Serial.println("Failed to initialize IMU!");
      while (1);
        {
          delay(1000);
        }
    }

  Serial.println( "IMU LSM6DSOX initialized!" );

  Serial.print("Accelerometer sample rate = ");
  Serial.print(IMU.accelerationSampleRate());
  Serial.println("Hz");
  Serial.println();

  Serial.print("Gyroscope sample rate = ");  
  Serial.print(IMU.gyroscopeSampleRate());
  Serial.println("Hz");
  Serial.println();
}

void loop()
{
  int ax, ay, az;
  int gx, gy, gz;
	
  while( !IMU.accelerationAvailable() )
    delay( 10 );

  IMU.readAcceleration( ax, ay, az );

  while( !IMU.gyroscopeAvailable() )
    delay( 10 );

  IMU.readGyroscope( gx, gy, gz );

  /* Print out the values */
  Serial.print("Acceleration X: ");
  Serial.print(ax);
  Serial.print(", Y: ");
  Serial.print(ay);
  Serial.print(", Z: ");
  Serial.print(az);
  Serial.println(" m/s^2");

  Serial.print("Rotation X: ");
  Serial.print(gx);
  Serial.print(", Y: ");
  Serial.print(gy);
  Serial.print(", Z: ");
  Serial.print(gz);
  Serial.println(" rad/s");

  if (IMU.temperatureAvailable())
    {
      int temperature_deg = 0;
      IMU.readTemperature(temperature_deg);

      Serial.print("Temperature = ");
      Serial.print(temperature_deg);
      Serial.println(" °C");
    }

  Serial.println("");
  delay( 1000 );
}
