#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>

#define BUF_SIZ 10000

FILE *stream;
FILE *stream2;

int find_word( char *s )
{
  char buffer[ BUF_SIZ + 1 ];
  
  // printf( "Looking for %s\n", s );

  for( ; ; )
    {
      if ( fscanf( stream, "%s", buffer ) < 1 )
	{
	  // printf( "No more input\n" );
	  return 0;
	}
      int value = strcmp( s, buffer );
      // printf( "Comparing %s %s %d\n", s, buffer, value );
      if ( value == 0 )
	return 1;
    }
}

int main( int argc, char *argv[] )
{
  float frequency;
  char buffer[ BUFSIZ + 1 ];
  char log_filename[ BUF_SIZ + 1 ];
  char files_txt_filename[ BUF_SIZ + 1 ];
  char data_filename[ BUF_SIZ + 1 ];
  float voltage;
  int voltage_raw;
  float angle_gain, angle_integral_gain, angle_velocity_gain;
    
  if ( argc != 2 )
    {
      fprintf( stderr, "Need a log file argument\n" );
      fprintf( stderr, "For run10.log, on linux type:\n" );
      fprintf( stderr, "%s run10\n", argv[0] );
      exit( -1 );
    }

  // Open the log file, and quit if this fails.
  sprintf( log_filename, "%s.log", argv[1] );
  stream = fopen( log_filename, "r" );
  if ( stream == NULL )
    {
      fprintf( stderr, "Couldn't open the log file %s\n", log_filename );
      exit( -1 );
    }

  // Create the data directory
  sprintf( buffer, "mkdir -p %s\n", argv[1] );
  system( buffer );

  sprintf( files_txt_filename, "%s/files.txt", argv[1] );
  stream2 = fopen( files_txt_filename, "w" );
  if ( stream2 == NULL )
    {
      fprintf( stderr, "Couldn't open the file %s for write.\n",
	       files_txt_filename );
      exit( -1 );
    }

  for ( int count; ; count++ )
    {
      /* Name files based on frequency, only use for sinusoids
      if ( !find_word( "Frequency:" ) )
	break;
      fscanf( stream, "%g", &frequency );
      int f1 = (int) frequency + 0.1; // fix 0.x -> 0.(x-1) error
      int f2 = 10*(frequency - f1) + 0.01; // fix 0.x -> 0.(x-1) error
      sprintf( data_filename, "%s/f%02dx%d", argv[1], f1, f2 );
      printf( "Writing %s\n", data_filename );
      */

      // Name files in order of collection
      sprintf( data_filename, "%s/f%03d", argv[1], count );
      printf( "Writing %s\n", data_filename );

      if ( !find_word( "voltage" ) )
	break;
      fscanf( stream, "%g%d", &voltage, &voltage_raw );
      printf( "Voltage %g %d\n", voltage, voltage_raw );

      // servo2
      if ( !find_word( "Gains" ) )
	break;
      fscanf( stream, "%g%g%g", &angle_gain, &angle_integral_gain,
	      &angle_velocity_gain );
      printf( "Gains %g %g %g\n", angle_gain, angle_integral_gain,
	      angle_velocity_gain );

      if ( !find_word( "Data" ) )
	break;

      fprintf( stream2, "../%s %g %d %g %g %g ",
	       data_filename, voltage, voltage_raw,
	       angle_gain, angle_integral_gain, angle_velocity_gain );

      FILE *stream3 = fopen( data_filename, "w" );
      if ( stream3 == NULL )
	{
	  fprintf( stderr, "Couldn't open data file %s for write.\n",
		   data_filename );
	  exit( -1 );
	}
      size_t buf_siz = 0;
      char *p_buffer = NULL;
      ssize_t chars_read;
      chars_read = getline( &p_buffer, &buf_siz, stream );
      /*
      printf("getline returned %ld\n", chars_read);
      if (chars_read < 0)
	{
	  puts("couldn't read the input");
	  free( p_buffer );
	  exit( -1 );
	}
      printf("<%s> is length %ld\n", p_buffer, strlen(p_buffer));
      */
      int i;
      for( i = 1; ; i++ )
	{
	  buf_siz = 0;
	  p_buffer = NULL;
	  long microseconds;

	  chars_read = getline( &p_buffer, &buf_siz, stream );
	  /*
	  printf("getline returned %ld\n", chars_read);
	   if (chars_read < 0)
	     {
	       puts("couldn't read the input");
	       free( p_buffer );
	       exit( -1 );
	     }
	  printf("<%s> is length %ld\n", p_buffer, strlen(p_buffer));
	  */
	  int n_read = sscanf( p_buffer, "%ld", &microseconds );
	  if ( n_read != 1 )
	    {
	      printf( "Quitting on %s", p_buffer );
	      free( p_buffer );
	      break;
	    }
	  fprintf( stream3, "%s", p_buffer );
	  free( p_buffer );
	}
      printf( "%d points read.\n", i );
      fprintf( stream2, "%d\n", i );
      fclose( stream3 );
    }
  fclose( stream );
  fclose( stream2 );
}
