function new_data = regress_left( data, filter_cutoff )
% build AA and BB matrics

global AA;
global BB;
global n_points;

Ts = 0.002;

% number of points in data
N = length(data);

% get position in radians
% use mean of data for zero, ignoring beginning of data
pos = pi*(data(:,2) - mean(data(round(0.5*N):N,2)))/780;
%pos = pi*(data(:,2) - 780)/780;

% estimate velocity
v(N) = 0; % allocate velocity array
for ( i = 3:N )
  v(i-1) = (pos(i) - pos(i-2))/(2*Ts);
end
v(1) = v(2); % take care of ends
v(N) = v(N-1);

[b_filter a_filter] = butter( 1, filter_cutoff );
v_filtered = filtfilt( b_filter, a_filter, v );

% pull out command array
commands = data(:,4);

weight = N;
%weight = sqrt( N );
%weight = 1;

for i = 3:(N-2)
  n_points = n_points + 1;
  AA( n_points, 1 ) = weight*v_filtered(i);
  AA( n_points, 2 ) = weight*commands(i-1);
  AA( n_points, 3 ) = weight*commands(i);
  AA( n_points, 4 ) = weight*sign(v_filtered(i));
  AA( n_points, 5 ) = weight;
  BB( n_points, 1 ) = weight*(pos(i+1) - pos(i));
  BB( n_points, 2 ) = weight*v_filtered(i+1);
end

new_data = data;

[nr nc] = size(data);

new_data(:,nc+1) = pos;
new_data(:,nc+2) = v_filtered;
