#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>

#define MAX_N_CHARS 1000

int main( int argc, char *argv[] )
{
  int i;
  char buffer[ MAX_N_CHARS + 1 ];
  char buffer2[ MAX_N_CHARS + 1 ];
  char filename_in[ MAX_N_CHARS + 1 ];
  char filename_out[ MAX_N_CHARS + 1 ];
  float voltage;
  float raw_voltage;
  float pos_gain, vel_gain, int_gain;
  float n_points;

  if ( argc != 2 )
    {
      fprintf( stderr, "Need a data directory argument: %s run33\n", argv[0] );
      exit( -1 );
    }

  sprintf( filename_in, "%s/files.txt", argv[1] );
  FILE *stream_in = fopen( filename_in, "r" );
  if ( stream_in == NULL )
    {
      fprintf( stderr, "Can't open %s for read.\n", filename_in );
      exit( -1 );
    }

  sprintf( filename_out, "%s.m", argv[1] );
  FILE *stream_out = fopen( filename_out, "w" );
  if ( stream_out == NULL )
    {
      fprintf( stderr, "Can't open %s for write.\n", filename_out );
      exit( -1 );
    }
  
  fprintf( stream_out, "global AA;\n" );
  fprintf( stream_out, "global BB;\n" );
  fprintf( stream_out, "global n_points;\n" );
  fprintf( stream_out, "n_points = 0;\n" );
  fprintf( stream_out, "AA( 1, 5 ) = 0;\n" );
  fprintf( stream_out, "BB( 1, 2 ) = 0;\n" );
  for( int i = 1; ; i++ )
    {
      // ../servo2/f000 8.31 1009 60 0 0 1008
      if ( fscanf( stream_in, "%s%g%g%g%g%g%g", buffer, &voltage,
		  &raw_voltage, &pos_gain, &int_gain, &vel_gain,
		  &n_points ) < 7 )
	break;
      fprintf( stream_out, "load %s\n", buffer );
      char *p = strchr( buffer, '/' );
      if ( p != NULL )
	{
	  p = strchr( p+1, '/' );
	  if ( p == NULL )
	    {
	      fprintf( stderr, "Can't find second / in %s\n", buffer );
	      fprintf( stderr, "Filenames should be something like ../run/f00x1\n" );
	      exit( -1 );
	    }
	}
      else
	{
	  p = strchr( buffer, '\\' );
	  if ( p == NULL )
	    {
	      fprintf( stderr, "Can't find slashes / or \\ in %s\n", buffer );
	      fprintf( stderr, "Filenames should be something like ../run/f00x1\n" );
	      exit( -1 );
	    }
	  p = strchr( p+1, '\\' );
	  if ( p == NULL )
	    {
	      fprintf( stderr, "Can't find second \\ in %s\n", buffer );
	      fprintf( stderr, "Filenames should be something like ../run/f00x1\n" );
	      exit( -1 );
	    }
	}
      sprintf( buffer2, "f%s", p+1 );
      fprintf( stream_out, "%s = regress_left( %s, 0.2 );\n",
	       buffer2, p+1 );
    }
  if ( i == 1 )
    {
      fprintf( stderr,
	       "Hmmm, there was something wrong with the input file %s\n",
	       filename_in );
      exit( -1 );
    }
  fprintf( stream_out, "format long;\n" );
  fprintf( stream_out, "CC = AA\\BB\n" );
  fprintf( stream_out, "  A = [ 1 CC(1,1) CC(2,1)\n" );
  fprintf( stream_out, "        0 CC(1,2) CC(2,2)\n" );
  fprintf( stream_out, "	   0 0       0 ]\n" );
  fprintf( stream_out, "  B = [ CC(3,1)\n" );
  fprintf( stream_out, "        CC(3,2)\n" );
  fprintf( stream_out, "        1 ]\n" );
  fprintf( stream_out, "  C = [ 1 0 0 ];\n" );
  fprintf( stream_out, "  D = [ 0 ];\n" );

  fclose( stream_in );
  fclose( stream_out );

  printf( "Wrote commands to %s\n", filename_out );
}
