#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>

#define MAX_N_CHARS 1000

FILE *stream;
FILE *stream2;

int find_word( char *s )
{
  char buffer[ MAX_N_CHARS + 1 ];
  
  // printf( "Looking for %s\n", s );

  for( ; ; )
    {
      if ( fscanf( stream, "%s", buffer ) < 1 )
	{
	  // printf( "No more input\n" );
	  return 0;
	}
      int value = strcmp( s, buffer );
      // printf( "Comparing %s %s %d\n", s, buffer, value );
      if ( value == 0 )
	return 1;
    }
}

int main( int argc, char *argv[] )
{
  float frequency;
  char buffer[ MAX_N_CHARS + 1 ];
  long numbers[5];
  char log_filename[ MAX_N_CHARS + 1 ];
  char files_txt_filename[ MAX_N_CHARS + 1 ];
  char data_filename[ MAX_N_CHARS + 1 ];
  char *line = NULL;
  size_t len = 0;
  ssize_t read;
  int ignore;
  float voltage;
  int voltage_raw;
    
  if ( argc != 2 )
    {
      fprintf( stderr, "Need a log file argument\n" );
      fprintf( stderr, "For run10.log, on linux type:\n" );
      fprintf( stderr, "%s run10\n", argv[0] );
      exit( -1 );
    }

  // Open the log file, and quit if this fails.
  sprintf( log_filename, "%s.log", argv[1] );
  stream = fopen( log_filename, "r" );
  if ( stream == NULL )
    {
      fprintf( stderr, "Couldn't open the log file %s\n", log_filename );
      exit( -1 );
    }

  // Create the data directory
  sprintf( buffer, "mkdir -p %s\n", argv[1] );
  system( buffer );

  sprintf( files_txt_filename, "%s/files.txt", argv[1] );
  stream2 = fopen( files_txt_filename, "w" );
  if ( stream2 == NULL )
    {
      fprintf( stderr, "Couldn't open the file %s for write.\n",
	       files_txt_filename );
      exit( -1 );
    }

  for (;;)
    {
      if ( !find_word( "Frequency:" ) )
	break;
      fscanf( stream, "%g", &frequency );
      int f1 = (int) frequency + 0.1; // fix 0.x -> 0.(x-1) error
      int f2 = 10*(frequency - f1) + 0.01; // fix 0.x -> 0.(x-1) error
      sprintf( data_filename, "%s/f%02dx%d", argv[1], f1, f2 );
      printf( "Writing %s\n", data_filename );

      if ( !find_word( "voltage" ) )
	break;
      fscanf( stream, "%g%d", &voltage, &voltage_raw );
      printf( "Voltage %g %d\n", voltage, voltage_raw );

      // try to get where the data starts
      for( int j = 0; ; j++ )
	{

	  char *ps = fgets( buffer, MAX_N_CHARS, stream );
	  if ( ps == NULL )
	    {
	      printf( "Read error or EOF\n" );
	      exit( 0 );
	    }
	  int n_read = sscanf( buffer, "%d%d%d%d",
				    &ignore, &ignore, &ignore, &ignore );
	  if ( n_read == 4 )
	    {
	      printf( "Got line: %s", buffer );
	      break; // the line in buffer is thrown away.
	    }
	  /*
	  else
            printf( "%d %s", j, buffer );
	  */
	}

      fprintf( stream2, "../%s %g %g %d ",
	       data_filename, frequency, voltage, voltage_raw );

      FILE *stream3 = fopen( data_filename, "w" );
      if ( stream3 == NULL )
	{
	  fprintf( stderr, "Couldn't open data file %s for write.\n",
		   data_filename );
	  exit( -1 );
	}
      int i;
      for( i = 1; ; i++ )
	{
	  // printf( "i: %d\n", i );
	  int n_read = fscanf( stream, "%ld %ld %ld %ld",
			       numbers, numbers+1, numbers+2, numbers+3 );
	  if ( n_read != 4 )
	    break;
	  fprintf( stream3, "%ld %ld %ld %ld\n", numbers[0], numbers[1],
		   numbers[2], numbers[3] );
	}
      printf( "%d points read.\n", i );
      fprintf( stream2, "%d\n", i );
      fclose( stream3 );
    }
  fclose( stream );
  fclose( stream2 );
}
