function [whdd thdd] = twip3( wh, whd, th, thd, trq, m_w, r_w, I_w, m_p, l_p, I_p, g, f )
% compute a two wheeled inverted pendulum's forward dynamics
% This version uses the wheel angle relative to the body as a state variable
% (which we measure directly), rather than the wheel angle relative to
% vertical (which is not measured directly).
% So the state vector is (wheel angle with respect to the body wh,
% wheel angular velocity with respect to the body whd,
% body angle with respect to world vertical,
% and body angular velocity with respect to world vertical).
% The wheel rolling forward is positive and should be expressed in radians,
% The wheel angular velocity should be expressed in radians/second.
% The body leaning forward is positive, and the angle should be expressed
% in radians, and the body angular velocity should be expressed in radians/s.
% Note that the arguments include the wheel position for consistency with
% convention, even though it doesn't appear in these equations
% This version is expressed in terms of unknown inertial parameters p1, p2,
% and p3 and friction parameter f (motor viscosity)

% Compute the "mass" matrix in terms of the three inertial parameters p_i:
p1 = I_w + (m_p + m_w)*r_w*r_w;
p2 = m_p*l_p;
p3 = I_p + m_p*l_p*l_p;
m12 = p1 + p2*r_w*cos(th);
M = [ p1  m12
      m12 (p1 + 2*p2*r_w*cos(th) + p3) ];

% Invert the mass matrix
Minv = inv(M);

% Set up the right hand side rhs
v_exp = p2*r_w*thd*thd*sin(th);
v = [ (-trq - f*whd + v_exp) (v_exp + p2*g*sin(th)) ];
rhs = transpose( v );

% Apply the inverse of the mass matrix
result = Minv*rhs;

% Voila!
whdd = result(1);
thdd = result(2);

end
