% Simulate a two wheeled inverted pendulum (Segway-like)
% State variables are encoders (wheel angle relative to body) and
% body angle relative to vertical
% State vector is [wheel_angle wheel_angular_velocity body_angle body_angular_velocity ]

global first_time
global r_w

if first_time
  m_w = 0.173; % kg
  m_p = 0.826-m_w; % kg
  I_w = 0.0066;
  l_p = 0.043; % m
  I_p = 0.00084;
  r_w = 0.0323; % m
  ll_p = 0.110; % m - total height of pendulum relative to wheel axis

  g = 9.81; % m/s^2
 
  Kc = [ rand() rand() rand() rand() ]
  goal = [ 0 0 0 0 ];
  samples_per_second = 333;
  duration = 6;
  x_initial = transpose( [ 0.8/r_w 0 0 0 ] );
  first_time = 0;
end

N = round(duration*samples_per_second);
dt = duration/N;

score = 0;

% initial conditions
xx = x_initial;

init_plots( xx, N, r_w, ll_p );

aa = [ 0 0 ];

% simulation
for i = 1:N
  x_array(i,:) = transpose( xx );
  zz(1) = (xx(1) + xx(3))*r_w;
  zz(2) = xx(3);
  zz(3) = (xx(2) + xx(4))*r_w;
  zz(4) = xx(4);
  z_array(i,:) = zz;

  uu = -Kc*xx;
  u_array(i,1) = uu;

  [wdd thdd] = twip3( xx(1), xx(2), xx(3), xx(4), uu, m_w, r_w, I_w, m_p, l_p, I_p, g, 0 ); % 0 is the friction
  aa = [wdd thdd];
  a_array(i,:) = transpose( aa );
  if ( i < N )
    % integrate wheel state
    vv_new = xx(2) + aa(1)*dt;
    xx(1) = xx(1) + 0.5*(vv_new + xx(2))*dt;
    xx(2) = vv_new;
    % integrate body angle state
    vv_new = xx(4) + aa(2)*dt;
    xx(3) = xx(3) + 0.5*(vv_new + xx(4))*dt;
    xx(4) = vv_new;
  end
  plot_it( xx, i, r_w, ll_p );
  if ( abs(xx(3)) > 1.5 )
    break;
  end
end

figure(2)
plot(x_array(:,1));
title( 'wheel angle' )

figure(3)
plot(x_array(:,2));
title( 'wheel angular velocity' )

figure(4)
plot(x_array(:,3));
title( 'body angle' )

figure(5)
plot(x_array(:,4));
title( 'body angular velocity' )

figure(6)
plot(u_array(:,1));
title( 'torque' )

figure(7)
plot(a_array(:,1));
title( 'wheel angular acceleration' )

figure(8)
plot(a_array(:,2));
title( 'body angular acceleration' )

figure(10)
plot(z_array(:,1));
title( 'x' )

figure(11)
plot(z_array(:,3));
title( 'x velocity' )

figure(1)

% To zoom in on a plot
% axis([0 10000 -0.01 0.01])
