% optimize 1 link swingup trajectory by optimizing global linear policy

% set globals
global first_time
global goal
global position_penalty  
global velocity_penalty
global action_penalty
global N
global dt
global mass
global gravity
global length
global moment_of_inertia_joint

if first_time
 goal = pi;
 position_penalty = 1.0;
 velocity_penalty = 1.0;
 action_penalty = 1.0;
 duration = 10;
 dt = 0.001;
 mass = 1.0;
 length = 1.0;
 gravity = 9.81;

% p0 is the intitial parameter vector
 p0 = [ 1 1 ]; % position gain, velocity gain
end

first_time = 0;

N = duration/dt;
moment_of_inertia_joint = mass*length*length;

% set options for fminunc()
% options = optimset();
options = optimset('MaxFunEvals',1000000000,'MaxIter',1000000000);

% p0 is the intitial parameter vector
p0 = [ 10 3 ]; % position gain, velocity gain

% do optimization
[answer,fval,exitflag]=fminunc(@criterion,p0,options);

answer
fval
exitflag

