% Simulate an inverted pendulum
% Down is zero

% set up globals for plotting
global first_time
global dt
global N
global goal;
global xx
global vv
global aa
global uu
global l1
global l2

if first_time
 mass = 1;
 length = 1;
 g = 9.81;
 stiffness = 10
 damping = 3.1
 goal = pi;
 duration = 5;
 dt = 0.001;
% initial state
 x0 = [0 0];
 first_time = 0;
end

N = duration/dt;
moment_of_inertia = mass*length*length;

score = 0;

% set up xx, vv, and aa arrays
xx = zeros(1,N); % position
vv = zeros(1,N); % velocity
aa = zeros(1,N); % acceleration
uu = zeros(1,N); % commands

% initial conditions
xx(1) = x0(1); % starting position
vv(1) = x0(2); % starting velocity

init_plots( x0(1), N, length, goal );

% simulation
for i = 1:N
 uu(i) = -mass*g*length*sin( xx(i) ) - stiffness*( xx(i) - goal ) - damping*( vv(i) );
 aa(i) = uu(i)/moment_of_inertia;
 if ( i < N )
  vv(i+1) = vv(i) + aa(i)*dt;
  xx(i+1) = xx(i) + 0.5*(vv(i) + vv(i+1))*dt;
  score = score + dt*((xx(i) - goal)*(xx(i) - goal) + 0.05*uu(i)*uu(i));
 else
  score = score + dt*((xx(i) - goal)*(xx(i) - goal));
 end
 plot_it( i, xx(i) );
end;

stiffness
damping
score

% To zoom in on a plot
% axis([0 10000 -0.01 0.01])
