% optimize the feedback gains to control a mass (rock)

% set globals
global first_time
global goal
global position_penalty  
global velocity_penalty
global action_penalty
global N
global dt
global mass

if first_time
 goal = 0;
 position_penalty = 1.0;
 velocity_penalty = 0.0;
 action_penalty = 1.0;
 duration = 10;
dt = 0.001;
 mass = 1.0;
% p0 is the intitial parameter vector
 p0 = [ 1 1 ]; % position gain, velocity gain
end

first_time = 0;

N = duration/dt;

% set options for fminunc()
% options = optimset();
% To increase the amount of maximum search:
options = optimset('MaxFunEvals',100000,'MaxIter',100000);

% do optimization
[answer,fval,exitflag]=fminunc(@criterion,p0,options);

answer
fval
exitflag

natural_frequency = sqrt(answer(1))
damping_ratio = answer(2)/(2*sqrt(answer(1)))
  
