function score=eval_traj(x0,p,color)
%%% criterion for optimizing global linear policy

% set globals
global goal
global position_penalty  
global velocity_penalty
global action_penalty
global N
global dt
global mass
  
score = 0;

% set up xx, vv, and aa arrays
xx = zeros(1,N); % position
vv = zeros(1,N); % velocity
aa = zeros(1,N); % acceleration
uu = zeros(1,N); % commands

% initial conditions
xx(1) = x0(1); % starting position
vv(1) = x0(2); % starting velocity

for i = 1:N-1
 uu(i) = -p(1)*(xx(i) - goal) - p(2)*vv(i);
 aa(i) = uu(i)/mass;
 vv(i+1) = vv(i) + aa(i)*dt;
 xx(i+1) = xx(i) + 0.5*(vv(i) + vv(i+1))*dt;
end;

plot(1:N,xx,color,"LineWidth",2)
drawnow;

% Compute state penalties
for i=1:N
 score = score + position_penalty*(xx(i)-goal)*(xx(i)-goal)*dt;
 score = score + velocity_penalty*vv(i)*vv(i)*dt;
end
% Compute action penalties
for i=1:N-1
 score = score + action_penalty*uu(i)*uu(i)*dt;
end

% Final end
end
