function score=criterion(p)
%%% criterion for optimizing global linear policy
% Optimize several trajectories with different initial conditions

% check for bad parameters
% return bad score for bad parameters
score = 1e10;

if p(1) < 0
 return;
end

if p(2) < 0
 return;
end

% parameters okay, get ready to sum real scores
score = 0;

%***** Test movement 1 *****

score = score + eval_traj( [ 0 0 ], p, 'g' );

hold on

%***** Test movement 2 *****

score = score + eval_traj( [ 1 0 ], p, 'r' );

%***** Test movement 3 *****

score = score + eval_traj( [ -1 0 ], p, 'm' );

%***** Test movement 4 *****

score = score + eval_traj( [ 0 2 ], p, 'k' );

%***** Test movement 5 *****

score = score + eval_traj( [ 0 -2 ], p, 'b' );

%*****************************************************

drawnow

% end hold
hold off

[ p(1) p(2) score ]

% final end
end
