% simulate a spring-mass-damper system
% show numerical integration, effect of gains.

% set up globals
% This variable allows us to initialize variables just once.
global first_time

% set these variable just on the first run, 
% so we can change them manually later.
if first_time
 mass = 1;
 stiffness = 10
 damping = 2*sqrt(stiffness*mass) % critical damping
 goal = 0;
 dt = 0.001;
 duration = 10;
 % vary the initial state to see the independence of trajectory shape
 % with respect to initial position
 x0 = [1 0];
 first_time = 0;
end

N = duration/dt;

% set up xx, vv, and aa arrays
xx = zeros(1,N); % position
vv = zeros(1,N); % velocity
aa = zeros(1,N); % acceleration
uu = zeros(1,N); % commands

% initial conditions
xx(1) = x0(1); % starting position
vv(1) = x0(2); % starting velocity

% simulation
for i = 1:N-1
 uu(i) = -stiffness*(xx(i) - goal) - damping*vv(i);
 aa(i) = uu(i)/mass;
 vv(i+1) = vv(i) + aa(i)*dt;
 xx(i+1) = xx(i) + 0.5*(vv(i) + vv(i+1))*dt;
end;

plot(1:N,xx)

% To zoom in on a plot
% axis([0 10000 -0.01 0.01])
