/************************************************************************/
/*
Call SNOPT
 */
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "f2c.h"
#include "snopt.h"
#include "snfilewrapper.h"

/************************************************************************/

#define MAX_N_X 1000 // max number of parameters
#define MAX_N_F 1000 // max number of constraints + 1 (for objective)

// size of work spaces
#define MAX_INTS  1000000
#define MAX_REALS 1000000
#define MAX_CHARS 500

// number of derivatives
#define LEN_A 1000
#define LEN_G 1000

// useful number
#define BUFF_SIZE 1000

/************************************************************************/

int usrfunf_();

/************************************************************************/
// avoid blowing up the stack?

  // memory resources
integer    leniw = MAX_INTS, lenrw = MAX_REALS, lencw = MAX_CHARS;
integer    iw[MAX_INTS];
doublereal rw[MAX_REALS];
char       cw[8*MAX_CHARS];

/************************************************************************/
// call the optimizer

void do_snopt()
{
  int i;

  // snopenappend (open a file)
  char       printname[BUFF_SIZE];
  integer    iPrint = 9,  prnt_len;
  // return status
  integer    INFO;

  // snInit arguments
  integer    iSumm  = 6;
  
  /* snInit:
On exit:
Some elements of cw, iw, rw are given values to indicate that most
optional parameters are undefined.
  */

  // usrfun_init results
  // name of problem for printing
  char       Prob[BUFF_SIZE];
  // nF: number of constraints + 1 (for objective function)
  integer neF;
  // n: dimensionality of X
  integer n;
  // something added to the objective for pretty printing
  doublereal ObjAdd = 0.0e0;
  // which row of F is the objective function
  integer ObjRow = 1;
  // bounds on x
  double xlow[MAX_N_X], xupp[MAX_N_X];
  // bounds of objectives and constraints
  double Flow[MAX_N_F], Fupp[MAX_N_F];
  // initial parameters to be optimized
  double x[MAX_N_X]; 
  // initial states for each variable 4:xlow, 5:xupp
  integer xstate[MAX_N_X];
  // something to do with Lagrange multipliers on input
  // Lagrange multipliers on output
  double Fmul[MAX_N_F];

  // snOptA arguments

  // Start:
  integer Cold = 0, Basis = 1, Warm = 2;
  // don't use names
  integer nxname = 1;
  integer nFname = 1;

  // coordinates (i,j) and values Aij
  integer    lenA = LEN_A, iAfun[LEN_A], jAvar[LEN_A];
  doublereal A[LEN_A];
  // coordinates (i,j) and derivatives Gij
  integer    lenG = LEN_G, iGfun[LEN_G], jGvar[LEN_G];
  integer    neA, neG;

  char xnames[1*8];
  char Fnames[1*8];

  // snOpta output

  // dual variables
  doublereal xmul[MAX_N_X];
  // object and constraint values
  doublereal F[MAX_N_F]; 
  // number of superbasic variables
  integer    nS;
  // number of violated constraints
  integer nInf;
  // sum of violated constraints
  doublereal sInf;
  

  // snOpta ???
  integer    Fstate[MAX_N_F];
  integer    minrw, miniw, mincw;


  integer npname;

  // snClose
  integer    iSpecs = 4;

  // not used
  integer  spec_len;
  char       specname[BUFF_SIZE];

  integer    DerOpt, Major, iSum, iPrt, strOpt_len;
  char       strOpt[BUFF_SIZE];

  printf("\nSolving usrfun without first derivatives ...\n");

  /* open output files using snfilewrappers.[ch] */
  sprintf(specname ,   "%s", "snopt.spc");   spec_len = strlen(specname);
  sprintf(printname,   "%s", "snopt.out");   prnt_len = strlen(printname);

  printf( "calling snopenappend_\n" );

  /* Open the print file, fortran style */
  snopenappend_
    ( &iPrint, printname,   &INFO, prnt_len );

  /*     ================================================================== */
  /*     First,  sninit_ MUST be called to initialize optional parameters   */
  /*     to their default values.                                           */
  /*     ================================================================== */

  printf( "calling sninit_\n" );

  sninit_
    ( &iPrint, &iSumm, cw, &lencw, iw, &leniw, rw, &lenrw, 8*MAX_CHARS );

  /*     Set up the problem to be solved.                       */
  /*     No derivatives are set in this case.                   */
  /*     NOTE: To mesh with Fortran style coding,               */
  /*           it ObjRow must be treated as if array F          */
  /*           started at 1, not 0.  Hence, if F(0) = objective */
  /*           then ObjRow should be set to 1.                  */

  /* Read in specs file (optional) */
  /* snfilewrapper_ will open the specs file, fortran style, */
  /* then call snspec_ to read in specs.                        */

  snfilewrapper_
    ( specname, &iSpecs, &INFO, cw, &lencw,
      iw, &leniw, rw, &lenrw, spec_len, 8*lencw);

  if( INFO == 101 )
    {
      printf("read specs file %s \n", specname);
    }
  else
    {
      printf("Warning: trouble reading specs file %s \n", specname);
    }

  printf( "calling usrfun_init\n" );

  usrfun_init
    ( &INFO, Prob, &neF, &n, &ObjAdd, &ObjRow, xlow, xupp,
      Flow, Fupp, x, xstate, Fmul );
  npname = strlen(Prob);

  /*     SnoptA will compute the Jacobian by finite-differences.   */
  /*     The user has the option of calling  snJac  to define the  */
  /*     coordinate arrays (iAfun,jAvar,A) and (iGfun, jGvar).     */

  printf( "calling snjac_\n" );

  snjac_
    ( &INFO, &neF, &n, usrfunf_,
      iAfun, jAvar, &lenA, &neA, A,
      iGfun, jGvar, &lenG, &neG,
      x, xlow, xupp, &mincw, &miniw, &minrw,
      cw, &lencw, iw, &leniw, rw, &lenrw,
      cw, &lencw, iw, &leniw, rw, &lenrw,
      8*500, 8*500 );

  /*
  printf( "lenA: %d, neA: %d\n", (int) lenA, (int) neA );
  for( i = 0; i < neA; i++ )
    printf( "%d: %d %d %g\n", i, (int) (iAfun[i]), (int) (jAvar[i]), A[i] );
  printf( "lenG: %d, neG: %d\n", (int) lenG, (int) neG );
  for( i = 0; i < neG; i++ )
    printf( "%d: %d %d\n", i, (int) (iGfun[i]), (int) (jGvar[i]) );
  */

  /*     ------------------------------------------------------------------ */
  /*     Warn SnoptA that userf does not compute derivatives.               */
  /*     The parameters iPrt and iSum may refer to the Print and Summary    */
  /*     file respectively.  Setting them to 0 suppresses printing.         */
  /*     ------------------------------------------------------------------ */

  DerOpt = 0;
  iPrt   = 0;
  iSum   = 0;
  sprintf(strOpt,"%s","Derivative option");
  strOpt_len = strlen(strOpt);
  snseti_
    ( strOpt, &DerOpt, &iPrt, &iSum, &INFO,
      cw, &lencw, iw, &leniw, rw, &lenrw, strOpt_len, 8*500 );

  /*
If the gradients are expensive to compute, specify Nonderivative linesearch and
use the value of the input parameter needG to avoid computing them on certain entries.
(There is no need to compute gradients if needG = 0 on entry to usrfun.)
*/

     /*
If not all gradients are known, you must specify Derivative option 0. You should
still compute as many gradients as you can. (It often happens that some of them are
constant or even zero.)
     */

  /*     ------------------------------------------------------------------ */
  /*     Go for it, using a Cold start.                                     */
  /*     ------------------------------------------------------------------ */

  snopta_
    ( &Cold, &neF, &n, &nxname, &nFname,
      &ObjAdd, &ObjRow, Prob, usrfunf_,
      iAfun, jAvar, &lenA, &neA, A,
      iGfun, jGvar, &lenG, &neG,
      xlow, xupp, xnames, Flow, Fupp, Fnames,
      x, xstate, xmul, F, Fstate, Fmul,
      &INFO, &mincw, &miniw, &minrw,
      &nS, &nInf, &sInf,
      cw, &lencw, iw, &leniw, rw, &lenrw,
      cw, &lencw, iw, &leniw, rw, &lenrw,
      npname, 8*nxname, 8*nFname,
      8*500, 8*500);

  snclose_( &iPrint );
  // snclose_( &iSpecs ); // not using specs file
}

/************************************************************************/
