#ifndef _LIBMEKFILTER2_
#define _LIBMEKFILTER2_

#ifdef __cplusplus

#include "kalman/ekfilter.hpp"

class LibmEKFilter2 : public Kalman::EKFilter<double,1,false,false,false>{
public:
        LibmEKFilter2();
		double xest[18];
		int initialized;
		int enabled;

protected:

        void makeBaseA();
        void makeBaseH();
        void makeBaseV();
        void makeBaseR();
        void makeBaseW();
        void makeBaseQ();
        
        void makeA();
        void makeH();
        void makeQ();
        void makeProcess();
        void makeMeasure();

        double Period, Mass, Gravity, Height;
};

#else
typedef struct LibmEKFilter2 LibmEKFilter2;
#endif

void LibmEKFilter2_init(LibmEKFilter2 *p, double *x0, double *P0);
void LibmEKFilter2_step(LibmEKFilter2 *p, double *input, double *meas, double *est);

#endif