#ifndef SERVER_MPC_H
#define SERVER_MPC_H

#ifdef MATLAB
#include "mex.h"
#endif

#include "mpc_solver.h"
#include "mpc_model.h"
#include "basic_server.h"
#include "config_file.h"
#include <Windows.h>

#include <Eigen/Core>
#include <Eigen/Cholesky>
using namespace Eigen;

template<class MODEL>
class MPC_Server: public Basic_Server{

public:

	MPC_Server();
	~MPC_Server();

	void set_params(ConfigurationData *cd);
	void set_params(char *cdfile);

	int set_input(mpcInput*);
	int precompute();
	//
	//int Send();
	//int Send(double t0, VectorXd &x0); // starts an optimization in another thread
	//int Receive(); // 

	//double total_cost(){ return solver->total_cost(); };
	void print_output_trajectory(bool run_sim){ solver->print_output_trajectory(run_sim); };

	//MPC_Solver<MODEL> * GetSolver(){	return solver;	};

	//mpcOutput get_output(){ return output; };
	
private:

	void Evaluate();
	void Send(void *ptr);
	void Receive(void *ptr);

	//mpcInput input;
	mpcOutput output;
	
	//void MPC_Server_Thread(void *ptr); // thread function for solving the MPC
		
	MPC_Solver<MODEL> *solver;
	MPC_Solver<MODEL> the_real_solver;

};


template<class MODEL>
MPC_Server<MODEL>::MPC_Server(void){
	solver = &the_real_solver;	
}

template<class MODEL>
MPC_Server<MODEL>::~MPC_Server(void){
	// close thread
}

template<class MODEL>
void MPC_Server<MODEL>::set_params(ConfigurationData *cd){
	solver->set_params(cd);
}

template<class MODEL>
void MPC_Server<MODEL>::set_params(char *cdfile){
	ConfigurationData *cd = load_conf_data(cdfile);
	solver->set_params(cd);
	free_conf_data(cd);
}

template<class MODEL>
int MPC_Server<MODEL>::set_input(mpcInput *in){
	// make sure the thread isn't already busy
	//if(WaitForSingleObject(hWaitingEvent,0) != WAIT_OBJECT_0)	return 0;
	solver->set_input(in);
	return 1;
}

template<class MODEL>
int MPC_Server<MODEL>::precompute(){
	// make sure the thread isn't already busy
	//if(WaitForSingleObject(hWaitingEvent,0) != WAIT_OBJECT_0)	return 0;
	solver->precompute();
	return 1;
}

template<class MODEL>
void MPC_Server<MODEL>::Send(void *ptr){
	mpcInput*in = (mpcInput*)ptr;
	
	solver->set_input(in);	

}

template<class MODEL>
void MPC_Server<MODEL>::Receive(void *ptr){
	mpcOutput*out = (mpcOutput*)ptr;

	// return the output
	*out = output;

	//printf("Cost = %f\n",output.cost);

}

template<class MODEL>
void MPC_Server<MODEL>::Evaluate(){
	printf("Solving\n");
	solver->solve();
	printf("Solved\n");
	output = solver->get_output();
}


#endif