#include "mpc_model.h"
#include <iostream>
#include <Eigen/Core>
using namespace Eigen;

void mpcModel::init(){

	precomputed_dynamics = false;
	precomputed_cost = false;
	precomputed_constraints = false;

	is_nonlinear = true;
	is_constant_hessian = false;

	is_input_set = false;

	is_initialized = true;

	is_unconstrained = false;

	is_params_set = false;
}

void mpcModel::mpc_allocate(){

	assert(is_params_set);

	X.setZero((N_TIMESTEPS+1)*num_states);
	U.setZero(num_vars());
	Y.setZero((N_TIMESTEPS+1)*num_outputs);

	A.setZero((N_TIMESTEPS+1)*num_states,num_states);
	B.setZero((N_TIMESTEPS+1)*num_states,num_vars());
	C.setZero((N_TIMESTEPS+1)*num_outputs,num_states);
	D.setZero((N_TIMESTEPS+1)*num_outputs,num_vars());

	T.setZero(N_TIMESTEPS+1);

	H.setZero(num_vars(),num_vars());
	f.setZero(num_vars());

	PreLuu.setZero(num_vars(),num_vars());
	PreLux.setZero(num_vars(),num_states);
	PreLxx.setZero(num_states,num_states);
	PreLu.setZero(num_vars());
	PreLx.setZero(num_states);
	PreL0 = 0;

	Luu.setZero(num_vars(),num_vars());
	Lux.setZero(num_vars(),num_states);
	Lxx.setZero(num_states,num_states);
	Lu.setZero(num_vars());
	Lx.setZero(num_states);
	L0 = 0;

	CE.setZero(num_vars(),num_equality_constraints);
	if(num_equality_constraints>0)		ce0.setZero(num_equality_constraints);

	CI.setZero(num_vars(),num_inequality_constraints);
	if(num_inequality_constraints>0){
		ci0.setZero(num_inequality_constraints);
		ci1.setZero(num_inequality_constraints);
	}

	output.T.setZero(N_TIMESTEPS+1);
	output.X.setZero((N_TIMESTEPS+1)*num_states);
	output.Y.setZero((N_TIMESTEPS+1)*num_outputs);
	output.U.setZero(num_vars());
	output.cost = 0;

	//input->x0.setZero(num_states);
		
	printf("MPC Allocated\n");

}

mpcOutput mpcModel::get_output(){ 
		simulate();
		output.T = T; 
		output.X = X; 
		output.Y = Y; 
		output.U = U; 
		output.cost = total_cost(); 
		return output; 
};

VectorXd mpcModel::output_trajectory(double t0, VectorXd &x0, VectorXd &U){
	assert(precomputed_dynamics);
	assert(is_input_set);
	return C*x0+D*U;
}

VectorXd mpcModel::output_trajectory(void){
	assert(precomputed_dynamics);
	assert(is_input_set);
	return C*input.x0+D*U;
}

void mpcModel::precompute_dynamics(void){
	assert(is_params_set);
	assert(is_input_set);	// doesn't necessarily need this, but I will leave it for now
	precompute_dynamics(input.t0,input.x0); 
}

void mpcModel::precompute_cost(void){
	assert(precomputed_dynamics);
	assert(is_input_set);	// doesn't necessarily need this, but I will leave it for now
	precompute_cost(input.t0,input.x0);
}

void mpcModel::precompute_constraints(void){
	assert(precomputed_dynamics);
	assert(is_input_set);
	precompute_constraints(input.t0,input.x0);
}

void mpcModel::update_cost(void){
	assert(precomputed_cost);
	assert(is_input_set);
	update_cost(input.t0,input.x0);
}

void mpcModel::update_constraints(void){
	assert(precomputed_constraints);
	assert(is_input_set);
	update_constraints(input.t0,input.x0);
}

VectorXd mpcModel::simulate(void){
	assert(precomputed_dynamics);
	assert(is_input_set);
	return simulate(input.t0,input.x0,U);
}

double mpcModel::total_cost(double t0, VectorXd &x0, VectorXd &U){
	assert(precomputed_cost);
	assert(is_input_set);
	VectorXd cost(U.transpose()*(Luu*U + Lux*x0 + Lu) + x0.transpose()*(Lxx*x0 + Lx));
	return cost(0) + L0;
}

double mpcModel::output_cost(double t0, VectorXd &x0, VectorXd &U){
	//assert(precomputed_cost);
	//assert(is_input_set);
	//VectorXd cost(U.transpose()*(H2*U + f2*x0) + x0.transpose()*V20*x0);
	//return cost(0);
	return 0;
}

double mpcModel::total_cost(void){
	return total_cost(input.t0,input.x0,U);
}

double mpcModel::output_cost(void){
	return output_cost(input.t0,input.x0,U);
}