//#include "lipmstep2d_multi.h"
#include <iostream>
#include "mpc_server.h"
#include "config_file.h"
#include "lipmstep2d_FEL_model.h"

#include <Eigen\Core>
using namespace Eigen;

void main(){
	int i,j,k;
	int N_TIMESTEPS;
	ConfigurationData *cd = load_conf_data("lipmstep2d_FEL_model.cf");
	ConfigurationData *cd1 = load_conf_data("lipmstep2d_FEL_model_init.cf");
	//lipmStep2dModel_FEL server("lipmstep2d_FEL_model.cf");
	MPC_Server<lipmStep2dModel_FEL> left;
	MPC_Server<lipmStep2dModel_FEL> right;
	MPC_Server<lipmStep2dModel_FEL> *server;

	int FIRST_FOOT = get_value_with_default(cd,"FIRST_FOOT",0);

	set_value(cd,"FIRST_FOOT",0);
	left.set_params(cd);
	set_value(cd,"FIRST_FOOT",1);
	right.set_params(cd);

	mpcInput input;
	mpcOutput output;

	N_TIMESTEPS = get_value_with_default(cd,"N_TIMESTEP",20);
	int N_SHIFT = get_value_with_default(cd,"N_SHIFT",4);
	int N_SWING = get_value_with_default(cd,"N_SWING",8);

	int N_PHASE = (N_SHIFT + N_SWING);

	float *xf = get_conf_row(cd1,"INITIAL_STATE");
	int N_CYCLES = get_value_with_default(cd1,"N_CYCLES",1);
	
	VectorXd x0(10);
	
	for(i=0;i<10;i++){
		x0(i) = (double)xf[i];
	}


	//x0 << 0.0,0.0,0,0,0,
	//	  0.0,0.0,0,0.1,-0.1;
	int USE_FEEDBACK_ERROR_TRAJECTORY = get_value_with_default(cd,"USE_FEEDBACK_ERROR_TRAJECTORY",0);
	
	if(USE_FEEDBACK_ERROR_TRAJECTORY){
		x0.conservativeResize(10+2*N_TIMESTEPS);

		for(i=0;i<N_TIMESTEPS;i++){
			x0(10+2*i+0) = 0.0;
			x0(10+2*i+1) = 0.2;
			//x0(10+2*i+1) = 0.4*cos(2*3.14159*i/N_PHASE);
		}
	}
	FILE *fp = fopen("output","w");

	double t0 = 0;
	input = mpcInput(t0,x0);

	for(k=0;k<N_CYCLES;k++){
		
		if((FIRST_FOOT+k)%2==0)	server = &left;
		else					server = &right;
		//count = 0;
		server->Start(&input);
		while(!server->Finish(&output)){
			Sleep(1);
		//	count++;
		}
		//printf("count = %i\n",count);

		server->print_output_trajectory(true);

		for(i=0;i<N_PHASE;i++){
			fprintf(fp,"%f ",t0 + output.T(i));
			for(j=0;j<12;j++){
				fprintf(fp,"% f ",output.Y(i*12+j));
			}
			fprintf(fp,"\n");
		}
		 
		printf("x0 = ");
		for(i=0;i<10;i++){
			if(USE_FEEDBACK_ERROR_TRAJECTORY){
				input.x0(i) = output.X(N_PHASE*(10 + 2*N_TIMESTEPS) + i);
			}else{
				input.x0(i) = output.X(10*N_PHASE + i);
			}
			printf("% 5.3f ",input.x0(i));
		}
		printf("\n");
		
		t0 += output.T(N_PHASE);
		printf("t0 = % 5.3f\n",t0);

	}
		printf("\n\nFinished - Press Enter to end program\n");
		std::cin.get();

	fclose(fp);

	free_conf_data(cd);
	free_conf_data(cd1);
}

//void main(){
//	ConfigurationData *cd = load_conf_data("lipmstep2d_model.cf");
//	const int N_DISCRETIZATIONS=3;
//	double T_PHASE = 0.4;
//	int i;
//
//	VectorXd x0(8);
//	x0 << 0.0,0.0,0,0,
//		  0.0,0.0,0.1,-0.1;
//	mpcInput input(0,x0);
//		
//	set_value(cd,"N_STEPS",0);
//	MPC_Solver<lipmStep2dModel> standing(cd);	
//	standing.precompute(&input);
//
//	set_value(cd,"N_STEPS",1);
//	set_value(cd,"FIRST_FOOT",0);
//	MPC_Solver<lipmStep2dModel> stepleft[N_DISCRETIZATIONS];
//	for(i=0;i<N_DISCRETIZATIONS;i++){
//		stepleft[i].set_params(cd);
//		input = mpcInput(i*T_PHASE/N_DISCRETIZATIONS,x0);
//		stepleft[i].precompute(&input);
//	}
//
//	set_value(cd,"FIRST_FOOT",1);
//	MPC_Solver<lipmStep2dModel> stepright[N_DISCRETIZATIONS];
//	for(i=0;i<N_DISCRETIZATIONS;i++){
//		stepright[i].set_params(cd);
//		input = mpcInput(i*T_PHASE/N_DISCRETIZATIONS,x0);
//		stepright[i].precompute(&input);
//	}
//
//	set_value(cd,"N_STEPS",2);
//	set_value(cd,"FIRST_FOOT",0);
//	MPC_Solver<lipmStep2dModel> stepleft2[N_DISCRETIZATIONS];
//	for(i=0;i<N_DISCRETIZATIONS;i++){
//		stepleft2[i].set_params(cd);
//		input = mpcInput(i*T_PHASE/N_DISCRETIZATIONS,x0);
//		stepleft2[i].precompute(&input); 
//	}
//
//	set_value(cd,"FIRST_FOOT",1);
//	MPC_Solver<lipmStep2dModel> stepright2[N_DISCRETIZATIONS];
//	for(i=0;i<N_DISCRETIZATIONS;i++){
//		stepright2[i].set_params(cd);
//		input = mpcInput(i*T_PHASE/N_DISCRETIZATIONS,x0);
//		stepright2[i].precompute(&input);
//	}
//
//
//	free_conf_data(cd);
//	
//	MultiMPC_Server<lipmStep2dModel> server(5);
//
//	server.Set_Solver(0,&standing);
//	server.Set_Solver(1,&stepleft[0]);
//	server.Set_Solver(2,&stepright[0]);
//	server.Set_Solver(3,&stepleft2[0]);
//	server.Set_Solver(4,&stepright2[0]);
//
//	mpcOutput output;
//
//	Sleep(100);
//
//	double cost_avg = 0;
//	double count_avg = 0;
//	for(int i=0;i<10;i++){
//	int count=0;
//
//	x0 << 0.0,i*0.7/9,0,0,
//		  0.0,0.0,0.1,-0.1;
//	input = mpcInput(0,x0);
//
//
//	server.Start(&input);
//	while(!server.Finish(&output)){
//			Sleep(1);
//			count++;
//		}
//	printf("%i %i ",count,server.Get_BestIdx());
//	for(int j=0;j<server.Get_Num_Servers();j++)	printf("%f ",server.Get_Output(j).cost);
//		printf("\n");
//		count_avg += (double)count/10;
//		cost_avg += output.cost/10;
//	}
//
//	printf("count_avg = %f cost_avg = %f\n",count_avg,cost_avg);
//		
//	//std::cout << standing.getU().transpose() << std::endl;
//
//	//standing.print_output_trajectory(true);
//	//stepleft[0].print_output_trajectory(true);
//	//stepright[0].print_output_trajectory(true);
//
//	printf("\n\nFinished - Press Enter to end program\n");
//	std::cin.get();
//
//}
