#ifndef LIPM_FEL_MODEL_H
#define LIPM_FEL_MODEL_H

#include "mpc_model.h"
#include "config_file.h"

#include <Eigen/Core>
using namespace Eigen;

class lipmStep2dModel_FEL:public mpcModel{

public:
	lipmStep2dModel_FEL();
	lipmStep2dModel_FEL(ConfigurationData *cd);

	void allocate();

	MatrixXd forward_dynamics_x(int i, double t0, VectorXd &x0, double DT);	
	MatrixXd forward_dynamics_u(int i, double t0, VectorXd &x0, double DT);	
	MatrixXd output_dynamics_x(int i, double t0, VectorXd &x0, double DT);	
	MatrixXd output_dynamics_u(int i, double t0, VectorXd &x0, double DT);	
	MatrixXd forward_dynamics_ud(int i, double t0, VectorXd &x0, double DT);	

	void precompute_dynamics(double t0, VectorXd &x0);

	void precompute_cost(double t0, VectorXd &x0);

	void precompute_constraints(double t0, VectorXd &x0);

	void update_cost(double t0, VectorXd &x0);

	void update_constraints(double t0, VectorXd &x0);

	VectorXd simulate(double t0, VectorXd &x0, VectorXd &U);
	
	void set_params(ConfigurationData *cd);

	//double one_step_cost(double t0, VectorXd &x0, double t, VectorXd &x, VectorXd &u);
	double total_cost(double t0, VectorXd &x0, VectorXd &U);

	VectorXi get_contact_state(){ return contact_state; };
	VectorXi get_state_indices(){ return step_indices; };

	
private:
	double TIMESTEP;

	double HEIGHT; 

	double global_pos_cost;
	double capture_cost;
	double pos_cost;
	double vel_cost;
	double zmp_cost;
	double zmpd_cost;
	double step_cost;

	double final_cost;

	int N_STEPS;

	double T_SHIFT;
	int N_SHIFT;	// number of timesteps in shift phase
	double T_SWING;
	int N_SWING;	// number of timesteps in swing phase

	double STANCE_WIDTH; // desired stance width
	double MAX_STANCE_WIDTH;
	double DES_STEP_LENGTH;
	double FOOT_SIZE_X;
	double FOOT_SIZE_Y;

	int USE_DOUBLE_SUPPORT_CONSTRAINTS;
	int USE_FEEDBACK_ERROR_TRAJECTORY;

	int FIRST_FOOT;

	int do_step;
	int n_steps;

	VectorXi step_indices;
	VectorXi contact_state;



};

#endif