#ifndef MULTI_MPC_SERVER_H
#define MULTI_MPC_SERVER_H

#include "basic_server.h"
#include "mpc_model.h"
#include "mpc_solver.h"
#include <stdlib.h>
#include <process.h>



template<class MODEL>
class MultiMPC_Server: public Basic_Server{

public:
	//MultiMPC_Server();
	MultiMPC_Server(int);

	void Set_Solver(int i, MPC_Solver<MODEL> *mpc);

	void Run_Solver(int i);

	int Get_Num_Servers(void){ return N_SERVERS; }

	mpcOutput Get_Output(int i);
	int Get_BestIdx();

	int waitForResult();
		
private:
	void Evaluate();
	void Send(void *ptr);
	void Receive(void *ptr);
	
	int N_SERVERS;	
	MPC_Solver<MODEL> **mpcs;

	class Thread: public Basic_Server{
	public:
		Thread(){};
		void Attach(MultiMPC_Server<MODEL> *m, int i);
	private:
		void Send(void*);
		void Evaluate();
		void Receive(void*);
		MultiMPC_Server<MODEL> *mpc;
		int which_solver;
	};

	int best_idx;

	Thread *mpcThreads;

	mpcOutput *allOutputs;
	mpcOutput output;
	
	HANDLE *hSubThreads;	
};

template<class MODEL>
void MultiMPC_Server<MODEL>::Thread::Send(void*ptr){
	//mpc = (MultiMPC_Server<MODEL>*)ptr;
}
template<class MODEL>
void MultiMPC_Server<MODEL>::Thread::Attach(MultiMPC_Server<MODEL> *m, int i){
	mpc = m;
	which_solver = i;
}
template<class MODEL>
void MultiMPC_Server<MODEL>::Thread::Evaluate(void){
	mpc->Run_Solver(which_solver);
}
template<class MODEL>
void MultiMPC_Server<MODEL>::Thread::Receive(void*ptr){
	mpcOutput *out = (mpcOutput*)ptr;
	*out = mpc->Get_Output(which_solver);
}

template<class MODEL>
void MultiMPC_Server<MODEL>::Run_Solver(int i){
	mpcs[i]->solve();
}

template<class MODEL>
mpcOutput MultiMPC_Server<MODEL>::Get_Output(int i){
	return mpcs[i]->get_output();
}

template<class MODEL>
int MultiMPC_Server<MODEL>::Get_BestIdx(){
	return best_idx;
}

//template<class MODEL>
//MultiMPC_Server<MODEL>::MultiMPC_Server(){
//	*this = MultiMPC_Server<MODEL>(1);
//}

template<class MODEL>
MultiMPC_Server<MODEL>::MultiMPC_Server(int N){
	
	N_SERVERS = N;

	mpcs = (MPC_Solver<MODEL>**)malloc(N_SERVERS*sizeof(MPC_Solver<MODEL>*));
	mpcThreads = new MultiMPC_Server<MODEL>::Thread[N_SERVERS];
	allOutputs = new mpcOutput[N_SERVERS];
	hSubThreads = new HANDLE[N_SERVERS];	
	for(int i=0;i<N_SERVERS;i++){
		hSubThreads[i] = mpcThreads[i].GethOutputReadyEvent();
		mpcThreads[i].Attach(this,i);
	}
}

template<class MODEL>
void MultiMPC_Server<MODEL>::Set_Solver(int i, MPC_Solver<MODEL> *mpc){	
	mpcs[i] = mpc;	
}

template<class MODEL>
void MultiMPC_Server<MODEL>::Send(void *ptr){
	int i;
	mpcInput*in = (mpcInput*)ptr;
	best_idx=-1;		
	for(i=0;i<N_SERVERS;i++){
		mpcs[i]->set_input(in);
	}
}


template<class MODEL>
void MultiMPC_Server<MODEL>::Evaluate(){
	int i;

	for(i=0;i<N_SERVERS;i++){
		mpcThreads[i].Start(NULL);
		//hSubThreads[i] = (HANDLE)_beginthread((void (*)(void*))MultiMPC_SingleSolver,0,this);
		//hSubThreads[i] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)MultiMPC_SingleSolver,this,0,NULL);
	}

	// wait for all threads to finish computing
	WaitForMultipleObjects(N_SERVERS,hSubThreads,TRUE,INFINITE);

	for(i=0;i<N_SERVERS;i++){
		mpcThreads[i].Finish(&allOutputs[i]);
	}
	
	double best_cost = 1e10; 
	double cost;
	 
	for(i=0;i<N_SERVERS;i++){
		cost = mpcs[i]->get_output().cost;
		if (cost<best_cost){
			best_idx = i;
			best_cost = cost;
		}
	}

	if(best_idx>=0)	output = allOutputs[best_idx];

}

template<class MODEL>
void MultiMPC_Server<MODEL>::Receive(void *ptr){
	mpcOutput*out = (mpcOutput*)ptr;
	*out = output;
}

#endif